/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.model.documentation;

import com.intellij.lang.documentation.QuickDocHighlightingHelper;
import com.intellij.lang.ruby.rbs.model.api.RbsContainerSymbol;
import com.intellij.lang.ruby.rbs.model.api.RbsQualifiedNameSymbol;
import com.intellij.lang.ruby.rbs.model.api.RbsTypeVariableSymbol;
import com.intellij.lang.ruby.rbs.model.documentation.RbsDocumentationTypeSignaturePresentationVisitor;
import com.intellij.lang.ruby.rbs.model.impl.RbsTypeAliasSymbol;
import com.intellij.lang.ruby.rbs.psi.data.RbsProcTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignatureResolver;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeVariableReferenceSignature;
import com.intellij.lang.ruby.rbs.util.Fqn;
import com.intellij.lang.ruby.rbs.util.RbsNamingConventionUtils;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.lang.highlighter.RubyHighlighter;

final class RbsDocumentationChunk {
    private RbsDocumentationChunk() {
    }

    @NotNull
    @NlsSafe
    static String ancestor(@NotNull Project project, @NotNull RbsQualifiedNameSymbol symbol, @NotNull Function<RbsTypeSignature, RbsTypeSignature> binding) {
        int max;
        if (project == null) {
            RbsDocumentationChunk.$$$reportNull$$$0(0);
        }
        if (symbol == null) {
            RbsDocumentationChunk.$$$reportNull$$$0(1);
        }
        if (binding == null) {
            RbsDocumentationChunk.$$$reportNull$$$0(2);
        }
        GlobalSearchScope searchScope = GlobalSearchScope.allScope((Project)project);
        StringBuilder sb = new StringBuilder();
        sb.append(RbsDocumentationChunk.fqn(symbol.getFqn()));
        if (symbol instanceof RbsContainerSymbol) {
            RbsContainerSymbol container = (RbsContainerSymbol)symbol;
            max = container.getTypeVariableSymbols(project, (SearchScope)searchScope).keySet().stream().max(Comparator.naturalOrder()).map(it -> it + 1).orElse(0);
        } else if (symbol instanceof RbsTypeAliasSymbol) {
            RbsTypeAliasSymbol typeAlias = (RbsTypeAliasSymbol)symbol;
            max = typeAlias.getTypeVariableSymbols(project, (SearchScope)searchScope).keySet().stream().max(Comparator.naturalOrder()).map(it -> it + 1).orElse(0);
        } else {
            max = 0;
        }
        if (max <= 0) {
            String string = sb.toString();
            if (string == null) {
                RbsDocumentationChunk.$$$reportNull$$$0(3);
            }
            return string;
        }
        sb.append(RbsDocumentationChunk.brackets("["));
        for (int i = 0; i < max; ++i) {
            RbsTypeSignature boundTypeArgumentSignature = new RbsTypeVariableReferenceSignature(RbsTypeVariableReferenceSignature.ReferenceType.CONTAINER_VARIABLE, "#" + i, i).apply(binding).apply(new RbsTypeSignatureResolver(project, (SearchScope)searchScope));
            sb.append(RbsDocumentationChunk.typeSignature(boundTypeArgumentSignature));
            if (i >= max - 1) continue;
            sb.append(RbsDocumentationChunk.operation(",")).append(" ");
        }
        sb.append(RbsDocumentationChunk.brackets("]"));
        String string = sb.toString();
        if (string == null) {
            RbsDocumentationChunk.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    static String braces(@NotNull String text) {
        if (text == null) {
            RbsDocumentationChunk.$$$reportNull$$$0(5);
        }
        return RbsDocumentationChunk.highlighted(RubyHighlighter.BRACES, text);
    }

    @NotNull
    @NlsSafe
    static String brackets(@NotNull String text) {
        if (text == null) {
            RbsDocumentationChunk.$$$reportNull$$$0(6);
        }
        return RbsDocumentationChunk.highlighted(RubyHighlighter.BRACKETS, text);
    }

    @NotNull
    @NlsSafe
    static String fqn(@NotNull Fqn fqn) {
        if (fqn == null) {
            RbsDocumentationChunk.$$$reportNull$$$0(7);
        }
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = fqn.split().getComponents().iterator();
        while (it.hasNext()) {
            String next = it.next();
            if (it.hasNext()) {
                sb.append(RbsDocumentationChunk.highlighted(RubyHighlighter.CONSTANT, next)).append(RbsDocumentationChunk.operation("::"));
                continue;
            }
            if (RbsNamingConventionUtils.isValidTypeAliasName(next)) {
                sb.append(RbsDocumentationChunk.highlighted(RubyHighlighter.IDENTIFIER, next));
                continue;
            }
            sb.append(RbsDocumentationChunk.highlighted(RubyHighlighter.CONSTANT, next));
        }
        String string = sb.toString();
        if (string == null) {
            RbsDocumentationChunk.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    static String fqn(@NotNull String name) {
        if (name == null) {
            RbsDocumentationChunk.$$$reportNull$$$0(9);
        }
        return RbsDocumentationChunk.fqn(Fqn.of(name, new String[0]));
    }

    @NotNull
    @NlsSafe
    static String highlighted(@NotNull TextAttributesKey key, @NotNull String text) {
        if (key == null) {
            RbsDocumentationChunk.$$$reportNull$$$0(10);
        }
        if (text == null) {
            RbsDocumentationChunk.$$$reportNull$$$0(11);
        }
        StringBuilder sb = new StringBuilder();
        QuickDocHighlightingHelper.appendStyledSignatureFragment((StringBuilder)sb, (String)Strings.escapeXmlEntities((String)text), (TextAttributesKey)key);
        String string = sb.toString();
        if (string == null) {
            RbsDocumentationChunk.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    static String identifier(@NotNull String text) {
        if (text == null) {
            RbsDocumentationChunk.$$$reportNull$$$0(13);
        }
        return RbsDocumentationChunk.highlighted(RubyHighlighter.IDENTIFIER, text);
    }

    @NotNull
    @NlsSafe
    static String keyword(@NotNull String text) {
        if (text == null) {
            RbsDocumentationChunk.$$$reportNull$$$0(14);
        }
        return RbsDocumentationChunk.highlighted(RubyHighlighter.KEYWORD, text);
    }

    @NotNull
    @NlsSafe
    static String number(@NotNull String text) {
        if (text == null) {
            RbsDocumentationChunk.$$$reportNull$$$0(15);
        }
        return RbsDocumentationChunk.highlighted(RubyHighlighter.NUMBER, text);
    }

    @NotNull
    @NlsSafe
    static String operation(@NotNull String text) {
        if (text == null) {
            RbsDocumentationChunk.$$$reportNull$$$0(16);
        }
        return RbsDocumentationChunk.highlighted(RubyHighlighter.OPERATION_SIGN, text);
    }

    @NotNull
    @NlsSafe
    static String parameter(@NotNull RbsProcTypeSignature.Parameter parameter) {
        if (parameter == null) {
            RbsDocumentationChunk.$$$reportNull$$$0(17);
        }
        String name = (String)ObjectUtils.coalesce((Object)((String)ObjectUtils.doIfNotNull((Object)parameter.getName(), RbsDocumentationChunk::identifier)), (Object)"");
        String type = RbsDocumentationChunk.typeSignature(parameter.getTypeSignature());
        String string = switch (parameter.getParameterType()) {
            default -> throw new IncompatibleClassChangeError();
            case RbsProcTypeSignature.ParameterType.POSITIONAL_REQUIRED -> "%s %s".formatted(type, name).trim();
            case RbsProcTypeSignature.ParameterType.POSITIONAL_OPTIONAL -> (RbsDocumentationChunk.operation("?") + type + " " + name).trim();
            case RbsProcTypeSignature.ParameterType.POSITIONAL_REST -> (RbsDocumentationChunk.operation("*") + type + " " + name).trim();
            case RbsProcTypeSignature.ParameterType.KEYWORD_REQUIRED -> (name + RbsDocumentationChunk.operation(":") + " " + type).trim();
            case RbsProcTypeSignature.ParameterType.KEYWORD_OPTIONAL -> (RbsDocumentationChunk.operation("?") + name + RbsDocumentationChunk.operation(":") + " " + type).trim();
            case RbsProcTypeSignature.ParameterType.KEYWORD_REST -> (RbsDocumentationChunk.operation("**") + type + " " + name).trim();
        };
        if (string == null) {
            RbsDocumentationChunk.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    static String parentheses(@NotNull String text) {
        if (text == null) {
            RbsDocumentationChunk.$$$reportNull$$$0(19);
        }
        return RbsDocumentationChunk.highlighted(RubyHighlighter.PARENTHESES, text);
    }

    @NotNull
    @NlsSafe
    static String string(@NotNull String text) {
        if (text == null) {
            RbsDocumentationChunk.$$$reportNull$$$0(20);
        }
        return RbsDocumentationChunk.highlighted(RubyHighlighter.SIMPLE_STRING, text);
    }

    @NotNull
    @NlsSafe
    static String symbol(@NotNull String text) {
        if (text == null) {
            RbsDocumentationChunk.$$$reportNull$$$0(21);
        }
        return RbsDocumentationChunk.highlighted(RubyHighlighter.SYMBOL, text);
    }

    @NotNull
    @NlsSafe
    static String typeSignature(@NotNull RbsTypeSignature signature) {
        if (signature == null) {
            RbsDocumentationChunk.$$$reportNull$$$0(22);
        }
        RbsDocumentationTypeSignaturePresentationVisitor visitor = new RbsDocumentationTypeSignaturePresentationVisitor();
        signature.accept(visitor);
        String string = visitor.getText();
        if (string == null) {
            RbsDocumentationChunk.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    static String typeVariable(@NotNull Project project, @NotNull RbsTypeVariableSymbol symbol) {
        RbsTypeSignature defaultTypeSignature;
        if (project == null) {
            RbsDocumentationChunk.$$$reportNull$$$0(24);
        }
        if (symbol == null) {
            RbsDocumentationChunk.$$$reportNull$$$0(25);
        }
        StringBuilder sb = new StringBuilder();
        if (symbol.isUnchecked()) {
            sb.append(RbsDocumentationChunk.keyword("unchecked")).append(" ");
        }
        switch (symbol.getVariance()) {
            case COVARIANT: {
                sb.append(RbsDocumentationChunk.keyword("out")).append(" ");
                break;
            }
            case CONTRAVARIANT: {
                sb.append(RbsDocumentationChunk.keyword("in")).append(" ");
            }
        }
        sb.append(RbsDocumentationChunk.fqn(symbol.getName()));
        RbsTypeSignature upperBoundTypeSignature = (RbsTypeSignature)ObjectUtils.doIfNotNull((Object)symbol.getUpperBound(), it -> it.apply(new RbsTypeSignatureResolver(project, (SearchScope)GlobalSearchScope.allScope((Project)project))));
        if (upperBoundTypeSignature != null) {
            sb.append(" ").append(RbsDocumentationChunk.operation("<")).append(" ");
            sb.append(RbsDocumentationChunk.typeSignature(upperBoundTypeSignature));
        }
        if ((defaultTypeSignature = (RbsTypeSignature)ObjectUtils.doIfNotNull((Object)symbol.getDefaultType(), it -> it.apply(new RbsTypeSignatureResolver(project, (SearchScope)GlobalSearchScope.allScope((Project)project))))) != null) {
            sb.append(" ").append(RbsDocumentationChunk.operation("=")).append(" ");
            sb.append(RbsDocumentationChunk.typeSignature(defaultTypeSignature));
        }
        String string = sb.toString().trim();
        if (string == null) {
            RbsDocumentationChunk.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    static String typeVariables(@NotNull Project project, @NotNull Map<Integer, ? extends RbsTypeVariableSymbol> symbols) {
        if (project == null) {
            RbsDocumentationChunk.$$$reportNull$$$0(27);
        }
        if (symbols == null) {
            RbsDocumentationChunk.$$$reportNull$$$0(28);
        }
        MultiMap multiMap = new MultiMap();
        multiMap.putAllValues(symbols);
        return RbsDocumentationChunk.typeVariables(project, (MultiMap<Integer, ? extends RbsTypeVariableSymbol>)multiMap);
    }

    @NotNull
    @NlsSafe
    static String typeVariables(@NotNull Project project, @NotNull MultiMap<Integer, ? extends RbsTypeVariableSymbol> symbols) {
        if (project == null) {
            RbsDocumentationChunk.$$$reportNull$$$0(29);
        }
        if (symbols == null) {
            RbsDocumentationChunk.$$$reportNull$$$0(30);
        }
        return RbsDocumentationChunk.typeVariables(project, symbols, false);
    }

    @NotNull
    @NlsSafe
    static String typeVariables(@NotNull Project project, @NotNull MultiMap<Integer, ? extends RbsTypeVariableSymbol> symbols, boolean isNameOnly) {
        int max;
        if (project == null) {
            RbsDocumentationChunk.$$$reportNull$$$0(31);
        }
        if (symbols == null) {
            RbsDocumentationChunk.$$$reportNull$$$0(32);
        }
        if ((max = symbols.keySet().stream().max(Comparator.naturalOrder()).map(it -> it + 1).orElse(0).intValue()) <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(RbsDocumentationChunk.brackets("["));
        for (int i = 0; i < max; ++i) {
            RbsTypeVariableSymbol symbol = (RbsTypeVariableSymbol)ContainerUtil.getFirstItem((Collection)symbols.get((Object)i));
            if (symbol != null) {
                sb.append(isNameOnly ? RbsDocumentationChunk.fqn(symbol.getName()) : RbsDocumentationChunk.typeVariable(project, symbol));
            } else {
                sb.append(RbsDocumentationChunk.highlighted(HighlighterColors.BAD_CHARACTER, "?"));
            }
            if (i >= max - 1) continue;
            sb.append(RbsDocumentationChunk.operation(",")).append(" ");
        }
        sb.append(RbsDocumentationChunk.brackets("]"));
        String string = sb.toString();
        if (string == null) {
            RbsDocumentationChunk.$$$reportNull$$$0(33);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 8, 12, 18, 23, 26, 33 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binding";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 12: 
            case 18: 
            case 23: 
            case 26: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/model/documentation/RbsDocumentationChunk";
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 28: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbols";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/model/documentation/RbsDocumentationChunk";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "ancestor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "fqn";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "highlighted";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "parameter";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "typeSignature";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "typeVariable";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "typeVariables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "ancestor";
                break;
            }
            case 3: 
            case 4: 
            case 8: 
            case 12: 
            case 18: 
            case 23: 
            case 26: 
            case 33: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "braces";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "brackets";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fqn";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "highlighted";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "identifier";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "keyword";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "number";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "operation";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "parameter";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "parentheses";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "string";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "symbol";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "typeSignature";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "typeVariable";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "typeVariables";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 8, 12, 18, 23, 26, 33 -> new IllegalStateException(string);
        };
    }
}

