/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.model.documentation;

import com.intellij.lang.ruby.rbs.model.documentation.RbsDocumentationChunk;
import com.intellij.lang.ruby.rbs.model.documentation.RbsDocumentationTargetBase;
import com.intellij.lang.ruby.rbs.model.impl.RbsClassSymbol;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignatureBinding;
import com.intellij.lang.ruby.rbs.util.RbsFqns;
import com.intellij.model.Pointer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.platform.backend.presentation.TargetPresentation;
import java.util.function.Function;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

final class RbsClassDocumentationTarget
extends RbsDocumentationTargetBase<RbsClassSymbol> {
    RbsClassDocumentationTarget(@NotNull Project project, @NotNull RbsClassSymbol symbol) {
        if (project == null) {
            RbsClassDocumentationTarget.$$$reportNull$$$0(0);
        }
        if (symbol == null) {
            RbsClassDocumentationTarget.$$$reportNull$$$0(1);
        }
        super(project, symbol);
    }

    @NlsContexts.HintText
    @NotNull
    public String computeDocumentationHint() {
        @Nls StringBuilder sb = new StringBuilder();
        sb.append(RbsDocumentationChunk.keyword("class")).append(" ").append(RbsDocumentationChunk.fqn(((RbsClassSymbol)this.mySymbol).getFqn()));
        RbsClassSymbol targetClass = ((RbsClassSymbol)this.mySymbol).getTargetClassSymbol(this.myProject, this.mySearchScope);
        if (targetClass != null) {
            sb.append(" ").append(RbsDocumentationChunk.operation("=")).append(" ").append(RbsDocumentationChunk.fqn(targetClass.getFqn()));
            String string = sb.toString();
            if (string == null) {
                RbsClassDocumentationTarget.$$$reportNull$$$0(2);
            }
            return string;
        }
        sb.append(RbsDocumentationChunk.typeVariables(this.myProject, ((RbsClassSymbol)this.mySymbol).getTypeVariableSymbols(this.myProject, this.mySearchScope)));
        RbsClassSymbol superclassSymbol = ((RbsClassSymbol)this.mySymbol).getSuperclassSymbol(this.myProject, this.mySearchScope);
        if (superclassSymbol != null && !superclassSymbol.getFqn().isEquivalentTo(RbsFqns.OBJECT_FQN)) {
            Function<RbsTypeSignature, RbsTypeSignature> binding = ((RbsClassSymbol)this.mySymbol).getTypeVariableBinding(this.myProject, this.mySearchScope).getOrDefault(superclassSymbol, RbsTypeSignatureBinding.UNTYPED);
            sb.append(" ").append(RbsDocumentationChunk.operation("<")).append(" ");
            sb.append(RbsDocumentationChunk.ancestor(this.myProject, superclassSymbol, binding));
        }
        String string = sb.toString();
        if (string == null) {
            RbsClassDocumentationTarget.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public TargetPresentation computePresentation() {
        TargetPresentation targetPresentation = TargetPresentation.builder((String)((RbsClassSymbol)this.mySymbol).getName()).icon(((RbsClassSymbol)this.mySymbol).getPresentation().icon()).presentation();
        if (targetPresentation == null) {
            RbsClassDocumentationTarget.$$$reportNull$$$0(4);
        }
        return targetPresentation;
    }

    @Override
    @NotNull
    public Pointer<RbsClassDocumentationTarget> createPointer() {
        Project project = this.myProject;
        Pointer pointer = Pointer.delegatingPointer(((RbsClassSymbol)this.mySymbol).createPointer(), it -> !project.isDisposed() ? new RbsClassDocumentationTarget(project, (RbsClassSymbol)it) : null);
        if (pointer == null) {
            RbsClassDocumentationTarget.$$$reportNull$$$0(5);
        }
        return pointer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/model/documentation/RbsClassDocumentationTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/model/documentation/RbsClassDocumentationTarget";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDocumentationHint";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computePresentation";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createPointer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

