/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.model.api;

import com.intellij.lang.ruby.rbs.model.api.RbsSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsClassSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsConstantSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsInterfaceSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsModuleSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsTypeAliasSymbol;
import com.intellij.lang.ruby.rbs.util.Fqn;
import com.intellij.lang.ruby.rbs.util.RbsNamingConventionUtils;
import com.intellij.model.Pointer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.model.presentation.PresentableSymbol;

public interface RbsQualifiedNameSymbol
extends RbsSymbol,
PresentableSymbol {
    @NotNull
    public Pointer<? extends RbsQualifiedNameSymbol> createPointer();

    @NotNull
    public Fqn getFqn();

    @NlsSafe
    @NotNull
    default public String getFullName() {
        String string = this.getFqn().split().getName();
        if (string == null) {
            RbsQualifiedNameSymbol.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    default public String getName() {
        String string = this.getFqn().split().getName();
        if (string == null) {
            RbsQualifiedNameSymbol.$$$reportNull$$$0(1);
        }
        return string;
    }

    @RequiresReadLock
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public static Stream<? extends RbsQualifiedNameSymbol> find(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull Fqn fqn) {
        if (project == null) {
            RbsQualifiedNameSymbol.$$$reportNull$$$0(2);
        }
        if (searchScope == null) {
            RbsQualifiedNameSymbol.$$$reportNull$$$0(3);
        }
        if (fqn == null) {
            RbsQualifiedNameSymbol.$$$reportNull$$$0(4);
        }
        ThreadingAssertions.softAssertReadAccess();
        if (fqn == Fqn.INVALID) {
            Stream stream = Stream.empty();
            if (stream == null) {
                RbsQualifiedNameSymbol.$$$reportNull$$$0(5);
            }
            return stream;
        }
        if (RbsNamingConventionUtils.isValidInterfaceName(fqn.join())) {
            Stream<RbsInterfaceSymbol> stream = RbsInterfaceSymbol.find(project, searchScope, fqn).stream();
            if (stream == null) {
                RbsQualifiedNameSymbol.$$$reportNull$$$0(6);
            }
            return stream;
        }
        if (RbsNamingConventionUtils.isValidTypeAliasName(fqn.join())) {
            Stream<RbsTypeAliasSymbol> stream = RbsTypeAliasSymbol.find(project, searchScope, fqn).stream();
            if (stream == null) {
                RbsQualifiedNameSymbol.$$$reportNull$$$0(7);
            }
            return stream;
        }
        Stream stream = Stream.of(() -> RbsClassSymbol.find(project, searchScope, fqn).stream(), () -> RbsModuleSymbol.find(project, searchScope, fqn).stream(), () -> RbsConstantSymbol.find(project, searchScope, fqn).stream()).flatMap(Supplier::get);
        if (stream == null) {
            RbsQualifiedNameSymbol.$$$reportNull$$$0(8);
        }
        return stream;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/model/api/RbsQualifiedNameSymbol";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/model/api/RbsQualifiedNameSymbol";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "find";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

