/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.model.api;

import com.github.benmanes.caffeine.cache.Cache;
import com.intellij.lang.ruby.rbs.model.api.RbsQualifiedNameSymbol;
import com.intellij.lang.ruby.rbs.model.cache.RbsSymbolsCache;
import com.intellij.lang.ruby.rbs.model.hierarchy.RbsContainerHierarchyUtil;
import com.intellij.lang.ruby.rbs.model.impl.RbsClassSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsContainerTypeVariableSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsInterfaceSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsModuleSymbol;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignature;
import com.intellij.lang.ruby.rbs.util.Fqn;
import com.intellij.lang.ruby.rbs.util.RbsNamingConventionUtils;
import com.intellij.model.Pointer;
import com.intellij.model.Symbol;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;

public interface RbsContainerSymbol
extends RbsQualifiedNameSymbol {
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    default public Stream<? extends RbsContainerSymbol> allAncestors(final @NotNull Project project, final @NotNull SearchScope searchScope) {
        Cache<Symbol, List<RbsContainerSymbol>> cache;
        List cachedAncestors;
        if (project == null) {
            RbsContainerSymbol.$$$reportNull$$$0(0);
        }
        if (searchScope == null) {
            RbsContainerSymbol.$$$reportNull$$$0(1);
        }
        if ((cachedAncestors = (List)(cache = RbsSymbolsCache.getInstance(project, searchScope).getAllAncestors()).getIfPresent((Object)this)) != null) {
            Stream<RbsContainerSymbol> stream = cachedAncestors.stream().peek(__ -> ProgressManager.checkCanceled());
            if (stream == null) {
                RbsContainerSymbol.$$$reportNull$$$0(2);
            }
            return stream;
        }
        int characteristics = 1297;
        Spliterators.AbstractSpliterator<RbsContainerSymbol> spliterator = new Spliterators.AbstractSpliterator<RbsContainerSymbol>(Long.MAX_VALUE, 1297){
            final LinkedList<RbsContainerSymbol> myQueue;
            final Set<RbsContainerSymbol> myProcessed;
            final Set<RbsContainerSymbol> myAllAncestors;
            {
                super(arg0, arg1);
                this.myQueue = new LinkedList<RbsContainerSymbol>(List.of(RbsContainerSymbol.this));
                this.myProcessed = new HashSet<RbsContainerSymbol>();
                this.myAllAncestors = new LinkedHashSet<RbsContainerSymbol>();
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public boolean tryAdvance(@NotNull Consumer<? super RbsContainerSymbol> action) {
                if (action == null) {
                    1.$$$reportNull$$$0(0);
                }
                ProgressManager.checkCanceled();
                if (this.myQueue.isEmpty()) {
                    cache.put((Object)RbsContainerSymbol.this, List.copyOf(this.myAllAncestors));
                    return false;
                }
                RbsContainerSymbol ancestor = this.myQueue.poll();
                if (!this.myProcessed.add(ancestor)) {
                    if (!this.myAllAncestors.add(ancestor)) return this.tryAdvance(action);
                    action.accept(ancestor);
                    return true;
                }
                if (ancestor instanceof RbsModuleSymbol) {
                    RbsModuleSymbol moduleSymbol = (RbsModuleSymbol)ancestor;
                    if (this.myProcessed.size() != 1) {
                        ArrayList<? extends RbsContainerSymbol> selfTypes = new ArrayList<RbsContainerSymbol>(moduleSymbol.getSelfTypeSymbols(project, searchScope));
                        this.myQueue.addAll(0, ancestor.ancestors(project, searchScope).filter(candidate -> !selfTypes.remove(candidate)).toList());
                        return this.tryAdvance(action);
                    }
                }
                this.myQueue.addAll(0, ancestor.ancestors(project, searchScope).toList());
                return this.tryAdvance(action);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/lang/ruby/rbs/model/api/RbsContainerSymbol$1", "tryAdvance"));
            }
        };
        Stream<RbsContainerSymbol> stream = StreamSupport.stream(spliterator, false);
        if (stream == null) {
            RbsContainerSymbol.$$$reportNull$$$0(3);
        }
        return stream;
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    default public Stream<? extends Symbol> allChildren(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RbsContainerSymbol.$$$reportNull$$$0(4);
        }
        if (searchScope == null) {
            RbsContainerSymbol.$$$reportNull$$$0(5);
        }
        Stream stream = this.allAncestors(project, searchScope).flatMap(ancestor -> ancestor.children(project, searchScope)).distinct();
        if (stream == null) {
            RbsContainerSymbol.$$$reportNull$$$0(6);
        }
        return stream;
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    default public Stream<? extends RbsContainerSymbol> ancestors(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RbsContainerSymbol.$$$reportNull$$$0(7);
        }
        if (searchScope == null) {
            RbsContainerSymbol.$$$reportNull$$$0(8);
        }
        Stream stream = ((List)RbsSymbolsCache.getInstance(project, searchScope).getAncestors().get((Object)this, __ -> List.copyOf(RbsContainerHierarchyUtil.getAncestors(project, searchScope, this)))).stream();
        if (stream == null) {
            RbsContainerSymbol.$$$reportNull$$$0(9);
        }
        return stream;
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    default public Stream<? extends Symbol> children(@NotNull Project project, @NotNull SearchScope searchScope) {
        Cache<Symbol, List<Symbol>> cache;
        List cachedChildren;
        if (project == null) {
            RbsContainerSymbol.$$$reportNull$$$0(10);
        }
        if (searchScope == null) {
            RbsContainerSymbol.$$$reportNull$$$0(11);
        }
        if ((cachedChildren = (List)(cache = RbsSymbolsCache.getInstance(project, searchScope).getChildren()).getIfPresent((Object)this)) != null) {
            Stream stream = cachedChildren.stream();
            if (stream == null) {
                RbsContainerSymbol.$$$reportNull$$$0(12);
            }
            return stream;
        }
        List<? extends Symbol> children = RbsContainerHierarchyUtil.getChildren(project, searchScope, this);
        cache.put((Object)this, List.copyOf(children));
        Stream stream = children.stream();
        if (stream == null) {
            RbsContainerSymbol.$$$reportNull$$$0(13);
        }
        return stream;
    }

    @NotNull
    public Pointer<? extends RbsContainerSymbol> createPointer();

    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    default public Map<RbsContainerSymbol, Function<RbsTypeSignature, RbsTypeSignature>> getTypeVariableBinding(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RbsContainerSymbol.$$$reportNull$$$0(14);
        }
        if (searchScope == null) {
            RbsContainerSymbol.$$$reportNull$$$0(15);
        }
        Map map = (Map)RbsSymbolsCache.getInstance(project, searchScope).getTypeVariableBindings().get((Object)this, __ -> RbsContainerHierarchyUtil.getTypeVariableBinding(project, searchScope, this));
        if (map == null) {
            RbsContainerSymbol.$$$reportNull$$$0(16);
        }
        return map;
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    default public MultiMap<Integer, RbsContainerTypeVariableSymbol> getTypeVariableSymbols(@NotNull Project project, @NotNull SearchScope searchScope) {
        Cache<Symbol, MultiMap<Integer, Pointer<RbsContainerTypeVariableSymbol>>> cache;
        MultiMap cachedTypeVariablePointers;
        if (project == null) {
            RbsContainerSymbol.$$$reportNull$$$0(17);
        }
        if (searchScope == null) {
            RbsContainerSymbol.$$$reportNull$$$0(18);
        }
        if ((cachedTypeVariablePointers = (MultiMap)(cache = RbsSymbolsCache.getInstance(project, searchScope).getContainerTypeVariablePointers()).getIfPresent((Object)this)) != null) {
            MultiMap cachedTypeVariableSymbols = new MultiMap();
            for (Map.Entry entry : cachedTypeVariablePointers.entrySet()) {
                cachedTypeVariableSymbols.putValues((Object)((Integer)entry.getKey()), (Collection)ContainerUtil.mapNotNull((Collection)((Collection)entry.getValue()), Pointer::dereference));
            }
            if (cachedTypeVariableSymbols.values().size() == cachedTypeVariablePointers.values().size()) {
                MultiMap multiMap = cachedTypeVariableSymbols;
                if (multiMap == null) {
                    RbsContainerSymbol.$$$reportNull$$$0(19);
                }
                return multiMap;
            }
            cache.invalidate((Object)this);
        }
        MultiMap<Integer, RbsContainerTypeVariableSymbol> typeVariableSymbols = RbsContainerHierarchyUtil.getTypeVariableSymbols(project, searchScope, this);
        MultiMap typeVariablePointers = new MultiMap();
        for (Map.Entry entry : typeVariableSymbols.entrySet()) {
            typeVariablePointers.putValues((Object)((Integer)entry.getKey()), (Collection)ContainerUtil.map((Collection)((Collection)entry.getValue()), RbsContainerTypeVariableSymbol::createPointer));
        }
        cache.put((Object)this, (Object)typeVariablePointers);
        MultiMap<Integer, RbsContainerTypeVariableSymbol> multiMap = typeVariableSymbols;
        if (multiMap == null) {
            RbsContainerSymbol.$$$reportNull$$$0(20);
        }
        return multiMap;
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    default public Stream<? extends RbsContainerSymbol> superAncestors(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RbsContainerSymbol.$$$reportNull$$$0(21);
        }
        if (searchScope == null) {
            RbsContainerSymbol.$$$reportNull$$$0(22);
        }
        Stream<RbsContainerSymbol> stream = this.allAncestors(project, searchScope).dropWhile(ancestor -> !ancestor.equals(this)).skip(1L);
        if (stream == null) {
            RbsContainerSymbol.$$$reportNull$$$0(23);
        }
        return stream;
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    default public Stream<? extends Symbol> superChildren(@NotNull Project project, @NotNull SearchScope searchScope) {
        if (project == null) {
            RbsContainerSymbol.$$$reportNull$$$0(24);
        }
        if (searchScope == null) {
            RbsContainerSymbol.$$$reportNull$$$0(25);
        }
        Stream stream = this.superAncestors(project, searchScope).flatMap(ancestor -> ancestor.children(project, searchScope)).distinct();
        if (stream == null) {
            RbsContainerSymbol.$$$reportNull$$$0(26);
        }
        return stream;
    }

    @RequiresReadLock
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public static Stream<? extends RbsContainerSymbol> find(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull Fqn fqn) {
        if (project == null) {
            RbsContainerSymbol.$$$reportNull$$$0(27);
        }
        if (searchScope == null) {
            RbsContainerSymbol.$$$reportNull$$$0(28);
        }
        if (fqn == null) {
            RbsContainerSymbol.$$$reportNull$$$0(29);
        }
        ThreadingAssertions.softAssertReadAccess();
        if (fqn == Fqn.INVALID) {
            Stream stream = Stream.empty();
            if (stream == null) {
                RbsContainerSymbol.$$$reportNull$$$0(30);
            }
            return stream;
        }
        if (RbsNamingConventionUtils.isValidInterfaceName(fqn.join())) {
            Stream<RbsInterfaceSymbol> stream = RbsInterfaceSymbol.find(project, searchScope, fqn).stream();
            if (stream == null) {
                RbsContainerSymbol.$$$reportNull$$$0(31);
            }
            return stream;
        }
        Stream stream = Stream.of(() -> RbsClassSymbol.find(project, searchScope, fqn).stream(), () -> RbsModuleSymbol.find(project, searchScope, fqn).stream()).flatMap(Supplier::get);
        if (stream == null) {
            RbsContainerSymbol.$$$reportNull$$$0(32);
        }
        return stream;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6, 9, 12, 13, 16, 19, 20, 23, 26, 30, 31, 32 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 11: 
            case 15: 
            case 18: 
            case 22: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 16: 
            case 19: 
            case 20: 
            case 23: 
            case 26: 
            case 30: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/model/api/RbsContainerSymbol";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/model/api/RbsContainerSymbol";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "allAncestors";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "allChildren";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "ancestors";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "children";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeVariableBinding";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeVariableSymbols";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "superAncestors";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "superChildren";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "find";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "allAncestors";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 16: 
            case 19: 
            case 20: 
            case 23: 
            case 26: 
            case 30: 
            case 31: 
            case 32: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "allChildren";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "ancestors";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "children";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTypeVariableBinding";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getTypeVariableSymbols";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "superAncestors";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "superChildren";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 6, 9, 12, 13, 16, 19, 20, 23, 26, 30, 31, 32 -> new IllegalStateException(string);
        };
    }
}

