/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.lang.annotator;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ruby.rbs.psi.RbsModuleDeclarationElement;
import com.intellij.lang.ruby.rbs.psi.RbsModuleSelfType;
import com.intellij.lang.ruby.rbs.psi.navigators.RbsModuleDeclarationNavigator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ruby.rbs.frontback.RbsBundle;
import com.intellij.ruby.rbs.frontback.psi.tree.RbsElementTypesGenerated;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

final class RbsRemoveModuleSelfTypeQuickFix
implements LocalQuickFix,
DumbAware {
    @NlsSafe
    private final String myQualifiedName;

    RbsRemoveModuleSelfTypeQuickFix(@NlsSafe @NotNull String qualifiedName) {
        if (qualifiedName == null) {
            RbsRemoveModuleSelfTypeQuickFix.$$$reportNull$$$0(0);
        }
        this.myQualifiedName = qualifiedName;
    }

    @NotNull
    public String getName() {
        String string = RbsBundle.message((String)"rbs.annotation.type.alias.used.as.self.type.remove.intention.name", (Object[])new Object[]{this.myQualifiedName});
        if (string == null) {
            RbsRemoveModuleSelfTypeQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = RbsBundle.message((String)"rbs.annotation.type.alias.used.as.self.type.remove.intention.family.name", (Object[])new Object[0]);
        if (string == null) {
            RbsRemoveModuleSelfTypeQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            RbsRemoveModuleSelfTypeQuickFix.$$$reportNull$$$0(3);
        }
        if (descriptor == null) {
            RbsRemoveModuleSelfTypeQuickFix.$$$reportNull$$$0(4);
        }
        RbsModuleSelfType selfType = (RbsModuleSelfType)descriptor.getPsiElement();
        RbsModuleDeclarationElement module = Objects.requireNonNull(RbsModuleDeclarationNavigator.getBySelfType(selfType));
        PsiElement next = PsiTreeUtil.skipWhitespacesForward((PsiElement)selfType);
        if (PsiUtilCore.getElementType((PsiElement)next) == RbsElementTypesGenerated.RBS_KCOMMA) {
            module.deleteChildRange(selfType, next);
        } else {
            PsiElement previous = PsiTreeUtil.skipWhitespacesBackward((PsiElement)selfType);
            if (List.of(RbsElementTypesGenerated.RBS_KCOLON, RbsElementTypesGenerated.RBS_KCOMMA).contains(PsiUtilCore.getElementType((PsiElement)previous))) {
                module.deleteChildRange(previous, selfType);
            } else {
                selfType.delete();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/lang/annotator/RbsRemoveModuleSelfTypeQuickFix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/lang/annotator/RbsRemoveModuleSelfTypeQuickFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

