/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.lang.annotator;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.ruby.rbs.lang.annotator.RbsAddTypeVariableDefaultTypeQuickFix;
import com.intellij.lang.ruby.rbs.lang.annotator.RbsRemoveBlockQuickFix;
import com.intellij.lang.ruby.rbs.lang.annotator.RbsRemoveMethodSelfTypeBindingQuickFix;
import com.intellij.lang.ruby.rbs.lang.annotator.RbsRemoveModuleSelfTypeQuickFix;
import com.intellij.lang.ruby.rbs.lang.annotator.RbsRemovePrependStatementQuickFix;
import com.intellij.lang.ruby.rbs.lang.annotator.RbsRemoveProcSelfTypeBindingQuickFix;
import com.intellij.lang.ruby.rbs.lang.annotator.RbsRemoveSelfPrefixFromAliasQuickFix;
import com.intellij.lang.ruby.rbs.lang.annotator.RbsRemoveSelfPrefixFromMethodQuickFix;
import com.intellij.lang.ruby.rbs.lang.annotator.RbsRemoveStatementQuickFix;
import com.intellij.lang.ruby.rbs.lang.annotator.RbsRemoveVisibilityModifierQuickFix;
import com.intellij.lang.ruby.rbs.lang.annotator.RbsReplacePrependWithExtendIntention;
import com.intellij.lang.ruby.rbs.lang.annotator.RbsReplacePrependWithIncludeIntention;
import com.intellij.lang.ruby.rbs.lang.annotator.RbsReplaceTypeQuickFix;
import com.intellij.lang.ruby.rbs.lang.annotator.RbsReplaceTypeVariableReferenceQuickFix;
import com.intellij.lang.ruby.rbs.model.impl.RbsUseClauseAliasSymbol;
import com.intellij.lang.ruby.rbs.model.psi.RbsPsiSymbolDeclaration;
import com.intellij.lang.ruby.rbs.model.rename.RbsSymbolRenameTargetFactory;
import com.intellij.lang.ruby.rbs.psi.RbsAliasMember;
import com.intellij.lang.ruby.rbs.psi.RbsBlock;
import com.intellij.lang.ruby.rbs.psi.RbsContainerDeclarationElement;
import com.intellij.lang.ruby.rbs.psi.RbsDeclarationType;
import com.intellij.lang.ruby.rbs.psi.RbsDefaultType;
import com.intellij.lang.ruby.rbs.psi.RbsIncludeMember;
import com.intellij.lang.ruby.rbs.psi.RbsInterfaceDecl;
import com.intellij.lang.ruby.rbs.psi.RbsInterfaceDeclaration;
import com.intellij.lang.ruby.rbs.psi.RbsMethodMember;
import com.intellij.lang.ruby.rbs.psi.RbsMethodType;
import com.intellij.lang.ruby.rbs.psi.RbsModuleSelfType;
import com.intellij.lang.ruby.rbs.psi.RbsModuleTypeParam;
import com.intellij.lang.ruby.rbs.psi.RbsModuleTypeParams;
import com.intellij.lang.ruby.rbs.psi.RbsPrependMember;
import com.intellij.lang.ruby.rbs.psi.RbsPsiVisitor;
import com.intellij.lang.ruby.rbs.psi.RbsQualifiedName;
import com.intellij.lang.ruby.rbs.psi.RbsQualifiedNameElement;
import com.intellij.lang.ruby.rbs.psi.RbsSelfTypeBinding;
import com.intellij.lang.ruby.rbs.psi.RbsSimpleType;
import com.intellij.lang.ruby.rbs.psi.RbsStatementElement;
import com.intellij.lang.ruby.rbs.psi.RbsTypeContext;
import com.intellij.lang.ruby.rbs.psi.RbsUseClauseType;
import com.intellij.lang.ruby.rbs.psi.RbsUseCls;
import com.intellij.lang.ruby.rbs.psi.RbsVisibilityModifier;
import com.intellij.lang.ruby.rbs.psi.data.RbsOptionalTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeVariableReferenceSignature;
import com.intellij.lang.ruby.rbs.psi.impl.RbsMethodMemberImpl;
import com.intellij.lang.ruby.rbs.psi.impl.RbsProcTypeImpl;
import com.intellij.lang.ruby.rbs.psi.navigators.RbsMethodDeclarationNavigator;
import com.intellij.lang.ruby.rbs.psi.navigators.RbsModuleDeclarationNavigator;
import com.intellij.lang.ruby.rbs.psi.navigators.RbsProcTypeNavigator;
import com.intellij.lang.ruby.rbs.util.RbsNamingConventionUtils;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.rename.api.RenameTarget;
import com.intellij.refactoring.rename.impl.StartRenameQuickFix;
import com.intellij.ruby.rbs.frontback.RbsBundle;
import com.intellij.ruby.rbs.frontback.psi.tree.RbsElementTypesGenerated;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public final class RbsAnnotator
implements Annotator,
DumbAware {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            RbsAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            RbsAnnotator.$$$reportNull$$$0(1);
        }
        element.accept((PsiElementVisitor)new MyVisitor(holder));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/ruby/rbs/lang/annotator/RbsAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyVisitor
    extends RbsPsiVisitor {
        private final AnnotationHolder myAnnotationHolder;

        private MyVisitor(@NotNull AnnotationHolder annotationHolder) {
            if (annotationHolder == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            this.myAnnotationHolder = annotationHolder;
        }

        @Override
        public void visitAliasMember(@NotNull RbsAliasMember aliasMember) {
            if (aliasMember == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            this.checkSingletonAliasInInterface(aliasMember);
        }

        @Override
        public void visitBlock(@NotNull RbsBlock block) {
            RbsProcTypeImpl procType;
            if (block == null) {
                MyVisitor.$$$reportNull$$$0(2);
            }
            if ((procType = RbsProcTypeNavigator.getByBlock(block)) == null || !procType.hasUntypedParameters()) {
                return;
            }
            Project project = block.getProject();
            String text = block.getText();
            String message = RbsBundle.message((String)"rbs.annotation.block.with.untyped.parameters", (Object[])new Object[]{text});
            RbsRemoveBlockQuickFix quickFix = new RbsRemoveBlockQuickFix(text);
            ProblemDescriptor descriptor = InspectionManager.getInstance((Project)project).createProblemDescriptor((PsiElement)block, message, (LocalQuickFix)quickFix, ProblemHighlightType.ERROR, true);
            this.myAnnotationHolder.newAnnotation(HighlightSeverity.ERROR, RbsBundle.message((String)"rbs.annotation.block.with.untyped.parameters", (Object[])new Object[0])).newLocalQuickFix((LocalQuickFix)quickFix, descriptor).registerFix().create();
        }

        @Override
        public void visitIncludeMember(@NotNull RbsIncludeMember includeMember) {
            if (includeMember == null) {
                MyVisitor.$$$reportNull$$$0(3);
            }
            this.checkNonInterfacedIncludeInInterface(includeMember);
        }

        @Override
        public void visitMethodMember(@NotNull RbsMethodMember methodMember) {
            if (methodMember == null) {
                MyVisitor.$$$reportNull$$$0(4);
            }
            this.checkSingletonMethodInInterface(methodMember);
        }

        @Override
        public void visitModuleSelfType(@NotNull RbsModuleSelfType selfType) {
            if (selfType == null) {
                MyVisitor.$$$reportNull$$$0(5);
            }
            Project project = selfType.getProject();
            if (RbsModuleDeclarationNavigator.getBySelfType(selfType) == null) {
                return;
            }
            PsiElement identifier = selfType.getQualifiedName().getNameIdentifier();
            if (identifier == null || !RbsNamingConventionUtils.isValidTypeAliasName(identifier.getText())) {
                return;
            }
            String message = RbsBundle.message((String)"rbs.annotation.type.alias.used.as.self.type", (Object[])new Object[0]);
            RbsRemoveModuleSelfTypeQuickFix fix = new RbsRemoveModuleSelfTypeQuickFix(selfType.getQualifiedName().getStrippedText());
            ProblemDescriptor descriptor = InspectionManager.getInstance((Project)project).createProblemDescriptor((PsiElement)selfType, identifier.getTextRangeInParent(), message, ProblemHighlightType.ERROR, true, new LocalQuickFix[0]);
            this.myAnnotationHolder.newAnnotation(HighlightSeverity.ERROR, message).range(identifier).newLocalQuickFix((LocalQuickFix)fix, descriptor).registerFix().create();
        }

        @Override
        public void visitModuleTypeParam(@NotNull RbsModuleTypeParam typeParameter) {
            if (typeParameter == null) {
                MyVisitor.$$$reportNull$$$0(6);
            }
            if (typeParameter.getDefaultType() != null) {
                return;
            }
            boolean isAfterDefaultTypeParameter = false;
            for (PsiElement sibling = typeParameter.getPrevSibling(); sibling != null; sibling = sibling.getPrevSibling()) {
                RbsModuleTypeParam previousTypeParameter;
                if (!(sibling instanceof RbsModuleTypeParam) || (previousTypeParameter = (RbsModuleTypeParam)sibling).getDefaultType() == null) continue;
                isAfterDefaultTypeParameter = true;
                break;
            }
            if (!isAfterDefaultTypeParameter) {
                return;
            }
            Project project = typeParameter.getProject();
            String message = RbsBundle.message((String)"rbs.annotation.type.variable.after.optional.type.variable", (Object[])new Object[0]);
            RbsAddTypeVariableDefaultTypeQuickFix quickFix = new RbsAddTypeVariableDefaultTypeQuickFix();
            ProblemDescriptor descriptor = InspectionManager.getInstance((Project)project).createProblemDescriptor((PsiElement)typeParameter, message, (LocalQuickFix)quickFix, ProblemHighlightType.ERROR, true);
            this.myAnnotationHolder.newAnnotation(HighlightSeverity.ERROR, message).newLocalQuickFix((LocalQuickFix)quickFix, descriptor).registerFix().create();
        }

        @Override
        public void visitPrependMember(@NotNull RbsPrependMember member) {
            PsiElement identifier;
            if (member == null) {
                MyVisitor.$$$reportNull$$$0(7);
            }
            if ((identifier = (PsiElement)ObjectUtils.doIfNotNull((Object)member.getQualifiedName(), RbsQualifiedNameElement::getNameIdentifier)) == null) {
                return;
            }
            String text = member.getIncludedModuleText();
            if (text == null || !RbsNamingConventionUtils.isValidInterfaceName(text)) {
                return;
            }
            RbsRemovePrependStatementQuickFix removeFix = new RbsRemovePrependStatementQuickFix(text);
            String message = RbsBundle.message((String)"rbs.annotation.interface.prepended.remove.quickfix.name", (Object[])new Object[]{text});
            ProblemDescriptor removeProblemDescriptor = InspectionManager.getInstance((Project)member.getProject()).createProblemDescriptor((PsiElement)member, message, (LocalQuickFix)removeFix, ProblemHighlightType.ERROR, true);
            TextRange textRange = identifier.getTextRange();
            this.myAnnotationHolder.newAnnotation(HighlightSeverity.ERROR, RbsBundle.message((String)"rbs.annotation.interface.prepended", (Object[])new Object[0])).withFix((IntentionAction)new RbsReplacePrependWithIncludeIntention(text)).withFix((IntentionAction)new RbsReplacePrependWithExtendIntention(text)).newLocalQuickFix((LocalQuickFix)removeFix, removeProblemDescriptor).registerFix().range(new TextRange(textRange.getStartOffset() + 1, textRange.getEndOffset())).create();
        }

        @Override
        public void visitSelfTypeBinding(@NotNull RbsSelfTypeBinding binding) {
            RbsProcTypeImpl procType;
            if (binding == null) {
                MyVisitor.$$$reportNull$$$0(8);
            }
            if ((procType = RbsProcTypeNavigator.getBySelfTypeBinding(binding)) == null) {
                return;
            }
            Project project = binding.getProject();
            String text = binding.getText();
            if (procType.getParent() instanceof RbsMethodType) {
                String message = RbsBundle.message((String)"rbs.annotation.self.type.in.method.remove.quickfix.name", (Object[])new Object[]{text});
                RbsRemoveMethodSelfTypeBindingQuickFix quickFix = new RbsRemoveMethodSelfTypeBindingQuickFix(text);
                ProblemDescriptor descriptor = InspectionManager.getInstance((Project)project).createProblemDescriptor((PsiElement)binding, message, (LocalQuickFix)quickFix, ProblemHighlightType.ERROR, true);
                this.myAnnotationHolder.newAnnotation(HighlightSeverity.ERROR, RbsBundle.message((String)"rbs.annotation.self.type.in.method", (Object[])new Object[0])).newLocalQuickFix((LocalQuickFix)quickFix, descriptor).registerFix().create();
            } else if (procType.getParent() instanceof RbsSimpleType && procType.hasUntypedParameters()) {
                String message = RbsBundle.message((String)"rbs.annotation.self.type.in.proc.with.untyped.parameters.remove.quickfix.name", (Object[])new Object[]{text});
                RbsRemoveProcSelfTypeBindingQuickFix quickFix = new RbsRemoveProcSelfTypeBindingQuickFix(text);
                ProblemDescriptor descriptor = InspectionManager.getInstance((Project)project).createProblemDescriptor((PsiElement)binding, message, (LocalQuickFix)quickFix, ProblemHighlightType.ERROR, true);
                this.myAnnotationHolder.newAnnotation(HighlightSeverity.ERROR, RbsBundle.message((String)"rbs.annotation.self.type.in.proc.with.untyped.parameters", (Object[])new Object[0])).newLocalQuickFix((LocalQuickFix)quickFix, descriptor).registerFix().create();
            }
        }

        @Override
        public void visitSimpleType(@NotNull RbsSimpleType type) {
            IElementType elementType;
            if (type == null) {
                MyVisitor.$$$reportNull$$$0(9);
            }
            if ((elementType = PsiUtilCore.getElementType((PsiElement)type.getKeyword())) == RbsElementTypesGenerated.RBS_KCLASS || elementType == RbsElementTypesGenerated.RBS_KINSTANCE) {
                this.checkKeywordTypeInValidContext(type, TextRange.allOf((String)type.getText()), RbsTypeContext.CLASSISH_CONTEXT);
            } else if (elementType == RbsElementTypesGenerated.RBS_KSELF || elementType == RbsElementTypesGenerated.RBS_KSELFQ) {
                this.checkKeywordTypeInValidContext(type, TextRange.from((int)0, (int)4), RbsTypeContext.SELF_CONTEXT);
            } else if (elementType == RbsElementTypesGenerated.RBS_KVOID) {
                this.checkKeywordTypeInValidContext(type, TextRange.from((int)0, (int)4), RbsTypeContext.VOID_CONTEXT);
            }
            RbsQualifiedName qualifiedName = type.getQualifiedName();
            if (qualifiedName == null) {
                return;
            }
            RbsDefaultType defaultType = (RbsDefaultType)PsiTreeUtil.getParentOfType((PsiElement)type, RbsDefaultType.class, (boolean)true, (Class[])new Class[]{RbsStatementElement.class});
            RbsModuleTypeParams typeParameters = (RbsModuleTypeParams)PsiTreeUtil.getParentOfType((PsiElement)defaultType, RbsModuleTypeParams.class);
            if (defaultType == null || typeParameters == null) {
                return;
            }
            RbsTypeVariableReferenceSignature typeSignature = Optional.of(type.getTypeSignature()).map(it -> {
                RbsTypeSignature rbsTypeSignature;
                if (it instanceof RbsOptionalTypeSignature) {
                    RbsOptionalTypeSignature optionalTypeSignature = (RbsOptionalTypeSignature)it;
                    rbsTypeSignature = optionalTypeSignature.getTypeSignature();
                } else {
                    rbsTypeSignature = it;
                }
                return rbsTypeSignature;
            }).map(it -> (RbsTypeVariableReferenceSignature)ObjectUtils.tryCast((Object)it, RbsTypeVariableReferenceSignature.class)).orElse(null);
            if (typeSignature == null) {
                return;
            }
            if (typeSignature.getReferenceType() == RbsTypeVariableReferenceSignature.ReferenceType.METHOD_VARIABLE) {
                return;
            }
            RbsModuleTypeParam typeParameter = (RbsModuleTypeParam)ContainerUtil.getOrElse(typeParameters.getModuleTypeParamList(), (int)typeSignature.getPosition(), null);
            if (typeParameter == null || typeParameter.getDefaultType() == null) {
                return;
            }
            Project project = type.getProject();
            String message = RbsBundle.message((String)"rbs.annotation.type.variable.depends.on.optional.type.variable", (Object[])new Object[0]);
            TextRange rangeInElement = TextRange.from((int)0, (int)qualifiedName.getText().length());
            RbsReplaceTypeVariableReferenceQuickFix quickFix = new RbsReplaceTypeVariableReferenceQuickFix(qualifiedName.getText());
            ProblemDescriptor descriptor = InspectionManager.getInstance((Project)project).createProblemDescriptor((PsiElement)qualifiedName, message, (LocalQuickFix)quickFix, ProblemHighlightType.ERROR, true);
            this.myAnnotationHolder.newAnnotation(HighlightSeverity.ERROR, message).range(rangeInElement.shiftRight(type.getTextOffset())).newLocalQuickFix((LocalQuickFix)quickFix, descriptor).registerFix().create();
        }

        @Override
        public void visitUseCls(@NotNull RbsUseCls useClause) {
            String message;
            if (useClause == null) {
                MyVisitor.$$$reportNull$$$0(10);
            }
            Project project = useClause.getProject();
            RbsUseClauseType rbsUseClauseType = useClause.getClauseType();
            if (!(rbsUseClauseType instanceof RbsUseClauseType.Alias)) {
                return;
            }
            RbsUseClauseType.Alias type = (RbsUseClauseType.Alias)rbsUseClauseType;
            RbsPsiSymbolDeclaration<RbsUseClauseAliasSymbol> declaration = useClause.getSymbolDeclaration();
            if (declaration == null) {
                return;
            }
            String targetName = type.fqn().split().getName();
            String name = type.name();
            if (RbsNamingConventionUtils.isValidInterfaceName(targetName) && !RbsNamingConventionUtils.isValidInterfaceName(name)) {
                message = RbsBundle.message((String)"rbs.annotation.use.alias.mismatched.case.interface", (Object[])new Object[]{name});
            } else if (RbsNamingConventionUtils.isValidTypeAliasName(targetName) && !RbsNamingConventionUtils.isValidTypeAliasName(name)) {
                message = RbsBundle.message((String)"rbs.annotation.use.alias.mismatched.case.lowercase", (Object[])new Object[]{name});
            } else if (RbsNamingConventionUtils.isValidClassName(targetName) && !RbsNamingConventionUtils.isValidClassName(name)) {
                message = RbsBundle.message((String)"rbs.annotation.use.alias.mismatched.case.uppercase", (Object[])new Object[]{name});
            } else {
                return;
            }
            AnnotationBuilder builder = this.myAnnotationHolder.newAnnotation(HighlightSeverity.ERROR, message).range(declaration.getAbsoluteRange());
            RenameTarget renameTarget = RbsSymbolRenameTargetFactory.getRenameTarget(project, declaration.getSymbol());
            if (renameTarget != null && !RbsNamingConventionUtils.isValidInterfaceName(name)) {
                builder = builder.withFix((IntentionAction)new StartRenameQuickFix(renameTarget));
            }
            builder.create();
        }

        @Override
        public void visitVisibilityModifier(@NotNull RbsVisibilityModifier modifier) {
            RbsMethodMemberImpl method;
            if (modifier == null) {
                MyVisitor.$$$reportNull$$$0(11);
            }
            Project project = modifier.getProject();
            RbsContainerDeclarationElement container = (RbsContainerDeclarationElement)PsiTreeUtil.getParentOfType((PsiElement)modifier, RbsContainerDeclarationElement.class);
            if (container instanceof RbsInterfaceDeclaration) {
                String message = RbsBundle.message((String)"rbs.annotation.visibility.modifier.used.in.interface", (Object[])new Object[0]);
                ProblemDescriptor descriptor = InspectionManager.getInstance((Project)project).createProblemDescriptor((PsiElement)modifier, message, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.ERROR, true, true);
                this.myAnnotationHolder.newAnnotation(HighlightSeverity.ERROR, message).newLocalQuickFix((LocalQuickFix)new RbsRemoveVisibilityModifierQuickFix(modifier.getText()), descriptor).registerFix().create();
            }
            if ((method = RbsMethodDeclarationNavigator.getByVisibilityModifier(modifier)) != null && method.getDeclarationTypes().size() == 2) {
                String message = RbsBundle.message((String)"rbs.annotation.visibility.modifier.used.in.module.method", (Object[])new Object[0]);
                ProblemDescriptor descriptor = InspectionManager.getInstance((Project)project).createProblemDescriptor((PsiElement)modifier, message, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.ERROR, true, true);
                this.myAnnotationHolder.newAnnotation(HighlightSeverity.ERROR, message).newLocalQuickFix((LocalQuickFix)new RbsRemoveVisibilityModifierQuickFix(modifier.getText()), descriptor).registerFix().create();
            }
        }

        private void checkKeywordTypeInValidContext(@NotNull RbsSimpleType type, @NotNull TextRange rangeInElement, @NotNull RbsTypeContext expectedTypeContext) {
            if (type == null) {
                MyVisitor.$$$reportNull$$$0(12);
            }
            if (rangeInElement == null) {
                MyVisitor.$$$reportNull$$$0(13);
            }
            if (expectedTypeContext == null) {
                MyVisitor.$$$reportNull$$$0(14);
            }
            Project project = type.getProject();
            if (RbsTypeContext.getElementContexts(type).contains((Object)expectedTypeContext)) {
                return;
            }
            String text = rangeInElement.substring(type.getText());
            String message = RbsBundle.message((String)"rbs.annotation.type.contexts.keyword.in.invalid.context", (Object[])new Object[]{text});
            ProblemDescriptor descriptor = InspectionManager.getInstance((Project)project).createProblemDescriptor((PsiElement)type, rangeInElement, message, ProblemHighlightType.ERROR, true, new LocalQuickFix[0]);
            this.myAnnotationHolder.newAnnotation(HighlightSeverity.ERROR, message).range(rangeInElement.shiftRight(type.getTextOffset())).newLocalQuickFix((LocalQuickFix)new RbsReplaceTypeQuickFix(text), descriptor).registerFix().create();
        }

        private void checkNonInterfacedIncludeInInterface(@NotNull RbsIncludeMember includeMember) {
            if (includeMember == null) {
                MyVisitor.$$$reportNull$$$0(15);
            }
            RbsInterfaceDecl interfaceParent = (RbsInterfaceDecl)PsiTreeUtil.getParentOfType((PsiElement)includeMember, RbsInterfaceDecl.class);
            PsiElement lastFQNPart = (PsiElement)ObjectUtils.doIfNotNull((Object)includeMember.getQualifiedName(), RbsQualifiedNameElement::getNameIdentifier);
            if (interfaceParent != null && lastFQNPart != null && !RbsNamingConventionUtils.isValidInterfaceName(lastFQNPart.getText())) {
                RbsRemoveStatementQuickFix removeQuickFix = new RbsRemoveStatementQuickFix(RbsBundle.message((String)"rbs.annotation.remove.include.statement.quickfix.name", (Object[])new Object[0]));
                ProblemDescriptor descriptor = InspectionManager.getInstance((Project)includeMember.getProject()).createProblemDescriptor((PsiElement)includeMember, RbsBundle.message((String)"rbs.annotation.module.included.in.interface", (Object[])new Object[0]), (LocalQuickFix)removeQuickFix, ProblemHighlightType.ERROR, true);
                this.myAnnotationHolder.newAnnotation(HighlightSeverity.ERROR, RbsBundle.message((String)"rbs.annotation.module.included.in.interface", (Object[])new Object[0])).range(lastFQNPart).newLocalQuickFix((LocalQuickFix)removeQuickFix, descriptor).registerFix().create();
            }
        }

        private void checkSingletonMethodInInterface(@NotNull RbsMethodMember methodMember) {
            if (methodMember == null) {
                MyVisitor.$$$reportNull$$$0(16);
            }
            RbsInterfaceDecl interfaceParent = (RbsInterfaceDecl)PsiTreeUtil.getParentOfType((PsiElement)methodMember, RbsInterfaceDecl.class);
            if (methodMember.getDeclarationTypes().contains((Object)RbsDeclarationType.SINGLETON_DECLARATION) && interfaceParent != null) {
                RbsRemoveStatementQuickFix removeQuickFix = new RbsRemoveStatementQuickFix(RbsBundle.message((String)"rbs.annotation.singleton.in.interface.remove.quickfix.name", (Object[])new Object[0]));
                ProblemDescriptor removeDescriptor = InspectionManager.getInstance((Project)methodMember.getProject()).createProblemDescriptor((PsiElement)methodMember, RbsBundle.message((String)"rbs.annotation.singleton.in.interface", (Object[])new Object[0]), (LocalQuickFix)removeQuickFix, ProblemHighlightType.ERROR, true);
                RbsRemoveSelfPrefixFromMethodQuickFix removeSelfQuickFix = new RbsRemoveSelfPrefixFromMethodQuickFix();
                ProblemDescriptor removeSelfDescriptor = InspectionManager.getInstance((Project)methodMember.getProject()).createProblemDescriptor((PsiElement)methodMember, RbsBundle.message((String)"rbs.annotation.singleton.in.interface", (Object[])new Object[0]), (LocalQuickFix)removeSelfQuickFix, ProblemHighlightType.ERROR, true);
                this.myAnnotationHolder.newAnnotation(HighlightSeverity.ERROR, RbsBundle.message((String)"rbs.annotation.singleton.in.interface", (Object[])new Object[0])).range((PsiElement)Objects.requireNonNullElse(methodMember.getMethodName(), methodMember)).newLocalQuickFix((LocalQuickFix)removeQuickFix, removeDescriptor).registerFix().newLocalQuickFix((LocalQuickFix)removeSelfQuickFix, removeSelfDescriptor).registerFix().create();
            }
        }

        private void checkSingletonAliasInInterface(@NotNull RbsAliasMember aliasMember) {
            RbsInterfaceDecl interfaceParent;
            if (aliasMember == null) {
                MyVisitor.$$$reportNull$$$0(17);
            }
            if ((interfaceParent = (RbsInterfaceDecl)PsiTreeUtil.getParentOfType((PsiElement)aliasMember, RbsInterfaceDecl.class)) != null && aliasMember.getDeclarationType() == RbsDeclarationType.SINGLETON_DECLARATION) {
                RbsRemoveStatementQuickFix removeQuickFix = new RbsRemoveStatementQuickFix(RbsBundle.message((String)"rbs.annotation.singleton.in.interface.remove.alias.quickfix.name", (Object[])new Object[0]));
                ProblemDescriptor removeDescriptor = InspectionManager.getInstance((Project)aliasMember.getProject()).createProblemDescriptor((PsiElement)aliasMember, RbsBundle.message((String)"rbs.annotation.singleton.in.interface", (Object[])new Object[0]), (LocalQuickFix)removeQuickFix, ProblemHighlightType.ERROR, true);
                RbsRemoveSelfPrefixFromAliasQuickFix removeSelfQuickFix = new RbsRemoveSelfPrefixFromAliasQuickFix();
                ProblemDescriptor removeSelfDescriptor = InspectionManager.getInstance((Project)aliasMember.getProject()).createProblemDescriptor((PsiElement)aliasMember, RbsBundle.message((String)"rbs.annotation.singleton.in.interface", (Object[])new Object[0]), (LocalQuickFix)removeSelfQuickFix, ProblemHighlightType.ERROR, true);
                this.myAnnotationHolder.newAnnotation(HighlightSeverity.ERROR, RbsBundle.message((String)"rbs.annotation.singleton.in.interface", (Object[])new Object[0])).range((PsiElement)Objects.requireNonNullElse(aliasMember.getAliasMethodNameIdentifier(), aliasMember)).newLocalQuickFix((LocalQuickFix)removeQuickFix, removeDescriptor).registerFix().newLocalQuickFix((LocalQuickFix)removeSelfQuickFix, removeSelfDescriptor).registerFix().create();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "annotationHolder";
                    break;
                }
                case 1: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aliasMember";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "block";
                    break;
                }
                case 3: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "includeMember";
                    break;
                }
                case 4: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodMember";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selfType";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeParameter";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "member";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "binding";
                    break;
                }
                case 9: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "useClause";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modifier";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rangeInElement";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expectedTypeContext";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/ruby/rbs/lang/annotator/RbsAnnotator$MyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAliasMember";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitBlock";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitIncludeMember";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodMember";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitModuleSelfType";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitModuleTypeParam";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPrependMember";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSelfTypeBinding";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitSimpleType";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitUseCls";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitVisibilityModifier";
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkKeywordTypeInValidContext";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkNonInterfacedIncludeInInterface";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkSingletonMethodInInterface";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkSingletonAliasInInterface";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

