/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.inspections.probableBugs;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.ruby.rbs.completion.RbsQualifiedNameCompletionTarget;
import com.intellij.lang.ruby.rbs.model.api.RbsQualifiedNameSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsClassSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsInterfaceSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsModuleSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsTypeAliasSymbol;
import com.intellij.lang.ruby.rbs.model.psi.RbsPsiSymbolReference;
import com.intellij.lang.ruby.rbs.model.psi.RbsQualifiedNameSymbolReference;
import com.intellij.lang.ruby.rbs.psi.RbsPsiVisitor;
import com.intellij.lang.ruby.rbs.psi.RbsUseClause;
import com.intellij.lang.ruby.rbs.psi.RbsUseClauseType;
import com.intellij.lang.ruby.rbs.psi.impl.RbsUseDirectiveImpl;
import com.intellij.lang.ruby.rbs.psi.util.RbsPsiEditUtil;
import com.intellij.lang.ruby.rbs.psi.util.RbsPsiElementFactory;
import com.intellij.lang.ruby.rbs.util.Fqn;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.model.psi.PsiSymbolReferenceService;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.ruby.rbs.frontback.RbsBundle;
import com.intellij.ui.list.TargetPopup;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class RbsUnresolvedReferenceInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RbsUnresolvedReferenceInspection.$$$reportNull$$$0(0);
        }
        return new MyVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsUnresolvedReferenceInspection", "buildVisitor"));
    }

    private static class MyVisitor
    extends RbsPsiVisitor {
        private final Project myProject;
        private final ProblemsHolder myProblemsHolder;

        protected MyVisitor(@NotNull ProblemsHolder holder) {
            if (holder == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            this.myProject = holder.getProject();
            this.myProblemsHolder = holder;
        }

        @Override
        public void visitPsiElement(@NotNull PsiElement element) {
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            for (RbsPsiSymbolReference reference : PsiSymbolReferenceService.getService().getReferences(element, RbsPsiSymbolReference.class)) {
                if (!reference.resolveReference().isEmpty()) continue;
                ArrayList<MyQuickFix> fixes = new ArrayList<MyQuickFix>();
                if (reference instanceof RbsQualifiedNameSymbolReference) {
                    Set<RbsQualifiedNameSymbol> candidates;
                    RbsQualifiedNameSymbolReference qualifiedNameReference = (RbsQualifiedNameSymbolReference)reference;
                    if (!(element instanceof RbsUseClause || qualifiedNameReference.getQualifiedName().contains("::") || (candidates = MyVisitor.getUseClauseCandidates(this.myProject, qualifiedNameReference.getSearchScope(), qualifiedNameReference)).isEmpty())) {
                        fixes.add(new MyQuickFix(candidates));
                    }
                }
                this.myProblemsHolder.registerProblem(element, MyVisitor.getErrorMessage((PsiSymbolReference)reference), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, reference.getRangeInElement(), fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            }
        }

        @InspectionMessage
        @NotNull
        private static String getErrorMessage(@NotNull PsiSymbolReference reference) {
            if (reference == null) {
                MyVisitor.$$$reportNull$$$0(2);
            }
            if (reference instanceof RbsQualifiedNameSymbolReference) {
                String string = RbsBundle.message((String)"rbs.inspection.unresolved.reference.description", (Object[])new Object[]{((RbsQualifiedNameSymbolReference)reference).getQualifiedName()});
                if (string == null) {
                    MyVisitor.$$$reportNull$$$0(3);
                }
                return string;
            }
            String string = RbsBundle.message((String)"rbs.inspection.unresolved.reference.description", (Object[])new Object[]{PsiSymbolReference.getReferenceText((PsiSymbolReference)reference)});
            if (string == null) {
                MyVisitor.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        private static Set<RbsQualifiedNameSymbol> getUseClauseCandidates(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RbsQualifiedNameSymbolReference reference) {
            TreeSet<RbsQualifiedNameSymbol> candidates;
            EnumSet<RbsQualifiedNameCompletionTarget> targets;
            String name;
            block19: {
                block18: {
                    block17: {
                        block16: {
                            block15: {
                                block14: {
                                    if (project == null) {
                                        MyVisitor.$$$reportNull$$$0(5);
                                    }
                                    if (searchScope == null) {
                                        MyVisitor.$$$reportNull$$$0(6);
                                    }
                                    if (reference == null) {
                                        MyVisitor.$$$reportNull$$$0(7);
                                    }
                                    name = PsiSymbolReference.getReferenceText((PsiSymbolReference)reference);
                                    targets = reference.getCompletionTargets();
                                    candidates = new TreeSet<RbsQualifiedNameSymbol>(Comparator.comparing(it -> it.getFqn().split().getParent()));
                                    if (targets.contains((Object)RbsQualifiedNameCompletionTarget.CLASS)) break block14;
                                    if (!targets.isEmpty()) break block15;
                                }
                                RbsClassSymbol.stream(project, searchScope).filter(it -> it.getName().equals(name) && !it.getFqn().isEquivalentTo(name)).forEach(candidates::add);
                            }
                            if (targets.contains((Object)RbsQualifiedNameCompletionTarget.INTERFACE)) break block16;
                            if (!targets.isEmpty()) break block17;
                        }
                        RbsInterfaceSymbol.stream(project, searchScope).filter(it -> it.getName().equals(name) && !it.getFqn().isEquivalentTo("_" + name)).forEach(candidates::add);
                    }
                    if (targets.contains((Object)RbsQualifiedNameCompletionTarget.MODULE)) break block18;
                    if (!targets.isEmpty()) break block19;
                }
                RbsModuleSymbol.stream(project, searchScope).filter(it -> it.getName().equals(name) && !it.getFqn().isEquivalentTo(name)).forEach(candidates::add);
            }
            if (targets.contains((Object)RbsQualifiedNameCompletionTarget.TYPE_ALIAS)) {
                RbsTypeAliasSymbol.stream(project, searchScope).filter(it -> it.getName().equals(name) && !it.getFqn().isEquivalentTo(name)).forEach(candidates::add);
            }
            Set<RbsQualifiedNameSymbol> set = Collections.unmodifiableSet(candidates);
            if (set == null) {
                MyVisitor.$$$reportNull$$$0(8);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 3: 
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsUnresolvedReferenceInspection$MyVisitor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "searchScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsUnresolvedReferenceInspection$MyVisitor";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrorMessage";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUseClauseCandidates";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPsiElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getErrorMessage";
                    break;
                }
                case 3: 
                case 4: 
                case 8: {
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getUseClauseCandidates";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 8 -> new IllegalStateException(string);
            };
        }
    }

    private static class MyQuickFix
    implements LocalQuickFix,
    DumbAware {
        @FileModifier.SafeFieldForPreview
        private final List<RbsQualifiedNameSymbol> myCandidates;

        private MyQuickFix(@NotNull Collection<RbsQualifiedNameSymbol> candidates) {
            if (candidates == null) {
                MyQuickFix.$$$reportNull$$$0(0);
            }
            this.myCandidates = List.copyOf(candidates);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                MyQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                MyQuickFix.$$$reportNull$$$0(2);
            }
            PsiElement element = descriptor.getPsiElement();
            SmartPsiElementPointer pointer = SmartPointerManager.createPointer((PsiElement)element.getContainingFile());
            Consumer<RbsQualifiedNameSymbol> consumer = target -> {
                PsiFile file = (PsiFile)pointer.dereference();
                if (file == null) {
                    return;
                }
                RbsUseDirectiveImpl useDirective = RbsPsiElementFactory.createUseDirective(project, new RbsUseClauseType.Import(target.getFqn()));
                RbsPsiEditUtil.insertStatement((PsiElement)file, useDirective);
            };
            if (this.myCandidates.size() == 1) {
                consumer.accept((RbsQualifiedNameSymbol)ContainerUtil.getOnlyItem(this.myCandidates));
            } else if (this.myCandidates.size() > 1) {
                Editor editor = PsiEditorUtil.findEditor((PsiElement)element);
                if (editor == null) {
                    return;
                }
                String title = RbsBundle.message((String)"rbs.inspection.unresolved.reference.add.use.clause.quickfix.title", (Object[])new Object[0]);
                List presentations = ContainerUtil.map(this.myCandidates, candidate -> {
                    Fqn fqn = candidate.getFqn().split();
                    return TargetPresentation.builder((String)fqn.getName()).icon(candidate.getPresentation().icon()).containerText(fqn.getParent().join()).presentation();
                });
                TargetPopup.createTargetPopup((String)title, this.myCandidates, (List)presentations, target -> {
                    String command = RbsBundle.message((String)"rbs.inspection.unresolved.reference.add.use.clause.quickfix.command", (Object[])new Object[0]);
                    WriteCommandAction.runWriteCommandAction((Project)project, (String)command, null, () -> consumer.accept((RbsQualifiedNameSymbol)target), (PsiFile[])new PsiFile[0]);
                }).showInBestPositionFor(editor);
            }
        }

        public boolean availableInBatchMode() {
            return false;
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            RbsQualifiedNameSymbol target;
            if (project == null) {
                MyQuickFix.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                MyQuickFix.$$$reportNull$$$0(4);
            }
            if ((target = (RbsQualifiedNameSymbol)ContainerUtil.getFirstItem(this.myCandidates)) == null) {
                IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
                if (intentionPreviewInfo == null) {
                    MyQuickFix.$$$reportNull$$$0(5);
                }
                return intentionPreviewInfo;
            }
            RbsUseDirectiveImpl useDirective = RbsPsiElementFactory.createUseDirective(project, new RbsUseClauseType.Import(target.getFqn()));
            RbsPsiEditUtil.insertStatement((PsiElement)descriptor.getPsiElement().getContainingFile(), useDirective);
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
            if (intentionPreviewInfo == null) {
                MyQuickFix.$$$reportNull$$$0(6);
            }
            return intentionPreviewInfo;
        }

        @NotNull
        public String getFamilyName() {
            String string = RbsBundle.message((String)"rbs.inspection.unresolved.reference.add.use.clause.quickfix.family.name", (Object[])new Object[0]);
            if (string == null) {
                MyQuickFix.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "candidates";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsUnresolvedReferenceInspection$MyQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsUnresolvedReferenceInspection$MyQuickFix";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6, 7 -> new IllegalStateException(string);
            };
        }
    }
}

