/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.inspections.probableBugs;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ruby.rbs.model.api.RbsSymbol;
import com.intellij.lang.ruby.rbs.model.api.RbsSyntacticSugarSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsMethodSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsModuleMethodSymbol;
import com.intellij.lang.ruby.rbs.model.psi.RbsPsiSymbolDeclarationSearcher;
import com.intellij.lang.ruby.rbs.model.psi.RbsSearchScope;
import com.intellij.lang.ruby.rbs.psi.RbsAliasMember;
import com.intellij.lang.ruby.rbs.psi.RbsAttributeMember;
import com.intellij.lang.ruby.rbs.psi.RbsDeclarationType;
import com.intellij.lang.ruby.rbs.psi.RbsMethodDeclarationElement;
import com.intellij.lang.ruby.rbs.psi.RbsMethodMember;
import com.intellij.lang.ruby.rbs.psi.RbsMethodTypeMore;
import com.intellij.lang.ruby.rbs.psi.RbsPsiVisitor;
import com.intellij.lang.ruby.rbs.psi.util.RbsPsiEditUtil;
import com.intellij.lang.ruby.rbs.psi.util.RbsPsiElementFactory;
import com.intellij.model.Symbol;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ruby.rbs.frontback.RbsBundle;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.model.presentation.PresentableSymbol;
import org.jetbrains.plugins.ruby.model.presentation.SymbolPresentation;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;

@ApiStatus.Internal
public final class RbsInvalidMethodOverloadInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RbsInvalidMethodOverloadInspection.$$$reportNull$$$0(0);
        }
        return new MyVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsInvalidMethodOverloadInspection", "buildVisitor"));
    }

    private static final class MyVisitor
    extends RbsPsiVisitor {
        private final ProblemsHolder myHolder;

        private MyVisitor(@NotNull ProblemsHolder holder) {
            if (holder == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            this.myHolder = holder;
        }

        @Override
        public void visitMethodTypeMore(@NotNull RbsMethodTypeMore element) {
            RbsMethodSymbol methodSymbol;
            List<Object> candidates;
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            Project project = element.getProject();
            GlobalSearchScope searchScope = RbsSearchScope.collectionScope(project);
            RbsMethodDeclarationElement method = (RbsMethodDeclarationElement)PsiTreeUtil.getParentOfType((PsiElement)element, RbsMethodDeclarationElement.class);
            if (method == null) {
                return;
            }
            RbsSymbol rbsSymbol = method.getSymbol();
            if (!(rbsSymbol instanceof PresentableSymbol)) {
                return;
            }
            PresentableSymbol symbol = (PresentableSymbol)rbsSymbol;
            EnumSet<RbsDeclarationType> validDeclarationTypes = EnumSet.noneOf(RbsDeclarationType.class);
            if (symbol instanceof RbsSyntacticSugarSymbol) {
                RbsSyntacticSugarSymbol syntacticSugarSymbol = (RbsSyntacticSugarSymbol)symbol;
                candidates = syntacticSugarSymbol.getDynamicSymbols(project, (SearchScope)searchScope);
            } else {
                candidates = List.of(symbol);
            }
            for (Symbol symbol2 : candidates) {
                RbsPsiSymbolDeclarationSearcher.processDeclarations(project, (SearchScope)searchScope, symbol2, declaration -> {
                    ProgressManager.checkCanceled();
                    PsiElement declarationElement = declaration.getDeclaringElement();
                    if (PsiTreeUtil.hasErrorElements((PsiElement)declarationElement)) {
                        return true;
                    }
                    if (declarationElement instanceof RbsMethodMember) {
                        RbsMethodMember methodMember = (RbsMethodMember)declarationElement;
                        if (!methodMember.isOverloaded()) {
                            validDeclarationTypes.addAll(methodMember.getDeclarationTypes());
                        }
                    } else if (declarationElement instanceof RbsAliasMember) {
                        RbsAliasMember aliasMember = (RbsAliasMember)declarationElement;
                        validDeclarationTypes.add(aliasMember.getDeclarationType());
                    } else if (declarationElement instanceof RbsAttributeMember) {
                        RbsAttributeMember attributeMember = (RbsAttributeMember)declarationElement;
                        validDeclarationTypes.add(attributeMember.getDeclarationType());
                    } else {
                        throw new UnsupportedOperationException("Unrecognised declaration type: " + String.valueOf(declarationElement.getClass()));
                    }
                    return !validDeclarationTypes.equals(EnumSet.allOf(RbsDeclarationType.class));
                });
            }
            if (symbol instanceof RbsMethodSymbol && validDeclarationTypes.contains((Object)(methodSymbol = (RbsMethodSymbol)symbol).getDeclarationType())) {
                return;
            }
            if (symbol instanceof RbsModuleMethodSymbol && validDeclarationTypes.equals(EnumSet.allOf(RbsDeclarationType.class))) {
                return;
            }
            SymbolPresentation presentation = symbol.getPresentation();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (!method.getMethodTypeSignatures().isEmpty()) {
                arrayList.add(new MyRemoveMethodTypeMoreQuickFix());
            } else {
                arrayList.add(new MyReplaceMethodTypeMoreQuickFix());
                arrayList.add(new MyRemoveMethodDeclarationQuickFix(presentation.name()));
            }
            this.myHolder.registerProblem((PsiElement)element, RbsBundle.message((String)"rbs.inspection.invalid.method.overload.description", (Object[])new Object[]{TextUtil.decapitalize((String)presentation.longDescription())}), arrayList.toArray(LocalQuickFix.EMPTY_ARRAY));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsInvalidMethodOverloadInspection$MyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodTypeMore";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyReplaceMethodTypeMoreQuickFix
    implements LocalQuickFix,
    DumbAware {
        private MyReplaceMethodTypeMoreQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = RbsBundle.message((String)"rbs.inspection.invalid.method.overload.replace.quickfix.family.name", (Object[])new Object[0]);
            if (string == null) {
                MyReplaceMethodTypeMoreQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                MyReplaceMethodTypeMoreQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                MyReplaceMethodTypeMoreQuickFix.$$$reportNull$$$0(2);
            }
            PsiElement element = descriptor.getPsiElement();
            element.replace((PsiElement)RbsPsiElementFactory.createMethodType(project, "-> untyped"));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsInvalidMethodOverloadInspection$MyReplaceMethodTypeMoreQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsInvalidMethodOverloadInspection$MyReplaceMethodTypeMoreQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private static final class MyRemoveMethodTypeMoreQuickFix
    implements LocalQuickFix,
    DumbAware {
        private MyRemoveMethodTypeMoreQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = RbsBundle.message((String)"rbs.inspection.invalid.method.overload.remove.quickfix.family.name", (Object[])new Object[0]);
            if (string == null) {
                MyRemoveMethodTypeMoreQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                MyRemoveMethodTypeMoreQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                MyRemoveMethodTypeMoreQuickFix.$$$reportNull$$$0(2);
            }
            RbsPsiEditUtil.deleteMethodTypeMoreElement((RbsMethodTypeMore)descriptor.getPsiElement());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsInvalidMethodOverloadInspection$MyRemoveMethodTypeMoreQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsInvalidMethodOverloadInspection$MyRemoveMethodTypeMoreQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private static final class MyRemoveMethodDeclarationQuickFix
    implements LocalQuickFix,
    DumbAware,
    LowPriorityAction {
        private final String myMethodName;

        private MyRemoveMethodDeclarationQuickFix(@NotNull String methodName) {
            if (methodName == null) {
                MyRemoveMethodDeclarationQuickFix.$$$reportNull$$$0(0);
            }
            this.myMethodName = methodName;
        }

        @NotNull
        public String getName() {
            String string = RbsBundle.message((String)"rbs.inspection.invalid.method.overload.remove.method.quickfix.name", (Object[])new Object[]{this.myMethodName});
            if (string == null) {
                MyRemoveMethodDeclarationQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = RbsBundle.message((String)"rbs.inspection.invalid.method.overload.remove.method.quickfix.family.name", (Object[])new Object[0]);
            if (string == null) {
                MyRemoveMethodDeclarationQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                MyRemoveMethodDeclarationQuickFix.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                MyRemoveMethodDeclarationQuickFix.$$$reportNull$$$0(4);
            }
            Objects.requireNonNull((RbsMethodDeclarationElement)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), RbsMethodDeclarationElement.class)).delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsInvalidMethodOverloadInspection$MyRemoveMethodDeclarationQuickFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsInvalidMethodOverloadInspection$MyRemoveMethodDeclarationQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

