/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.inspections.probableBugs;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ruby.rbs.model.impl.RbsClassSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsModuleSymbol;
import com.intellij.lang.ruby.rbs.model.psi.RbsResolveUtil;
import com.intellij.lang.ruby.rbs.psi.RbsAliasSource;
import com.intellij.lang.ruby.rbs.psi.RbsClassAliasDeclarationElement;
import com.intellij.lang.ruby.rbs.psi.RbsModuleAliasDeclarationElement;
import com.intellij.lang.ruby.rbs.psi.RbsPsiVisitor;
import com.intellij.lang.ruby.rbs.psi.mixin.RbsClassAliasDeclarationMixin;
import com.intellij.lang.ruby.rbs.psi.mixin.RbsModuleAliasDeclarationMixin;
import com.intellij.lang.ruby.rbs.util.Fqn;
import com.intellij.model.Symbol;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ruby.rbs.frontback.RbsBundle;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DumbModeAccessType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.model.navigation.NavigationTargetPopup;

@ApiStatus.Internal
public final class RbsInconsistentClassModuleAliasInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RbsInconsistentClassModuleAliasInspection.$$$reportNull$$$0(0);
        }
        return new MyVisitor(holder.getProject(), holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsInconsistentClassModuleAliasInspection", "buildVisitor"));
    }

    private static class MyVisitor
    extends RbsPsiVisitor {
        private final Project myProject;
        private final ProblemsHolder myProblemsHolder;

        protected MyVisitor(@NotNull Project project, @NotNull ProblemsHolder holder) {
            if (project == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            if (holder == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myProblemsHolder = holder;
        }

        @Override
        public void visitClassAliasDeclarationElement(@NotNull RbsClassAliasDeclarationElement classAlias) {
            boolean hasModuleDeclarations;
            if (classAlias == null) {
                MyVisitor.$$$reportNull$$$0(2);
            }
            if (!(classAlias instanceof RbsClassAliasDeclarationMixin)) {
                return;
            }
            RbsClassAliasDeclarationMixin classAliasMixin = (RbsClassAliasDeclarationMixin)classAlias;
            String targetClassName = classAlias.getTargetClassName();
            if (targetClassName == null) {
                return;
            }
            boolean bl = hasModuleDeclarations = ContainerUtil.findInstance(RbsResolveUtil.resolveQualifiedName(this.myProject, (SearchScope)classAlias.getResolveScope(), classAliasMixin.getContainerFqn(), targetClassName, Collections.emptySet(), classAlias), RbsModuleSymbol.class) != null;
            if (hasModuleDeclarations) {
                RbsAliasSource aliasSource = (RbsAliasSource)PsiTreeUtil.getParentOfType((PsiElement)Objects.requireNonNull(classAlias.getTargetClassNameIdentifier()), RbsAliasSource.class);
                this.myProblemsHolder.registerProblem((PsiElement)Objects.requireNonNull(aliasSource), classAlias.getTargetClassNameIdentifier().getTextRangeInParent(), RbsBundle.message((String)"rbs.inspection.inconsistent.class.alias.name", (Object[])new Object[]{targetClassName}), new LocalQuickFix[]{new MyNavigateToConflictingDefinitionQuickFix()});
            }
        }

        @Override
        public void visitModuleAliasDeclarationElement(@NotNull RbsModuleAliasDeclarationElement moduleAlias) {
            boolean hasClassDeclarations;
            if (moduleAlias == null) {
                MyVisitor.$$$reportNull$$$0(3);
            }
            if (!(moduleAlias instanceof RbsModuleAliasDeclarationMixin)) {
                return;
            }
            RbsModuleAliasDeclarationMixin moduleAliasMixin = (RbsModuleAliasDeclarationMixin)moduleAlias;
            String targetModuleName = moduleAlias.getTargetModuleName();
            if (targetModuleName == null) {
                return;
            }
            boolean bl = hasClassDeclarations = ContainerUtil.findInstance(RbsResolveUtil.resolveQualifiedName(this.myProject, (SearchScope)moduleAlias.getResolveScope(), moduleAliasMixin.getContainerFqn(), targetModuleName, Collections.emptySet(), moduleAlias), RbsClassSymbol.class) != null;
            if (hasClassDeclarations) {
                RbsAliasSource aliasSource = (RbsAliasSource)PsiTreeUtil.getParentOfType((PsiElement)Objects.requireNonNull(moduleAlias.getTargetModuleNameIdentifier()), RbsAliasSource.class);
                this.myProblemsHolder.registerProblem((PsiElement)Objects.requireNonNull(aliasSource), moduleAlias.getTargetModuleNameIdentifier().getTextRangeInParent(), RbsBundle.message((String)"rbs.inspection.inconsistent.module.alias.name", (Object[])new Object[]{targetModuleName}), new LocalQuickFix[]{new MyNavigateToConflictingDefinitionQuickFix()});
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classAlias";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleAlias";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsInconsistentClassModuleAliasInspection$MyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClassAliasDeclarationElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitModuleAliasDeclarationElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyNavigateToConflictingDefinitionQuickFix
    implements LocalQuickFix,
    DumbAware,
    LowPriorityAction {
        private MyNavigateToConflictingDefinitionQuickFix() {
        }

        public boolean availableInBatchMode() {
            return false;
        }

        public boolean startInWriteAction() {
            return false;
        }

        @NotNull
        public String getFamilyName() {
            String string = RbsBundle.message((String)"rbs.inspection.inconsistent.class.module.alias.quickfix.name", (Object[])new Object[0]);
            if (string == null) {
                MyNavigateToConflictingDefinitionQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            String targetName;
            RbsAliasSource aliasSource;
            if (project == null) {
                MyNavigateToConflictingDefinitionQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                MyNavigateToConflictingDefinitionQuickFix.$$$reportNull$$$0(2);
            }
            if ((aliasSource = (RbsAliasSource)ObjectUtils.tryCast((Object)descriptor.getPsiElement(), RbsAliasSource.class)) == null) {
                return;
            }
            RbsModuleAliasDeclarationMixin moduleAlias = (RbsModuleAliasDeclarationMixin)PsiTreeUtil.getParentOfType((PsiElement)aliasSource, RbsModuleAliasDeclarationMixin.class);
            RbsClassAliasDeclarationMixin classAlias = (RbsClassAliasDeclarationMixin)PsiTreeUtil.getParentOfType((PsiElement)aliasSource, RbsClassAliasDeclarationMixin.class);
            if (moduleAlias == null && classAlias == null) {
                return;
            }
            Fqn containerFqn = moduleAlias != null ? moduleAlias.getContainerFqn() : classAlias.getContainerFqn();
            String string = targetName = moduleAlias != null ? moduleAlias.getTargetModuleName() : classAlias.getTargetClassName();
            if (targetName == null) {
                return;
            }
            GlobalSearchScope searchScope = descriptor.getPsiElement().getResolveScope();
            List targets = (List)DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> MyNavigateToConflictingDefinitionQuickFix.lambda$applyFix$1(project, (SearchScope)searchScope, containerFqn, targetName, moduleAlias, classAlias));
            Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
            if (editor == null) {
                return;
            }
            NavigationTargetPopup.builder((Collection)targets).withTitle(RbsBundle.message((String)"rbs.inspection.duplicate.go.to.conflicting.declarations.title", (Object[])new Object[0])).navigateOrShowInBestPositionFor(editor);
        }

        private static /* synthetic */ List lambda$applyFix$1(Project project, SearchScope searchScope, Fqn containerFqn, String targetName, RbsModuleAliasDeclarationMixin moduleAlias, RbsClassAliasDeclarationMixin classAlias) throws RuntimeException {
            Collection<? extends Symbol> symbols = RbsResolveUtil.resolveQualifiedName(project, searchScope, containerFqn, targetName, Collections.emptySet(), (PsiElement)ObjectUtils.coalesce((Object)moduleAlias, (Object)classAlias));
            return symbols.stream().flatMap(it -> {
                if (it instanceof RbsModuleSymbol) {
                    RbsModuleSymbol moduleSymbol = (RbsModuleSymbol)it;
                    return moduleSymbol.getNavigationTargets(project).stream();
                }
                if (it instanceof RbsClassSymbol) {
                    RbsClassSymbol classSymbol = (RbsClassSymbol)it;
                    return classSymbol.getNavigationTargets(project).stream();
                }
                return Stream.empty();
            }).toList();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsInconsistentClassModuleAliasInspection$MyNavigateToConflictingDefinitionQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsInconsistentClassModuleAliasInspection$MyNavigateToConflictingDefinitionQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

