/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.inspections.probableBugs;

import com.intellij.DynamicBundle;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.lang.ruby.rbs.model.api.RbsContainerSymbol;
import com.intellij.lang.ruby.rbs.model.hierarchy.RbsContainerSymbolUtil;
import com.intellij.lang.ruby.rbs.model.impl.RbsClassSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsInterfaceSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsMethodSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsModuleSymbol;
import com.intellij.lang.ruby.rbs.model.psi.RbsPsiSymbolDeclarationSearcher;
import com.intellij.lang.ruby.rbs.model.psi.RbsQualifiedNameSymbolReference;
import com.intellij.lang.ruby.rbs.model.psi.RbsResolveUtil;
import com.intellij.lang.ruby.rbs.model.psi.RbsSearchScope;
import com.intellij.lang.ruby.rbs.psi.RbsClassAliasDeclarationElement;
import com.intellij.lang.ruby.rbs.psi.RbsClassDecl;
import com.intellij.lang.ruby.rbs.psi.RbsClassDeclarationElement;
import com.intellij.lang.ruby.rbs.psi.RbsClassName;
import com.intellij.lang.ruby.rbs.psi.RbsClassNameElement;
import com.intellij.lang.ruby.rbs.psi.RbsConstDecl;
import com.intellij.lang.ruby.rbs.psi.RbsContainerDeclarationElement;
import com.intellij.lang.ruby.rbs.psi.RbsDeclarationType;
import com.intellij.lang.ruby.rbs.psi.RbsGlobalDecl;
import com.intellij.lang.ruby.rbs.psi.RbsIncludeMember;
import com.intellij.lang.ruby.rbs.psi.RbsInterfaceDecl;
import com.intellij.lang.ruby.rbs.psi.RbsMethodDeclaration;
import com.intellij.lang.ruby.rbs.psi.RbsMethodMember;
import com.intellij.lang.ruby.rbs.psi.RbsModuleAliasDeclarationElement;
import com.intellij.lang.ruby.rbs.psi.RbsModuleDecl;
import com.intellij.lang.ruby.rbs.psi.RbsModuleDeclarationElement;
import com.intellij.lang.ruby.rbs.psi.RbsPsiVisitor;
import com.intellij.lang.ruby.rbs.psi.RbsQualifiedNameElement;
import com.intellij.lang.ruby.rbs.psi.RbsSuperClass;
import com.intellij.lang.ruby.rbs.psi.RbsTypeDecl;
import com.intellij.lang.ruby.rbs.psi.impl.RbsMethodMemberImpl;
import com.intellij.lang.ruby.rbs.psi.index.RbsClassDeclarationFqnIndex;
import com.intellij.lang.ruby.rbs.psi.index.RbsConstantDeclarationFqnIndex;
import com.intellij.lang.ruby.rbs.psi.index.RbsContainerStatementParentFqnIndex;
import com.intellij.lang.ruby.rbs.psi.index.RbsFqnStubIndexExtension;
import com.intellij.lang.ruby.rbs.psi.index.RbsGlobalVariableDeclarationNameIndex;
import com.intellij.lang.ruby.rbs.psi.index.RbsInterfaceDeclarationFqnIndex;
import com.intellij.lang.ruby.rbs.psi.index.RbsMethodDeclarationNameIndex;
import com.intellij.lang.ruby.rbs.psi.index.RbsModuleDeclarationFqnIndex;
import com.intellij.lang.ruby.rbs.psi.index.RbsTypeDeclarationFqnIndex;
import com.intellij.lang.ruby.rbs.psi.mixin.RbsClassDeclarationMixin;
import com.intellij.lang.ruby.rbs.psi.stub.RbsStubBasedPsiElement;
import com.intellij.lang.ruby.rbs.util.Fqn;
import com.intellij.model.Pointer;
import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiSymbolDeclaration;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.navigation.EmptyNavigatable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ruby.rbs.frontback.RbsBundle;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DumbModeAccessType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.model.navigation.NavigatableSymbol;
import org.jetbrains.plugins.ruby.model.navigation.NavigationTarget;
import org.jetbrains.plugins.ruby.model.navigation.NavigationTargetPopup;
import org.jetbrains.plugins.ruby.model.navigation.TargetLocation;
import org.jetbrains.plugins.ruby.model.navigation.TargetPresentationUtil;
import org.jetbrains.plugins.ruby.model.presentation.PresentableSymbol;
import org.jetbrains.plugins.ruby.model.psi.NavigatablePsiSymbolDeclaration;
import org.jetbrains.plugins.ruby.util.StreamUtil;

@ApiStatus.Internal
public final class RbsDuplicateDeclarationsInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RbsDuplicateDeclarationsInspection.$$$reportNull$$$0(0);
        }
        return new MyVisitor(holder.getProject(), holder);
    }

    @NotNull
    private static TextRange getRangeInAncestor(@NotNull PsiElement element, @NotNull PsiElement ancestor) {
        if (element == null) {
            RbsDuplicateDeclarationsInspection.$$$reportNull$$$0(1);
        }
        if (ancestor == null) {
            RbsDuplicateDeclarationsInspection.$$$reportNull$$$0(2);
        }
        TextRange textRange = element.getTextRange().shiftLeft(ancestor.getTextRange().getStartOffset());
        if (textRange == null) {
            RbsDuplicateDeclarationsInspection.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsDuplicateDeclarationsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsDuplicateDeclarationsInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInAncestor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRangeInAncestor";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private static final class MyVisitor
    extends RbsPsiVisitor {
        private final Project myProject;
        private final SearchScope mySearchScope;
        private final ProblemsHolder myProblemsHolder;

        private MyVisitor(@NotNull Project project, @NotNull ProblemsHolder holder) {
            if (project == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            if (holder == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.mySearchScope = RbsSearchScope.collectionScope(project);
            this.myProblemsHolder = holder;
        }

        @Override
        public void visitGlobalDecl(@NotNull RbsGlobalDecl globalDecl) {
            String name;
            if (globalDecl == null) {
                MyVisitor.$$$reportNull$$$0(2);
            }
            if ((name = globalDecl.getName()) == null) {
                return;
            }
            AtomicBoolean hasProblem = new AtomicBoolean();
            RbsGlobalVariableDeclarationNameIndex.getInstance().processElements(this.myProject, this.mySearchScope, name, element -> {
                ProgressManager.checkCanceled();
                return hasProblem.compareAndSet(false, !element.equals(globalDecl)) && !hasProblem.get();
            });
            if (hasProblem.get()) {
                this.myProblemsHolder.registerProblem((PsiElement)globalDecl, Objects.requireNonNull(globalDecl.getSymbolDeclaration()).getRangeInDeclaringElement(), RbsBundle.message((String)"rbs.inspection.duplicate.global.variable", (Object[])new Object[0]), new LocalQuickFix[]{new MyRemoveDeclarationQuickFix(){

                    @NotNull
                    public String getName() {
                        String string = RbsBundle.message((String)"rbs.inspection.duplicate.remove.global.variable.quickfix.name", (Object[])new Object[0]);
                        if (string == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsDuplicateDeclarationsInspection$MyVisitor$1", "getName"));
                    }
                }, new MyNavigateToDuplicateQuickFix(Objects.requireNonNull(globalDecl.getSymbol()))});
            }
        }

        @Override
        public void visitTypeDecl(@NotNull RbsTypeDecl typeDecl) {
            if (typeDecl == null) {
                MyVisitor.$$$reportNull$$$0(3);
            }
            AtomicBoolean hasProblem = new AtomicBoolean();
            RbsTypeDeclarationFqnIndex.getInstance().processElements(this.myProject, this.mySearchScope, typeDecl.getFqn(), element -> {
                ProgressManager.checkCanceled();
                return hasProblem.compareAndSet(false, !element.equals(typeDecl)) && !hasProblem.get();
            });
            if (hasProblem.get()) {
                this.myProblemsHolder.registerProblem((PsiElement)typeDecl, Objects.requireNonNull(typeDecl.getSymbolDeclaration()).getRangeInDeclaringElement(), RbsBundle.message((String)"rbs.inspection.duplicate.type.alias", (Object[])new Object[0]), new LocalQuickFix[]{new MyRemoveDeclarationQuickFix(){

                    @NotNull
                    public String getName() {
                        String string = RbsBundle.message((String)"rbs.inspection.duplicate.remove.type.alias.quickfix.name", (Object[])new Object[0]);
                        if (string == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsDuplicateDeclarationsInspection$MyVisitor$2", "getName"));
                    }
                }, new MyNavigateToDuplicateQuickFix(Objects.requireNonNull(typeDecl.getSymbol()))});
            }
        }

        @Override
        public void visitConstDecl(@NotNull RbsConstDecl constDecl) {
            if (constDecl == null) {
                MyVisitor.$$$reportNull$$$0(4);
            }
            AtomicBoolean hasProblem = new AtomicBoolean();
            RbsConstantDeclarationFqnIndex.getInstance().processElements(this.myProject, this.mySearchScope, constDecl.getFqn(), element -> {
                ProgressManager.checkCanceled();
                return hasProblem.compareAndSet(false, !element.equals(constDecl)) && !hasProblem.get();
            });
            if (hasProblem.get()) {
                this.myProblemsHolder.registerProblem((PsiElement)constDecl, Objects.requireNonNull(constDecl.getSymbolDeclaration()).getRangeInDeclaringElement(), RbsBundle.message((String)"rbs.inspection.duplicate.constant", (Object[])new Object[0]), new LocalQuickFix[]{new MyRemoveDeclarationQuickFix(){

                    @NotNull
                    public String getName() {
                        String string = RbsBundle.message((String)"rbs.inspection.duplicate.remove.constant.quickfix.name", (Object[])new Object[0]);
                        if (string == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsDuplicateDeclarationsInspection$MyVisitor$3", "getName"));
                    }
                }, new MyNavigateToDuplicateQuickFix(Objects.requireNonNull(constDecl.getSymbol()))});
            }
        }

        @Override
        public void visitModuleDecl(@NotNull RbsModuleDecl moduleDecl) {
            if (moduleDecl == null) {
                MyVisitor.$$$reportNull$$$0(5);
            }
            if (moduleDecl.getNameIdentifier() != null) {
                this.findDuplicateModuleOrClass(moduleDecl);
            }
            this.findDuplicateInterfaceMethods(moduleDecl, moduleDecl.getIncludeMemberList());
            this.findDuplicateInterfaceInclusions(moduleDecl, moduleDecl.getIncludeMemberList());
            this.findModuleAlias(moduleDecl);
        }

        @Override
        public void visitModuleAliasDeclarationElement(@NotNull RbsModuleAliasDeclarationElement moduleAlias) {
            if (moduleAlias == null) {
                MyVisitor.$$$reportNull$$$0(6);
            }
            this.visitContainerAlias(moduleAlias, moduleAlias.getFqn(), (PsiSymbolDeclaration)Objects.requireNonNull(moduleAlias.getSymbolDeclaration()), Objects.requireNonNull(moduleAlias.getSymbol()), RbsModuleDeclarationFqnIndex.getInstance(), RbsBundle.message((String)"rbs.inspection.duplicate.module.alias", (Object[])new Object[0]), RbsBundle.message((String)"rbs.inspection.duplicate.remove.module.alias.quickfix.name", (Object[])new Object[0]));
        }

        @Override
        public void visitClassDecl(@NotNull RbsClassDecl classDecl) {
            if (classDecl == null) {
                MyVisitor.$$$reportNull$$$0(7);
            }
            if (classDecl.getNameIdentifier() != null) {
                this.findDuplicateModuleOrClass(classDecl);
            }
            this.findDuplicatesWithDifferentSuperclass(classDecl);
            this.findDuplicateInterfaceMethods(classDecl, classDecl.getIncludeMemberList());
            this.findDuplicateInterfaceInclusions(classDecl, classDecl.getIncludeMemberList());
            this.findClassAlias(classDecl);
        }

        @Override
        public void visitClassAliasDeclarationElement(@NotNull RbsClassAliasDeclarationElement classAlias) {
            if (classAlias == null) {
                MyVisitor.$$$reportNull$$$0(8);
            }
            this.visitContainerAlias(classAlias, classAlias.getFqn(), (PsiSymbolDeclaration)Objects.requireNonNull(classAlias.getSymbolDeclaration()), Objects.requireNonNull(classAlias.getSymbol()), RbsClassDeclarationFqnIndex.getInstance(), RbsBundle.message((String)"rbs.inspection.duplicate.class.alias", (Object[])new Object[0]), RbsBundle.message((String)"rbs.inspection.duplicate.remove.class.alias.quickfix.name", (Object[])new Object[0]));
        }

        @Override
        public void visitInterfaceDecl(@NotNull RbsInterfaceDecl interfaceDecl) {
            if (interfaceDecl == null) {
                MyVisitor.$$$reportNull$$$0(9);
            }
            AtomicBoolean hasProblem = new AtomicBoolean();
            RbsInterfaceDeclarationFqnIndex.getInstance().processElements(this.myProject, this.mySearchScope, interfaceDecl.getFqn(), element -> {
                ProgressManager.checkCanceled();
                return hasProblem.compareAndSet(false, !element.equals(interfaceDecl)) && !hasProblem.get();
            });
            if (hasProblem.get()) {
                this.myProblemsHolder.registerProblem((PsiElement)Objects.requireNonNull(interfaceDecl), Objects.requireNonNull(interfaceDecl.getSymbolDeclaration()).getRangeInDeclaringElement(), RbsBundle.message((String)"rbs.inspection.duplicate.interface", (Object[])new Object[0]), new LocalQuickFix[]{new MyRemoveDeclarationQuickFix(){

                    @NotNull
                    public String getName() {
                        String string = RbsBundle.message((String)"rbs.inspection.duplicate.remove.interface.quickfix.name", (Object[])new Object[0]);
                        if (string == null) {
                            4.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsDuplicateDeclarationsInspection$MyVisitor$4", "getName"));
                    }
                }, new MyNavigateToDuplicateQuickFix(Objects.requireNonNull(interfaceDecl.getSymbol()))});
            }
        }

        @Override
        public void visitMethodMember(@NotNull RbsMethodMember methodMember) {
            String name;
            if (methodMember == null) {
                MyVisitor.$$$reportNull$$$0(10);
            }
            if ((name = methodMember.getName()) == null || !(methodMember instanceof RbsMethodMemberImpl) || methodMember.isOverloaded()) {
                return;
            }
            Fqn containerFqn = ((RbsMethodMemberImpl)methodMember).getContainerFqn();
            if (containerFqn == Fqn.INVALID) {
                return;
            }
            for (RbsDeclarationType declarationType : methodMember.getDeclarationTypes()) {
                List methods = RbsMethodDeclarationNameIndex.getInstance().getElements(this.myProject, this.mySearchScope, Set.of(declarationType), containerFqn, name).stream().mapMulti(StreamUtil.select(RbsMethodMember.class, (Class[])new Class[0])).toList();
                final List overloadedMethodPointers = ContainerUtil.map((Collection)ContainerUtil.filter(methods, RbsMethodDeclaration::isOverloaded), SmartPointerManager::createPointer);
                if (overloadedMethodPointers.size() >= methods.size() - 1) continue;
                this.myProblemsHolder.registerProblem((PsiElement)methodMember, Objects.requireNonNull(methodMember.getSymbolDeclaration()).getRangeInDeclaringElement(), RbsBundle.message((String)"rbs.inspection.duplicate.method", (Object[])new Object[0]), new LocalQuickFix[]{new MyRemoveDeclarationQuickFix(){

                    @NotNull
                    public String getName() {
                        String string = RbsBundle.message((String)"rbs.inspection.duplicate.remove.method.quickfix.name", (Object[])new Object[0]);
                        if (string == null) {
                            5.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsDuplicateDeclarationsInspection$MyVisitor$5", "getName"));
                    }
                }, new MyNavigateToDuplicateQuickFix(Objects.requireNonNull(methodMember.getSymbol())){

                    @Override
                    @NotNull
                    public List<? extends NavigationTarget> getTargets(@NotNull Project project, @NotNull Symbol symbol, @NotNull PsiElement element) {
                        if (project == null) {
                            6.$$$reportNull$$$0(0);
                        }
                        if (symbol == null) {
                            6.$$$reportNull$$$0(1);
                        }
                        if (element == null) {
                            6.$$$reportNull$$$0(2);
                        }
                        List overloadedMethods = ContainerUtil.mapNotNull((Collection)overloadedMethodPointers, SmartPsiElementPointer::dereference);
                        List<NavigationTarget> list = RbsPsiSymbolDeclarationSearcher.getDeclarations(project, (SearchScope)RbsSearchScope.collectionScope(project), symbol).stream().filter(it -> !it.getDeclaringElement().equals(element)).filter(it -> !overloadedMethods.contains(it.getDeclaringElement())).map(NavigatablePsiSymbolDeclaration::getNavigationTarget).sorted().toList();
                        if (list == null) {
                            6.$$$reportNull$$$0(3);
                        }
                        return list;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[switch (n) {
                            default -> 3;
                            case 3 -> 2;
                        }];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "project";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "symbol";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "element";
                                break;
                            }
                            case 3: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsDuplicateDeclarationsInspection$MyVisitor$6";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsDuplicateDeclarationsInspection$MyVisitor$6";
                                break;
                            }
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getTargets";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "getTargets";
                                break;
                            }
                            case 3: {
                                break;
                            }
                        }
                        String string = String.format(v0, objectArray);
                        throw switch (n) {
                            default -> new IllegalArgumentException(string);
                            case 3 -> new IllegalStateException(string);
                        };
                    }
                }});
            }
        }

        private void findDuplicateModuleOrClass(@NotNull RbsContainerDeclarationElement moduleOrClassDecl) {
            String message;
            Fqn fqn;
            if (moduleOrClassDecl == null) {
                MyVisitor.$$$reportNull$$$0(11);
            }
            if ((fqn = moduleOrClassDecl.getFqn()) == Fqn.INVALID || !(moduleOrClassDecl instanceof RbsModuleDecl) && !(moduleOrClassDecl instanceof RbsClassDecl)) {
                return;
            }
            final boolean isModule = moduleOrClassDecl instanceof RbsModuleDecl;
            RbsFqnStubIndexExtension index = isModule ? RbsClassDeclarationFqnIndex.getInstance() : RbsModuleDeclarationFqnIndex.getInstance();
            String string = message = isModule ? RbsBundle.message((String)"rbs.inspection.duplicate.class.exists", (Object[])new Object[]{fqn}) : RbsBundle.message((String)"rbs.inspection.duplicate.module.exists", (Object[])new Object[]{fqn});
            if (index.containsElements(this.myProject, this.mySearchScope, fqn)) {
                this.myProblemsHolder.registerProblem((PsiElement)moduleOrClassDecl, Objects.requireNonNull(moduleOrClassDecl.getSymbolDeclaration()).getRangeInDeclaringElement(), message, new LocalQuickFix[]{new MyRemoveDeclarationQuickFix(){

                    @NotNull
                    public String getName() {
                        String string = isModule ? RbsBundle.message((String)"rbs.inspection.duplicate.remove.conflicting.module.quickfix.name", (Object[])new Object[0]) : RbsBundle.message((String)"rbs.inspection.duplicate.remove.conflicting.class.quickfix.name", (Object[])new Object[0]);
                        if (string == null) {
                            7.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsDuplicateDeclarationsInspection$MyVisitor$7", "getName"));
                    }
                }, new MyNavigateToDuplicateClassOrModuleQuickFix(isModule)});
            }
        }

        private void findDuplicatesWithDifferentSuperclass(@NotNull RbsClassDecl classDecl) {
            if (classDecl == null) {
                MyVisitor.$$$reportNull$$$0(12);
            }
            RbsSuperClass superclass = classDecl.getSuperClass();
            RbsClassSymbol symbol = classDecl.getSymbol();
            if (symbol == null || symbol.getFqn() == Fqn.INVALID || superclass == null || superclass.getClassName() == null) {
                return;
            }
            PsiElement superclassNameIdentifier = (PsiElement)ObjectUtils.doIfNotNull((Object)superclass.getClassName(), RbsClassNameElement::getNameIdentifier);
            if (superclassNameIdentifier == null) {
                return;
            }
            LinkedHashMap uniqueSuperclassDeclarations = new LinkedHashMap();
            RbsClassDeclarationFqnIndex.getInstance().processElements(this.myProject, this.mySearchScope, symbol.getFqn(), elem -> {
                RbsClassDeclarationMixin declaration;
                ProgressManager.checkCanceled();
                if (elem instanceof RbsClassDeclarationMixin && (declaration = (RbsClassDeclarationMixin)elem).getSuperclassName() != null) {
                    uniqueSuperclassDeclarations.putIfAbsent(this.getSuperclassDeclarations(declaration), declaration);
                }
                return true;
            });
            HashSet<? extends Symbol> originalSuperclassDeclarations = new HashSet<Symbol>(this.getSuperclassDeclarations(classDecl));
            for (RbsClassDecl decl : uniqueSuperclassDeclarations.values()) {
                LinkedHashSet<? extends Symbol> superclassDeclarations = new LinkedHashSet<Symbol>(this.getSuperclassDeclarations(decl));
                if (originalSuperclassDeclarations.equals(superclassDeclarations)) continue;
                String description = symbol.getPresentation().longDescription();
                Symbol superclassSymbol = superclassDeclarations.stream().findAny().orElse(null);
                String superclassName = superclassSymbol instanceof RbsClassSymbol ? ((RbsClassSymbol)superclassSymbol).getFqn().join(true) : decl.getSuperclassName();
                this.myProblemsHolder.registerProblem((PsiElement)superclass, RbsDuplicateDeclarationsInspection.getRangeInAncestor(superclassNameIdentifier, superclass), RbsBundle.message((String)"rbs.inspection.duplicate.different.superclass", (Object[])new Object[]{description, superclassName}), new LocalQuickFix[]{new MyRemoveDeclarationQuickFix(){

                    @NotNull
                    public String getName() {
                        String string = RbsBundle.message((String)"rbs.inspection.duplicate.remove.superclass.quickfix.name", (Object[])new Object[0]);
                        if (string == null) {
                            8.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsDuplicateDeclarationsInspection$MyVisitor$8", "getName"));
                    }
                }, new MyNavigateToConflictingSuperclassQuickFix()});
            }
        }

        private void findDuplicateInterfaceMethods(@NotNull RbsContainerDeclarationElement container, @NotNull List<RbsIncludeMember> includeMembers) {
            RbsContainerSymbol containerSymbol;
            if (container == null) {
                MyVisitor.$$$reportNull$$$0(13);
            }
            if (includeMembers == null) {
                MyVisitor.$$$reportNull$$$0(14);
            }
            if ((containerSymbol = container.getSymbol()) == null) {
                return;
            }
            List<RbsMethodSymbol> methodSymbols = this.getIncludedMethods(containerSymbol);
            for (RbsIncludeMember includeMember : includeMembers) {
                PsiElement nameIdentifier = (PsiElement)ObjectUtils.doIfNotNull((Object)includeMember.getQualifiedName(), RbsQualifiedNameElement::getNameIdentifier);
                if (nameIdentifier == null) continue;
                Set includedMethods = MyVisitor.resolveInterfaceIncludeMember(includeMember).stream().flatMap(it -> this.getIncludedMethods((RbsContainerSymbol)it).stream()).collect(Collectors.toSet());
                Set methodsNotFromIncludeMember = methodSymbols.stream().filter(it -> !includedMethods.contains(it)).collect(Collectors.toSet());
                List res = ContainerUtil.filter(includedMethods, it -> ContainerUtil.exists((Iterable)methodsNotFromIncludeMember, other -> other.getName().equals(it.getName())));
                for (RbsMethodSymbol method : res) {
                    final String quickFixName = RbsBundle.message((String)"rbs.inspection.duplicate.inclusion.call.remove.quickfix.name", (Object[])new Object[]{includeMember.getInclusionCallType().name().toLowerCase(DynamicBundle.getLocale())});
                    this.myProblemsHolder.registerProblem((PsiElement)includeMember, RbsDuplicateDeclarationsInspection.getRangeInAncestor(nameIdentifier, includeMember), RbsBundle.message((String)"rbs.inspection.duplicate.includes.method", (Object[])new Object[]{method.getName()}), new LocalQuickFix[]{new MyRemoveDeclarationQuickFix(){

                        @NotNull
                        public String getName() {
                            String string = quickFixName;
                            if (string == null) {
                                9.$$$reportNull$$$0(0);
                            }
                            return string;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsDuplicateDeclarationsInspection$MyVisitor$9", "getName"));
                        }
                    }, new MyNavigateToDuplicateIncludedMethodQuickFix(ContainerUtil.map(methodsNotFromIncludeMember, RbsMethodSymbol::createPointer))});
                }
            }
        }

        private void findDuplicateInterfaceInclusions(@NotNull RbsContainerDeclarationElement container, @NotNull List<RbsIncludeMember> includeMembers) {
            if (container == null) {
                MyVisitor.$$$reportNull$$$0(15);
            }
            if (includeMembers == null) {
                MyVisitor.$$$reportNull$$$0(16);
            }
            Fqn fqn = container.getFqn();
            for (RbsIncludeMember includeMember : includeMembers) {
                RbsQualifiedNameSymbolReference reference = includeMember.getSymbolReference();
                if (reference == null) continue;
                List<RbsContainerSymbol> includedSymbols = MyVisitor.resolveInterfaceIncludeMember(includeMember);
                for (RbsContainerSymbol includedSymbol : includedSymbols) {
                    RbsContainerStatementParentFqnIndex.getInstance().processElements(this.myProject, this.mySearchScope, fqn, arg_0 -> this.lambda$findDuplicateInterfaceInclusions$9(includeMember, includedSymbol, (PsiSymbolReference)reference, arg_0));
                }
            }
        }

        private void visitContainerAlias(@NotNull PsiElement aliasElement, @NotNull Fqn aliasFqn, @NotNull PsiSymbolDeclaration aliasDeclaration, @NotNull RbsContainerSymbol aliasSymbol, @NotNull RbsFqnStubIndexExtension<?> index, @InspectionMessage @NotNull String errorMessage, final @IntentionName @NotNull String quickFixMessage) {
            if (aliasElement == null) {
                MyVisitor.$$$reportNull$$$0(17);
            }
            if (aliasFqn == null) {
                MyVisitor.$$$reportNull$$$0(18);
            }
            if (aliasDeclaration == null) {
                MyVisitor.$$$reportNull$$$0(19);
            }
            if (aliasSymbol == null) {
                MyVisitor.$$$reportNull$$$0(20);
            }
            if (index == null) {
                MyVisitor.$$$reportNull$$$0(21);
            }
            if (errorMessage == null) {
                MyVisitor.$$$reportNull$$$0(22);
            }
            if (quickFixMessage == null) {
                MyVisitor.$$$reportNull$$$0(23);
            }
            AtomicBoolean hasProblem = new AtomicBoolean();
            index.processElements(this.myProject, this.mySearchScope, aliasFqn, element -> {
                ProgressManager.checkCanceled();
                return hasProblem.compareAndSet(false, aliasElement.getClass().isInstance(element) && !((Object)element).equals(aliasElement)) && !hasProblem.get();
            });
            if (hasProblem.get()) {
                this.myProblemsHolder.registerProblem(aliasElement, aliasDeclaration.getRangeInDeclaringElement(), errorMessage, new LocalQuickFix[]{new MyRemoveDeclarationQuickFix(){

                    @NotNull
                    public String getName() {
                        String string = quickFixMessage;
                        if (string == null) {
                            10.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsDuplicateDeclarationsInspection$MyVisitor$10", "getName"));
                    }
                }, new MyNavigateToDuplicateQuickFix(Objects.requireNonNull(aliasSymbol))});
            }
        }

        @NotNull
        private List<RbsMethodSymbol> getIncludedMethods(@NotNull RbsContainerSymbol symbol) {
            if (symbol == null) {
                MyVisitor.$$$reportNull$$$0(24);
            }
            List<RbsMethodSymbol> list = symbol.ancestors(this.myProject, this.mySearchScope).mapMulti(StreamUtil.select(RbsInterfaceSymbol.class, (Class[])new Class[0])).flatMap(ancestor -> ancestor.allChildren(this.myProject, this.mySearchScope)).mapMulti(StreamUtil.select(RbsMethodSymbol.class, (Class[])new Class[0])).toList();
            if (list == null) {
                MyVisitor.$$$reportNull$$$0(25);
            }
            return list;
        }

        private void findModuleAlias(@NotNull RbsModuleDeclarationElement moduleDeclaration) {
            RbsModuleSymbol moduleSymbol;
            if (moduleDeclaration == null) {
                MyVisitor.$$$reportNull$$$0(26);
            }
            if ((moduleSymbol = moduleDeclaration.getSymbol()) == null) {
                return;
            }
            RbsModuleAliasDeclarationElement aliasElement = (RbsModuleAliasDeclarationElement)ObjectUtils.tryCast((Object)this.findClassOrModuleAlias(moduleDeclaration, RbsModuleAliasDeclarationElement.class), RbsModuleAliasDeclarationElement.class);
            if (aliasElement != null) {
                this.myProblemsHolder.registerProblem((PsiElement)moduleDeclaration, Objects.requireNonNull(moduleDeclaration.getSymbolDeclaration()).getRangeInDeclaringElement(), RbsBundle.message((String)"rbs.inspection.duplicate.opened.module.alias", (Object[])new Object[]{moduleSymbol.getName()}), new LocalQuickFix[]{new MyNavigateToDuplicateQuickFix(moduleSymbol){

                    @Override
                    @NotNull
                    public String getFamilyName() {
                        String string = RbsBundle.message((String)"rbs.inspection.duplicate.go.to.alias.quickfix.name", (Object[])new Object[0]);
                        if (string == null) {
                            11.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsDuplicateDeclarationsInspection$MyVisitor$11", "getFamilyName"));
                    }
                }});
                RbsModuleSymbol aliasSymbol = Objects.requireNonNull(aliasElement.getSymbol());
                this.myProblemsHolder.registerProblem((PsiElement)aliasElement, Objects.requireNonNull(aliasElement.getSymbolDeclaration()).getRangeInDeclaringElement(), RbsBundle.message((String)"rbs.inspection.duplicate.module.alias.container", (Object[])new Object[]{aliasSymbol.getName()}), new LocalQuickFix[]{new MyNavigateToDuplicateQuickFix(aliasSymbol){

                    @Override
                    @NotNull
                    public String getFamilyName() {
                        String string = RbsBundle.message((String)"rbs.inspection.duplicate.go.to.module.quickfix.name", (Object[])new Object[0]);
                        if (string == null) {
                            12.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsDuplicateDeclarationsInspection$MyVisitor$12", "getFamilyName"));
                    }
                }});
            }
        }

        private void findClassAlias(@NotNull RbsClassDeclarationElement classDeclaration) {
            RbsClassSymbol classSymbol;
            if (classDeclaration == null) {
                MyVisitor.$$$reportNull$$$0(27);
            }
            if ((classSymbol = classDeclaration.getSymbol()) == null) {
                return;
            }
            RbsClassAliasDeclarationElement aliasElement = (RbsClassAliasDeclarationElement)ObjectUtils.tryCast((Object)this.findClassOrModuleAlias(classDeclaration, RbsClassAliasDeclarationElement.class), RbsClassAliasDeclarationElement.class);
            if (aliasElement != null) {
                this.myProblemsHolder.registerProblem((PsiElement)classDeclaration, Objects.requireNonNull(classDeclaration.getSymbolDeclaration()).getRangeInDeclaringElement(), RbsBundle.message((String)"rbs.inspection.duplicate.opened.class.alias", (Object[])new Object[]{classSymbol.getName()}), new LocalQuickFix[]{new MyNavigateToDuplicateQuickFix(classSymbol){

                    @Override
                    @NotNull
                    public String getFamilyName() {
                        String string = RbsBundle.message((String)"rbs.inspection.duplicate.go.to.alias.quickfix.name", (Object[])new Object[0]);
                        if (string == null) {
                            13.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsDuplicateDeclarationsInspection$MyVisitor$13", "getFamilyName"));
                    }
                }});
                RbsClassSymbol aliasSymbol = Objects.requireNonNull(aliasElement.getSymbol());
                this.myProblemsHolder.registerProblem((PsiElement)aliasElement, Objects.requireNonNull(aliasElement.getSymbolDeclaration()).getRangeInDeclaringElement(), RbsBundle.message((String)"rbs.inspection.duplicate.class.alias.container", (Object[])new Object[]{aliasSymbol.getName()}), new LocalQuickFix[]{new MyNavigateToDuplicateQuickFix(aliasSymbol){

                    @Override
                    @NotNull
                    public String getFamilyName() {
                        String string = RbsBundle.message((String)"rbs.inspection.duplicate.go.to.class.quickfix.name", (Object[])new Object[0]);
                        if (string == null) {
                            14.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsDuplicateDeclarationsInspection$MyVisitor$14", "getFamilyName"));
                    }
                }});
            }
        }

        @Nullable
        private PsiElement findClassOrModuleAlias(@NotNull RbsContainerDeclarationElement container, @NotNull Class<?> aliasDeclarationClass) {
            RbsContainerSymbol containerSymbol;
            if (container == null) {
                MyVisitor.$$$reportNull$$$0(28);
            }
            if (aliasDeclarationClass == null) {
                MyVisitor.$$$reportNull$$$0(29);
            }
            if ((containerSymbol = container.getSymbol()) == null) {
                return null;
            }
            Ref declarationRef = new Ref(null);
            RbsPsiSymbolDeclarationSearcher.processDeclarations(this.myProject, this.mySearchScope, containerSymbol, element -> {
                PsiElement declaringElement = element.getDeclaringElement();
                if (aliasDeclarationClass.isInstance(declaringElement)) {
                    declarationRef.set((Object)declaringElement);
                    return false;
                }
                return true;
            });
            return (PsiElement)declarationRef.get();
        }

        @NotNull
        private Collection<? extends Symbol> getSuperclassDeclarations(@NotNull RbsClassDecl classDecl) {
            if (classDecl == null) {
                MyVisitor.$$$reportNull$$$0(30);
            }
            Fqn fqn = classDecl.getFqn().getParent();
            String superclassName = classDecl.getSuperclassName();
            if (superclassName == null) {
                List list = Collections.emptyList();
                if (list == null) {
                    MyVisitor.$$$reportNull$$$0(31);
                }
                return list;
            }
            List<? super Symbol> list = RbsResolveUtil.resolveQualifiedNameInNesting(this.myProject, this.mySearchScope, fqn, superclassName, classDecl).stream().mapMulti(RbsContainerSymbolUtil.followAliases(this.myProject, this.mySearchScope)).toList();
            if (list == null) {
                MyVisitor.$$$reportNull$$$0(32);
            }
            return list;
        }

        private static List<RbsContainerSymbol> resolveInterfaceIncludeMember(@NotNull RbsIncludeMember includeMember) {
            RbsQualifiedNameSymbolReference reference;
            if (includeMember == null) {
                MyVisitor.$$$reportNull$$$0(33);
            }
            if ((reference = includeMember.getSymbolReference()) == null) {
                return Collections.emptyList();
            }
            return reference.resolveReference().stream().mapMulti(StreamUtil.select(RbsInterfaceSymbol.class, (Class[])new Class[0])).collect(Collectors.toUnmodifiableList());
        }

        private /* synthetic */ boolean lambda$findDuplicateInterfaceInclusions$9(RbsIncludeMember includeMember, RbsContainerSymbol includedSymbol, PsiSymbolReference reference, RbsStubBasedPsiElement element) {
            ProgressManager.checkCanceled();
            if (!(element instanceof RbsIncludeMember) || ((Object)((Object)element)).equals(includeMember)) {
                return true;
            }
            RbsQualifiedNameSymbolReference otherReference = ((RbsIncludeMember)((Object)element)).getSymbolReference();
            if (otherReference == null || !otherReference.resolvesTo(includedSymbol)) {
                return true;
            }
            this.myProblemsHolder.registerProblem((PsiElement)includeMember, reference.getRangeInElement(), RbsBundle.message((String)"rbs.inspection.duplicate.interface.include", (Object[])new Object[]{includedSymbol.getPresentation().longDescription()}), new LocalQuickFix[0]);
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 25, 31, 32 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "globalDecl";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeDecl";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "constDecl";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleDecl";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleAlias";
                    break;
                }
                case 7: 
                case 12: 
                case 30: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classDecl";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classAlias";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interfaceDecl";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodMember";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleOrClassDecl";
                    break;
                }
                case 13: 
                case 15: 
                case 28: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "container";
                    break;
                }
                case 14: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "includeMembers";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aliasElement";
                    break;
                }
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aliasFqn";
                    break;
                }
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aliasDeclaration";
                    break;
                }
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aliasSymbol";
                    break;
                }
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "index";
                    break;
                }
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorMessage";
                    break;
                }
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "quickFixMessage";
                    break;
                }
                case 24: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "symbol";
                    break;
                }
                case 25: 
                case 31: 
                case 32: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsDuplicateDeclarationsInspection$MyVisitor";
                    break;
                }
                case 26: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleDeclaration";
                    break;
                }
                case 27: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classDeclaration";
                    break;
                }
                case 29: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aliasDeclarationClass";
                    break;
                }
                case 33: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "includeMember";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsDuplicateDeclarationsInspection$MyVisitor";
                    break;
                }
                case 25: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIncludedMethods";
                    break;
                }
                case 31: 
                case 32: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSuperclassDeclarations";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "visitGlobalDecl";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "visitTypeDecl";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "visitConstDecl";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "visitModuleDecl";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "visitModuleAliasDeclarationElement";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "visitClassDecl";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "visitClassAliasDeclarationElement";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "visitInterfaceDecl";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "visitMethodMember";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "findDuplicateModuleOrClass";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "findDuplicatesWithDifferentSuperclass";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "findDuplicateInterfaceMethods";
                    break;
                }
                case 15: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "findDuplicateInterfaceInclusions";
                    break;
                }
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "visitContainerAlias";
                    break;
                }
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "getIncludedMethods";
                    break;
                }
                case 25: 
                case 31: 
                case 32: {
                    break;
                }
                case 26: {
                    objectArray = objectArray;
                    objectArray[2] = "findModuleAlias";
                    break;
                }
                case 27: {
                    objectArray = objectArray;
                    objectArray[2] = "findClassAlias";
                    break;
                }
                case 28: 
                case 29: {
                    objectArray = objectArray;
                    objectArray[2] = "findClassOrModuleAlias";
                    break;
                }
                case 30: {
                    objectArray = objectArray;
                    objectArray[2] = "getSuperclassDeclarations";
                    break;
                }
                case 33: {
                    objectArray = objectArray;
                    objectArray[2] = "resolveInterfaceIncludeMember";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 25, 31, 32 -> new IllegalStateException(string);
            };
        }
    }

    private static final class MyNavigationTarget
    implements NavigationTarget {
        private final PsiElement myElement;
        private final TargetLocation myLocation;
        private final TargetPresentation myPresentation;

        private MyNavigationTarget(@NotNull PsiElement element, @NotNull TargetPresentation presentation) {
            if (element == null) {
                MyNavigationTarget.$$$reportNull$$$0(0);
            }
            if (presentation == null) {
                MyNavigationTarget.$$$reportNull$$$0(1);
            }
            this.myElement = element;
            this.myLocation = TargetLocation.fromElement((PsiElement)element);
            this.myPresentation = presentation;
        }

        @NotNull
        public Pointer<MyNavigationTarget> createPointer() {
            TargetPresentation presentation = this.myPresentation;
            Pointer pointer = Pointer.delegatingPointer((Pointer)SmartPointerManager.createPointer((PsiElement)this.myElement), it -> new MyNavigationTarget((PsiElement)it, presentation));
            if (pointer == null) {
                MyNavigationTarget.$$$reportNull$$$0(2);
            }
            return pointer;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            MyNavigationTarget other = (MyNavigationTarget)obj;
            return this.myElement.equals(other.myElement) && this.myPresentation.equals(other.myPresentation);
        }

        @NotNull
        public Navigatable getNavigatable() {
            Navigatable navigatable = (Navigatable)ObjectUtils.coalesce((Object)PsiNavigationSupport.getInstance().getDescriptor(this.myElement), (Object)EmptyNavigatable.INSTANCE);
            if (navigatable == null) {
                MyNavigationTarget.$$$reportNull$$$0(3);
            }
            return navigatable;
        }

        public int hashCode() {
            return 31 * this.myElement.hashCode() + this.myPresentation.hashCode();
        }

        @NotNull
        public TargetLocation location() {
            TargetLocation targetLocation = this.myLocation;
            if (targetLocation == null) {
                MyNavigationTarget.$$$reportNull$$$0(4);
            }
            return targetLocation;
        }

        @NotNull
        public TargetPresentation computePresentation() {
            TargetPresentation targetPresentation = this.myPresentation;
            if (targetPresentation == null) {
                MyNavigationTarget.$$$reportNull$$$0(5);
            }
            return targetPresentation;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsDuplicateDeclarationsInspection$MyNavigationTarget";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsDuplicateDeclarationsInspection$MyNavigationTarget";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPointer";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigatable";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "location";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computePresentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    private static final class MyNavigateToConflictingSuperclassQuickFix
    implements LocalQuickFix,
    DumbAware,
    LowPriorityAction {
        private MyNavigateToConflictingSuperclassQuickFix() {
        }

        public boolean availableInBatchMode() {
            return false;
        }

        public boolean startInWriteAction() {
            return false;
        }

        @NotNull
        public String getFamilyName() {
            String string = RbsBundle.message((String)"rbs.inspection.duplicate.go.to.conflicting.declarations.quickfix.name", (Object[])new Object[0]);
            if (string == null) {
                MyNavigateToConflictingSuperclassQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Editor editor;
            if (project == null) {
                MyNavigateToConflictingSuperclassQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                MyNavigateToConflictingSuperclassQuickFix.$$$reportNull$$$0(2);
            }
            if ((editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor()) == null) {
                return;
            }
            GlobalSearchScope searchScope = RbsSearchScope.collectionScope(project);
            RbsClassDecl classDecl = (RbsClassDecl)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), RbsClassDecl.class);
            if (classDecl == null) {
                return;
            }
            ArrayList targets = new ArrayList();
            DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> MyNavigateToConflictingSuperclassQuickFix.lambda$applyFix$1(project, (SearchScope)searchScope, classDecl, descriptor, targets));
            if (targets.size() == 1) {
                PsiNavigateUtil.navigate((PsiElement)((PsiElement)targets.get(0)));
            } else if (!targets.isEmpty()) {
                List navigationTargets = ContainerUtil.map(targets, element -> {
                    TargetPresentation presentation = TargetPresentationUtil.createTargetPresentation((PresentableSymbol)Objects.requireNonNull(classDecl.getSymbol()), (PsiElement)element);
                    return new MyNavigationTarget((PsiElement)element, presentation);
                });
                NavigationTargetPopup.builder((Collection)navigationTargets).withTitle(RbsBundle.message((String)"rbs.inspection.duplicate.go.to.conflicting.declarations.title", (Object[])new Object[0])).navigateOrShowInBestPositionFor(editor);
            }
        }

        private static /* synthetic */ void lambda$applyFix$1(Project project, SearchScope searchScope, RbsClassDecl classDecl, ProblemDescriptor descriptor, List targets) {
            RbsClassDeclarationFqnIndex.getInstance().processElements(project, searchScope, classDecl.getFqn(), elem -> {
                ProgressManager.checkCanceled();
                if (elem instanceof RbsClassDeclarationMixin) {
                    RbsClassDeclarationMixin declaration = (RbsClassDeclarationMixin)elem;
                    String superclassName = declaration.getSuperclassName();
                    if (superclassName == null || superclassName.equals(classDecl.getSuperclassName())) {
                        return true;
                    }
                    if (PsiTreeUtil.isAncestor((PsiElement)declaration, (PsiElement)descriptor.getPsiElement(), (boolean)false)) {
                        return true;
                    }
                    RbsClassName className = (RbsClassName)ObjectUtils.doIfNotNull((Object)declaration.getSuperClass(), RbsSuperClass::getClassName);
                    if (className == null) {
                        return true;
                    }
                    ContainerUtil.addIfNotNull((Collection)targets, (Object)className.getNameIdentifier());
                }
                return true;
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsDuplicateDeclarationsInspection$MyNavigateToConflictingSuperclassQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsDuplicateDeclarationsInspection$MyNavigateToConflictingSuperclassQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private static final class MyNavigateToDuplicateIncludedMethodQuickFix
    implements LocalQuickFix,
    DumbAware {
        private final List<Pointer<RbsMethodSymbol>> myMethodsNotFromIncludeMemberPointers;

        private MyNavigateToDuplicateIncludedMethodQuickFix(@NotNull List<Pointer<RbsMethodSymbol>> pointers) {
            if (pointers == null) {
                MyNavigateToDuplicateIncludedMethodQuickFix.$$$reportNull$$$0(0);
            }
            this.myMethodsNotFromIncludeMemberPointers = pointers;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Editor editor;
            if (project == null) {
                MyNavigateToDuplicateIncludedMethodQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                MyNavigateToDuplicateIncludedMethodQuickFix.$$$reportNull$$$0(2);
            }
            if ((editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor()) == null) {
                return;
            }
            List methodsNotFromIncludeMember = ContainerUtil.mapNotNull(this.myMethodsNotFromIncludeMemberPointers, Pointer::dereference);
            List targets = (List)DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> methodsNotFromIncludeMember.stream().flatMap(it -> it.getNavigationTargets(project).stream()).collect(Collectors.toList()));
            NavigationTargetPopup.builder((Collection)targets).withTitle(RbsBundle.message((String)"rbs.inspection.duplicate.go.to.duplicate.included.method.title", (Object[])new Object[0])).navigateOrShowInBestPositionFor(editor);
        }

        public boolean availableInBatchMode() {
            return false;
        }

        @NotNull
        public String getFamilyName() {
            String string = RbsBundle.message((String)"rbs.inspection.duplicate.go.to.duplicate.included.method.quickfix.name", (Object[])new Object[0]);
            if (string == null) {
                MyNavigateToDuplicateIncludedMethodQuickFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pointers";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsDuplicateDeclarationsInspection$MyNavigateToDuplicateIncludedMethodQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsDuplicateDeclarationsInspection$MyNavigateToDuplicateIncludedMethodQuickFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private static final class MyNavigateToDuplicateClassOrModuleQuickFix
    implements LocalQuickFix,
    DumbAware,
    LowPriorityAction {
        final boolean myFindClasses;

        private MyNavigateToDuplicateClassOrModuleQuickFix(boolean findClasses) {
            this.myFindClasses = findClasses;
        }

        public boolean availableInBatchMode() {
            return false;
        }

        public boolean startInWriteAction() {
            return false;
        }

        @NotNull
        public String getFamilyName() {
            String string = RbsBundle.message((String)"rbs.inspection.duplicate.go.to.conflicting.declarations.quickfix.name", (Object[])new Object[0]);
            if (string == null) {
                MyNavigateToDuplicateClassOrModuleQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement psiElement;
            if (project == null) {
                MyNavigateToDuplicateClassOrModuleQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                MyNavigateToDuplicateClassOrModuleQuickFix.$$$reportNull$$$0(2);
            }
            if (!((psiElement = descriptor.getPsiElement()) instanceof RbsContainerDeclarationElement)) {
                return;
            }
            RbsContainerDeclarationElement containerElement = (RbsContainerDeclarationElement)psiElement;
            Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
            if (editor == null) {
                return;
            }
            GlobalSearchScope searchScope = RbsSearchScope.collectionScope(project);
            Fqn fqn = containerElement.getFqn();
            Collection targets = (Collection)DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> this.lambda$applyFix$1(project, (SearchScope)searchScope, fqn));
            NavigationTargetPopup.builder((Collection)targets).withTitle(RbsBundle.message((String)"rbs.inspection.duplicate.go.to.conflicting.declarations.title", (Object[])new Object[0])).navigateOrShowInBestPositionFor(editor);
        }

        private /* synthetic */ Collection lambda$applyFix$1(Project project, SearchScope searchScope, Fqn fqn) throws RuntimeException {
            Optional<NavigatableSymbol> container = this.myFindClasses ? RbsClassSymbol.find(project, searchScope, fqn) : RbsModuleSymbol.find(project, searchScope, fqn);
            return container.map(it -> it.getNavigationTargets(project)).orElse(Collections.emptyList());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsDuplicateDeclarationsInspection$MyNavigateToDuplicateClassOrModuleQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsDuplicateDeclarationsInspection$MyNavigateToDuplicateClassOrModuleQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class MyNavigateToDuplicateQuickFix
    implements LocalQuickFix,
    DumbAware,
    LowPriorityAction {
        private final Pointer<? extends Symbol> mySymbolPointer;

        private MyNavigateToDuplicateQuickFix(@NotNull Symbol symbol) {
            if (symbol == null) {
                MyNavigateToDuplicateQuickFix.$$$reportNull$$$0(0);
            }
            this.mySymbolPointer = symbol.createPointer();
        }

        @NotNull
        public String getFamilyName() {
            String string = RbsBundle.message((String)"rbs.inspection.duplicate.go.to.duplicate.quickfix.name", (Object[])new Object[0]);
            if (string == null) {
                MyNavigateToDuplicateQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public boolean availableInBatchMode() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Symbol symbol;
            if (project == null) {
                MyNavigateToDuplicateQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                MyNavigateToDuplicateQuickFix.$$$reportNull$$$0(3);
            }
            if ((symbol = (Symbol)this.mySymbolPointer.dereference()) == null) {
                return;
            }
            Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
            if (editor == null) {
                return;
            }
            List targets = (List)DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> this.getTargets(project, symbol, descriptor.getPsiElement()));
            NavigationTargetPopup.builder((Collection)targets).withTitle(RbsBundle.message((String)"rbs.inspection.duplicate.go.to.duplicate.title", (Object[])new Object[0])).navigateOrShowInBestPositionFor(editor);
        }

        @NotNull
        public List<? extends NavigationTarget> getTargets(@NotNull Project project, @NotNull Symbol symbol, @NotNull PsiElement element) {
            if (project == null) {
                MyNavigateToDuplicateQuickFix.$$$reportNull$$$0(4);
            }
            if (symbol == null) {
                MyNavigateToDuplicateQuickFix.$$$reportNull$$$0(5);
            }
            if (element == null) {
                MyNavigateToDuplicateQuickFix.$$$reportNull$$$0(6);
            }
            List<NavigationTarget> list = RbsPsiSymbolDeclarationSearcher.getDeclarations(project, (SearchScope)RbsSearchScope.collectionScope(project), symbol).stream().filter(it -> !it.getDeclaringElement().equals(element)).map(NavigatablePsiSymbolDeclaration::getNavigationTarget).sorted().toList();
            if (list == null) {
                MyNavigateToDuplicateQuickFix.$$$reportNull$$$0(7);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "symbol";
                    break;
                }
                case 1: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsDuplicateDeclarationsInspection$MyNavigateToDuplicateQuickFix";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsDuplicateDeclarationsInspection$MyNavigateToDuplicateQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTargets";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 7: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getTargets";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 7 -> new IllegalStateException(string);
            };
        }
    }

    private static class MyRemoveDeclarationQuickFix
    implements LocalQuickFix,
    DumbAware {
        private MyRemoveDeclarationQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = RbsBundle.message((String)"rbs.inspection.duplicate.remove.quickfix.family.name", (Object[])new Object[0]);
            if (string == null) {
                MyRemoveDeclarationQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean availableInBatchMode() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                MyRemoveDeclarationQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                MyRemoveDeclarationQuickFix.$$$reportNull$$$0(2);
            }
            descriptor.getPsiElement().delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsDuplicateDeclarationsInspection$MyRemoveDeclarationQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsDuplicateDeclarationsInspection$MyRemoveDeclarationQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

