/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.inspections.probableBugs;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ruby.rbs.model.impl.RbsContainerTypeVariableSymbol;
import com.intellij.lang.ruby.rbs.model.psi.RbsPsiSymbolDeclaration;
import com.intellij.lang.ruby.rbs.model.psi.RbsSearchScope;
import com.intellij.lang.ruby.rbs.psi.RbsClassDeclarationElement;
import com.intellij.lang.ruby.rbs.psi.RbsContainerDeclarationElement;
import com.intellij.lang.ruby.rbs.psi.RbsModuleDeclarationElement;
import com.intellij.lang.ruby.rbs.psi.RbsPsiVisitor;
import com.intellij.lang.ruby.rbs.psi.index.RbsClassDeclarationFqnIndex;
import com.intellij.lang.ruby.rbs.psi.index.RbsFqnStubIndexExtension;
import com.intellij.lang.ruby.rbs.psi.index.RbsModuleDeclarationFqnIndex;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ruby.rbs.frontback.RbsBundle;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.model.presentation.SymbolPresentation;

@ApiStatus.Internal
public final class RbsConflictingTypeVariableVarianceInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RbsConflictingTypeVariableVarianceInspection.$$$reportNull$$$0(0);
        }
        return new MyVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsConflictingTypeVariableVarianceInspection", "buildVisitor"));
    }

    private static final class MyVisitor
    extends RbsPsiVisitor {
        private final ProblemsHolder myHolder;

        private MyVisitor(@NotNull ProblemsHolder holder) {
            if (holder == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            this.myHolder = holder;
        }

        @Override
        public void visitClassDeclarationElement(@NotNull RbsClassDeclarationElement declaration) {
            if (declaration == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            this.visitContainerDeclarationElement(declaration, RbsClassDeclarationFqnIndex.getInstance());
        }

        @Override
        public void visitModuleDeclarationElement(@NotNull RbsModuleDeclarationElement declaration) {
            if (declaration == null) {
                MyVisitor.$$$reportNull$$$0(2);
            }
            this.visitContainerDeclarationElement(declaration, RbsModuleDeclarationFqnIndex.getInstance());
        }

        private void visitContainerDeclarationElement(@NotNull RbsContainerDeclarationElement declaration, @NotNull RbsFqnStubIndexExtension<?> index) {
            if (declaration == null) {
                MyVisitor.$$$reportNull$$$0(3);
            }
            if (index == null) {
                MyVisitor.$$$reportNull$$$0(4);
            }
            Project project = declaration.getProject();
            GlobalSearchScope searchScope = RbsSearchScope.collectionScope(project);
            for (RbsPsiSymbolDeclaration<RbsContainerTypeVariableSymbol> typeVariableDeclaration : declaration.getTypeVariableSymbolDeclarations()) {
                RbsContainerTypeVariableSymbol typeVariable = (RbsContainerTypeVariableSymbol)typeVariableDeclaration.getSymbol();
                AtomicInteger count = new AtomicInteger();
                index.processElements(project, (SearchScope)searchScope, declaration.getFqn(), element -> {
                    ProgressManager.checkCanceled();
                    if (!(element instanceof RbsContainerDeclarationElement)) {
                        return true;
                    }
                    RbsContainerDeclarationElement containerDeclaration = (RbsContainerDeclarationElement)((Object)element);
                    List typeVariables = ContainerUtil.map(containerDeclaration.getTypeVariableSymbolDeclarations(), RbsPsiSymbolDeclaration::getSymbol);
                    for (RbsContainerTypeVariableSymbol other : typeVariables) {
                        if (other.getTypeVariableIndex() != typeVariable.getTypeVariableIndex()) continue;
                        if (other.getVariance() != typeVariable.getVariance() || other.isUnchecked() != typeVariable.isUnchecked()) {
                            count.incrementAndGet();
                        }
                        return count.get() <= 1;
                    }
                    return true;
                });
                if (count.get() <= 0) continue;
                SymbolPresentation presentation = typeVariable.getPresentation();
                this.myHolder.registerProblem((PsiElement)declaration, typeVariableDeclaration.getRangeInDeclaringElement(), RbsBundle.message((String)"rbs.inspection.conflicting.type.variable.variance.description", (Object[])new Object[]{presentation.longDescription(), count.get()}), new LocalQuickFix[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "declaration";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "index";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsConflictingTypeVariableVarianceInspection$MyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClassDeclarationElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitModuleDeclarationElement";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitContainerDeclarationElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

