/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.inspections.probableBugs;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ruby.rbs.model.api.RbsContainerSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsContainerTypeVariableSymbol;
import com.intellij.lang.ruby.rbs.model.psi.RbsPsiSymbolDeclaration;
import com.intellij.lang.ruby.rbs.model.psi.RbsPsiSymbolDeclarationSearcher;
import com.intellij.lang.ruby.rbs.model.psi.RbsSearchScope;
import com.intellij.lang.ruby.rbs.psi.RbsClassDecl;
import com.intellij.lang.ruby.rbs.psi.RbsContainerDeclarationElement;
import com.intellij.lang.ruby.rbs.psi.RbsModuleDecl;
import com.intellij.lang.ruby.rbs.psi.RbsModuleTypeParams;
import com.intellij.lang.ruby.rbs.psi.RbsModuleTypeParamsOwner;
import com.intellij.lang.ruby.rbs.psi.RbsPsiVisitor;
import com.intellij.lang.ruby.rbs.psi.util.RbsPsiEditUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ruby.rbs.frontback.RbsBundle;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.DumbModeAccessType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.model.navigation.NavigatableSymbol;
import org.jetbrains.plugins.ruby.model.navigation.NavigationTargetPopup;
import org.jetbrains.plugins.ruby.model.psi.NavigatablePsiSymbolDeclaration;
import org.jetbrains.plugins.ruby.util.StreamUtil;

@ApiStatus.Internal
public final class RbsConflictingTypeVariableCountInspection
extends LocalInspectionTool {
    private static final int MAX_NUMBER_OF_DIFFERENT_CASES_MISMATCH_TYPE_VARIABLES = 5;
    private static final String EMPTY_TYPE_VARIABLE_NAME = "";

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RbsConflictingTypeVariableCountInspection.$$$reportNull$$$0(0);
        }
        return new MyVisitor(holder);
    }

    @NotNull
    private static Stream<List<RbsContainerTypeVariableSymbol>> getStreamOfListOfTypeVariableSymbols(@NotNull List<? extends RbsPsiSymbolDeclaration<?>> partialDeclarations) {
        if (partialDeclarations == null) {
            RbsConflictingTypeVariableCountInspection.$$$reportNull$$$0(1);
        }
        Stream<List<RbsContainerTypeVariableSymbol>> stream = partialDeclarations.stream().map(it -> it.getDeclaringElement()).mapMulti(StreamUtil.select(RbsContainerDeclarationElement.class, (Class[])new Class[0])).map(it -> it.getTypeVariableSymbols());
        if (stream == null) {
            RbsConflictingTypeVariableCountInspection.$$$reportNull$$$0(2);
        }
        return stream;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partialDeclarations";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsConflictingTypeVariableCountInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsConflictingTypeVariableCountInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStreamOfListOfTypeVariableSymbols";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getStreamOfListOfTypeVariableSymbols";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static final class MyVisitor
    extends RbsPsiVisitor {
        private final ProblemsHolder myHolder;

        private MyVisitor(@NotNull ProblemsHolder holder) {
            if (holder == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            this.myHolder = holder;
        }

        @Override
        public void visitClassDecl(@NotNull RbsClassDecl declaration) {
            if (declaration == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            this.visit(declaration);
        }

        @Override
        public void visitModuleDecl(@NotNull RbsModuleDecl declaration) {
            if (declaration == null) {
                MyVisitor.$$$reportNull$$$0(2);
            }
            this.visit(declaration);
        }

        private void visit(@NotNull RbsContainerDeclarationElement declaration) {
            if (declaration == null) {
                MyVisitor.$$$reportNull$$$0(3);
            }
            if (PsiTreeUtil.hasErrorElements((PsiElement)declaration)) {
                return;
            }
            RbsContainerSymbol declarationSymbol = declaration.getSymbol();
            if (declarationSymbol == null) {
                return;
            }
            RbsPsiSymbolDeclaration<? extends RbsContainerSymbol> psiSymbolDeclaration = declaration.getSymbolDeclaration();
            if (psiSymbolDeclaration == null) {
                return;
            }
            PsiElement declarationNameIdentifier = declaration.getNameIdentifier();
            if (declarationNameIdentifier == null) {
                return;
            }
            PsiElement declarationFullName = declarationNameIdentifier.getParent();
            if (declarationFullName == null) {
                return;
            }
            Project project = declaration.getProject();
            GlobalSearchScope searchScope = RbsSearchScope.collectionScope(project);
            int currentCount = declaration.getTypeVariableSymbols().size();
            List<RbsPsiSymbolDeclaration<?>> partialSymbolDeclarations = RbsPsiSymbolDeclarationSearcher.getDeclarations(project, (SearchScope)searchScope, declarationSymbol);
            MultiMap possibleTypeArgumentNames = new MultiMap();
            RbsConflictingTypeVariableCountInspection.getStreamOfListOfTypeVariableSymbols(partialSymbolDeclarations).forEach(list -> {
                int currentPosition = 1;
                for (RbsContainerTypeVariableSymbol typeVariableSymbol : list) {
                    possibleTypeArgumentNames.putValue((Object)currentPosition, (Object)typeVariableSymbol.getName());
                    ++currentPosition;
                }
            });
            int numberDifferentCasesMismatchTypeVariables = (int)RbsConflictingTypeVariableCountInspection.getStreamOfListOfTypeVariableSymbols(partialSymbolDeclarations).map(it -> it.size()).distinct().filter(it -> it != currentCount).count();
            if (numberDifferentCasesMismatchTypeVariables != 0) {
                if (numberDifferentCasesMismatchTypeVariables > 5) {
                    this.myHolder.registerProblem((PsiElement)declaration, psiSymbolDeclaration.getRangeInDeclaringElement(), RbsBundle.message((String)"rbs.inspection.conflicting.type.variable.count.description", (Object[])new Object[]{declarationSymbol.getPresentation().longDescription(), currentCount}), new LocalQuickFix[]{new MyGoToQuickFix()});
                } else {
                    ArrayList<MyGoToQuickFix> quickFixes = new ArrayList<MyGoToQuickFix>();
                    partialSymbolDeclarations.forEach(partialSymbolDeclaration -> {
                        PsiElement declaringElement = partialSymbolDeclaration.getDeclaringElement();
                        if (declaringElement instanceof RbsContainerDeclarationElement) {
                            int otherCount = ((RbsContainerDeclarationElement)declaringElement).getTypeVariableSymbols().size();
                            if (otherCount > currentCount) {
                                quickFixes.add((MyGoToQuickFix)((Object)new MyAddQuickFix(currentCount, otherCount, (MultiMap<Integer, String>)possibleTypeArgumentNames)));
                            }
                            if (otherCount < currentCount) {
                                quickFixes.add((MyGoToQuickFix)((Object)new MyRemoveQuickFix(currentCount - otherCount)));
                            }
                        }
                    });
                    quickFixes.add(new MyGoToQuickFix());
                    this.myHolder.registerProblem((PsiElement)declaration, psiSymbolDeclaration.getRangeInDeclaringElement(), RbsBundle.message((String)"rbs.inspection.conflicting.type.variable.count.description", (Object[])new Object[]{declarationSymbol.getPresentation().longDescription(), currentCount}), (LocalQuickFix[])quickFixes.toArray(LocalQuickFix[]::new));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "declaration";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsConflictingTypeVariableCountInspection$MyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClassDecl";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitModuleDecl";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visit";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyGoToQuickFix
    implements LocalQuickFix,
    DumbAware,
    LowPriorityAction {
        private MyGoToQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = RbsBundle.message((String)"rbs.inspection.conflicting.type.variable.count.goTo.quickfix.family.name", (Object[])new Object[0]);
            if (string == null) {
                MyGoToQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            RbsContainerDeclarationElement declaration;
            RbsContainerSymbol declarationSymbol;
            if (project == null) {
                MyGoToQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                MyGoToQuickFix.$$$reportNull$$$0(2);
            }
            if (!((declarationSymbol = (declaration = (RbsContainerDeclarationElement)descriptor.getPsiElement()).getSymbol()) instanceof NavigatableSymbol)) {
                return;
            }
            Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
            if (editor == null) {
                return;
            }
            int currentCount = declaration.getTypeVariableSymbols().size();
            List targets = (List)DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> RbsPsiSymbolDeclarationSearcher.getDeclarations(project, (SearchScope)RbsSearchScope.collectionScope(project), declarationSymbol).stream().filter(it -> {
                PsiElement element = it.getDeclaringElement();
                if (element.equals(declaration) || !(element instanceof RbsModuleTypeParamsOwner)) {
                    return false;
                }
                return ((RbsModuleTypeParamsOwner)element).getModuleTypeParamList().size() != currentCount;
            }).map(NavigatablePsiSymbolDeclaration::getNavigationTarget).sorted().toList());
            NavigationTargetPopup.builder((Collection)targets).withTitle(RbsBundle.message((String)"rbs.inspection.conflicting.type.variable.count.goTo.quickfix.name.popup.title", (Object[])new Object[0])).navigateOrShowInBestPositionFor(editor);
        }

        public boolean availableInBatchMode() {
            return false;
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsConflictingTypeVariableCountInspection$MyGoToQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsConflictingTypeVariableCountInspection$MyGoToQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    private static final class MyRemoveQuickFix
    implements LocalQuickFix,
    DumbAware,
    HighPriorityAction {
        private final int myNumberDeleteVariables;

        private MyRemoveQuickFix(int numberDeleteVariables) {
            this.myNumberDeleteVariables = numberDeleteVariables;
        }

        @NotNull
        public String getName() {
            String string = RbsBundle.message((String)"rbs.inspection.conflicting.type.variable.count.remove.quickfix.name", (Object[])new Object[]{this.myNumberDeleteVariables});
            if (string == null) {
                MyRemoveQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = RbsBundle.message((String)"rbs.inspection.conflicting.type.variable.count.remove.quickfix.family.name", (Object[])new Object[0]);
            if (string == null) {
                MyRemoveQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            RbsContainerDeclarationElement element;
            RbsModuleTypeParams moduleTypeParams;
            if (project == null) {
                MyRemoveQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                MyRemoveQuickFix.$$$reportNull$$$0(3);
            }
            if ((moduleTypeParams = (element = (RbsContainerDeclarationElement)descriptor.getPsiElement()).getModuleTypeParams()) == null) {
                return;
            }
            if (moduleTypeParams.getModuleTypeParamList().size() == this.myNumberDeleteVariables) {
                moduleTypeParams.delete();
            } else {
                for (int currentDeletedVariables = 0; currentDeletedVariables != this.myNumberDeleteVariables; ++currentDeletedVariables) {
                    PsiElement psiElement = (PsiElement)ContainerUtil.getLastItem(moduleTypeParams.getModuleTypeParamList());
                    if (psiElement != null) {
                        RbsPsiEditUtil.deleteListElement(psiElement);
                        continue;
                    }
                    moduleTypeParams.delete();
                    return;
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsConflictingTypeVariableCountInspection$MyRemoveQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsConflictingTypeVariableCountInspection$MyRemoveQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static final class MyAddQuickFix
    implements LocalQuickFix,
    DumbAware,
    HighPriorityAction {
        private final int myCurrentCount;
        private final int myExpectedCount;
        @FileModifier.SafeFieldForPreview
        @NotNull
        private final MultiMap<Integer, String> myPossibleTypeVariableNames;

        private MyAddQuickFix(int currentCount, int expectedCount, @NotNull MultiMap<Integer, String> possibleTypeArgumentNames) {
            if (possibleTypeArgumentNames == null) {
                MyAddQuickFix.$$$reportNull$$$0(0);
            }
            this.myCurrentCount = currentCount;
            this.myExpectedCount = expectedCount;
            this.myPossibleTypeVariableNames = possibleTypeArgumentNames;
        }

        public boolean availableInBatchMode() {
            return false;
        }

        @NotNull
        public String getName() {
            String string = RbsBundle.message((String)"rbs.inspection.conflicting.type.variable.count.add.quickfix.name", (Object[])new Object[]{this.myExpectedCount - this.myCurrentCount});
            if (string == null) {
                MyAddQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = RbsBundle.message((String)"rbs.inspection.conflicting.type.variable.count.add.quickfix.family.name", (Object[])new Object[0]);
            if (string == null) {
                MyAddQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                MyAddQuickFix.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                MyAddQuickFix.$$$reportNull$$$0(4);
            }
            RbsContainerDeclarationElement element = (RbsContainerDeclarationElement)descriptor.getPsiElement();
            Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
            if (editor == null) {
                return;
            }
            TemplateManager manager = TemplateManager.getInstance((Project)project);
            Template template = manager.createTemplate("rbs_add_type_variables_to_partial_declarations_template", "rbs");
            template.setToReformat(true);
            RbsModuleTypeParams typeList = element.getModuleTypeParams();
            if (typeList == null) {
                PsiElement name = element.getNameIdentifier();
                if (name != null) {
                    template.addTextSegment("[");
                    for (int i = 0; i < this.myExpectedCount; ++i) {
                        if (i > 0) {
                            template.addTextSegment(", ");
                        }
                        Collection candidates = this.myPossibleTypeVariableNames.get((Object)(i + 1));
                        String defaultCandidate = (String)ObjectUtils.coalesce((Object)((String)ContainerUtil.getFirstItem((Collection)candidates)), (Object)RbsConflictingTypeVariableCountInspection.EMPTY_TYPE_VARIABLE_NAME);
                        template.addVariable((Expression)new ConstantNode(defaultCandidate).withLookupStrings(candidates), true);
                    }
                    template.addTextSegment("]");
                    editor.getCaretModel().moveToOffset(name.getTextRange().getEndOffset());
                }
            } else {
                for (int i = 0; i < this.myExpectedCount - this.myCurrentCount; ++i) {
                    template.addTextSegment(", ");
                    Collection candidates = this.myPossibleTypeVariableNames.get((Object)(this.myCurrentCount + i + 1));
                    String defaultCandidate = (String)ObjectUtils.coalesce((Object)((String)ContainerUtil.getFirstItem((Collection)candidates)), (Object)RbsConflictingTypeVariableCountInspection.EMPTY_TYPE_VARIABLE_NAME);
                    template.addVariable((Expression)new ConstantNode(defaultCandidate).withLookupStrings(candidates), true);
                }
                editor.getCaretModel().moveToOffset(typeList.getTextRange().getEndOffset() - 1);
            }
            manager.startTemplate(editor, template);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "possibleTypeArgumentNames";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsConflictingTypeVariableCountInspection$MyAddQuickFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/probableBugs/RbsConflictingTypeVariableCountInspection$MyAddQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

