/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.inspections.dataFlow;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ruby.rbs.inspections.dataFlow.RbsUnusedSymbolVisitor;
import com.intellij.lang.ruby.rbs.model.impl.RbsClassSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsContainerTypeVariableSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsInterfaceSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsMethodTypeVariableSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsModuleSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsTypeAliasTypeVariableSymbol;
import com.intellij.lang.ruby.rbs.model.psi.RbsPsiSymbolDeclaration;
import com.intellij.lang.ruby.rbs.model.psi.RbsPsiSymbolDeclarationSearcher;
import com.intellij.lang.ruby.rbs.psi.RbsClassDeclarationElement;
import com.intellij.lang.ruby.rbs.psi.RbsContainerDeclarationElement;
import com.intellij.lang.ruby.rbs.psi.RbsInterfaceDeclarationElement;
import com.intellij.lang.ruby.rbs.psi.RbsMethodMember;
import com.intellij.lang.ruby.rbs.psi.RbsMethodType;
import com.intellij.lang.ruby.rbs.psi.RbsModuleDeclarationElement;
import com.intellij.lang.ruby.rbs.psi.RbsModuleTypeParam;
import com.intellij.lang.ruby.rbs.psi.RbsModuleTypeParams;
import com.intellij.lang.ruby.rbs.psi.RbsTypeDeclarationElement;
import com.intellij.lang.ruby.rbs.psi.RbsTypeParam;
import com.intellij.lang.ruby.rbs.psi.util.RbsPsiEditUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ruby.rbs.frontback.RbsBundle;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.model.presentation.SymbolPresentation;

@ApiStatus.Internal
public final class RbsUnusedTypeVariableInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RbsUnusedTypeVariableInspection.$$$reportNull$$$0(0);
        }
        return new MyVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/ruby/rbs/inspections/dataFlow/RbsUnusedTypeVariableInspection", "buildVisitor"));
    }

    private static final class MyVisitor
    extends RbsUnusedSymbolVisitor {
        private final ProblemsHolder myHolder;

        private MyVisitor(@NotNull ProblemsHolder holder) {
            if (holder == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            super(holder.getProject());
            this.myHolder = holder;
        }

        @Override
        public void visitClassDeclarationElement(@NotNull RbsClassDeclarationElement element) {
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            GlobalSearchScope searchScope = element.getResolveScope();
            RbsClassSymbol symbol = element.getSymbol();
            if (symbol == null || RbsPsiSymbolDeclarationSearcher.getDeclarations(this.myProject, (SearchScope)searchScope, symbol).size() > 1) {
                return;
            }
            this.visitContainerDeclarationElement(element);
        }

        @Override
        public void visitInterfaceDeclarationElement(@NotNull RbsInterfaceDeclarationElement element) {
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(2);
            }
            GlobalSearchScope searchScope = element.getResolveScope();
            RbsInterfaceSymbol symbol = element.getSymbol();
            if (symbol == null || RbsPsiSymbolDeclarationSearcher.getDeclarations(this.myProject, (SearchScope)searchScope, symbol).size() > 1) {
                return;
            }
            this.visitContainerDeclarationElement(element);
        }

        @Override
        public void visitMethodMember(@NotNull RbsMethodMember element) {
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(3);
            }
            for (RbsPsiSymbolDeclaration<RbsMethodTypeVariableSymbol> declaration : element.getTypeVariableSymbolDeclarations()) {
                RbsMethodTypeVariableSymbol symbol = (RbsMethodTypeVariableSymbol)declaration.getSymbol();
                if (this.hasUsages(symbol)) continue;
                RbsMethodType methodType = element.getMethodTypeList().get(symbol.getMethodTypeIndex());
                PsiElement identifier = Objects.requireNonNull(methodType.getTypeParamIdentifiers().get(symbol.getTypeVariableIndex()));
                SymbolPresentation presentation = symbol.getPresentation();
                this.myHolder.registerProblem(identifier, RbsBundle.message((String)"rbs.inspection.unused.type.variable.description", (Object[])new Object[]{presentation.longDescription()}), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new MyRemoveMethodTypeVariableQuickFix(presentation.name())});
            }
        }

        @Override
        public void visitModuleDeclarationElement(@NotNull RbsModuleDeclarationElement element) {
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(4);
            }
            GlobalSearchScope searchScope = element.getResolveScope();
            RbsModuleSymbol symbol = element.getSymbol();
            if (symbol == null || RbsPsiSymbolDeclarationSearcher.getDeclarations(this.myProject, (SearchScope)searchScope, symbol).size() > 1) {
                return;
            }
            this.visitContainerDeclarationElement(element);
        }

        @Override
        public void visitTypeDeclarationElement(@NotNull RbsTypeDeclarationElement element) {
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(5);
            }
            for (RbsPsiSymbolDeclaration<RbsTypeAliasTypeVariableSymbol> declaration : element.getTypeVariableSymbolDeclarations()) {
                RbsTypeAliasTypeVariableSymbol symbol = (RbsTypeAliasTypeVariableSymbol)declaration.getSymbol();
                if (this.hasUsages(symbol)) continue;
                PsiElement identifier = Objects.requireNonNull(element.getModuleTypeParamIdentifiers().get(symbol.getTypeVariableIndex()));
                SymbolPresentation presentation = symbol.getPresentation();
                this.myHolder.registerProblem(identifier, RbsBundle.message((String)"rbs.inspection.unused.type.variable.description", (Object[])new Object[]{presentation.longDescription()}), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new MyRemoveQualifiedNameTypeVariableQuickFix(presentation.name())});
            }
        }

        private void visitContainerDeclarationElement(@NotNull RbsContainerDeclarationElement element) {
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(6);
            }
            for (RbsPsiSymbolDeclaration<RbsContainerTypeVariableSymbol> declaration : element.getTypeVariableSymbolDeclarations()) {
                RbsContainerTypeVariableSymbol symbol = (RbsContainerTypeVariableSymbol)declaration.getSymbol();
                if (this.hasUsages(symbol)) continue;
                PsiElement identifier = Objects.requireNonNull(element.getModuleTypeParamIdentifiers().get(symbol.getTypeVariableIndex()));
                SymbolPresentation presentation = symbol.getPresentation();
                this.myHolder.registerProblem(identifier, RbsBundle.message((String)"rbs.inspection.unused.type.variable.description", (Object[])new Object[]{presentation.longDescription()}), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new MyRemoveQualifiedNameTypeVariableQuickFix(presentation.name())});
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/dataFlow/RbsUnusedTypeVariableInspection$MyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClassDeclarationElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitInterfaceDeclarationElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodMember";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitModuleDeclarationElement";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTypeDeclarationElement";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitContainerDeclarationElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyRemoveQualifiedNameTypeVariableQuickFix
    implements LocalQuickFix,
    DumbAware {
        private final String myName;

        private MyRemoveQualifiedNameTypeVariableQuickFix(@NotNull String name) {
            if (name == null) {
                MyRemoveQualifiedNameTypeVariableQuickFix.$$$reportNull$$$0(0);
            }
            this.myName = name;
        }

        @NotNull
        public String getName() {
            String string = RbsBundle.message((String)"rbs.inspection.unused.type.variable.remove.quickfix.name", (Object[])new Object[]{this.myName});
            if (string == null) {
                MyRemoveQualifiedNameTypeVariableQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = RbsBundle.message((String)"rbs.inspection.unused.type.variable.remove.quickfix.family.name", (Object[])new Object[0]);
            if (string == null) {
                MyRemoveQualifiedNameTypeVariableQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            RbsModuleTypeParam typeParam;
            RbsModuleTypeParams typeParams;
            if (project == null) {
                MyRemoveQualifiedNameTypeVariableQuickFix.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                MyRemoveQualifiedNameTypeVariableQuickFix.$$$reportNull$$$0(4);
            }
            if ((typeParams = (RbsModuleTypeParams)(typeParam = (RbsModuleTypeParam)descriptor.getPsiElement().getParent()).getParent()).getModuleTypeParamList().size() == 1) {
                typeParams.delete();
            } else {
                RbsPsiEditUtil.deleteListElement(typeParam);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ruby/rbs/inspections/dataFlow/RbsUnusedTypeVariableInspection$MyRemoveQualifiedNameTypeVariableQuickFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/dataFlow/RbsUnusedTypeVariableInspection$MyRemoveQualifiedNameTypeVariableQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    private static final class MyRemoveMethodTypeVariableQuickFix
    implements LocalQuickFix,
    DumbAware {
        private final String myName;

        private MyRemoveMethodTypeVariableQuickFix(@NotNull String name) {
            if (name == null) {
                MyRemoveMethodTypeVariableQuickFix.$$$reportNull$$$0(0);
            }
            this.myName = name;
        }

        @NotNull
        public String getName() {
            String string = RbsBundle.message((String)"rbs.inspection.unused.type.variable.remove.quickfix.name", (Object[])new Object[]{this.myName});
            if (string == null) {
                MyRemoveMethodTypeVariableQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = RbsBundle.message((String)"rbs.inspection.unused.type.variable.remove.quickfix.family.name", (Object[])new Object[0]);
            if (string == null) {
                MyRemoveMethodTypeVariableQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            RbsTypeParam typeParam;
            RbsMethodType methodType;
            if (project == null) {
                MyRemoveMethodTypeVariableQuickFix.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                MyRemoveMethodTypeVariableQuickFix.$$$reportNull$$$0(4);
            }
            if ((methodType = (RbsMethodType)(typeParam = (RbsTypeParam)descriptor.getPsiElement().getParent()).getParent()).getTypeParamList().size() == 1) {
                methodType.deleteChildRange(methodType.getFirstChild(), methodType.getProcType().getPrevSibling());
            } else {
                RbsPsiEditUtil.deleteListElement(typeParam);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ruby/rbs/inspections/dataFlow/RbsUnusedTypeVariableInspection$MyRemoveMethodTypeVariableQuickFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/dataFlow/RbsUnusedTypeVariableInspection$MyRemoveMethodTypeVariableQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

