/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.inspections.codeStyle;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ruby.rbs.psi.RbsProcType;
import com.intellij.lang.ruby.rbs.psi.RbsPsiVisitor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ruby.rbs.frontback.RbsBundle;
import com.intellij.ruby.rbs.frontback.psi.tree.RbsElementTypesGenerated;
import com.intellij.util.ObjectUtils;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class RbsUnnecessaryParenthesesInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RbsUnnecessaryParenthesesInspection.$$$reportNull$$$0(0);
        }
        return new MyVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/ruby/rbs/inspections/codeStyle/RbsUnnecessaryParenthesesInspection", "buildVisitor"));
    }

    private static final class MyVisitor
    extends RbsPsiVisitor {
        private final ProblemsHolder myHolder;

        private MyVisitor(@NotNull ProblemsHolder holder) {
            if (holder == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            this.myHolder = holder;
        }

        @Override
        public void visitProcType(@NotNull RbsProcType element) {
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            if (!element.getParamList().isEmpty()) {
                return;
            }
            PsiElement start = PsiTreeUtil.getDeepestFirst((PsiElement)element);
            PsiElement end = PsiTreeUtil.findSiblingForward((PsiElement)start, (IElementType)RbsElementTypesGenerated.RBS_KRPAREN, null);
            if (PsiUtilCore.getElementType((PsiElement)start) != RbsElementTypesGenerated.RBS_KLPAREN || end == null) {
                return;
            }
            if (!List.of(RbsElementTypesGenerated.RBS_KARROW, RbsElementTypesGenerated.RBS_KLBRACE).contains(PsiUtilCore.getElementType((PsiElement)PsiTreeUtil.nextVisibleLeaf((PsiElement)end)))) {
                return;
            }
            TextRange range = TextRange.create((int)start.getStartOffsetInParent(), (int)(end.getStartOffsetInParent() + end.getTextLength()));
            this.myHolder.registerProblem((PsiElement)element, range, RbsBundle.message((String)"rbs.inspection.unnecessary.parentheses.description", (Object[])new Object[0]), new LocalQuickFix[]{MyQuickFix.INSTANCE});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/codeStyle/RbsUnnecessaryParenthesesInspection$MyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitProcType";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyQuickFix
    implements LocalQuickFix,
    DumbAware {
        private static final MyQuickFix INSTANCE = new MyQuickFix();

        private MyQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = RbsBundle.message((String)"rbs.inspection.unnecessary.parentheses.remove.quickfix.name", (Object[])new Object[0]);
            if (string == null) {
                MyQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                MyQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                MyQuickFix.$$$reportNull$$$0(2);
            }
            RbsProcType element = (RbsProcType)descriptor.getPsiElement();
            PsiElement start = PsiTreeUtil.getDeepestFirst((PsiElement)element);
            PsiElement end = Objects.requireNonNull((PsiElement)ObjectUtils.coalesce((Object)PsiTreeUtil.findSiblingForward((PsiElement)start, (IElementType)RbsElementTypesGenerated.RBS_BLOCK, null), (Object)PsiTreeUtil.findSiblingForward((PsiElement)start, (IElementType)RbsElementTypesGenerated.RBS_KARROW, null))).getPrevSibling();
            element.deleteChildRange(start, end);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ruby/rbs/inspections/codeStyle/RbsUnnecessaryParenthesesInspection$MyQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/codeStyle/RbsUnnecessaryParenthesesInspection$MyQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

