/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.inspections.codeStyle;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ruby.rbs.psi.RbsOrType;
import com.intellij.lang.ruby.rbs.psi.RbsPsiVisitor;
import com.intellij.lang.ruby.rbs.psi.RbsType;
import com.intellij.lang.ruby.rbs.psi.data.RbsBooleanLiteralSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsQualifiedNameTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignatureResolver;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignatureVisitor;
import com.intellij.lang.ruby.rbs.psi.mixin.RbsOrTypeMixin;
import com.intellij.lang.ruby.rbs.psi.navigators.RbsOrTypeNavigator;
import com.intellij.lang.ruby.rbs.psi.util.RbsPsiElementFactory;
import com.intellij.lang.ruby.rbs.util.RbsFqns;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ruby.rbs.frontback.RbsBundle;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DumbModeAccessType;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class RbsSimplifiableBooleanUnionInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RbsSimplifiableBooleanUnionInspection.$$$reportNull$$$0(0);
        }
        return new MyVisitor(holder);
    }

    private static boolean isFalseTypeSignature(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RbsTypeSignature signature) {
        if (project == null) {
            RbsSimplifiableBooleanUnionInspection.$$$reportNull$$$0(1);
        }
        if (searchScope == null) {
            RbsSimplifiableBooleanUnionInspection.$$$reportNull$$$0(2);
        }
        if (signature == null) {
            RbsSimplifiableBooleanUnionInspection.$$$reportNull$$$0(3);
        }
        final Ref isFalseClassRef = new Ref((Object)false);
        signature.apply(new RbsTypeSignatureResolver(project, searchScope)).accept(new RbsTypeSignatureVisitor(){

            @Override
            public void visitBooleanLiteralSignature(@NotNull RbsBooleanLiteralSignature signature) {
                if (signature == null) {
                    1.$$$reportNull$$$0(0);
                }
                isFalseClassRef.set((Object)(!signature.getLiteral() ? 1 : 0));
            }

            @Override
            public void visitQualifiedNameTypeSignature(@NotNull RbsQualifiedNameTypeSignature signature) {
                if (signature == null) {
                    1.$$$reportNull$$$0(1);
                }
                isFalseClassRef.set((Object)signature.getFqn().isEquivalentTo(RbsFqns.FALSE_CLASS_FQN));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "signature";
                objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/codeStyle/RbsSimplifiableBooleanUnionInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitBooleanLiteralSignature";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitQualifiedNameTypeSignature";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return (Boolean)isFalseClassRef.get();
    }

    private static boolean isTrueTypeSignature(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RbsTypeSignature signature) {
        if (project == null) {
            RbsSimplifiableBooleanUnionInspection.$$$reportNull$$$0(4);
        }
        if (searchScope == null) {
            RbsSimplifiableBooleanUnionInspection.$$$reportNull$$$0(5);
        }
        if (signature == null) {
            RbsSimplifiableBooleanUnionInspection.$$$reportNull$$$0(6);
        }
        final Ref isTrueClassRef = new Ref((Object)false);
        signature.apply(new RbsTypeSignatureResolver(project, searchScope)).accept(new RbsTypeSignatureVisitor(){

            @Override
            public void visitBooleanLiteralSignature(@NotNull RbsBooleanLiteralSignature signature) {
                if (signature == null) {
                    2.$$$reportNull$$$0(0);
                }
                isTrueClassRef.set((Object)signature.getLiteral());
            }

            @Override
            public void visitQualifiedNameTypeSignature(@NotNull RbsQualifiedNameTypeSignature signature) {
                if (signature == null) {
                    2.$$$reportNull$$$0(1);
                }
                isTrueClassRef.set((Object)signature.getFqn().isEquivalentTo(RbsFqns.TRUE_CLASS_FQN));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "signature";
                objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/codeStyle/RbsSimplifiableBooleanUnionInspection$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitBooleanLiteralSignature";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitQualifiedNameTypeSignature";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return (Boolean)isTrueClassRef.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/codeStyle/RbsSimplifiableBooleanUnionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isFalseTypeSignature";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isTrueTypeSignature";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyVisitor
    extends RbsPsiVisitor {
        private final Project myProject;
        private final SearchScope mySearchScope;
        private final ProblemsHolder myHolder;

        private MyVisitor(@NotNull ProblemsHolder holder) {
            if (holder == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            this.myProject = holder.getProject();
            this.mySearchScope = holder.getFile().getResolveScope();
            this.myHolder = holder;
        }

        @Override
        public void visitOrType(@NotNull RbsOrType type) {
            if (type == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            if (type.getParent() instanceof RbsOrType || PsiTreeUtil.hasErrorElements((PsiElement)type)) {
                return;
            }
            List<RbsType> typeList = ((RbsOrTypeMixin)type).getFlattenedTypeList();
            RbsType trueType = (RbsType)ContainerUtil.find(typeList, it -> RbsSimplifiableBooleanUnionInspection.isTrueTypeSignature(this.myProject, this.mySearchScope, it.getTypeSignature()));
            if (trueType == null) {
                return;
            }
            RbsType falseType = (RbsType)ContainerUtil.find(typeList, it -> RbsSimplifiableBooleanUnionInspection.isFalseTypeSignature(this.myProject, this.mySearchScope, it.getTypeSignature()));
            if (falseType == null) {
                return;
            }
            RbsType identifier = trueType.getTextOffset() < falseType.getTextOffset() ? trueType : falseType;
            RbsType other = identifier == trueType ? falseType : trueType;
            this.myHolder.registerProblem((PsiElement)identifier, RbsBundle.message((String)"rbs.inspection.simplifiable.boolean.union.description", (Object[])new Object[]{identifier.getText(), other.getText()}), new LocalQuickFix[]{new MyQuickFix(identifier.getText(), other.getText())});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/codeStyle/RbsSimplifiableBooleanUnionInspection$MyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitOrType";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyQuickFix
    implements LocalQuickFix,
    DumbAware {
        private final String myFirstTypeName;
        private final String mySecondTypeName;

        private MyQuickFix(@NotNull String firstTypeName, @NotNull String secondTypeName) {
            if (firstTypeName == null) {
                MyQuickFix.$$$reportNull$$$0(0);
            }
            if (secondTypeName == null) {
                MyQuickFix.$$$reportNull$$$0(1);
            }
            this.myFirstTypeName = firstTypeName;
            this.mySecondTypeName = secondTypeName;
        }

        @NotNull
        public String getName() {
            String string = RbsBundle.message((String)"rbs.inspection.simplifiable.boolean.union.replace.quickfix.name", (Object[])new Object[]{this.myFirstTypeName, this.mySecondTypeName});
            if (string == null) {
                MyQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = RbsBundle.message((String)"rbs.inspection.simplifiable.boolean.union.replace.quickfix.family.name", (Object[])new Object[0]);
            if (string == null) {
                MyQuickFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                MyQuickFix.$$$reportNull$$$0(4);
            }
            if (descriptor == null) {
                MyQuickFix.$$$reportNull$$$0(5);
            }
            RbsType identifier = (RbsType)descriptor.getPsiElement();
            GlobalSearchScope searchScope = identifier.getResolveScope();
            RbsOrTypeMixin topmostParent = (RbsOrTypeMixin)ContainerUtil.getLastItem((List)PsiTreeUtil.collectParents((PsiElement)identifier, RbsOrTypeMixin.class, (boolean)false, it -> !(it instanceof RbsOrTypeMixin)));
            List<RbsType> typeList = topmostParent.getFlattenedTypeList();
            RbsType other = RbsSimplifiableBooleanUnionInspection.isTrueTypeSignature(project, (SearchScope)searchScope, identifier.getTypeSignature()) ? (RbsType)DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> MyQuickFix.lambda$applyFix$2(typeList, project, (SearchScope)searchScope)) : (RbsType)DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> MyQuickFix.lambda$applyFix$4(typeList, project, (SearchScope)searchScope));
            if (other == null) {
                return;
            }
            identifier.replace(RbsPsiElementFactory.createType(project, "bool"));
            RbsOrType bottomParent = Objects.requireNonNull(RbsOrTypeNavigator.getByType(other));
            bottomParent.replace(bottomParent.getTypeList().get(0));
        }

        private static /* synthetic */ RbsType lambda$applyFix$4(List typeList, Project project, SearchScope searchScope) throws RuntimeException {
            return (RbsType)ContainerUtil.find((Iterable)typeList, it -> RbsSimplifiableBooleanUnionInspection.isTrueTypeSignature(project, searchScope, it.getTypeSignature()));
        }

        private static /* synthetic */ RbsType lambda$applyFix$2(List typeList, Project project, SearchScope searchScope) throws RuntimeException {
            return (RbsType)ContainerUtil.find((Iterable)typeList, it -> RbsSimplifiableBooleanUnionInspection.isFalseTypeSignature(project, searchScope, it.getTypeSignature()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "firstTypeName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "secondTypeName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ruby/rbs/inspections/codeStyle/RbsSimplifiableBooleanUnionInspection$MyQuickFix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/codeStyle/RbsSimplifiableBooleanUnionInspection$MyQuickFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

