/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.inspections.codeStyle;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ruby.rbs.psi.RbsPsiVisitor;
import com.intellij.lang.ruby.rbs.psi.RbsQualifiedName;
import com.intellij.lang.ruby.rbs.psi.RbsSimpleType;
import com.intellij.lang.ruby.rbs.psi.data.RbsQualifiedNameTypeSignature;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignatureResolver;
import com.intellij.lang.ruby.rbs.psi.data.RbsTypeSignatureVisitor;
import com.intellij.lang.ruby.rbs.psi.impl.RbsSimpleTypeImpl;
import com.intellij.lang.ruby.rbs.psi.navigators.RbsSimpleTypeNavigator;
import com.intellij.lang.ruby.rbs.psi.util.RbsPsiElementFactory;
import com.intellij.lang.ruby.rbs.util.Fqn;
import com.intellij.lang.ruby.rbs.util.RbsFqns;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ruby.rbs.frontback.RbsBundle;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class RbsLiteralClassReferencedInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RbsLiteralClassReferencedInspection.$$$reportNull$$$0(0);
        }
        return new MyVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/ruby/rbs/inspections/codeStyle/RbsLiteralClassReferencedInspection", "buildVisitor"));
    }

    private static final class MyVisitor
    extends RbsPsiVisitor {
        private final Project myProject;
        private final SearchScope mySearchScope;
        private final ProblemsHolder myHolder;

        private MyVisitor(@NotNull ProblemsHolder holder) {
            if (holder == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            this.myProject = holder.getProject();
            this.mySearchScope = holder.getFile().getResolveScope();
            this.myHolder = holder;
        }

        @Override
        public void visitQualifiedName(final @NotNull RbsQualifiedName element) {
            RbsSimpleTypeImpl type;
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            if ((type = RbsSimpleTypeNavigator.getByQualifiedName(element)) == null || PsiTreeUtil.hasErrorElements((PsiElement)type)) {
                return;
            }
            final String text = element.getStrippedText();
            type.getTypeSignature().apply(new RbsTypeSignatureResolver(this.myProject, this.mySearchScope)).accept(new RbsTypeSignatureVisitor(){

                @Override
                public void visitQualifiedNameTypeSignature(@NotNull RbsQualifiedNameTypeSignature signature) {
                    String replacement;
                    Fqn fqn;
                    if (signature == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((fqn = signature.getFqn()).isEquivalentTo(RbsFqns.FALSE_CLASS_FQN)) {
                        replacement = "false";
                    } else if (fqn.isEquivalentTo(RbsFqns.NIL_CLASS_FQN)) {
                        replacement = "nil";
                    } else if (fqn.isEquivalentTo(RbsFqns.TRUE_CLASS_FQN)) {
                        replacement = "true";
                    } else {
                        return;
                    }
                    myHolder.registerProblem((PsiElement)element, RbsBundle.message((String)"rbs.inspection.literal.class.referenced.description", (Object[])new Object[]{text, replacement}), new LocalQuickFix[]{new MyQuickFix(replacement)});
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "com/intellij/lang/ruby/rbs/inspections/codeStyle/RbsLiteralClassReferencedInspection$MyVisitor$1", "visitQualifiedNameTypeSignature"));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/codeStyle/RbsLiteralClassReferencedInspection$MyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitQualifiedName";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyQuickFix
    implements LocalQuickFix,
    DumbAware {
        @NlsSafe
        private final String myReplacement;

        private MyQuickFix(@NlsSafe @NotNull String replacement) {
            if (replacement == null) {
                MyQuickFix.$$$reportNull$$$0(0);
            }
            this.myReplacement = replacement;
        }

        @NotNull
        public String getName() {
            String string = RbsBundle.message((String)"rbs.inspection.literal.class.referenced.replace.quickfix.name", (Object[])new Object[]{this.myReplacement});
            if (string == null) {
                MyQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = RbsBundle.message((String)"rbs.inspection.literal.class.referenced.replace.quickfix.family.name", (Object[])new Object[0]);
            if (string == null) {
                MyQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                MyQuickFix.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                MyQuickFix.$$$reportNull$$$0(4);
            }
            RbsQualifiedName element = (RbsQualifiedName)descriptor.getPsiElement();
            RbsSimpleType simpleType = Objects.requireNonNull(RbsSimpleTypeNavigator.getByQualifiedName(element));
            simpleType.replace(RbsPsiElementFactory.createType(project, this.myReplacement));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "replacement";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ruby/rbs/inspections/codeStyle/RbsLiteralClassReferencedInspection$MyQuickFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/inspections/codeStyle/RbsLiteralClassReferencedInspection$MyQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

