/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.formatter;

import com.intellij.lang.ImportOptimizer;
import com.intellij.lang.ruby.rbs.model.api.RbsQualifiedNameSymbol;
import com.intellij.lang.ruby.rbs.model.psi.RbsQualifiedNameSymbolReference;
import com.intellij.lang.ruby.rbs.model.psi.RbsResolveUtil;
import com.intellij.lang.ruby.rbs.psi.RbsPsiFile;
import com.intellij.lang.ruby.rbs.psi.RbsPsiVisitor;
import com.intellij.lang.ruby.rbs.psi.RbsUseAlias;
import com.intellij.lang.ruby.rbs.psi.RbsUseClauseElement;
import com.intellij.lang.ruby.rbs.psi.RbsUseClauseType;
import com.intellij.lang.ruby.rbs.psi.RbsUseCls;
import com.intellij.lang.ruby.rbs.psi.impl.RbsUseDirectiveImpl;
import com.intellij.lang.ruby.rbs.psi.index.RbsDeclarationByParentFqnIndex;
import com.intellij.lang.ruby.rbs.psi.navigators.RbsUseDirectiveNavigator;
import com.intellij.lang.ruby.rbs.psi.util.RbsPsiEditUtil;
import com.intellij.lang.ruby.rbs.util.Fqn;
import com.intellij.model.psi.PsiSymbolReferenceService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ruby.rbs.frontback.psi.tree.RbsElementTypesGenerated;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class RbsImportOptimizer
implements ImportOptimizer {
    @NotNull
    public Runnable processFile(@NotNull PsiFile file) {
        if (file == null) {
            RbsImportOptimizer.$$$reportNull$$$0(0);
        }
        if (!(file instanceof RbsPsiFile)) {
            Runnable runnable = () -> {};
            if (runnable == null) {
                RbsImportOptimizer.$$$reportNull$$$0(1);
            }
            return runnable;
        }
        RbsPsiFile rbsFile = (RbsPsiFile)file;
        List<RbsUseClauseElement> useClauses = rbsFile.getUseClauses();
        if (useClauses.isEmpty()) {
            Runnable runnable = () -> {};
            if (runnable == null) {
                RbsImportOptimizer.$$$reportNull$$$0(2);
            }
            return runnable;
        }
        Set<String> referencedNames = this.getReferencedNames(file);
        Runnable runnable = () -> this.run(file.getProject(), rbsFile, referencedNames);
        if (runnable == null) {
            RbsImportOptimizer.$$$reportNull$$$0(3);
        }
        return runnable;
    }

    public void run(@NotNull Project project, @NotNull RbsPsiFile file, @NotNull Set<String> referencedNames) {
        if (project == null) {
            RbsImportOptimizer.$$$reportNull$$$0(4);
        }
        if (file == null) {
            RbsImportOptimizer.$$$reportNull$$$0(5);
        }
        if (referencedNames == null) {
            RbsImportOptimizer.$$$reportNull$$$0(6);
        }
        MyVisitor visitor = new MyVisitor(project, referencedNames);
        file.getUseClauses().forEach(it -> it.accept(visitor));
    }

    public boolean supports(@NotNull PsiFile file) {
        if (file == null) {
            RbsImportOptimizer.$$$reportNull$$$0(7);
        }
        return file instanceof RbsPsiFile;
    }

    @NotNull
    private Set<String> getReferencedNames(@NotNull PsiFile file) {
        if (file == null) {
            RbsImportOptimizer.$$$reportNull$$$0(8);
        }
        final HashSet referencedNames = new HashSet();
        file.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitElement(element);
                Collection references = PsiSymbolReferenceService.getService().getReferences(element, RbsQualifiedNameSymbolReference.class);
                for (RbsQualifiedNameSymbolReference reference : references) {
                    String name = reference.getQualifiedName();
                    if (name.startsWith("::")) continue;
                    referencedNames.add((String)ObjectUtils.coalesce((Object)StringUtil.substringBefore((String)name, (String)"::"), (Object)name));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/ruby/rbs/formatter/RbsImportOptimizer$1", "visitElement"));
            }
        });
        Set<String> set = Collections.unmodifiableSet(referencedNames);
        if (set == null) {
            RbsImportOptimizer.$$$reportNull$$$0(9);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/formatter/RbsImportOptimizer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencedNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/formatter/RbsImportOptimizer";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "processFile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencedNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "supports";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getReferencedNames";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 9 -> new IllegalStateException(string);
        };
    }

    private static final class MyVisitor
    extends RbsPsiVisitor {
        private final Project myProject;
        private final Set<String> myReferencedNames;

        private MyVisitor(@NotNull Project project, @NotNull Set<String> referencedNames) {
            if (project == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            if (referencedNames == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myReferencedNames = Set.copyOf(referencedNames);
        }

        @Override
        public void visitUseCls(@NotNull RbsUseCls element) {
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(2);
            }
            HashSet<String> names = new HashSet<String>();
            RbsUseClauseType type = element.getClauseType();
            if (type instanceof RbsUseClauseType.Alias) {
                RbsUseClauseType.Alias alias = (RbsUseClauseType.Alias)type;
                if (alias.fqn().split().getName().equals(alias.name())) {
                    if (alias.fqn().split().getParent() == Fqn.INVALID) {
                        MyVisitor.deleteUseClause(element);
                        return;
                    }
                    RbsUseAlias last = element.getUseAlias();
                    PsiElement first = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)last);
                    if (first != null && PsiUtilCore.getElementType((PsiElement)first) == RbsElementTypesGenerated.RBS_KAS) {
                        element.deleteChildRange(first, last);
                    }
                }
                names.add(alias.name());
            } else if (type instanceof RbsUseClauseType.Import) {
                RbsUseClauseType.Import import_ = (RbsUseClauseType.Import)type;
                if (import_.fqn().split().getParent() == Fqn.INVALID) {
                    MyVisitor.deleteUseClause(element);
                    return;
                }
                names.add(import_.fqn().split().getName());
            } else if (type instanceof RbsUseClauseType.Wildcard) {
                RbsUseClauseType.Wildcard wildcard = (RbsUseClauseType.Wildcard)type;
                Collection<? extends RbsQualifiedNameSymbol> targets = RbsResolveUtil.resolveUseClauseWildcard(this.myProject, (SearchScope)element.getResolveScope(), wildcard);
                if (targets.isEmpty()) {
                    MyVisitor.deleteUseClause(element);
                    return;
                }
                for (RbsQualifiedNameSymbol rbsQualifiedNameSymbol : targets) {
                    names.add(rbsQualifiedNameSymbol.getFullName());
                }
            }
            if (ContainerUtil.intersects(names, this.getUnresolvedReferencedNames(element))) {
                return;
            }
            MyVisitor.deleteUseClause(element);
        }

        @NotNull
        private Set<String> getUnresolvedReferencedNames(@NotNull RbsUseCls anchor) {
            RbsUseClauseElement useClause;
            RbsPsiFile file;
            if (anchor == null) {
                MyVisitor.$$$reportNull$$$0(3);
            }
            if ((file = (RbsPsiFile)((Object)ObjectUtils.tryCast((Object)anchor.getContainingFile(), RbsPsiFile.class))) == null) {
                Set<String> set = Collections.emptySet();
                if (set == null) {
                    MyVisitor.$$$reportNull$$$0(4);
                }
                return set;
            }
            HashSet<String> unresolvedNames = new HashSet<String>(this.myReferencedNames);
            Iterator iterator = ContainerUtil.reverse(file.getUseClauses()).iterator();
            while (iterator.hasNext() && !(useClause = (RbsUseClauseElement)iterator.next()).equals(anchor)) {
                RbsUseClauseType clauseType = useClause.getClauseType();
                if (clauseType instanceof RbsUseClauseType.Alias) {
                    RbsUseClauseType.Alias alias = (RbsUseClauseType.Alias)clauseType;
                    unresolvedNames.remove(alias.name());
                    continue;
                }
                if (clauseType instanceof RbsUseClauseType.Import) {
                    RbsUseClauseType.Import import_ = (RbsUseClauseType.Import)clauseType;
                    unresolvedNames.remove(import_.fqn().split().getName());
                    continue;
                }
                if (!(clauseType instanceof RbsUseClauseType.Wildcard)) continue;
                RbsUseClauseType.Wildcard wildcard = (RbsUseClauseType.Wildcard)clauseType;
                Fqn namespace = wildcard.namespace();
                RbsDeclarationByParentFqnIndex.processAllValues(this.myProject, (SearchScope)useClause.getResolveScope(), namespace, (type, name) -> {
                    switch (type) {
                        case CLASS: 
                        case INTERFACE: 
                        case MODULE: 
                        case TYPE_ALIAS: {
                            unresolvedNames.remove(name);
                        }
                    }
                });
            }
            Set<String> set = Collections.unmodifiableSet(unresolvedNames);
            if (set == null) {
                MyVisitor.$$$reportNull$$$0(5);
            }
            return set;
        }

        private static void deleteUseClause(@NotNull RbsUseCls useClause) {
            RbsUseDirectiveImpl useDirective;
            if (useClause == null) {
                MyVisitor.$$$reportNull$$$0(6);
            }
            if ((useDirective = RbsUseDirectiveNavigator.getByUseClause(useClause)) == null) {
                return;
            }
            if (useDirective.getUseClsList().size() == 1) {
                useDirective.delete();
            } else {
                RbsPsiEditUtil.deleteListElement((PsiElement)useClause);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "referencedNames";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ruby/rbs/formatter/RbsImportOptimizer$MyVisitor";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "useClause";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/formatter/RbsImportOptimizer$MyVisitor";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedReferencedNames";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "visitUseCls";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getUnresolvedReferencedNames";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteUseClause";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

