/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.completion;

import com.intellij.codeInsight.completion.AddSpaceInsertHandler;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.lang.ruby.rbs.completion.RbsCompletionScope;
import com.intellij.lang.ruby.rbs.completion.RbsQualifiedNameLookupElement;
import com.intellij.lang.ruby.rbs.model.api.RbsTypeVariableSymbol;
import com.intellij.ruby.rbs.frontback.util.RbsKeywords;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class RbsWeighedLookupElement
extends LookupElementDecorator<LookupElement> {
    private static final Set<String> KEYWORDS_WITH_SPACE_AFTER = Set.copyOf(ContainerUtil.concat((List[])new List[]{RbsKeywords.DECLARATIONS, RbsKeywords.INTERFACE_MEMBERS, RbsKeywords.CLASS_OR_MODULE_ONLY_MEMBERS, RbsKeywords.VARIANCE, List.of("as", "unchecked", "use")}));
    private static final Set<String> KEYWORDS_LOW_PRIORITY = Set.of("__todo__");
    @NotNull
    private final RbsCompletionScope myScope;
    private final int myNumberOfComponents;
    private final boolean myIsTypeAlias;

    RbsWeighedLookupElement(@NotNull LookupElement delegate, @NotNull RbsCompletionScope scope, int numberOfComponents, boolean isTypeAlias) {
        if (delegate == null) {
            RbsWeighedLookupElement.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            RbsWeighedLookupElement.$$$reportNull$$$0(1);
        }
        super(delegate);
        this.myScope = scope;
        this.myNumberOfComponents = numberOfComponents;
        this.myIsTypeAlias = isTypeAlias;
    }

    @NotNull
    RbsCompletionScope getScope() {
        RbsCompletionScope rbsCompletionScope = this.myScope;
        if (rbsCompletionScope == null) {
            RbsWeighedLookupElement.$$$reportNull$$$0(2);
        }
        return rbsCompletionScope;
    }

    int getNumberOfComponents() {
        return this.myNumberOfComponents;
    }

    boolean isTypeAlias() {
        return this.myIsTypeAlias;
    }

    @NotNull
    static RbsWeighedLookupElement fromKeyword(@NotNull String keyword) {
        if (keyword == null) {
            RbsWeighedLookupElement.$$$reportNull$$$0(3);
        }
        LookupElementBuilder element = LookupElementBuilder.create((String)keyword).bold();
        if (KEYWORDS_WITH_SPACE_AFTER.contains(keyword)) {
            element = element.withInsertHandler(AddSpaceInsertHandler.INSTANCE);
        }
        if (keyword.equals("singleton")) {
            element = element.withInsertHandler((context, item) -> {
                ParenthesesInsertHandler.WITH_PARAMETERS.handleInsert(context, item);
                context.commitDocument();
                RbsQualifiedNameLookupElement.AUTO_POPUP.handleInsert(context, item);
            });
        }
        if (KEYWORDS_LOW_PRIORITY.contains(keyword)) {
            return new RbsWeighedLookupElement((LookupElement)element, RbsCompletionScope.KEYWORD_LOW_PRIORITY, 1, false);
        }
        return new RbsWeighedLookupElement((LookupElement)element, RbsCompletionScope.KEYWORD, 1, false);
    }

    @NotNull
    static RbsWeighedLookupElement fromOperator(@NotNull String operator) {
        if (operator == null) {
            RbsWeighedLookupElement.$$$reportNull$$$0(4);
        }
        LookupElementBuilder element = LookupElementBuilder.create((String)operator).bold();
        return new RbsWeighedLookupElement((LookupElement)element, RbsCompletionScope.OPERATOR, 1, false);
    }

    @NotNull
    static RbsWeighedLookupElement fromTypeVariable(@NotNull RbsTypeVariableSymbol symbol) {
        if (symbol == null) {
            RbsWeighedLookupElement.$$$reportNull$$$0(5);
        }
        LookupElementBuilder delegate = LookupElementBuilder.create((String)symbol.getName()).bold().withIcon(symbol.getPresentation().icon());
        return new RbsWeighedLookupElement((LookupElement)delegate, RbsCompletionScope.TYPE_VARIABLE, 1, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/completion/RbsWeighedLookupElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/completion/RbsWeighedLookupElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fromKeyword";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fromOperator";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fromTypeVariable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

