/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.completion;

import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.lang.ruby.rbs.completion.RbsCompletionUtil;
import com.intellij.lang.ruby.rbs.psi.RbsUseClauseType;
import com.intellij.lang.ruby.rbs.util.Fqn;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class RbsQualifiedNamePrefixMatcher
extends PrefixMatcher {
    @NotNull
    private final List<RbsUseClauseType> myUseClauses;
    @NotNull
    private final Fqn myContainerFqn;
    @NotNull
    private final String myQualifier;
    @NotNull
    private final PrefixMatcher myPlainPrefixMatcher;
    @NotNull
    private final PrefixMatcher myQualifierMatcher;
    @NotNull
    private final PrefixMatcher myLastComponentMatcher;
    @NotNull
    private final PrefixMatcher myPrefixAsNamespaceMatcher;

    RbsQualifiedNamePrefixMatcher(@NotNull List<RbsUseClauseType> useClauses, @NotNull Fqn containerFqn, @NotNull String prefix) {
        if (useClauses == null) {
            RbsQualifiedNamePrefixMatcher.$$$reportNull$$$0(0);
        }
        if (containerFqn == null) {
            RbsQualifiedNamePrefixMatcher.$$$reportNull$$$0(1);
        }
        if (prefix == null) {
            RbsQualifiedNamePrefixMatcher.$$$reportNull$$$0(2);
        }
        super(prefix);
        Pair<String, String> qualifierAndName = RbsQualifiedNamePrefixMatcher.getQualifierAndName(prefix);
        this.myUseClauses = List.copyOf(useClauses);
        this.myContainerFqn = containerFqn;
        this.myQualifier = (String)qualifierAndName.first;
        this.myPlainPrefixMatcher = new PlainPrefixMatcher(prefix, true);
        this.myQualifierMatcher = new PlainPrefixMatcher(this.myQualifier, true);
        this.myLastComponentMatcher = new CamelHumpMatcher((String)qualifierAndName.second);
        this.myPrefixAsNamespaceMatcher = ((String)qualifierAndName.second).isEmpty() ? AlwaysFalseMatcher.INSTANCE : new PlainPrefixMatcher(prefix + "::");
    }

    public boolean prefixMatches(@NotNull String name) {
        if (name == null) {
            RbsQualifiedNamePrefixMatcher.$$$reportNull$$$0(3);
        }
        if (this.myPrefix.contains("_") && !name.contains("_")) {
            return false;
        }
        if (this.myPrefix.startsWith("::")) {
            return this.myPlainPrefixMatcher.prefixMatches(name);
        }
        if (this.qualifierMatches(name) && this.myLastComponentMatcher.prefixMatches((String)ObjectUtils.chooseNotNull((Object)StringUtil.substringAfterLast((String)name, (String)"::"), (Object)name))) {
            return true;
        }
        return this.myPrefixAsNamespaceMatcher.prefixMatches(name);
    }

    @NotNull
    public PrefixMatcher cloneWithPrefix(@NotNull String prefix) {
        if (prefix == null) {
            RbsQualifiedNamePrefixMatcher.$$$reportNull$$$0(4);
        }
        return new RbsQualifiedNamePrefixMatcher(this.myUseClauses, this.myContainerFqn, prefix);
    }

    private boolean qualifierMatches(@NotNull String name) {
        if (name == null) {
            RbsQualifiedNamePrefixMatcher.$$$reportNull$$$0(5);
        }
        for (String candidate : RbsCompletionUtil.getCandidateRelativeQualifiedNames(this.myUseClauses, this.myContainerFqn, Fqn.of(name, new String[0]))) {
            String qualifier = (String)RbsQualifiedNamePrefixMatcher.getQualifierAndName((String)candidate).first;
            if (qualifier.isBlank() || !this.myQualifierMatcher.prefixMatches(qualifier)) continue;
            return true;
        }
        return this.myQualifier.isEmpty();
    }

    @NotNull
    private static Pair<String, String> getQualifierAndName(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            RbsQualifiedNamePrefixMatcher.$$$reportNull$$$0(6);
        }
        Pair pair = qualifiedName.contains("::") ? Pair.pair((Object)(StringUtil.substringBeforeLast((String)qualifiedName, (String)"::") + "::"), (Object)StringUtil.substringAfterLast((String)qualifiedName, (String)"::")) : Pair.pair((Object)"", (Object)qualifiedName);
        if (pair == null) {
            RbsQualifiedNamePrefixMatcher.$$$reportNull$$$0(7);
        }
        return pair;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "useClauses";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerFqn";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/completion/RbsQualifiedNamePrefixMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/completion/RbsQualifiedNamePrefixMatcher";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierAndName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "prefixMatches";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "cloneWithPrefix";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "qualifierMatches";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierAndName";
                break;
            }
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }

    private static final class AlwaysFalseMatcher
    extends PrefixMatcher {
        private static final AlwaysFalseMatcher INSTANCE = new AlwaysFalseMatcher();

        private AlwaysFalseMatcher() {
            super(null);
        }

        public boolean prefixMatches(@NotNull String name) {
            if (name == null) {
                AlwaysFalseMatcher.$$$reportNull$$$0(0);
            }
            return false;
        }

        @NotNull
        public PrefixMatcher cloneWithPrefix(@NotNull String prefix) {
            if (prefix == null) {
                AlwaysFalseMatcher.$$$reportNull$$$0(1);
            }
            AlwaysFalseMatcher alwaysFalseMatcher = INSTANCE;
            if (alwaysFalseMatcher == null) {
                AlwaysFalseMatcher.$$$reportNull$$$0(2);
            }
            return alwaysFalseMatcher;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ruby/rbs/completion/RbsQualifiedNamePrefixMatcher$AlwaysFalseMatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/completion/RbsQualifiedNamePrefixMatcher$AlwaysFalseMatcher";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "cloneWithPrefix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "prefixMatches";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "cloneWithPrefix";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

