/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ruby.rbs.completion.RbsCompletionScope;
import com.intellij.lang.ruby.rbs.completion.RbsQualifiedNameInsertHandler;
import com.intellij.lang.ruby.rbs.completion.RbsWeighedLookupElement;
import com.intellij.lang.ruby.rbs.model.api.RbsQualifiedNameSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsTypeAliasSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsUseClauseAliasSymbol;
import com.intellij.lang.ruby.rbs.util.Fqn;
import com.intellij.model.Symbol;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

final class RbsQualifiedNameLookupElement {
    static final InsertHandler<LookupElement> AUTO_POPUP = (context, item) -> AutoPopupController.getInstance((Project)context.getProject()).scheduleAutoPopup(context.getEditor());

    private RbsQualifiedNameLookupElement() {
    }

    @NotNull
    static LookupElement create(@NotNull RbsQualifiedNameSymbol symbol, @NotNull RbsCompletionScope scope, int numberOfComponents) {
        if (symbol == null) {
            RbsQualifiedNameLookupElement.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            RbsQualifiedNameLookupElement.$$$reportNull$$$0(1);
        }
        Fqn fqn = symbol.getFqn();
        Fqn parentFqn = fqn.split().getParent();
        boolean isTopLevelCoreTypeAlias = symbol instanceof RbsTypeAliasSymbol && scope == RbsCompletionScope.CORE && parentFqn == Fqn.INVALID;
        LookupElement delegate = LookupElementBuilder.create((Object)fqn.normalize(), (String)fqn.absolute().join()).withPresentableText(symbol.getName()).withTypeText(StringUtil.defaultIfEmpty((String)parentFqn.join(), (String)"::"), true).withIcon(symbol.getPresentation().icon()).withBoldness(scope == RbsCompletionScope.LOCAL || isTopLevelCoreTypeAlias).withInsertHandler(RbsQualifiedNameInsertHandler.INSTANCE).withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE);
        return new RbsWeighedLookupElement(delegate, isTopLevelCoreTypeAlias ? RbsCompletionScope.TOP_LEVEL_CORE_TYPE_ALIAS : scope, numberOfComponents, symbol instanceof RbsTypeAliasSymbol);
    }

    @NotNull
    static LookupElement create(@NotNull RbsUseClauseAliasSymbol symbol, @NotNull Collection<? extends Symbol> targets) {
        if (symbol == null) {
            RbsQualifiedNameLookupElement.$$$reportNull$$$0(2);
        }
        if (targets == null) {
            RbsQualifiedNameLookupElement.$$$reportNull$$$0(3);
        }
        LookupElement delegate = LookupElementBuilder.create((String)symbol.getName()).bold().withTypeText("::", true).withIcon(symbol.getPresentation().icon()).withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE);
        return new RbsWeighedLookupElement(delegate, RbsCompletionScope.LOCAL, 1, ContainerUtil.or(targets, it -> it instanceof RbsTypeAliasSymbol));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "symbol";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "scope";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "targets";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/ruby/rbs/completion/RbsQualifiedNameLookupElement";
        objectArray[2] = "create";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

