/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ruby.rbs.completion.RbsCompletionUtil;
import com.intellij.lang.ruby.rbs.completion.RbsQualifiedNameCompletionTarget;
import com.intellij.lang.ruby.rbs.model.api.RbsQualifiedNameSymbol;
import com.intellij.lang.ruby.rbs.model.psi.RbsQualifiedNameSymbolReference;
import com.intellij.lang.ruby.rbs.model.psi.RbsResolveUtil;
import com.intellij.lang.ruby.rbs.psi.util.RbsPsiUtil;
import com.intellij.lang.ruby.rbs.util.Fqn;
import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiSymbolReferenceService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class RbsQualifiedNameInsertHandler
implements InsertHandler<LookupElement> {
    static final InsertHandler<LookupElement> INSTANCE = new RbsQualifiedNameInsertHandler();

    private RbsQualifiedNameInsertHandler() {
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        PsiElement element;
        RbsQualifiedNameSymbolReference reference;
        if (context == null) {
            RbsQualifiedNameInsertHandler.$$$reportNull$$$0(0);
        }
        if (item == null) {
            RbsQualifiedNameInsertHandler.$$$reportNull$$$0(1);
        }
        if ((reference = RbsQualifiedNameInsertHandler.findReference(element = PsiUtilCore.getElementAtOffset((PsiFile)context.getFile(), (int)Math.max(0, context.getTailOffset() - 1)))) == null) {
            return;
        }
        Project project = context.getProject();
        GlobalSearchScope searchScope = element.getResolveScope();
        Fqn containerFqn = reference.getContainerFqn();
        Fqn fqn = Fqn.of(StringUtil.trimStart((String)item.getLookupString(), (String)"::"), new String[0]);
        EnumSet<RbsQualifiedNameCompletionTarget> targets = reference.getCompletionTargets();
        for (String candidate : RbsCompletionUtil.getCandidateRelativeQualifiedNames(RbsPsiUtil.getUseClauseTypes(element), containerFqn, fqn)) {
            if (candidate.equals(item.getLookupString())) break;
            Collection<? extends Symbol> result = RbsResolveUtil.resolveQualifiedName(project, (SearchScope)searchScope, containerFqn, candidate, targets, element);
            if (result.isEmpty() || !ContainerUtil.and(result, it -> {
                RbsQualifiedNameSymbol qualifiedNameSymbol;
                return it instanceof RbsQualifiedNameSymbol && (qualifiedNameSymbol = (RbsQualifiedNameSymbol)it).getFqn().isEquivalentTo(fqn);
            })) continue;
            context.getDocument().replaceString(context.getStartOffset(), context.getTailOffset(), (CharSequence)candidate);
            context.commitDocument();
            break;
        }
    }

    @Nullable
    private static RbsQualifiedNameSymbolReference findReference(@NotNull PsiElement element) {
        if (element == null) {
            RbsQualifiedNameInsertHandler.$$$reportNull$$$0(2);
        }
        for (PsiElement parent = element.getParent(); parent != null; parent = parent.getParent()) {
            Collection references = PsiSymbolReferenceService.getService().getReferences(parent, RbsQualifiedNameSymbolReference.class);
            if (references.isEmpty()) continue;
            return (RbsQualifiedNameSymbolReference)ContainerUtil.iterateAndGetLastItem((Iterable)references);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/ruby/rbs/completion/RbsQualifiedNameInsertHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleInsert";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findReference";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

