/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ruby.rbs.model.api.RbsContainerSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsClassSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsMethodSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsModuleSymbol;
import com.intellij.lang.ruby.rbs.psi.RbsDeclarationType;
import com.intellij.lang.ruby.rbs.psi.impl.RbsAliasMemberImpl;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ruby.rbs.frontback.RbsLanguage;
import com.intellij.util.ProcessingContext;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyTrackedCompletionProvider;
import org.jetbrains.plugins.ruby.util.StreamUtil;

final class RbsMethodAliasCompletionProvider
extends RubyTrackedCompletionProvider {
    static final RbsMethodAliasCompletionProvider INSTANCE = new RbsMethodAliasCompletionProvider();

    private RbsMethodAliasCompletionProvider() {
        super(RbsLanguage.getInstance());
    }

    protected void addCompletionsTracked(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            RbsMethodAliasCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            RbsMethodAliasCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            RbsMethodAliasCompletionProvider.$$$reportNull$$$0(2);
        }
        PsiElement location = parameters.getPosition();
        Project project = location.getProject();
        RbsAliasMemberImpl aliasMember = Objects.requireNonNull((RbsAliasMemberImpl)PsiTreeUtil.getParentOfType((PsiElement)location, RbsAliasMemberImpl.class));
        GlobalSearchScope searchScope = aliasMember.getResolveScope();
        RbsContainerSymbol containerSymbol = RbsMethodAliasCompletionProvider.getContextSymbol(aliasMember);
        if (containerSymbol == null) {
            return;
        }
        List<? extends RbsContainerSymbol> allAncestors = containerSymbol.allAncestors(project, (SearchScope)searchScope).toList();
        RbsMethodAliasCompletionProvider.getIncludedMethods(project, (SearchScope)searchScope, containerSymbol).forEach(method -> {
            ProgressManager.checkCanceled();
            if (method.getName().equals(aliasMember.getAliasMethodName())) {
                return;
            }
            LookupElementBuilder element = LookupElementBuilder.create((String)method.getName()).withBoldness(method.getContainerSymbol().equals(containerSymbol)).withIcon(method.getPresentation().icon()).withTypeText(method.getContainerFqn().join());
            int proximity = allAncestors.size() - allAncestors.indexOf(method.getContainerSymbol());
            result.addElement(PrioritizedLookupElement.withExplicitProximity((LookupElement)element, (int)proximity));
        });
    }

    @Nullable
    private static RbsContainerSymbol getContextSymbol(@NotNull RbsAliasMemberImpl aliasMember) {
        if (aliasMember == null) {
            RbsMethodAliasCompletionProvider.$$$reportNull$$$0(3);
        }
        RbsContainerSymbol containerSymbol = aliasMember.getContainerSymbol();
        if (aliasMember.getDeclarationType() == RbsDeclarationType.SINGLETON_DECLARATION) {
            if (containerSymbol instanceof RbsClassSymbol) {
                return ((RbsClassSymbol)containerSymbol).getSingletonSymbol();
            }
            if (containerSymbol instanceof RbsModuleSymbol) {
                return ((RbsModuleSymbol)containerSymbol).getSingletonSymbol();
            }
            return null;
        }
        return containerSymbol;
    }

    @NotNull
    private static Stream<RbsMethodSymbol> getIncludedMethods(@NotNull Project project, @NotNull SearchScope searchScope, @NotNull RbsContainerSymbol symbol) {
        if (project == null) {
            RbsMethodAliasCompletionProvider.$$$reportNull$$$0(4);
        }
        if (searchScope == null) {
            RbsMethodAliasCompletionProvider.$$$reportNull$$$0(5);
        }
        if (symbol == null) {
            RbsMethodAliasCompletionProvider.$$$reportNull$$$0(6);
        }
        Stream<RbsMethodSymbol> stream = symbol.allAncestors(project, searchScope).dropWhile(it -> !it.equals(symbol)).flatMap(ancestor -> ancestor.children(project, searchScope)).mapMulti(StreamUtil.select(RbsMethodSymbol.class, (Class[])new Class[0])).distinct();
        if (stream == null) {
            RbsMethodAliasCompletionProvider.$$$reportNull$$$0(7);
        }
        return stream;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aliasMember";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/completion/RbsMethodAliasCompletionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/completion/RbsMethodAliasCompletionProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludedMethods";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addCompletionsTracked";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getContextSymbol";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getIncludedMethods";
                break;
            }
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

