/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.completion;

import com.intellij.lang.ruby.rbs.psi.RbsUseClauseType;
import com.intellij.lang.ruby.rbs.util.Fqn;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

public final class RbsCompletionUtil {
    private RbsCompletionUtil() {
    }

    @NotNull
    public static Set<String> getCandidateRelativeQualifiedNames(@NotNull List<RbsUseClauseType> useClauses, @NotNull Fqn containerFqn, @NotNull Fqn fqn) {
        if (useClauses == null) {
            RbsCompletionUtil.$$$reportNull$$$0(0);
        }
        if (containerFqn == null) {
            RbsCompletionUtil.$$$reportNull$$$0(1);
        }
        if (fqn == null) {
            RbsCompletionUtil.$$$reportNull$$$0(2);
        }
        TreeSet<String> candidates = new TreeSet<String>(Comparator.comparingInt(String::length).thenComparing(Comparator.naturalOrder()));
        String joined = fqn.join(true);
        candidates.addAll(Set.of("::" + joined, joined));
        for (RbsUseClauseType useClause : useClauses) {
            RbsUseClauseType.Wildcard wildcard;
            Object target;
            if (useClause instanceof RbsUseClauseType.Alias) {
                RbsUseClauseType.Alias alias = (RbsUseClauseType.Alias)useClause;
                target = alias.fqn().join() + "::";
                if (!joined.startsWith((String)target)) continue;
                candidates.add(alias.name() + "::" + joined.substring(((String)target).length()));
                continue;
            }
            if (useClause instanceof RbsUseClauseType.Import) {
                RbsUseClauseType.Import import_ = (RbsUseClauseType.Import)useClause;
                target = import_.fqn().join();
                if (joined.equals(target)) {
                    candidates.add(import_.fqn().split().getName());
                    continue;
                }
                if (!joined.startsWith((String)target + "::")) continue;
                candidates.add(import_.fqn().split().getName() + joined.substring(((String)target).length()));
                continue;
            }
            if (!(useClause instanceof RbsUseClauseType.Wildcard) || !joined.startsWith((String)(target = (wildcard = (RbsUseClauseType.Wildcard)useClause).namespace().join() + "::"))) continue;
            candidates.add(joined.substring(((String)target).length()));
        }
        for (Fqn nesting = containerFqn; nesting != Fqn.INVALID; nesting = nesting.getParent()) {
            candidates.add(fqn.split().relativize(nesting).join(true));
        }
        Set<String> set = Collections.unmodifiableSet(candidates);
        if (set == null) {
            RbsCompletionUtil.$$$reportNull$$$0(3);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "useClauses";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerFqn";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/completion/RbsCompletionUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/completion/RbsCompletionUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCandidateRelativeQualifiedNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCandidateRelativeQualifiedNames";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

