/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.completion;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.lang.ruby.rbs.completion.RbsCompletionScope;
import com.intellij.lang.ruby.rbs.completion.RbsQualifiedNameCompletionTarget;
import com.intellij.lang.ruby.rbs.completion.RbsQualifiedNameLookupElement;
import com.intellij.lang.ruby.rbs.completion.RbsQualifiedNamePrefixMatcher;
import com.intellij.lang.ruby.rbs.completion.RbsWeighedLookupElement;
import com.intellij.lang.ruby.rbs.model.api.RbsQualifiedNameSymbol;
import com.intellij.lang.ruby.rbs.model.api.RbsTypeVariableSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsClassSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsInterfaceSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsModuleSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsTypeAliasSymbol;
import com.intellij.lang.ruby.rbs.model.impl.RbsUseClauseAliasSymbol;
import com.intellij.lang.ruby.rbs.model.psi.RbsPsiSymbolDeclaration;
import com.intellij.lang.ruby.rbs.model.psi.RbsQualifiedNameSymbolReference;
import com.intellij.lang.ruby.rbs.model.usages.RbsUsageTypes;
import com.intellij.lang.ruby.rbs.psi.RbsClassAliasDeclarationElement;
import com.intellij.lang.ruby.rbs.psi.RbsContainerDeclarationElement;
import com.intellij.lang.ruby.rbs.psi.RbsExtendMember;
import com.intellij.lang.ruby.rbs.psi.RbsMethodTypeElement;
import com.intellij.lang.ruby.rbs.psi.RbsModuleAliasDeclarationElement;
import com.intellij.lang.ruby.rbs.psi.RbsModuleDeclarationElement;
import com.intellij.lang.ruby.rbs.psi.RbsPsiFile;
import com.intellij.lang.ruby.rbs.psi.RbsQualifiedNameDeclaration;
import com.intellij.lang.ruby.rbs.psi.RbsSuperClassElement;
import com.intellij.lang.ruby.rbs.psi.RbsTypeDeclarationElement;
import com.intellij.lang.ruby.rbs.psi.RbsUseClauseType;
import com.intellij.lang.ruby.rbs.psi.impl.RbsTypeDeclImpl;
import com.intellij.lang.ruby.rbs.psi.navigators.RbsClassDeclarationNavigator;
import com.intellij.lang.ruby.rbs.psi.util.RbsPsiUtil;
import com.intellij.lang.ruby.rbs.ruby.project.RbsRubysigsLibraryUtil;
import com.intellij.lang.ruby.rbs.util.Fqn;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopeUtil;
import com.intellij.psi.search.GlobalSearchScopes;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.usages.impl.rules.UsageType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class RbsCompletableQualifiedNameWrapper {
    @NotNull
    private static final Logger LOG = Logger.getInstance(RbsCompletableQualifiedNameWrapper.class);
    private final Project myProject;
    private final SearchScope mySearchScope;
    @NotNull
    private final PsiElement myElement;
    @NotNull
    private final Fqn myContainerFqn;
    @NotNull
    private final String myCompletionPrefix;
    @Nullable
    private final UsageType myUsageType;
    @NotNull
    private final EnumSet<RbsQualifiedNameCompletionTarget> myCompletionTargets;

    RbsCompletableQualifiedNameWrapper(@NotNull RbsQualifiedNameSymbolReference reference) {
        if (reference == null) {
            RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(0);
        }
        this.myProject = reference.getElement().getProject();
        this.mySearchScope = reference.getElement().getResolveScope();
        this.myElement = reference.getElement();
        this.myContainerFqn = reference.getContainerFqn();
        this.myCompletionPrefix = StringUtil.substringBeforeLast((String)reference.getQualifiedName(), (String)"IntellijIdeaRulezzz");
        this.myCompletionTargets = reference.getCompletionTargets();
        this.myUsageType = reference.getUsage().getUsageType();
    }

    void addCompletionVariants(@NotNull CompletionResultSet result) {
        if (result == null) {
            RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(1);
        }
        List<RbsUseClauseType> useClauses = RbsPsiUtil.getUseClauseTypes(this.myElement);
        this.addCompletionVariantsImpl(result.withPrefixMatcher((PrefixMatcher)new RbsQualifiedNamePrefixMatcher(useClauses, this.myContainerFqn, this.myCompletionPrefix)));
    }

    @RequiresReadLock
    private void addCompletionVariantsImpl(@NotNull CompletionResultSet result) {
        if (result == null) {
            RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(2);
        }
        ThreadingAssertions.softAssertReadAccess();
        if (this.myCompletionTargets.isEmpty()) {
            return;
        }
        GlobalSearchScope librariesScope = ProjectScope.getLibrariesScope((Project)this.myProject);
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)this.myElement);
        if (virtualFile != null && librariesScope.accept(virtualFile)) {
            this.processQualifiedNameSymbols(this.mySearchScope, RbsCompletionScope.CORE, result);
        } else {
            SearchScope coreLibraryScope = this.getCoreLibraryScope();
            if (SearchScope.isEmptyScope((SearchScope)coreLibraryScope) && !ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.warn("Can't find 'rbs/core' directory");
            }
            this.processQualifiedNameSymbols(this.mySearchScope.intersectWith(coreLibraryScope), RbsCompletionScope.CORE, result);
            if (!this.myCompletionPrefix.isEmpty()) {
                this.processQualifiedNameSymbols(this.mySearchScope.intersectWith((SearchScope)GlobalSearchScope.notScope((GlobalSearchScope)librariesScope)), RbsCompletionScope.LOCAL, result);
                this.processQualifiedNameSymbols(this.mySearchScope.intersectWith((SearchScope)librariesScope).intersectWith((SearchScope)GlobalSearchScope.notScope((GlobalSearchScope)GlobalSearchScopeUtil.toGlobalSearchScope((SearchScope)coreLibraryScope, (Project)this.myProject))), RbsCompletionScope.OTHER, result);
            } else {
                result.restartCompletionWhenNothingMatches();
                this.processQualifiedNameSymbols(this.mySearchScope.intersectWith((SearchScope)GlobalSearchScope.fileScope((Project)this.myProject, (VirtualFile)virtualFile)), RbsCompletionScope.LOCAL, result);
            }
        }
        this.addTypeVariableLookupElements(result);
        this.addUseClauseAliasLookupElements(result);
    }

    private void processQualifiedNameSymbols(@NotNull SearchScope scope, @NotNull RbsCompletionScope scopeRank, @NotNull CompletionResultSet result) {
        if (scope == null) {
            RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(3);
        }
        if (scopeRank == null) {
            RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(4);
        }
        if (result == null) {
            RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(5);
        }
        if (this.myCompletionTargets.contains((Object)RbsQualifiedNameCompletionTarget.CLASS)) {
            RbsClassSymbol.stream(this.myProject, scope).forEach(symbol -> this.processCompletionCandidate((RbsQualifiedNameSymbol)symbol, scopeRank, result));
        }
        if (this.myCompletionTargets.contains((Object)RbsQualifiedNameCompletionTarget.MODULE)) {
            RbsModuleSymbol.stream(this.myProject, scope).forEach(symbol -> this.processCompletionCandidate((RbsQualifiedNameSymbol)symbol, scopeRank, result));
        }
        if (this.myCompletionTargets.contains((Object)RbsQualifiedNameCompletionTarget.INTERFACE)) {
            RbsInterfaceSymbol.stream(this.myProject, scope).forEach(symbol -> this.processCompletionCandidate((RbsQualifiedNameSymbol)symbol, scopeRank, result));
        }
        if (this.myCompletionTargets.contains((Object)RbsQualifiedNameCompletionTarget.TYPE_ALIAS)) {
            RbsTypeAliasSymbol.stream(this.myProject, scope).forEach(symbol -> this.processCompletionCandidate((RbsQualifiedNameSymbol)symbol, scopeRank, result));
        }
    }

    private void processCompletionCandidate(@NotNull RbsQualifiedNameSymbol symbol, @NotNull RbsCompletionScope scopeRank, @NotNull CompletionResultSet result) {
        if (symbol == null) {
            RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(6);
        }
        if (scopeRank == null) {
            RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(7);
        }
        if (result == null) {
            RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(8);
        }
        ProgressManager.checkCanceled();
        Fqn fqn = symbol.getFqn();
        int numberOfComponents = fqn.join(true).split("::").length;
        if (this.myCompletionPrefix.isEmpty() && numberOfComponents > 1 && scopeRank != RbsCompletionScope.LOCAL) {
            return;
        }
        if (!this.isRecursiveSuggestion(fqn) && !this.isIrrelevantForCurrentPrefix(numberOfComponents)) {
            result.addElement(RbsQualifiedNameLookupElement.create(symbol, scopeRank, numberOfComponents));
        }
    }

    private boolean isRecursiveSuggestion(@NotNull Fqn fqn) {
        if (fqn == null) {
            RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(9);
        }
        if (this.myUsageType == RbsUsageTypes.USAGE_TYPE_SUPERCLASS_CLAUSE) {
            return fqn.isEquivalentTo(this.getParentClassDeclarationFqn());
        }
        if (this.myUsageType == RbsUsageTypes.USAGE_TYPE_SELF_TYPE_CLAUSE) {
            return fqn.isEquivalentTo(this.myContainerFqn);
        }
        if (this.myUsageType == RbsUsageTypes.USAGE_TYPE_TYPE_SIGNATURE) {
            return fqn.isEquivalentTo(this.getParentTypeDeclarationFqn());
        }
        if (this.myUsageType == RbsUsageTypes.USAGE_TYPE_EXTEND_INCLUDE_PREPEND_CALL) {
            return !this.isExtendInsideModule() && fqn.isEquivalentTo(this.myContainerFqn);
        }
        if (this.myUsageType == RbsUsageTypes.USAGE_TYPE_ALIAS) {
            return fqn.isEquivalentTo(this.getAliasFqn());
        }
        return false;
    }

    @NotNull
    private Fqn getParentTypeDeclarationFqn() {
        Fqn fqn = (Fqn)ObjectUtils.chooseNotNull((Object)((Fqn)ObjectUtils.doIfNotNull((Object)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, RbsTypeDeclImpl.class), RbsQualifiedNameDeclaration::getFqn)), (Object)Fqn.INVALID);
        if (fqn == null) {
            RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(10);
        }
        return fqn;
    }

    @NotNull
    private Fqn getParentClassDeclarationFqn() {
        Fqn fqn = Optional.ofNullable((RbsSuperClassElement)ObjectUtils.tryCast((Object)this.myElement, RbsSuperClassElement.class)).map(RbsClassDeclarationNavigator::getBySuperclass).map(RbsQualifiedNameDeclaration::getFqn).orElse(Fqn.INVALID);
        if (fqn == null) {
            RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(11);
        }
        return fqn;
    }

    @NotNull
    private Fqn getAliasFqn() {
        PsiElement psiElement = this.myElement;
        if (psiElement instanceof RbsClassAliasDeclarationElement) {
            RbsClassAliasDeclarationElement classAlias = (RbsClassAliasDeclarationElement)psiElement;
            Fqn fqn = classAlias.getFqn();
            if (fqn == null) {
                RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(12);
            }
            return fqn;
        }
        psiElement = this.myElement;
        if (psiElement instanceof RbsModuleAliasDeclarationElement) {
            RbsModuleAliasDeclarationElement moduleAlias = (RbsModuleAliasDeclarationElement)psiElement;
            Fqn fqn = moduleAlias.getFqn();
            if (fqn == null) {
                RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(13);
            }
            return fqn;
        }
        Fqn fqn = Fqn.INVALID;
        if (fqn == null) {
            RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(14);
        }
        return fqn;
    }

    private boolean isExtendInsideModule() {
        return this.myElement instanceof RbsExtendMember && PsiTreeUtil.getParentOfType((PsiElement)this.myElement, RbsContainerDeclarationElement.class) instanceof RbsModuleDeclarationElement;
    }

    private boolean isIrrelevantForCurrentPrefix(int numberOfComponents) {
        return this.myCompletionPrefix.equals("::") && numberOfComponents != 1;
    }

    private void addTypeVariableLookupElements(@NotNull CompletionResultSet result) {
        if (result == null) {
            RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(15);
        }
        Stream<RbsTypeVariableSymbol> symbols = Stream.empty();
        if (this.myCompletionTargets.contains((Object)RbsQualifiedNameCompletionTarget.CONTAINER_TYPE_VARIABLE)) {
            symbols = Stream.concat(symbols, this.findSymbols(RbsContainerDeclarationElement.class, RbsContainerDeclarationElement::getTypeVariableSymbols));
        }
        if (this.myCompletionTargets.contains((Object)RbsQualifiedNameCompletionTarget.METHOD_TYPE_VARIABLE)) {
            symbols = Stream.concat(symbols, this.findSymbols(RbsMethodTypeElement.class, RbsMethodTypeElement::getTypeVariableSymbols));
        }
        if (this.myCompletionTargets.contains((Object)RbsQualifiedNameCompletionTarget.TYPE_ALIAS_TYPE_VARIABLE)) {
            symbols = Stream.concat(symbols, this.findSymbols(RbsTypeDeclarationElement.class, RbsTypeDeclarationElement::getTypeVariableSymbols));
        }
        symbols.map(RbsWeighedLookupElement::fromTypeVariable).forEach(arg_0 -> ((CompletionResultSet)result).addElement(arg_0));
    }

    private void addUseClauseAliasLookupElements(@NotNull CompletionResultSet result) {
        Object object;
        if (result == null) {
            RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(16);
        }
        if (!((object = this.myElement.getContainingFile()) instanceof RbsPsiFile)) {
            return;
        }
        RbsPsiFile file = (RbsPsiFile)((Object)object);
        for (RbsPsiSymbolDeclaration declaration : ContainerUtil.mapNotNull(file.getUseClauses(), it -> it.getSymbolDeclaration())) {
            RbsUseClauseAliasSymbol symbol = (RbsUseClauseAliasSymbol)declaration.getSymbol();
            List<RbsQualifiedNameSymbol> targets = RbsQualifiedNameSymbol.find(this.myProject, this.mySearchScope, symbol.getTargetFqn()).filter(it -> it instanceof RbsClassSymbol && this.myCompletionTargets.contains((Object)RbsQualifiedNameCompletionTarget.CLASS) || it instanceof RbsInterfaceSymbol && this.myCompletionTargets.contains((Object)RbsQualifiedNameCompletionTarget.INTERFACE) || it instanceof RbsModuleSymbol && this.myCompletionTargets.contains((Object)RbsQualifiedNameCompletionTarget.MODULE) || it instanceof RbsTypeAliasSymbol && this.myCompletionTargets.contains((Object)RbsQualifiedNameCompletionTarget.TYPE_ALIAS)).toList();
            if (targets.isEmpty()) continue;
            result.addElement(RbsQualifiedNameLookupElement.create(symbol, targets));
        }
    }

    @NotNull
    private SearchScope getCoreLibraryScope() {
        VirtualFile coreDirectory;
        Project project = this.myElement.getProject();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myElement);
        VirtualFile virtualFile = coreDirectory = module != null ? RbsRubysigsLibraryUtil.getRbsCoreLibraryRoot(project, module) : null;
        if (coreDirectory == null) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
            if (globalSearchScope == null) {
                RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(17);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScopes.directoryScope((Project)project, (VirtualFile)coreDirectory, (boolean)true);
        if (globalSearchScope == null) {
            RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(18);
        }
        return globalSearchScope;
    }

    @NotNull
    private <E extends PsiElement, S extends RbsTypeVariableSymbol> Stream<S> findSymbols(@NotNull Class<E> parentClass, @NotNull Function<E, List<S>> toSymbols) {
        PsiElement parent;
        if (parentClass == null) {
            RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(19);
        }
        if (toSymbols == null) {
            RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(20);
        }
        if ((parent = PsiTreeUtil.getParentOfType((PsiElement)this.myElement, parentClass)) == null) {
            Stream stream = Stream.empty();
            if (stream == null) {
                RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(21);
            }
            return stream;
        }
        Stream stream = toSymbols.apply(parent).stream();
        if (stream == null) {
            RbsCompletableQualifiedNameWrapper.$$$reportNull$$$0(22);
        }
        return stream;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11, 12, 13, 14, 17, 18, 21, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeRank";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/completion/RbsCompletableQualifiedNameWrapper";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClass";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toSymbols";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/completion/RbsCompletableQualifiedNameWrapper";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentTypeDeclarationFqn";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentClassDeclarationFqn";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAliasFqn";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoreLibraryScope";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "findSymbols";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addCompletionVariants";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addCompletionVariantsImpl";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processQualifiedNameSymbols";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processCompletionCandidate";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isRecursiveSuggestion";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 22: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addTypeVariableLookupElements";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addUseClauseAliasLookupElements";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findSymbols";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11, 12, 13, 14, 17, 18, 21, 22 -> new IllegalStateException(string);
        };
    }
}

