/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.actions.generate;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.CodeInsightAction;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.lang.ruby.rbs.actions.RbsCommandlineAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ruby.rbs.frontback.RbsBundle;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.util.RubyGemSearchUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

final class RbsGenerateFromRubyAction
extends CodeInsightAction {
    private static final Logger LOG = Logger.getInstance(RbsGenerateFromRubyAction.class);
    private static final String NOTIFICATION_GROUP = "rbs.fileGeneration";
    private static final String SIG_DIR = "sig";

    RbsGenerateFromRubyAction() {
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        MyHandler.ActionData actionData;
        if (project == null) {
            RbsGenerateFromRubyAction.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            RbsGenerateFromRubyAction.$$$reportNull$$$0(1);
        }
        if (psiFile == null) {
            RbsGenerateFromRubyAction.$$$reportNull$$$0(2);
        }
        if ((actionData = MyHandler.getActionData(psiFile)) == null) {
            return false;
        }
        VirtualFile virtualFile = actionData.file();
        VirtualFile contentRoot = ProjectFileIndex.getInstance((Project)project).getContentRootForFile(virtualFile);
        if (contentRoot == null) {
            LOG.debug("File is not in content root, file=", new Object[]{virtualFile, "; project=", project});
            return false;
        }
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)virtualFile.getParent(), (VirtualFile)contentRoot);
        if (relativePath == null) {
            LOG.error("Unable to find relative path for " + String.valueOf(virtualFile) + " the content root " + String.valueOf(contentRoot));
            return false;
        }
        VirtualFile existingSignature = VfsUtil.findFile((Path)Path.of(contentRoot.getPath(), SIG_DIR, relativePath, virtualFile.getNameWithoutExtension() + ".rbs"), (boolean)true);
        if (existingSignature != null) {
            LOG.debug("There is a signature file: ", new Object[]{existingSignature});
            return false;
        }
        return RubyGemSearchUtil.findGem((Module)actionData.module(), (Sdk)actionData.sdk(), (String)"rbs") != null;
    }

    @NotNull
    protected CodeInsightActionHandler getHandler() {
        return new MyHandler();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "psiFile";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/ruby/rbs/actions/generate/RbsGenerateFromRubyAction";
        objectArray[2] = "isValidForFile";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyHandler
    implements CodeInsightActionHandler {
        private MyHandler() {
        }

        public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
            ActionData actionData;
            if (project == null) {
                MyHandler.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                MyHandler.$$$reportNull$$$0(1);
            }
            if (psiFile == null) {
                MyHandler.$$$reportNull$$$0(2);
            }
            if ((actionData = MyHandler.getActionData(psiFile)) == null) {
                LOG.warn("Unable to compute an action data");
                return;
            }
            ApplicationManager.getApplication().runWriteAction(() -> FileDocumentManager.getInstance().saveAllDocuments());
            new MyTask(project, RbsBundle.message((String)"rbs.action.generate.title", (Object[])new Object[0]), actionData.sdk(), actionData.file()).queue();
        }

        @Nullable
        private static ActionData getActionData(@NotNull PsiFile psiFile) {
            VirtualFile virtualFile;
            if (psiFile == null) {
                MyHandler.$$$reportNull$$$0(3);
            }
            if ((virtualFile = PsiUtilCore.getVirtualFile((PsiElement)psiFile)) == null) {
                LOG.debug("Virtual file not found for psi file: ", new Object[]{psiFile});
                return null;
            }
            if (psiFile.getViewProvider().getBaseLanguage() != RubyLanguage.INSTANCE) {
                LOG.debug("File is not a ruby file ", new Object[]{psiFile});
                return null;
            }
            Module module = ModuleUtilCore.findModuleForFile((PsiFile)psiFile);
            if (!RModuleUtil.getInstance().isRubyModule(module)) {
                LOG.debug("Unable detect a ruby module for ", new Object[]{psiFile, "; module=", module});
                return null;
            }
            Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
            if (sdk == null) {
                LOG.debug("No ruby sdk for a module: ", new Object[]{module});
                return null;
            }
            return new ActionData(virtualFile, sdk, module);
        }

        @RequiresWriteLock
        @NotNull
        private static VirtualFile getOrCreateSigDir(@NotNull Project project, @NotNull VirtualFile rubyFile) throws IOException {
            if (project == null) {
                MyHandler.$$$reportNull$$$0(4);
            }
            if (rubyFile == null) {
                MyHandler.$$$reportNull$$$0(5);
            }
            ThreadingAssertions.assertWriteAccess();
            VirtualFile projectDir = Objects.requireNonNull(ProjectUtil.guessProjectDir((Project)project), "Project directory must not be null!");
            VirtualFile sigDir = VfsUtil.createDirectoryIfMissing((VirtualFile)projectDir, (String)RbsGenerateFromRubyAction.SIG_DIR);
            VirtualFile virtualFile = VfsUtil.createDirectoryIfMissing((VirtualFile)sigDir, (String)VfsUtilCore.getRelativePath((VirtualFile)rubyFile.getParent(), (VirtualFile)projectDir));
            if (virtualFile == null) {
                MyHandler.$$$reportNull$$$0(6);
            }
            return virtualFile;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rubyFile";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ruby/rbs/actions/generate/RbsGenerateFromRubyAction$MyHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ruby/rbs/actions/generate/RbsGenerateFromRubyAction$MyHandler";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOrCreateSigDir";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getActionData";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getOrCreateSigDir";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6 -> new IllegalStateException(string);
            };
        }

        private record ActionData(VirtualFile file, Sdk sdk, Module module) {
        }

        private static class MyTask
        extends Task.Backgroundable {
            private final Sdk mySdk;
            private final VirtualFile myRubyFile;

            private MyTask(@NotNull Project project, @NlsContexts.ProgressTitle @NotNull String title, @NotNull Sdk sdk, @NotNull VirtualFile rubyFile) {
                if (project == null) {
                    MyTask.$$$reportNull$$$0(0);
                }
                if (title == null) {
                    MyTask.$$$reportNull$$$0(1);
                }
                if (sdk == null) {
                    MyTask.$$$reportNull$$$0(2);
                }
                if (rubyFile == null) {
                    MyTask.$$$reportNull$$$0(3);
                }
                super(project, title);
                this.mySdk = sdk;
                this.myRubyFile = rubyFile;
            }

            public void run(@NotNull ProgressIndicator indicator) {
                ProcessOutput output;
                Project project;
                if (indicator == null) {
                    MyTask.$$$reportNull$$$0(4);
                }
                LOG.assertTrue((project = this.getProject()) != null);
                RbsCommandlineAction.Prototype prototype = new RbsCommandlineAction.Prototype("rb", RubySdkUtil.convertToRemote((Sdk)this.mySdk, (Module)ModuleUtilCore.findModuleForFile((VirtualFile)this.myRubyFile, (Project)project), (String)this.myRubyFile.getPath()));
                try {
                    output = prototype.performInvisibly(this.mySdk);
                }
                catch (ExecutionException e) {
                    LOG.warn("Exception while generating RBS", (Throwable)e);
                    new Notification(RbsGenerateFromRubyAction.NOTIFICATION_GROUP, RbsBundle.message((String)"rbs.action.error.generating.rbs", (Object[])new Object[]{e.getMessage()}), NotificationType.ERROR).notify(project);
                    return;
                }
                if (output == null || output.getExitCode() != 0) {
                    @Nls String message = output == null ? RbsBundle.message((String)"rbs.action.output.null", (Object[])new Object[0]) : RbsBundle.message((String)"rbs.action.non.zero.exit.code", (Object[])new Object[]{output.getExitCode()});
                    LOG.warn(message + String.valueOf(output));
                    new Notification(RbsGenerateFromRubyAction.NOTIFICATION_GROUP, message, NotificationType.ERROR).notify(project);
                    return;
                }
                LOG.debug("Finished generation process: ", new Object[]{output});
                String rbsFileText = output.getStdout();
                String rbsFileName = NamingConventions.toUnderscoreCase((String)this.myRubyFile.getNameWithoutExtension()) + ".rbs";
                Application application = ApplicationManager.getApplication();
                application.invokeLaterOnWriteThread(() -> WriteAction.run(() -> {
                    try {
                        if (project.isDisposed()) {
                            LOG.warn("Project disposed, cancel saving: " + String.valueOf(project));
                            return;
                        }
                        LOG.debug("Saving generated rbs to ", new Object[]{rbsFileName});
                        VirtualFile rbsFileDir = MyHandler.getOrCreateSigDir(project, this.myRubyFile);
                        VirtualFile fileToModify = rbsFileDir.createChildData((Object)this, rbsFileName);
                        fileToModify.setBinaryContent(rbsFileText.getBytes(StandardCharsets.UTF_8));
                        LOG.debug("Saved generated rbs file to ", new Object[]{rbsFileName});
                        FileEditorManager.getInstance((Project)project).openFile(fileToModify, true);
                    }
                    catch (IOException e) {
                        LOG.warn("Exception while saving generated RBS", (Throwable)e);
                        new Notification(RbsGenerateFromRubyAction.NOTIFICATION_GROUP, RbsBundle.message((String)"rbs.action.error.generating.rbs", (Object[])new Object[]{e.getMessage()}), NotificationType.ERROR).notify(project);
                    }
                }));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "title";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "sdk";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rubyFile";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/ruby/rbs/actions/generate/RbsGenerateFromRubyAction$MyHandler$MyTask";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "run";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

