/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.rbs.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ruby.rbs.frontback.RbsBundle;
import com.intellij.ruby.rbs.frontback.RbsIcons;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.gem.util.RubyGemSearchUtil;
import org.jetbrains.plugins.ruby.ruby.run.ConsoleRunnerOptions;
import org.jetbrains.plugins.ruby.ruby.run.MergingCommandLineArgumentsProvider;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLineArgumentsProvider;
import org.jetbrains.plugins.ruby.ruby.run.RubyScriptRunner;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;

public abstract class RbsCommandlineAction
extends DumbAwareAction {
    public static final String RBS_EXECUTABLE_NAME = "rbs";
    public static final String GROUP_ID = "rbs.cli.actions";
    public static final String RBS_GEM_NAME = "rbs";
    private static final Logger LOG = Logger.getInstance(RbsCommandlineAction.class);
    private final String[] myCommands;

    protected RbsCommandlineAction(String ... commands) {
        if (commands == null) {
            RbsCommandlineAction.$$$reportNull$$$0(0);
        }
        super(RbsIcons.RBS_FILE_ICON);
        this.myCommands = commands;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            RbsCommandlineAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            RbsCommandlineAction.$$$reportNull$$$0(2);
        }
        Module module = (Module)e.getData(PlatformCoreDataKeys.MODULE);
        Objects.requireNonNull(module);
        LOG.assertTrue(!module.isDisposed(), (Object)"Module is disposed!");
        FileDocumentManager.getInstance().saveAllDocuments();
        RbsCommandlineAction.executeAction(module, RbsCommandlineAction.buildFullCommand(this.getExecutableName(), this.getCommands()));
    }

    public ProcessOutput performInvisibly(@NotNull Sdk sdk) throws ExecutionException {
        if (sdk == null) {
            RbsCommandlineAction.$$$reportNull$$$0(3);
        }
        RubyGemExecutionContext context = RubyGemExecutionContext.create((Sdk)sdk, (String)"rbs");
        context.withArguments(this.getCommands());
        return context.executeScript();
    }

    @NotNull
    @NonNls
    public @NotNull @NonNls String @NotNull [] getCommands() {
        if (this.myCommands == null) {
            RbsCommandlineAction.$$$reportNull$$$0(4);
        }
        return this.myCommands;
    }

    @NotNull
    @NonNls
    public String getExecutableName() {
        return "rbs";
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RbsCommandlineAction.$$$reportNull$$$0(5);
        }
        Module module = (Module)e.getData(PlatformCoreDataKeys.MODULE);
        Project project = e.getProject();
        Sdk sdk = project != null ? RubySdkUtil.findRubySdk((Project)project) : null;
        ProgressManager.checkCanceled();
        e.getPresentation().setEnabledAndVisible(sdk != null && RubyGemSearchUtil.findGem((Module)module, (Sdk)sdk, (String)this.getExecutableName()) != null);
    }

    @NotNull
    protected static @NotNull String @NotNull [] buildFullCommand(@NotNull String executable, @NotNull @NotNull String @NotNull [] commands) {
        if (executable == null) {
            RbsCommandlineAction.$$$reportNull$$$0(6);
        }
        if (commands == null) {
            RbsCommandlineAction.$$$reportNull$$$0(7);
        }
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(executable);
        strings.addAll(java.util.List.of(commands));
        String[] stringArray = ArrayUtil.toStringArray(strings);
        if (stringArray == null) {
            RbsCommandlineAction.$$$reportNull$$$0(8);
        }
        return stringArray;
    }

    private static void executeAction(@NotNull Module module, @NotNull @NonNls @NotNull @NonNls String @NotNull [] commands) {
        if (module == null) {
            RbsCommandlineAction.$$$reportNull$$$0(9);
        }
        if (commands == null) {
            RbsCommandlineAction.$$$reportNull$$$0(10);
        }
        Project project = module.getProject();
        Sdk sdk = RubySdkUtil.findRubySdk((Project)project);
        Objects.requireNonNull(sdk, "Sdk should not be null here!");
        String tabTitle = RbsBundle.message((String)"rbs.action.tab.title", (Object[])new Object[]{StringUtil.join((String[])commands, (String)" ")});
        String gemPath = RubyGemExecutionContext.getScriptPath((Sdk)sdk, (Module)module, (String)commands[0]);
        if (gemPath != null) {
            commands[0] = RubySdkUtil.convertToRemote((Sdk)sdk, (Module)module, (String)gemPath);
        }
        MergingCommandLineArgumentsProvider provider = new MergingCommandLineArgumentsProvider(commands, null, null, null);
        ProcessListener reloadListener = new ProcessListener(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    SaveAndSyncHandler.getInstance().refreshOpenFiles();
                    VirtualFileManager.getInstance().refreshWithoutFileWatcher(false);
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/ruby/rbs/actions/RbsCommandlineAction$1", "processTerminated"));
            }
        };
        ConsoleRunnerOptions consoleRunnerOptions = ConsoleRunnerOptions.builder((Module)module, (String)tabTitle).withProcessListeners(reloadListener).withWorkingDirectory(project.getBasePath()).build();
        RubyScriptRunner.runRubyScriptInConsole((RubyCommandLineArgumentsProvider)provider, (Sdk)sdk, (ConsoleRunnerOptions)consoleRunnerOptions);
    }

    public static java.util.List<RbsCommandlineAction> getRbsActions() {
        AnAction action = ActionManager.getInstance().getAction(GROUP_ID);
        if (action instanceof DefaultActionGroup) {
            DefaultActionGroup actionGroup = (DefaultActionGroup)action;
            return RbsCommandlineAction.doGetActions(actionGroup.getChildren(ActionManager.getInstance()));
        }
        return Collections.emptyList();
    }

    protected static <T extends RbsCommandlineAction> java.util.List<T> doGetActions(@NotNull @NotNull AnAction @NotNull [] children) {
        if (children == null) {
            RbsCommandlineAction.$$$reportNull$$$0(11);
        }
        ArrayList<RbsCommandlineAction> actions = new ArrayList<RbsCommandlineAction>();
        for (AnAction child : children) {
            actions.add((RbsCommandlineAction)child);
        }
        return actions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commands";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ruby/rbs/actions/RbsCommandlineAction";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executable";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ruby/rbs/actions/RbsCommandlineAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommands";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFullCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "performInvisibly";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildFullCommand";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "executeAction";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doGetActions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 8 -> new IllegalStateException(string);
        };
    }

    static final class Vendor
    extends RbsCommandlineAction {
        private Vendor() {
            super("vendor");
        }
    }

    static final class Test
    extends RbsCommandlineAction {
        private Test() {
            super("test");
        }
    }

    static final class Paths
    extends RbsCommandlineAction {
        private Paths() {
            super("paths");
        }
    }

    static final class Parse
    extends RbsCommandlineAction {
        private Parse() {
            super("parse");
        }
    }

    static final class Methods
    extends RbsCommandlineAction {
        private Methods() {
            super("methods");
        }
    }

    static final class Method
    extends RbsCommandlineAction {
        private Method() {
            super("method");
        }
    }

    static final class List
    extends RbsCommandlineAction {
        private List() {
            super("list");
        }
    }

    static final class Constant
    extends RbsCommandlineAction {
        private Constant() {
            super("constant");
        }
    }

    static final class Ast
    extends RbsCommandlineAction {
        private Ast() {
            super("ast");
        }
    }

    static final class Ancestors
    extends RbsCommandlineAction {
        private Ancestors() {
            super("ancestors");
        }
    }

    public static final class Prototype
    extends RbsCommandlineAction {
        private static final String COMMAND_NAME = "prototype";

        public Prototype() {
            super(COMMAND_NAME);
        }

        public Prototype(String ... args) {
            if (args == null) {
                Prototype.$$$reportNull$$$0(0);
            }
            super((String[])ArrayUtil.prepend((Object)COMMAND_NAME, (Object[])args));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/lang/ruby/rbs/actions/RbsCommandlineAction$Prototype", "<init>"));
        }
    }

    static final class Validate
    extends RbsCommandlineAction {
        private Validate() {
            super("validate");
        }
    }
}

