/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.grazie;

import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextExtractor;
import com.intellij.grazie.utils.HtmlUtilsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.rdoc.RDocTokenTypes;
import org.jetbrains.plugins.ruby.rdoc.yard.YARDPsiLexer;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyCommentsUtil;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyCommentsUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyDocumentationUtil;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.rendering.CompositeDocumentationItem;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.rendering.RenderedDocumentationCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.rendering.RenderedDocumentationItem;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.RubyElementTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.TokenBNF;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0014J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/lang/ruby/grazie/RubyTextExtractor;", "Lcom/intellij/grazie/text/TextExtractor;", "<init>", "()V", "STRINGS", "Lcom/intellij/psi/tree/TokenSet;", "ALLOWED_YARD_TOKENS", "IGNORE_SECTIONS", "buildTextContents", "", "Lcom/intellij/grazie/text/TextContent;", "element", "Lcom/intellij/psi/PsiElement;", "allowedDomains", "", "Lcom/intellij/grazie/text/TextContent$TextDomain;", "buildYardContents", "commentElement", "Lcom/intellij/psi/PsiComment;", "buildCommentBlockContent", "getCommentsGroupContainingWithoutCodeBlocks", "getCommentGroupContaining", "findFirstComment", "intellij.ruby.grazie"})
@SourceDebugExtension(value={"SMAP\nRubyTextExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RubyTextExtractor.kt\ncom/intellij/lang/ruby/grazie/RubyTextExtractor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,163:1\n1#2:164\n1#2:181\n1374#3:165\n1460#3,5:166\n1617#3,9:171\n1869#3:180\n1870#3:182\n1626#3:183\n1563#3:184\n1634#3,3:185\n*S KotlinDebug\n*F\n+ 1 RubyTextExtractor.kt\ncom/intellij/lang/ruby/grazie/RubyTextExtractor\n*L\n126#1:181\n120#1:165\n120#1:166,5\n126#1:171,9\n126#1:180\n126#1:182\n126#1:183\n134#1:184\n134#1:185,3\n*E\n"})
public final class RubyTextExtractor
extends TextExtractor {
    @NotNull
    private final TokenSet STRINGS;
    @NotNull
    private final TokenSet ALLOWED_YARD_TOKENS;
    @NotNull
    private final TokenSet IGNORE_SECTIONS;

    public RubyTextExtractor() {
        IElementType[] iElementTypeArray = new IElementType[]{RubyElementTypes.STRING, RubyElementTypes.NI_STRING};
        TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        this.STRINGS = tokenSet;
        iElementTypeArray = new IElementType[]{RDocTokenTypes.CID, RDocTokenTypes.WHITESPACE, RDocTokenTypes.CHARACTER, RDocTokenTypes.RESWORD, RDocTokenTypes.DELIMITER};
        TokenSet tokenSet2 = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet2, (String)"create(...)");
        this.ALLOWED_YARD_TOKENS = tokenSet2;
        iElementTypeArray = new IElementType[]{RDocTokenTypes.EXAMPLE};
        TokenSet tokenSet3 = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet3, (String)"create(...)");
        this.IGNORE_SECTIONS = tokenSet3;
    }

    @NotNull
    protected List<TextContent> buildTextContents(@NotNull PsiElement element, @NotNull Set<? extends TextContent.TextDomain> allowedDomains) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(allowedDomains, (String)"allowedDomains");
        IElementType elementType = PsiUtilCore.getElementType((PsiElement)element);
        if (this.STRINGS.contains(elementType) && allowedDomains.contains(TextContent.TextDomain.LITERALS)) {
            return CollectionsKt.listOfNotNull((Object)TextContent.builder().withMarkup(RubyTextExtractor::buildTextContents$lambda$0).withUnknown(RubyTextExtractor::buildTextContents$lambda$1).build(element, TextContent.TextDomain.LITERALS));
        }
        if (Intrinsics.areEqual((Object)elementType, (Object)RubyElementTypes.HEREDOC_VALUE) && allowedDomains.contains(TextContent.TextDomain.LITERALS)) {
            return CollectionsKt.listOfNotNull((Object)TextContent.builder().withUnknown(RubyTextExtractor::buildTextContents$lambda$2).build(element, TextContent.TextDomain.LITERALS));
        }
        if (Intrinsics.areEqual((Object)elementType, (Object)RubyTokenTypes.tBLOCK_COMMENT) && allowedDomains.contains(TextContent.TextDomain.DOCUMENTATION)) {
            TextContent defaultContent = TextContent.builder().build(element, TextContent.TextDomain.DOCUMENTATION);
            int startOffset = 7;
            String string = element.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            int it = StringsKt.indexOf$default((CharSequence)string, (String)"\n=end", (int)0, (boolean)false, (int)6, null);
            boolean bl = false;
            int endOffset = it < 0 ? element.getText().length() : it;
            if (startOffset <= endOffset) {
                TextContent textContent = defaultContent;
                return CollectionsKt.listOfNotNull(textContent != null ? textContent.subText(TextRange.create((int)startOffset, (int)endOffset)) : null);
            }
            return CollectionsKt.listOfNotNull((Object)defaultContent);
        }
        if (!Intrinsics.areEqual((Object)elementType, (Object)RubyTokenTypes.TLINE_COMMENT)) {
            return CollectionsKt.emptyList();
        }
        boolean isDocComment = RubyDocumentationUtil.isDocumentationLineComment((PsiComment)((PsiComment)element));
        if (isDocComment && allowedDomains.contains(TextContent.TextDomain.DOCUMENTATION)) {
            return this.buildYardContents((PsiComment)element);
        }
        if (!isDocComment && allowedDomains.contains(TextContent.TextDomain.COMMENTS)) {
            return CollectionsKt.listOfNotNull((Object)this.buildCommentBlockContent((PsiComment)element));
        }
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    private final List<TextContent> buildYardContents(PsiComment commentElement) {
        void $this$flatMapTo$iv$iv;
        Iterable commentElement2;
        List<PsiComment> commentsList = this.getCommentsGroupContainingWithoutCodeBlocks(commentElement);
        if (commentsList.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        List result = new ArrayList();
        List chunkChunks = new ArrayList();
        boolean ignoreSection = false;
        YARDPsiLexer yardPsiLexer = new YARDPsiLexer(commentsList);
        while (yardPsiLexer.getTokenType() != null) {
            IElementType tokenType = yardPsiLexer.getTokenType();
            if (RDocTokenTypes.YARD_NOT_DEPRECATED_TAGS.contains(tokenType)) {
                TextContent textContent = TextContent.join((List)chunkChunks);
                UtilKt.addIfNotNull((List)result, (Object)(textContent != null ? textContent.trimWhitespace() : null));
                chunkChunks.clear();
                ignoreSection = false;
                if (this.IGNORE_SECTIONS.contains(tokenType)) {
                    ignoreSection = true;
                }
            } else {
                if (ignoreSection) {
                    yardPsiLexer.advance();
                    continue;
                }
                if (Intrinsics.areEqual((Object)tokenType, (Object)RDocTokenTypes.EOL)) {
                    commentIndexAndOffset = yardPsiLexer.getPsiStart();
                    commentElement2 = commentsList.get(commentIndexAndOffset[0]);
                    PsiElement newLineElement = commentElement2.getNextSibling();
                    UtilKt.addIfNotNull((List)chunkChunks, (Object)TextContent.psiFragment((TextContent.TextDomain)TextContent.TextDomain.DOCUMENTATION, (PsiElement)newLineElement, (TextRange)TextRange.create((int)0, (int)1)));
                } else if (this.ALLOWED_YARD_TOKENS.contains(tokenType)) {
                    commentIndexAndOffset = yardPsiLexer.getPsiStart();
                    commentElement2 = commentsList.get(commentIndexAndOffset[0]);
                    int tokenStart = commentIndexAndOffset[1] + 1;
                    int tokenLength = yardPsiLexer.getTokenEnd() - yardPsiLexer.getTokenStart();
                    if (tokenLength > 0) {
                        TextRange rangeInComment;
                        Intrinsics.checkNotNullExpressionValue((Object)TextRange.from((int)tokenStart, (int)tokenLength), (String)"from(...)");
                        UtilKt.addIfNotNull((List)chunkChunks, (Object)TextContent.psiFragment((TextContent.TextDomain)TextContent.TextDomain.DOCUMENTATION, (PsiElement)((PsiElement)commentElement2), (TextRange)rangeInComment));
                    }
                }
            }
            yardPsiLexer.advance();
        }
        if (!((Collection)chunkChunks).isEmpty()) {
            TextContent textContent = TextContent.join((List)chunkChunks);
            UtilKt.addIfNotNull((List)result, (Object)(textContent != null ? textContent.trimWhitespace() : null));
        }
        Iterable $this$flatMap$iv = result;
        boolean $i$f$flatMap = false;
        commentElement2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            TextContent it = (TextContent)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = HtmlUtilsKt.excludeHtml((TextContent)it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final TextContent buildCommentBlockContent(PsiComment commentElement) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Iterable iterable = this.getCommentGroupContaining(commentElement);
        char c = '\n';
        boolean $i$f$mapNotNull = false;
        void var4_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            TextContent it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            PsiComment it = (PsiComment)element$iv$iv;
            boolean bl2 = false;
            if (TextContent.builder().removingIndents("#").build((PsiElement)it, TextContent.TextDomain.COMMENTS) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list = (List)destination$iv$iv;
        return TextContent.joinWithWhitespace((char)c, (List)CollectionsKt.toList((Iterable)list));
    }

    /*
     * WARNING - void declaration
     */
    private final List<PsiComment> getCommentsGroupContainingWithoutCodeBlocks(PsiComment commentElement) {
        void $this$mapTo$iv$iv;
        List<PsiComment> allComments = this.getCommentGroupContaining(commentElement);
        Iterable $this$map$iv = allComments;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void commentElement2;
            PsiComment psiComment = (PsiComment)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = commentElement2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            char[] cArray = new char[]{'#'};
            collection.add(StringsKt.trimStart((String)string, (char[])cArray));
        }
        List commentsTexts = RubyDocumentationUtil.cutCommonIndent((List)((List)destination$iv$iv));
        CompositeDocumentationItem compositeDocumentationItem = new CompositeDocumentationItem(commentElement.getProject(), commentsTexts, null);
        List list = compositeDocumentationItem.buildRenderedDocumentationStructure(commentsTexts);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"buildRenderedDocumentationStructure(...)");
        List documentationItems = list;
        int commentIndex = 0;
        List result = new ArrayList();
        for (RenderedDocumentationItem documentationItem : documentationItems) {
            int itemSize = documentationItem.getLinesNumber();
            if (documentationItem instanceof RenderedDocumentationCodeBlock) {
                commentIndex += itemSize;
                continue;
            }
            int lastIndex = commentIndex + itemSize;
            if (lastIndex > allComments.size()) {
                Logger logger = Logger.getInstance(RubyTextExtractor.class);
                Intrinsics.checkNotNull((Object)commentsTexts);
                logger.error("Comment index is out of range for comment:\n" + CollectionsKt.joinToString$default((Iterable)commentsTexts, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
                return CollectionsKt.emptyList();
            }
            result.addAll((Collection)allComments.subList(commentIndex, lastIndex));
            commentIndex = lastIndex;
        }
        return result;
    }

    private final List<PsiComment> getCommentGroupContaining(PsiComment commentElement) {
        List list = RubyCommentsUtil.getCommentsFollowing((PsiComment)this.findFirstComment(commentElement));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getCommentsFollowing(...)");
        return list;
    }

    private final PsiComment findFirstComment(PsiComment commentElement) {
        return (PsiComment)SequencesKt.last((Sequence)SequencesKt.generateSequence((Object)commentElement, RubyTextExtractor::findFirstComment$lambda$7));
    }

    private static final boolean buildTextContents$lambda$0(PsiElement it) {
        return TokenBNF.tSTRING_DELIMITERS.contains(PsiUtilCore.getElementType((PsiElement)it));
    }

    private static final boolean buildTextContents$lambda$1(PsiElement it) {
        return Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)it), (Object)RubyElementTypes.EXPR_SUBTITUTION);
    }

    private static final boolean buildTextContents$lambda$2(PsiElement it) {
        return Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)it), (Object)RubyElementTypes.EXPR_SUBTITUTION);
    }

    private static final PsiComment findFirstComment$lambda$7(PsiComment it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return RubyCommentsUtilCore.getPrevComment((PsiElement)((PsiElement)it), (IElementType)RubyTokenTypes.TLINE_COMMENT);
    }
}

