/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ruby.grazie;

import com.intellij.grazie.text.ProblemFilter;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextProblem;
import com.intellij.grazie.utils.ProblemFilterUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/lang/ruby/grazie/RubyGrazieProblemFilter;", "Lcom/intellij/grazie/text/ProblemFilter;", "<init>", "()V", "shouldIgnore", "", "problem", "Lcom/intellij/grazie/text/TextProblem;", "intellij.ruby.grazie"})
public final class RubyGrazieProblemFilter
extends ProblemFilter {
    public boolean shouldIgnore(@NotNull TextProblem problem) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        if (problem.getText().getDomain() != TextContent.TextDomain.DOCUMENTATION) {
            return false;
        }
        if (!ProblemFilterUtil.isUndecoratedSingleSentenceIssue((TextProblem)problem) && !ProblemFilterUtil.isInitialCasingIssue((TextProblem)problem)) {
            return false;
        }
        List list = problem.getHighlightRanges();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getHighlightRanges(...)");
        int firstRangeOffset = ((TextRange)CollectionsKt.first((List)list)).getStartOffset();
        return Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)problem.getText().findPsiElementAt(firstRangeOffset)), (Object)RubyTokenTypes.TLINE_COMMENT);
    }
}

