/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.slim.lexer;

import com.intellij.lexer.EmbeddedTokenTypesProvider;
import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.MergingLexerAdapter;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.slim.lexer._SlimLexer;
import org.jetbrains.plugins.slim.psi.SlimLanguageLevel;
import org.jetbrains.plugins.slim.psi.SlimTokenTypes;

public final class SlimLexer
extends MergingLexerAdapter {
    private static final TokenSet TOKENS_2_MERGE = TokenSet.create((IElementType[])new IElementType[]{SlimTokenTypes.CODE_COMMENT, SlimTokenTypes.HTML_COMMENT, SlimTokenTypes.RUBY_CODE, SlimTokenTypes.STATIC_CONTENT, SlimTokenTypes.CONTROL_CODE_START, SlimTokenTypes.BAD_CHARACTER, SlimTokenTypes.FILTER_CONTENT, SlimTokenTypes.COFFEE_CODE, SlimTokenTypes.JAVASCRIPT_CODE, SlimTokenTypes.CSS_CODE, SlimTokenTypes.SASS_CODE, SlimTokenTypes.SCSS_CODE, SlimTokenTypes.LESS_CODE, SlimTokenTypes.STYLUS_CODE, SlimTokenTypes.STRING_LITERAL});
    private IElementType myTokenType;
    private final boolean myLexEmbeddedElements;
    private static Ref<IElementType> myOuterLanguageTokenType;

    public SlimLexer(SlimLanguageLevel slimLanguageLevel, boolean lexEmbeddedElements) {
        super((Lexer)new SlimFlexAdapter(), TOKENS_2_MERGE);
        this.getSlimFlexAdapter().getSlimFlexLexer().setSlimLanguageLevel(slimLanguageLevel);
        this.myLexEmbeddedElements = lexEmbeddedElements;
    }

    @NotNull
    private SlimFlexAdapter getSlimFlexAdapter() {
        SlimFlexAdapter slimFlexAdapter = (SlimFlexAdapter)this.getDelegate();
        if (slimFlexAdapter == null) {
            SlimLexer.$$$reportNull$$$0(0);
        }
        return slimFlexAdapter;
    }

    public void advance() {
        this.myTokenType = null;
        IElementType previousType = this.getTokenType();
        String previousText = this.getTokenText();
        super.advance();
        if (previousType == SlimTokenTypes.FILTER) {
            for (EmbeddedTokenTypesProvider embeddedTokenTypesProvider : EmbeddedTokenTypesProvider.getProviders()) {
                if (!previousText.startsWith(embeddedTokenTypesProvider.getName())) continue;
                this.myTokenType = embeddedTokenTypesProvider.getElementType();
            }
        } else if (super.getTokenType() == SlimTokenTypes.RUBY_CODE) {
            this.myTokenType = SlimLexer.getOuterLanguageTokenType();
        }
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            SlimLexer.$$$reportNull$$$0(1);
        }
        this.myTokenType = null;
        super.start(buffer, startOffset, endOffset, initialState);
        if (this.myDelegate.getTokenType() == SlimTokenTypes.RUBY_CODE) {
            this.myTokenType = SlimLexer.getOuterLanguageTokenType();
        }
    }

    public IElementType getTokenType() {
        if (this.myLexEmbeddedElements && this.myTokenType != null) {
            return this.myTokenType;
        }
        return super.getTokenType();
    }

    @Nullable
    public static IElementType getOuterLanguageTokenType() {
        if (myOuterLanguageTokenType == null) {
            for (EmbeddedTokenTypesProvider embeddedTokenTypesProvider : EmbeddedTokenTypesProvider.getProviders()) {
                if (!embeddedTokenTypesProvider.getName().equals("ruby-slim")) continue;
                myOuterLanguageTokenType = Ref.create((Object)embeddedTokenTypesProvider.getElementType());
            }
        }
        return myOuterLanguageTokenType != null ? (IElementType)myOuterLanguageTokenType.get() : null;
    }

    @TestOnly
    public static void setOuterLanguageTokenType(IElementType elementType) {
        myOuterLanguageTokenType.set((Object)elementType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/slim/lexer/SlimLexer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSlimFlexAdapter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/slim/lexer/SlimLexer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static final class SlimFlexAdapter
    extends FlexAdapter {
        private SlimFlexAdapter() {
            super((FlexLexer)new _SlimLexer(null));
        }

        @NotNull
        private _SlimLexer getSlimFlexLexer() {
            _SlimLexer _SlimLexer2 = (_SlimLexer)this.getFlex();
            if (_SlimLexer2 == null) {
                SlimFlexAdapter.$$$reportNull$$$0(0);
            }
            return _SlimLexer2;
        }

        public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
            if (buffer == null) {
                SlimFlexAdapter.$$$reportNull$$$0(1);
            }
            if (initialState == 0) {
                this.getSlimFlexLexer().resetInternals();
            }
            super.start(buffer, startOffset, endOffset, initialState);
        }

        public int getState() {
            int flexLexerState = super.getState();
            return flexLexerState == 0 && this.getSlimFlexLexer().isInternallyInitial() ? 0 : flexLexerState;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/slim/lexer/SlimLexer$SlimFlexAdapter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buffer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSlimFlexLexer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/slim/lexer/SlimLexer$SlimFlexAdapter";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "start";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }
}

