/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.slim.lexer;

import com.intellij.lexer.FlexLexer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.Stack;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.slim.psi.SlimLanguageLevel;
import org.jetbrains.plugins.slim.psi.SlimTokenTypes;
import org.jetbrains.plugins.slim.settings.SlimLanguageCodeStyleSettingsProvider;

public abstract class BaseSlimLexer
implements FlexLexer,
SlimTokenTypes {
    public static final String[] STRINGS_TO_MERGE = new String[]{"else", "elsif"};
    protected boolean isInEscapedInterpolation = false;
    protected boolean rubyComment = false;
    protected boolean rubyCodeExpected = false;
    protected int currentIndent = 0;
    protected int rubyCodeIndent = 0;
    protected char attrsListOpenBrace = '\u0000';
    protected char openBrace = '\u0000';
    protected char closeBrace = '\u0000';
    protected final Stack<Integer> stateStack = new Stack();
    protected IElementType filterType;
    protected SlimLanguageLevel mySlimLanguageLevel;
    protected static final Map<Character, Character> MATCHING_BRACES = Map.of(Character.valueOf('('), Character.valueOf(')'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('{'), Character.valueOf('}'));

    protected abstract char nextChar();

    protected abstract char nextNotWhitespaceChar();

    protected abstract boolean isFollowedByOneOfIdents(String[] var1);

    protected abstract int getCurrentIndent();

    protected abstract char charAt(int var1);

    protected abstract int nextIndentSize();

    protected abstract void readParens(boolean var1);

    protected abstract void readRubyTillSpace(char ... var1);

    public void setSlimLanguageLevel(@NotNull SlimLanguageLevel slimLanguageLevel) {
        if (slimLanguageLevel == null) {
            BaseSlimLexer.$$$reportNull$$$0(0);
        }
        this.mySlimLanguageLevel = slimLanguageLevel;
    }

    protected static int getTabSize() {
        return SlimLanguageCodeStyleSettingsProvider.TAB_SIZE;
    }

    protected final boolean rubyInjectionMustBeMerged() {
        if (this.rubyComment) {
            return true;
        }
        return this.isFollowedByOneOfIdents(STRINGS_TO_MERGE);
    }

    protected static boolean isRubyCodeStartMarker(char c) {
        return c == '-' | c == '=';
    }

    protected static int calcStringLength(CharSequence text) {
        int len = 0;
        int tabSize = BaseSlimLexer.getTabSize();
        for (int i = text.length() - 1; i >= 0; --i) {
            if (text.charAt(i) == '\t') {
                len += tabSize;
                continue;
            }
            ++len;
        }
        return len;
    }

    protected static int getIndentAtLoc(CharSequence s, int loc) {
        int tabSize = BaseSlimLexer.getTabSize();
        int currentIndent = 0;
        while (loc < s.length() && StringUtil.isWhiteSpace((char)s.charAt(loc))) {
            ++loc;
        }
        --loc;
        while (0 <= loc && s.charAt(loc) != '\n' && (loc == 0 || s.charAt(loc - 1) != '\\')) {
            char c = s.charAt(loc);
            currentIndent = c == '\t' ? (currentIndent += tabSize) : (StringUtil.isWhiteSpace((char)c) ? ++currentIndent : 0);
            --loc;
        }
        return currentIndent;
    }

    protected final char previousChar() {
        return this.charAt(-1);
    }

    protected final IElementType commentTypeByState() {
        return this.yystate() == 2 ? CODE_COMMENT : HTML_COMMENT;
    }

    protected final void yyBegin(int newState) {
        this.yybegin(newState);
    }

    protected final void yyPopState() {
        if (!this.stateStack.isEmpty()) {
            this.yyBegin((Integer)this.stateStack.pop());
        }
    }

    protected final void yyPushState(int newState) {
        this.stateStack.push((Object)newState);
    }

    protected static IElementType getFilterType(String filterName) {
        if (filterName != null) {
            if (filterName.startsWith("ruby")) {
                return RUBY_CODE;
            }
            if (filterName.startsWith("coffee")) {
                return COFFEE_CODE;
            }
            if (filterName.startsWith("javascript")) {
                return JAVASCRIPT_CODE;
            }
            if (filterName.startsWith("css")) {
                return CSS_CODE;
            }
            if (filterName.startsWith("sass")) {
                return SASS_CODE;
            }
            if (filterName.startsWith("scss")) {
                return SCSS_CODE;
            }
            if (filterName.startsWith("less")) {
                return LESS_CODE;
            }
            if (filterName.startsWith("styl")) {
                return STYLUS_CODE;
            }
        }
        return FILTER_CONTENT;
    }

    public final boolean isInternallyInitial() {
        return !this.isInEscapedInterpolation && !this.rubyComment && !this.rubyCodeExpected && this.currentIndent == 0 && this.rubyCodeIndent == 0 && this.attrsListOpenBrace == '\u0000' && this.openBrace == '\u0000' && this.closeBrace == '\u0000' && this.stateStack.isEmpty() || this.stateStack.size() == 1 && (Integer)this.stateStack.peek() == 0 && this.filterType == null;
    }

    protected final void resetInternals() {
        this.isInEscapedInterpolation = false;
        this.rubyComment = false;
        this.rubyCodeExpected = false;
        this.currentIndent = 0;
        this.rubyCodeIndent = 0;
        this.attrsListOpenBrace = '\u0000';
        this.openBrace = '\u0000';
        this.closeBrace = '\u0000';
        this.stateStack.clear();
        this.stateStack.push((Object)0);
        this.filterType = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "slimLanguageLevel", "org/jetbrains/plugins/slim/lexer/BaseSlimLexer", "setSlimLanguageLevel"));
    }
}

