/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.slim.annotator;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.slim.SlimBundle;
import org.jetbrains.plugins.slim.SlimHighlighter;
import org.jetbrains.plugins.slim.psi.SlimTokenTypes;
import org.jetbrains.plugins.slim.psi.SlimVisitor;
import org.jetbrains.plugins.slim.psi.impl.SlimAttrNameImpl;
import org.jetbrains.plugins.slim.psi.impl.SlimAttributeImpl;

final class SlimAnnotator
implements Annotator {
    SlimAnnotator() {
    }

    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            SlimAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            SlimAnnotator.$$$reportNull$$$0(1);
        }
        CodeStyleSettings settings = CodeStyle.getSettings((PsiFile)psiElement.getContainingFile());
        CommonCodeStyleSettings.IndentOptions options = settings.getIndentOptions();
        psiElement.accept((PsiElementVisitor)new SlimAnnotatorVisitor(holder, options.TAB_SIZE));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/slim/annotator/SlimAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class SlimAnnotatorVisitor
    extends PsiElementVisitor
    implements SlimVisitor {
        private final int myTabSize;
        private final AnnotationHolder myHolder;
        private final IElementType myIndentTokenType;
        private final IElementType myEolTokenType;
        private final TokenSet myCommentTypes;

        SlimAnnotatorVisitor(@NotNull AnnotationHolder holder, int tabSize) {
            if (holder == null) {
                SlimAnnotatorVisitor.$$$reportNull$$$0(0);
            }
            this.myHolder = holder;
            this.myIndentTokenType = SlimTokenTypes.INDENT;
            this.myEolTokenType = SlimTokenTypes.EOL;
            this.myCommentTypes = SlimTokenTypes.COMMENTS;
            this.myTabSize = tabSize;
        }

        public void visitFile(@NotNull PsiFile psiFile) {
            if (psiFile == null) {
                SlimAnnotatorVisitor.$$$reportNull$$$0(1);
            }
            int lastIndent = 0;
            int initialIndent = -1;
            PsiElement leaf = PsiTreeUtil.getDeepestFirst((PsiElement)psiFile);
            if (leaf instanceof PsiFile) {
                return;
            }
            PsiElement nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)leaf);
            if (leaf.getNode().getElementType() == this.myIndentTokenType) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, SlimBundle.message("slim.indentation.at.file.beginning", new Object[0])).range(leaf).create();
            }
            PsiElement psiElement = nextLeaf = (leaf = nextLeaf) != null ? PsiTreeUtil.nextLeaf((PsiElement)leaf) : null;
            while (leaf != null) {
                IElementType nextLeafType;
                IElementType leafType = leaf.getNode().getElementType();
                if (leafType == this.myIndentTokenType && nextLeaf != null && (nextLeafType = nextLeaf.getNode().getElementType()) != this.myEolTokenType && !this.myCommentTypes.contains(nextLeafType)) {
                    String currentIndentText = leaf.getText();
                    int currentIndentLength = this.getIndent(currentIndentText);
                    if (initialIndent < 0) {
                        lastIndent = currentIndentLength;
                        initialIndent = currentIndentLength;
                    } else {
                        int delta = currentIndentLength - lastIndent;
                        if (currentIndentLength % initialIndent != 0 || delta > initialIndent) {
                            if (delta < 0) {
                                delta += initialIndent;
                            }
                            String message = delta < initialIndent / 2 ? SlimBundle.message("slim.wrong.indentation.extra", delta, initialIndent) : SlimBundle.message("slim.wrong.indentation.missing", initialIndent - delta, initialIndent);
                            this.myHolder.newAnnotation(HighlightSeverity.WARNING, message).range(leaf).create();
                        }
                        lastIndent = currentIndentLength / initialIndent * initialIndent;
                    }
                }
                nextLeaf = (leaf = nextLeaf) != null ? PsiTreeUtil.nextLeaf((PsiElement)leaf) : null;
            }
            psiFile.acceptChildren((PsiElementVisitor)this);
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                SlimAnnotatorVisitor.$$$reportNull$$$0(2);
            }
            ProgressIndicatorProvider.checkCanceled();
            super.visitElement(element);
        }

        @Override
        public void visitSlimAttribute(SlimAttributeImpl attribute) {
            XmlElement element = attribute.getNameElement();
            if (element instanceof SlimAttrNameImpl) {
                SlimAttrNameImpl leaf = (SlimAttrNameImpl)element;
                int start = leaf.getStartOffset();
                TreeElement next = leaf.getTreeNext();
                int end = next != null && next.getElementType() == SlimTokenTypes.EQUALS ? next.getTextOffset() + next.getTextLength() : leaf.getStartOffset() + leaf.getTextLength();
                this.myHolder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(new TextRange(start, end)).textAttributes(SlimHighlighter.TAG_ATTR_KEY).create();
            }
        }

        private int getIndent(String text) {
            int length = text.length();
            int currentPos = 0;
            for (int i = 0; i < length; ++i) {
                if (text.charAt(i) != '\t') {
                    ++currentPos;
                    continue;
                }
                currentPos = (currentPos / this.myTabSize + 1) * this.myTabSize;
            }
            return currentPos;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/slim/annotator/SlimAnnotator$SlimAnnotatorVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

