/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.slim;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.slim.SlimOuterLanguageProvider;
import org.jetbrains.plugins.slim.lexer.SlimLexer;
import org.jetbrains.plugins.slim.parser.SlimParser;
import org.jetbrains.plugins.slim.psi.SlimFileElementType;
import org.jetbrains.plugins.slim.psi.SlimLanguageLevel;
import org.jetbrains.plugins.slim.psi.SlimTokenTypes;
import org.jetbrains.plugins.slim.psi.impl.SlimFileImpl;

public final class SlimParserDefinition
implements ParserDefinition {
    @NotNull
    public Lexer createLexer(Project project) {
        return new SlimLexer(SlimLanguageLevel.DEFAULT, true);
    }

    @NotNull
    public PsiParser createParser(Project project) {
        List<IElementType> containerTypes = null;
        Iterator<SlimOuterLanguageProvider> iterator = SlimOuterLanguageProvider.getProviders().iterator();
        if (iterator.hasNext()) {
            SlimOuterLanguageProvider factory = iterator.next();
            containerTypes = factory.getContainerElementTypes();
        }
        return new SlimParser(containerTypes);
    }

    @NotNull
    public IFileElementType getFileNodeType() {
        IFileElementType iFileElementType = SlimParserDefinition.getFileElementType();
        if (iFileElementType == null) {
            SlimParserDefinition.$$$reportNull$$$0(0);
        }
        return iFileElementType;
    }

    public static IFileElementType getFileElementType() {
        Iterator<SlimOuterLanguageProvider> iterator = SlimOuterLanguageProvider.getProviders().iterator();
        if (iterator.hasNext()) {
            SlimOuterLanguageProvider factory = iterator.next();
            return factory.getFileElementType();
        }
        return SlimFileElementType.SLIM_FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{SlimTokenTypes.WHITESPACE});
        if (tokenSet == null) {
            SlimParserDefinition.$$$reportNull$$$0(1);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{SlimTokenTypes.CODE_COMMENT, SlimTokenTypes.HTML_COMMENT, SlimTokenTypes.CONDITIONAL_COMMENT});
        if (tokenSet == null) {
            SlimParserDefinition.$$$reportNull$$$0(2);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{SlimTokenTypes.STATIC_CONTENT});
        if (tokenSet == null) {
            SlimParserDefinition.$$$reportNull$$$0(3);
        }
        return tokenSet;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        PsiElement psiElement = PsiUtilCore.NULL_PSI_ELEMENT;
        if (psiElement == null) {
            SlimParserDefinition.$$$reportNull$$$0(4);
        }
        return psiElement;
    }

    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            SlimParserDefinition.$$$reportNull$$$0(5);
        }
        return new SlimFileImpl(viewProvider);
    }

    @NotNull
    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode left, ASTNode right) {
        ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MAY;
        if (spaceRequirements == null) {
            SlimParserDefinition.$$$reportNull$$$0(6);
        }
        return spaceRequirements;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/slim/SlimParserDefinition";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNodeType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhitespaceTokens";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentTokens";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringLiteralElements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/slim/SlimParserDefinition";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "spaceExistenceTypeBetweenTokens";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 5 -> new IllegalArgumentException(string);
        };
    }
}

