/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.slim;

import com.intellij.codeInsight.generation.CommenterDataHolder;
import com.intellij.codeInsight.generation.IndentedCommenter;
import com.intellij.codeInsight.generation.SelfManagingCommenter;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.slim.SlimLanguage;
import org.jetbrains.plugins.slim.psi.impl.SlimFilterImpl;

public final class SlimCommenter
implements IndentedCommenter,
SelfManagingCommenter<SlimCommenterData> {
    @NonNls
    private static final String LINE_COMMENT_PREFIX = "/ ";

    @NotNull
    public String getLineCommentPrefix() {
        return LINE_COMMENT_PREFIX;
    }

    @Nullable
    public String getBlockCommentPrefix() {
        return null;
    }

    @Nullable
    public String getBlockCommentSuffix() {
        return null;
    }

    public String getCommentedBlockCommentPrefix() {
        return null;
    }

    public String getCommentedBlockCommentSuffix() {
        return null;
    }

    public Boolean forceIndentedLineComment() {
        return true;
    }

    @NotNull
    public SlimCommenterData createLineCommentingState(int startLine, int endLine, @NotNull Document document, @NotNull PsiFile file) {
        if (document == null) {
            SlimCommenter.$$$reportNull$$$0(0);
        }
        if (file == null) {
            SlimCommenter.$$$reportNull$$$0(1);
        }
        return new SlimCommenterData(startLine, endLine, document, file);
    }

    @Nullable
    public SlimCommenterData createBlockCommentingState(int selectionStart, int selectionEnd, @NotNull Document document, @NotNull PsiFile file) {
        if (document == null) {
            SlimCommenter.$$$reportNull$$$0(2);
        }
        if (file == null) {
            SlimCommenter.$$$reportNull$$$0(3);
        }
        return null;
    }

    public void commentLine(int line, int offset, @NotNull Document document, @NotNull SlimCommenterData data) {
        Language commenterLanguage;
        String commentPrefix;
        if (document == null) {
            SlimCommenter.$$$reportNull$$$0(4);
        }
        if (data == null) {
            SlimCommenter.$$$reportNull$$$0(5);
        }
        if ((commentPrefix = ((Commenter)LanguageCommenters.INSTANCE.forLanguage(commenterLanguage = data.getLanguages().get(line - data.getStartLineNumber()))).getLineCommentPrefix()) != null) {
            document.insertString(offset, (CharSequence)commentPrefix);
        }
    }

    public void uncommentLine(int line, int offset, @NotNull Document document, @NotNull SlimCommenterData data) {
        String commentPrefix;
        if (document == null) {
            SlimCommenter.$$$reportNull$$$0(6);
        }
        if (data == null) {
            SlimCommenter.$$$reportNull$$$0(7);
        }
        if ((commentPrefix = SlimCommenter.getLineCommentPrefixThatCommentsTheLine(line, offset, document, data)) != null) {
            document.deleteString(offset, offset + commentPrefix.length());
        }
    }

    public boolean isLineCommented(int line, int offset, @NotNull Document document, @NotNull SlimCommenterData data) {
        if (document == null) {
            SlimCommenter.$$$reportNull$$$0(8);
        }
        if (data == null) {
            SlimCommenter.$$$reportNull$$$0(9);
        }
        return SlimCommenter.getLineCommentPrefixThatCommentsTheLine(line, offset, document, data) != null;
    }

    @Nullable
    private static String getLineCommentPrefixThatCommentsTheLine(int line, int offset, @NotNull Document document, @NotNull SlimCommenterData data) {
        if (document == null) {
            SlimCommenter.$$$reportNull$$$0(10);
        }
        if (data == null) {
            SlimCommenter.$$$reportNull$$$0(11);
        }
        Language commenterLanguage = data.getLanguages().get(line - data.getStartLineNumber());
        String commentPrefix = ((Commenter)LanguageCommenters.INSTANCE.forLanguage(commenterLanguage)).getLineCommentPrefix();
        ArrayList<String> commentPrefixVariants = new ArrayList<String>();
        if (commentPrefix != null) {
            commentPrefixVariants.add(commentPrefix);
            if (commenterLanguage == SlimLanguage.INSTANCE) {
                commentPrefixVariants.add(commentPrefix.trim());
            }
        }
        for (String commentPrefixVariant : commentPrefixVariants) {
            if (!CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)offset, (CharSequence)commentPrefixVariant)) continue;
            return commentPrefixVariant;
        }
        return null;
    }

    @Nullable
    public String getCommentPrefix(int line, @NotNull Document document, @NotNull SlimCommenterData data) {
        if (document == null) {
            SlimCommenter.$$$reportNull$$$0(12);
        }
        if (data == null) {
            SlimCommenter.$$$reportNull$$$0(13);
        }
        return null;
    }

    @Nullable
    public TextRange getBlockCommentRange(int selectionStart, int selectionEnd, @NotNull Document document, @NotNull SlimCommenterData data) {
        if (document == null) {
            SlimCommenter.$$$reportNull$$$0(14);
        }
        if (data == null) {
            SlimCommenter.$$$reportNull$$$0(15);
        }
        return null;
    }

    @Nullable
    public String getBlockCommentPrefix(int selectionStart, @NotNull Document document, @NotNull SlimCommenterData data) {
        if (document == null) {
            SlimCommenter.$$$reportNull$$$0(16);
        }
        if (data == null) {
            SlimCommenter.$$$reportNull$$$0(17);
        }
        return null;
    }

    @Nullable
    public String getBlockCommentSuffix(int selectionEnd, @NotNull Document document, @NotNull SlimCommenterData data) {
        if (document == null) {
            SlimCommenter.$$$reportNull$$$0(18);
        }
        if (data == null) {
            SlimCommenter.$$$reportNull$$$0(19);
        }
        return null;
    }

    public void uncommentBlockComment(int startOffset, int endOffset, Document document, SlimCommenterData data) {
    }

    @NotNull
    public TextRange insertBlockComment(int startOffset, int endOffset, Document document, SlimCommenterData data) {
        return new TextRange(startOffset, endOffset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/slim/SlimCommenter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createLineCommentingState";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createBlockCommentingState";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "commentLine";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "uncommentLine";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isLineCommented";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineCommentPrefixThatCommentsTheLine";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getCommentPrefix";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "getBlockCommentRange";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "getBlockCommentPrefix";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "getBlockCommentSuffix";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @ApiStatus.Internal
    public static final class SlimCommenterData
    extends CommenterDataHolder {
        private final List<Language> myLanguages;
        private final int startLineNumber;

        SlimCommenterData(int startLine, int endLine, @NotNull Document document, @NotNull PsiFile file) {
            if (document == null) {
                SlimCommenterData.$$$reportNull$$$0(0);
            }
            if (file == null) {
                SlimCommenterData.$$$reportNull$$$0(1);
            }
            this.startLineNumber = startLine;
            this.myLanguages = new ArrayList<Language>();
            for (int i = startLine; i <= endLine; ++i) {
                int lineStartOffset = document.getLineStartOffset(i);
                PsiElement element = file.findElementAt(lineStartOffset);
                PsiElement filter = PsiTreeUtil.getParentOfType((PsiElement)element, SlimFilterImpl.class);
                if (filter != null) {
                    PsiElement filterContent = filter.getChildren()[1];
                    this.myLanguages.add(filterContent.getLanguage());
                    continue;
                }
                this.myLanguages.add(SlimLanguage.INSTANCE);
            }
        }

        public List<Language> getLanguages() {
            return this.myLanguages;
        }

        public int getStartLineNumber() {
            return this.startLineNumber;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "document";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/slim/SlimCommenter$SlimCommenterData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

