/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.impl.UnparsedValueKind;
import java.sql.Connection;
import java.sql.Driver;
import java.util.Properties;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VertJdbcHelper
extends JdbcHelperImpl {
    public VertJdbcHelper(@Nullable String version, @Nullable Connection connection, @Nullable ClassLoader jdbcClassLoader) {
        super("VERTICA", version, connection, jdbcClassLoader);
    }

    public VertJdbcHelper() {
        this(null, null, null);
    }

    private VertJdbcHelper(@NotNull VertJdbcHelper helper, @NotNull ClassLoader jdbcClassLoader) {
        if (helper == null) {
            VertJdbcHelper.$$$reportNull$$$0(0);
        }
        if (jdbcClassLoader == null) {
            VertJdbcHelper.$$$reportNull$$$0(1);
        }
        super(helper, jdbcClassLoader);
    }

    @Override
    @Nullable
    public UnparsedValueKind detectUnparsedValueKind(@Nullable String typeName, int jdbcType) {
        if ("timetz".equalsIgnoreCase(typeName)) {
            return UnparsedValueKind.ZONED_TIME;
        }
        if ("timestamptz".equalsIgnoreCase(typeName)) {
            return UnparsedValueKind.ZONED_TIMESTAMP;
        }
        return super.detectUnparsedValueKind(typeName, jdbcType);
    }

    @Override
    public int fixScale(int type, int precision, int scale) {
        if (type == 92) {
            return precision - 9;
        }
        return super.fixScale(type, precision, scale);
    }

    @Override
    public JdbcHelperImpl bindClassLoader(@NotNull ClassLoader jdbcClassLoader) {
        if (jdbcClassLoader == null) {
            VertJdbcHelper.$$$reportNull$$$0(2);
        }
        return new VertJdbcHelper(this, jdbcClassLoader);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return VertJdbcHelper.extractVersion(version);
    }

    @Nullable
    public static String extractVersion(@Nullable String version) {
        return JdbcNativeUtil.findVersion(version, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }

    @Override
    @Nullable
    public JdbcHelperImpl detect(@Nullable Connection delegate, @Nullable String product, @Nullable String productVer, @Nullable JdbcHelperImpl connectHelper, @Nullable ClassLoader jdbcClassLoader) {
        if (!JdbcNativeUtil.detectString(product, "vertica")) {
            return null;
        }
        JdbcNativeUtil.logInfo("getDatabaseProductName: " + product);
        return VertJdbcHelper.create(delegate, productVer, jdbcClassLoader);
    }

    @Override
    public boolean detect(@NotNull Driver driver, @Nullable String url) {
        if (driver == null) {
            VertJdbcHelper.$$$reportNull$$$0(3);
        }
        return VertJdbcHelper.classNameContains(driver, "com.vertica.");
    }

    @Override
    protected void setDriverLogLevel(Driver driver, Properties properties, @Nullable Level level, @Nullable String logPath) {
        super.setDriverLogLevel(driver, properties, level, logPath);
        VertJdbcHelper.setIfEmpty(properties, "LogNameSpace", "com.vertica");
        if (level != null) {
            VertJdbcHelper.setIfEmpty(properties, "LogLevel", level.intValue() >= Level.OFF.intValue() ? "OFF" : (level.intValue() >= Level.SEVERE.intValue() ? "ERROR" : (level.intValue() >= Level.WARNING.intValue() ? "WARNING" : (level.intValue() >= Level.INFO.intValue() ? "INFO" : (level.intValue() >= Level.FINE.intValue() ? "DEBUG" : "TRACE")))));
        }
        if (logPath != null) {
            VertJdbcHelper.setIfEmpty(properties, "LogPath", logPath);
        }
    }

    @NotNull
    static VertJdbcHelper create(@Nullable Connection delegate, @Nullable String productVer, @Nullable ClassLoader jdbcCLassLoader) {
        JdbcNativeUtil.logInfo("getDatabaseProductVersion: " + productVer);
        return new VertJdbcHelper(VertJdbcHelper.extractVersion(productVer), delegate, jdbcCLassLoader);
    }

    @Override
    public JdbcHelperImpl create(@Nullable String version, @Nullable Connection connection, @Nullable ClassLoader jdbcClassLoader) {
        return new VertJdbcHelper(version, connection, jdbcClassLoader);
    }

    @Override
    public boolean supportsIlike() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdbcClassLoader";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/VertJdbcHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "bindClassLoader";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "detect";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

