/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc;

import com.intellij.database.remote.jdbc.RemoteDriver;
import com.intellij.database.remote.jdbc.RemoteDriverFactory;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.RemoteLogHelper;
import com.intellij.database.remote.jdbc.helpers.RemoteLogStdRedirector;
import com.intellij.database.remote.jdbc.impl.JdbcClassLoader;
import com.intellij.database.remote.jdbc.impl.ReflectionHelper;
import com.intellij.database.remote.jdbc.impl.RemoteDriverImpl;
import com.intellij.database.remote.toolkit.RemoteDesktopActionsHandler;
import com.intellij.database.remote.toolkit.RemoteDesktopActionsHandlerImpl;
import com.intellij.execution.rmi.RemoteObject;
import com.intellij.execution.rmi.ssl.SslKeyStore;
import com.intellij.execution.rmi.ssl.SslTrustStore;
import java.io.File;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.sql.Driver;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.nativecerts.NativeTrustedCertificates;

public class RemoteDriverFactoryImpl
extends RemoteObject
implements RemoteDriverFactory {
    private final String driverClassName;
    private volatile RemoteDriver driver = null;
    private volatile ClassLoader jdbcClassLoader = null;
    private final Semaphore initLock = new Semaphore(1);
    private final AtomicBoolean logIsInitialized = new AtomicBoolean(false);
    private boolean shouldInitLogConnectionProperties = false;

    public RemoteDriverFactoryImpl(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    @Override
    public void setClassPath(List<String> classPath) throws RemoteException {
        if (this.jdbcClassLoader != null) {
            throw new RemoteException("Class path is already set");
        }
        this.jdbcClassLoader = JdbcClassLoader.getClassLoader(classPath);
    }

    @Override
    public boolean tryLockIfNotInitialized() throws RemoteException {
        if (this.jdbcClassLoader != null) {
            return false;
        }
        this.lock();
        if (this.jdbcClassLoader != null) {
            this.unlock();
            return false;
        }
        return true;
    }

    private void lock() throws RemoteException {
        try {
            this.initLock.acquire();
        }
        catch (InterruptedException e) {
            throw new RemoteException(e.getMessage(), this.wrapException(e));
        }
    }

    @Override
    public void unlock() throws RemoteException {
        this.initLock.release();
    }

    @Override
    public RemoteDriver getDriver() throws RemoteException {
        if (this.driver != null) {
            return this.driver;
        }
        this.lock();
        try {
            if (this.driver != null) {
                RemoteDriver remoteDriver = this.driver;
                return remoteDriver;
            }
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(JdbcClassLoader.createAppAndJdbcClassLoader(this.jdbcClassLoader));
            try {
                this.driver = (RemoteDriver)((Object)this.export((Remote)((Object)RemoteDriverImpl.wrap((Driver)ReflectionHelper.classForName(this.driverClassName, this.jdbcClassLoader).newInstance(), this.jdbcClassLoader, this.shouldInitLogConnectionProperties))));
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
            RemoteDriver remoteDriver = this.driver;
            return remoteDriver;
        }
        catch (Throwable e) {
            this.driver = null;
            throw new RemoteException(e.getMessage(), this.wrapException(e));
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void logStdOutAndErr() {
        RemoteLogStdRedirector.logStdOutAndErr();
    }

    @Override
    public boolean trySetLogConfig(String config, boolean shouldInitConnectionProperties) throws Exception {
        if (this.logIsInitialized.get()) {
            return false;
        }
        if (this.logIsInitialized.compareAndSet(false, true)) {
            RemoteLogHelper.loadConfig(config);
            this.shouldInitLogConnectionProperties = shouldInitConnectionProperties;
            return true;
        }
        return false;
    }

    @NotNull
    private static String certificates(int count) {
        String string = count == 1 ? "certificate" : count + " certificates";
        if (string == null) {
            RemoteDriverFactoryImpl.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public void loadTrustedCertificate(@NotNull String alias, @NotNull String certPath) throws Exception {
        if (alias == null) {
            RemoteDriverFactoryImpl.$$$reportNull$$$0(1);
        }
        if (certPath == null) {
            RemoteDriverFactoryImpl.$$$reportNull$$$0(2);
        }
        try {
            int count = SslTrustStore.appendUserCert((String)alias, (String)certPath);
            JdbcNativeUtil.logInfo("Loaded " + RemoteDriverFactoryImpl.certificates(count) + ": " + alias + " from " + certPath);
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage(), this.wrapException(e));
        }
    }

    @Override
    public void loadTrustedCertificates(@NotNull String storePath, char[] password) throws Exception {
        if (storePath == null) {
            RemoteDriverFactoryImpl.$$$reportNull$$$0(3);
        }
        try {
            int count = SslTrustStore.appendUserTrustStore((String)storePath, (char[])password);
            JdbcNativeUtil.logInfo("Loaded " + RemoteDriverFactoryImpl.certificates(count) + " truststore" + (password == null ? "" : "(password protected)") + " from " + storePath);
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage(), this.wrapException(e));
        }
    }

    @Override
    public void loadJavaTrustedCertificates() throws Exception {
        String path = System.getProperty("javax.net.ssl.trustStore");
        if (path == null) {
            JdbcNativeUtil.logInfo("No java truststore passed");
            return;
        }
        if (!new File(path).exists()) {
            JdbcNativeUtil.logInfo("Java truststore does not exist in " + path);
            return;
        }
        String password = System.getProperty("javax.net.ssl.trustStorePassword");
        try {
            int count = SslTrustStore.appendUserTrustStore((String)path, (char[])(password == null ? null : password.toCharArray()));
            JdbcNativeUtil.logInfo("Loaded " + RemoteDriverFactoryImpl.certificates(count) + " java truststore" + (password == null ? "" : "(password protected)") + " from " + path);
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage(), this.wrapException(e));
        }
    }

    @Override
    public void loadSystemTrustedCertificates() throws Exception {
        try {
            Collection systemCerts = NativeTrustedCertificates.getCustomOsSpecificTrustedCertificates();
            SslTrustStore.appendCertificates((String)"os-certificate", (Collection)systemCerts);
            JdbcNativeUtil.logInfo("Loaded " + RemoteDriverFactoryImpl.certificates(systemCerts.size()) + " system truststore");
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage(), this.wrapException(e));
        }
    }

    @Override
    public void loadUserCertificate(@NotNull String alias, @NotNull String keyPath, @Nullable String certPath, char[] keyPassword) throws Exception {
        if (alias == null) {
            RemoteDriverFactoryImpl.$$$reportNull$$$0(4);
        }
        if (keyPath == null) {
            RemoteDriverFactoryImpl.$$$reportNull$$$0(5);
        }
        try {
            SslKeyStore.loadKey((String)alias, (String)keyPath, (String)certPath, (char[])keyPassword);
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage(), this.wrapException(e));
        }
    }

    @Override
    public void loadUserCertificates(@NotNull String storePath, char[] password) throws Exception {
        if (storePath == null) {
            RemoteDriverFactoryImpl.$$$reportNull$$$0(6);
        }
        try {
            int count = SslKeyStore.appendUserKeyStore((String)storePath, (char[])password);
            JdbcNativeUtil.logInfo("Loaded " + RemoteDriverFactoryImpl.certificates(count) + " keystore" + (password == null ? "" : "(password protected)") + " from " + storePath);
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage(), this.wrapException(e));
        }
    }

    @Override
    public void setAuthenticatorPassword(final @NotNull String userName, final char[] password) throws Exception {
        if (userName == null) {
            RemoteDriverFactoryImpl.$$$reportNull$$$0(7);
        }
        try {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(userName, password);
                }
            });
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage(), this.wrapException(e));
        }
    }

    @Override
    public void setDesktopActionsHandler(RemoteDesktopActionsHandler handler) throws RemoteException {
        RemoteDesktopActionsHandlerImpl.setHandler(handler);
    }

    public void unreferenced() {
        System.exit(0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdbc/RemoteDriverFactoryImpl";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "certPath";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storePath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyPath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "certificates";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdbc/RemoteDriverFactoryImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadTrustedCertificate";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadTrustedCertificates";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadUserCertificate";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadUserCertificates";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setAuthenticatorPassword";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

