/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails;

import com.intellij.application.options.PredefinedCodeStyleUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ProjectGeneratorPeer;
import com.intellij.psi.codeStyle.PredefinedCodeStyle;
import icons.RubyIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.codeStyle.RailsOmakaseCodeStyle;
import org.jetbrains.plugins.ruby.rails.codeStyle.RailsOmakaseCodeStyleKt;
import org.jetbrains.plugins.ruby.rails.facet.BaseRailsFacetBuilder;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.facet.ui.wizard.RailsWizardSettings;
import org.jetbrains.plugins.ruby.rails.facet.versions.BaseRailsFacet;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.wizard.RailsGeneratorPeer;
import org.jetbrains.plugins.ruby.wizard.RubyFrameworkProjectGenerator;
import org.jetbrains.plugins.ruby.wizard.RubyWizardSharedSettings;

public class RailsProjectGenerator
extends RubyFrameworkProjectGenerator<RailsWizardSettings> {
    public static final String CODE_STYLE_NOTIFICATION_GROUP = "Ruby code style suggestions";
    public static final String SKIP_RUBOCOP_OPTION = "--skip-rubocop";

    @NotNull
    public String getName() {
        String string = RBundle.message((String)"rails.application.project.generator.name");
        if (string == null) {
            RailsProjectGenerator.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    protected ProjectGeneratorPeer<RailsWizardSettings> createPeer(@NotNull RubyWizardSharedSettings sharedSettings) {
        if (sharedSettings == null) {
            RailsProjectGenerator.$$$reportNull$$$0(1);
        }
        return new RailsGeneratorPeer(sharedSettings, RailsWizardSettings.RailsProjectTypes.RubyOnRails);
    }

    @NotNull
    public String getParentGroupName() {
        return "Rails";
    }

    @Nullable
    public Icon getLogo() {
        return RubyIcons.Rails.Rails;
    }

    public void generateProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull RailsWizardSettings settings, @NotNull Module module) {
        if (project == null) {
            RailsProjectGenerator.$$$reportNull$$$0(2);
        }
        if (baseDir == null) {
            RailsProjectGenerator.$$$reportNull$$$0(3);
        }
        if (settings == null) {
            RailsProjectGenerator.$$$reportNull$$$0(4);
        }
        if (module == null) {
            RailsProjectGenerator.$$$reportNull$$$0(5);
        }
        RModuleUtil.getInstance().changeModuleSdk(settings.getProjectSdk(), module);
        module.putUserData(RailsUtil.GENERATE_RAILS_VERSION, (Object)settings.getRailsVersion());
        BaseRailsFacet facet = RailsFacetUtil.configureRailsFacet((VirtualFile)baseDir, (Module)module);
        StartupManager.getInstance((Project)project).runAfterOpened(() -> {
            ModifiableRootModel rootModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
            BaseRailsFacetBuilder.setupGreenhornFacet((Module)module, (BaseRailsFacet)facet, (ModifiableRootModel)rootModel, (RailsWizardSettings)settings);
            ApplicationManager.getApplication().invokeLater(() -> rootModel.commit());
            RailsProjectGenerator.suggestRailsCodeStyle(project, settings);
        });
    }

    private static void suggestRailsCodeStyle(@NotNull Project project, @NotNull RailsWizardSettings settings) {
        if (project == null) {
            RailsProjectGenerator.$$$reportNull$$$0(6);
        }
        if (settings == null) {
            RailsProjectGenerator.$$$reportNull$$$0(7);
        }
        if (!RailsUtil.isRails8OrHigher((String)settings.getRailsVersion()) || settings.getAdditionalRailsOptions().contains(SKIP_RUBOCOP_OPTION)) {
            return;
        }
        RailsOmakaseCodeStyle codeStyle = RailsOmakaseCodeStyleKt.getInstance();
        if (PredefinedCodeStyleUtil.isCodeStyleSet((Project)project, (PredefinedCodeStyle)codeStyle)) {
            return;
        }
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup(CODE_STYLE_NOTIFICATION_GROUP);
        Notification notification = notificationGroup.createNotification(RBundle.message((String)"ruby.code.style.notification.title"), RBundle.message((String)"ruby.code.style.notification.content"), NotificationType.INFORMATION);
        notification.addAction((AnAction)NotificationAction.createSimpleExpiring((String)RBundle.message((String)"ruby.code.style.action.update"), () -> RailsProjectGenerator.lambda$suggestRailsCodeStyle$2(project, (PredefinedCodeStyle)codeStyle)));
        notification.notify(project);
    }

    private static /* synthetic */ void lambda$suggestRailsCodeStyle$2(Project project, PredefinedCodeStyle codeStyle) {
        PredefinedCodeStyleUtil.setCodeStylesToProject((Project)project, (PredefinedCodeStyle[])new PredefinedCodeStyle[]{codeStyle});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/RailsProjectGenerator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sharedSettings";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/RailsProjectGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createPeer";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "generateProject";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "suggestRailsCodeStyle";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

