/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.inspections;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.RubyVersionCallTypeProvider;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyFix;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.support.UIUtil;

public class RubyVersionInspection
extends LocalInspectionTool {
    @NonNls
    private static final String SHORT_NAME = "RubyVersionInspection";
    private String myGemfileVersion = null;

    @NotNull
    @Nls
    public String getGroupDisplayName() {
        String string = RBundle.message((String)"inspection.group.ruby.gems.name");
        if (string == null) {
            RubyVersionInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RubyVersionInspection.$$$reportNull$$$0(1);
        }
        return new RubyVersionVisitor(holder);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nullable
    private static String getSdkVersionNumber(Sdk sdk) {
        String fullVersion = sdk.getVersionString();
        if (fullVersion == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("^(\\w+\\.)([\\d\\.]+)(\\s)?.*");
        Matcher matcher = pattern.matcher(fullVersion);
        if (matcher.matches()) {
            return matcher.group(2);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/inspections/RubyVersionInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/inspections/RubyVersionInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private class RubyVersionVisitor
    extends RubyInspectionVisitor {
        RubyVersionVisitor(ProblemsHolder holder) {
            super(holder);
        }

        public void visitRCall(@NotNull RCall rCall) {
            PsiFile file;
            VirtualFile virtualFile;
            if (rCall == null) {
                RubyVersionVisitor.$$$reportNull$$$0(0);
            }
            if ((virtualFile = (file = rCall.getContainingFile()).getVirtualFile()) == null) {
                return;
            }
            if (!BundlerUtil.isGemfile((PsiFileSystemItem)file)) {
                return;
            }
            if (rCall.getCallType() != RubyVersionCallTypeProvider.RUBY_CALL) {
                return;
            }
            List arguments = (List)rCall.getData(new RubyCallType[0]);
            RubyVersionInspection.this.myGemfileVersion = (String)arguments.get(0);
            Module module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)rCall.getProject());
            Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
            if (sdk != null) {
                String currentVersion;
                if (sdk.getSdkType() instanceof RubySdkType && (currentVersion = RubyVersionInspection.getSdkVersionNumber(sdk)) != null && !currentVersion.equals(RubyVersionInspection.this.myGemfileVersion)) {
                    this.registerProblem((PsiElement)rCall, currentVersion, RubyVersionInspection.this.myGemfileVersion);
                }
            } else {
                this.registerProblem((PsiElement)rCall, RBundle.message((String)"gems.inspection.no.ruby.version.set", (Object[])new Object[]{RubyVersionInspection.this.myGemfileVersion}));
            }
        }

        private void registerProblem(PsiElement element, String currentVersion, String gemfileVersion) {
            this.registerProblem(element, RBundle.message((String)"gems.inspection.wrong.ruby.version", (Object[])new Object[]{currentVersion, gemfileVersion}), new LocalQuickFix[]{new RubySdkQuickFix()});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rCall", "org/jetbrains/plugins/ruby/inspections/RubyVersionInspection$RubyVersionVisitor", "visitRCall"));
        }
    }

    private class RubySdkQuickFix
    extends RubyFix {
        private RubySdkQuickFix() {
        }

        protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
            if (project == null) {
                RubySdkQuickFix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                RubySdkQuickFix.$$$reportNull$$$0(1);
            }
            Sdk[] jdks = ProjectJdkTable.getInstance().getAllJdks();
            ArrayList<Sdk> matchingSdks = new ArrayList<Sdk>();
            for (Sdk jdk : jdks) {
                String versionNumber;
                if (!(jdk.getSdkType() instanceof RubySdkType) || (versionNumber = RubyVersionInspection.getSdkVersionNumber(jdk)) == null || RubyVersionInspection.this.myGemfileVersion == null || !versionNumber.equals(RubyVersionInspection.this.myGemfileVersion)) continue;
                matchingSdks.add(jdk);
            }
            if (matchingSdks.isEmpty()) {
                Notifications.Bus.notify((Notification)new NoSdkMatchNotification("NoSdkNotificationId", RBundle.message((String)"gem.inspection.notification.no.matching.sdk", (Object[])new Object[]{RubyVersionInspection.this.myGemfileVersion}), RBundle.message((String)"gem.inspection.notification.no.matching.sdk.body"), NotificationType.WARNING));
            } else {
                SwingUtilities.invokeLater(() -> UIUtil.openRubyProjectSettings((Project)project));
            }
        }

        @NotNull
        @Nls
        public String getFamilyName() {
            String string = RBundle.message((String)"gems.inspection.ruby.version.fix.family.name");
            if (string == null) {
                RubySdkQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = RBundle.message((String)"gems.inspection.ruby.version.fix", (Object[])new Object[]{RubyVersionInspection.this.myGemfileVersion});
            if (string == null) {
                RubySdkQuickFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            if (project == null) {
                RubySdkQuickFix.$$$reportNull$$$0(4);
            }
            if (previewDescriptor == null) {
                RubySdkQuickFix.$$$reportNull$$$0(5);
            }
            return new IntentionPreviewInfo.Html(RBundle.message((String)"gems.inspection.ruby.version.fix.preview"));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/inspections/RubyVersionInspection$RubySdkQuickFix";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/inspections/RubyVersionInspection$RubySdkQuickFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }

        private static class NoSdkMatchNotification
        extends Notification {
            NoSdkMatchNotification(@NotNull String groupDisplayId, @NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @NotNull String content, @NotNull NotificationType type) {
                if (groupDisplayId == null) {
                    NoSdkMatchNotification.$$$reportNull$$$0(0);
                }
                if (title == null) {
                    NoSdkMatchNotification.$$$reportNull$$$0(1);
                }
                if (content == null) {
                    NoSdkMatchNotification.$$$reportNull$$$0(2);
                }
                if (type == null) {
                    NoSdkMatchNotification.$$$reportNull$$$0(3);
                }
                super(groupDisplayId, title, content, type);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "groupDisplayId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "title";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "content";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/ruby/inspections/RubyVersionInspection$RubySdkQuickFix$NoSdkMatchNotification";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

