/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.cli;

import com.intellij.codeInspection.AbstractInspectionCmdlineOptions;
import com.intellij.codeInspection.InspectionToolCmdlineOptions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import com.sampullara.cli.Argument;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.cli.RMInspectionToolLaunchSettings;
import org.jetbrains.plugins.ruby.version.management.rvm.RVMSupportUtil;

public class RubyMineCmdlineOptions
extends AbstractInspectionCmdlineOptions {
    @Argument(value="project", prefix="--", description="<directory_path> Project path. Current directory by default.")
    private String myProjectPath;
    @Argument(value="config", prefix="--", description="<file_path> Yaml configuration file.")
    private String myConfigFileName;
    @Argument(value="dir", prefix="--", description="<directory_path> Directory to be inspected. Whole project will be inspected by default.")
    private String myDirToInspect;
    @Argument(value="output", prefix="--", description="<file_path/directory_path> Inspection results path. By default STDOUT is used for plain formatter and <project_path>/results for other formatters.")
    private String myOutputPath;
    @Argument(value="format", prefix="--", description="<FORMAT> Report format. Supported: html, rubymine, plain. Will be ignored if --xslt option is specified. By default plain text report will be used.")
    private String myOutputFormatName;
    @Argument(value="xslt", prefix="--", description="<file.xsl> XSLT scheme.")
    private String myXSLTPath;
    @Argument(value="sdk", prefix="--", description="<file_path/rvm_interpreter_name> Ruby interpreter path or RVM interpreter name (e.g. ruby-1.8.7-p249@rails). Same interpreter as for launcher script by default.")
    private String myRubyInterpreterPathOrName;
    @Argument(value="profile", prefix="--", description="<file_path/name> Inspections profile name or file path.")
    private static final String myProfileNameOrPath = "Default";
    @Argument(value="gemfile", prefix="--", description="<file_path> Gemfile path. By default will be searched in project root.")
    private String myGemfilePath;
    @Argument(value="v", prefix="-", description="<level> Verbose output level from 1 to 3.")
    private Integer myVerboseLevel;
    @Argument(value="suppress-help", prefix="--", description="Allows to hide this cmdline options info.")
    private Boolean mySuppressHelp;
    private Boolean myRunWithEditorSettings;
    private Boolean myErrorCodeRequired;

    protected String getProfileNameOrPathProperty() {
        return myProfileNameOrPath;
    }

    protected String getProjectPathProperty() {
        return this.myProjectPath;
    }

    protected String getOutputPathProperty() {
        return this.myOutputPath;
    }

    protected String getDirToInspectProperty() {
        return this.myDirToInspect;
    }

    @Nullable
    protected String getOutputFormatProperty() {
        return this.myOutputFormatName != null ? this.myOutputFormatName : "plain";
    }

    @Nullable
    protected String getXSLTSchemePathProperty() {
        return this.myXSLTPath;
    }

    @Nullable
    public Boolean getErrorCodeRequiredProperty() {
        return this.myErrorCodeRequired;
    }

    @Nullable
    protected Boolean getRunWithEditorSettingsProperty() {
        return this.myRunWithEditorSettings;
    }

    protected String @NotNull [] optionsBanner() {
        String[] stringArray = new String[]{"Usage: rinspect [options]", "", "Examples:", "  rinspect --dir features -v", "    Considers current folder as project and launches inspections for 'features' subfolder.", "", "  rinspect --dir features --sdk ruby-1.8.7-p249@my_gemset --project ~/my_project", "    Launches inspections for 'my_project' project with ruby-1.8.7-p249@my_gemset ruby interpreter", "", "", "Options:"};
        if (stringArray == null) {
            RubyMineCmdlineOptions.$$$reportNull$$$0(0);
        }
        return stringArray;
    }

    @Nullable
    private String getDefaultGemfilePath() {
        String projectPath = this.determineProjectPath();
        String defaultGemfilePath = null;
        File projectDir = new File(projectPath);
        File[] files = projectDir.listFiles();
        if (files == null) {
            return null;
        }
        for (File file : files) {
            if (file.isDirectory() || !"gemfile".equals(StringUtil.toLowerCase((String)file.getName()))) continue;
            defaultGemfilePath = projectPath + "/" + file.getName();
            break;
        }
        return defaultGemfilePath;
    }

    public boolean suppressHelp() {
        return this.mySuppressHelp != null && this.mySuppressHelp != false;
    }

    @Nullable
    private static String getDefaultRubyInterpreterPath() {
        return RVMSupportUtil.getCurrentRvmSdkName();
    }

    public int getVerboseLevelProperty() {
        return this.myVerboseLevel != null ? this.myVerboseLevel : 0;
    }

    public void validate() throws InspectionToolCmdlineOptions.CmdlineArgsValidationException {
        super.validate();
        String gemfilePath = this.determineGemfilePath();
        if (gemfilePath == null) {
            this.mySuppressHelp = true;
            throw new InspectionToolCmdlineOptions.CmdlineArgsValidationException("Gemfile not found.");
        }
        if (!new File(gemfilePath).exists()) {
            this.mySuppressHelp = true;
            throw new InspectionToolCmdlineOptions.CmdlineArgsValidationException("Gemfile '" + gemfilePath + "' not found.");
        }
        String rubyInterpreterPath = this.determineRubyInterpreterPath();
        if (rubyInterpreterPath == null) {
            this.mySuppressHelp = true;
            throw new InspectionToolCmdlineOptions.CmdlineArgsValidationException("Ruby interpreter isn't specified.");
        }
    }

    public void beforeStartup() {
        RMInspectionToolLaunchSettings settings = RMInspectionToolLaunchSettings.getInstance();
        String gemFilePath = this.determineGemfilePath();
        assert (gemFilePath != null);
        settings.setGemFilePath(gemFilePath);
        String rubyInterpreterPathOrName = this.determineRubyInterpreterPath();
        assert (rubyInterpreterPathOrName != null);
        if (this.myRubyInterpreterPathOrName == null) {
            this.log("Default Ruby Interpreter detected: " + rubyInterpreterPathOrName);
        }
        settings.setRubyInterpreterPath(rubyInterpreterPathOrName);
        settings.setVerboseLevel(this.getVerboseLevelProperty());
    }

    private void log(String msg) {
        if (this.getVerboseLevelProperty() > 0) {
            System.out.println(msg);
        }
    }

    @Nullable
    private String determineRubyInterpreterPath() {
        return this.myRubyInterpreterPathOrName != null ? this.myRubyInterpreterPathOrName : RubyMineCmdlineOptions.getDefaultRubyInterpreterPath();
    }

    @Nullable
    private String determineGemfilePath() {
        return this.myGemfilePath != null ? this.myGemfilePath : this.getDefaultGemfilePath();
    }

    protected String getDefaultProjectPath() {
        return EnvironmentUtil.getValue((String)"DEFAULT_PROJECT_PATH");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/cli/RubyMineCmdlineOptions", "optionsBanner"));
    }
}

