/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class ProjectSettingsPatcher
implements ModuleListener {
    private static final Logger LOG = Logger.getInstance(ProjectSettingsPatcher.class);

    ProjectSettingsPatcher() {
    }

    public void modulesAdded(@NotNull Project project, @NotNull List<? extends Module> modules) {
        if (project == null) {
            ProjectSettingsPatcher.$$$reportNull$$$0(0);
        }
        if (modules == null) {
            ProjectSettingsPatcher.$$$reportNull$$$0(1);
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)project);
        boolean isPatched = propertiesComponent.getBoolean("project.settings.patched");
        int nModules = ModuleManager.getInstance((Project)project).getModules().length;
        if (LOG.isDebugEnabled()) {
            LOG.debug("patching project's settings: project " + project.getName() + ", already patched = " + isPatched + ", nModules = " + nModules);
        }
        if (!isPatched && nModules > 1) {
            ChangesViewManager.getInstance((Project)project).setGrouping("directory");
            propertiesComponent.setValue("project.settings.patched", true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "modules";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/ruby/ProjectSettingsPatcher";
        objectArray[2] = "modulesAdded";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

