/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.registry.Registry;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ModuleRunConfigurationManager")
final class ModuleRunConfigurationManager
implements PersistentStateComponent<Element>,
Disposable.Default {
    private static final String SHARED = "shared";
    private static final String LOCAL = "local";
    private static final Logger LOG = Logger.getInstance(ModuleRunConfigurationManager.class);
    @NotNull
    private final Module myModule;
    @NotNull
    private final Predicate<RunnerAndConfigurationSettings> myModuleConfigCondition;

    ModuleRunConfigurationManager(@NotNull Module module) {
        if (module == null) {
            ModuleRunConfigurationManager.$$$reportNull$$$0(0);
        }
        this.myModuleConfigCondition = settings -> settings != null && this.usesMyModule((RunnerAndConfigurationSettings)settings);
        this.myModule = module;
        this.myModule.getProject().getMessageBus().connect((Disposable)this).subscribe(ModuleListener.TOPIC, (Object)new ModuleListener(){

            public void beforeModuleRemoved(@NotNull Project project, @NotNull Module module) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (module == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (ModuleRunConfigurationManager.this.myModule.equals(module)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("time to remove something from project (" + String.valueOf(project) + ")");
                    }
                    ModuleRunConfigurationManager.this.getRunManager().removeConfigurations((Collection)ModuleRunConfigurationManager.this.getModuleRunConfigurationSettings().collect(Collectors.toList()));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "module";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/ruby/ModuleRunConfigurationManager$1";
                objectArray[2] = "beforeModuleRemoved";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Nullable
    public Element getState() {
        try {
            Element element = new Element("state").addContent(this.writeExternal(new Element(SHARED), true));
            if (Registry.is((String)"ruby.store.local.run.conf.in.modules", (boolean)false)) {
                element.addContent(this.writeExternal(new Element(LOCAL), false));
            }
            return element;
        }
        catch (WriteExternalException e1) {
            LOG.error((Throwable)e1);
            return null;
        }
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            ModuleRunConfigurationManager.$$$reportNull$$$0(1);
        }
        try {
            this.readExternal(state);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    private Stream<RunnerAndConfigurationSettings> getModuleRunConfigurationSettings() {
        Stream<RunnerAndConfigurationSettings> stream = this.getRunManager().getAllSettings().stream().filter(this.myModuleConfigCondition);
        if (stream == null) {
            ModuleRunConfigurationManager.$$$reportNull$$$0(2);
        }
        return stream;
    }

    @NotNull
    private RunManagerImpl getRunManager() {
        RunManagerImpl runManagerImpl = (RunManagerImpl)RunManager.getInstance((Project)this.myModule.getProject());
        if (runManagerImpl == null) {
            ModuleRunConfigurationManager.$$$reportNull$$$0(3);
        }
        return runManagerImpl;
    }

    private boolean usesMyModule(@NotNull RunnerAndConfigurationSettings runnerAndConfigurationSettings) {
        if (runnerAndConfigurationSettings == null) {
            ModuleRunConfigurationManager.$$$reportNull$$$0(4);
        }
        if (runnerAndConfigurationSettings.isStoredInArbitraryFileInProject()) {
            return false;
        }
        RunConfiguration config = runnerAndConfigurationSettings.getConfiguration();
        return config instanceof ModuleBasedConfiguration && this.myModule.equals(((ModuleBasedConfiguration)config).getConfigurationModule().getModule());
    }

    public Element writeExternal(@NotNull Element element, boolean isShared) throws WriteExternalException {
        if (element == null) {
            ModuleRunConfigurationManager.$$$reportNull$$$0(5);
        }
        LOG.debug("writeExternal(" + String.valueOf(this.myModule) + "); shared: " + isShared);
        this.getRunManager().writeConfigurations(element, (Collection)this.getModuleRunConfigurationSettings().filter(settings -> settings.isStoredInDotIdeaFolder() == isShared).collect(Collectors.toList()));
        return element;
    }

    public void readExternal(@NotNull Element element) {
        Element localElement;
        Element sharedElement;
        if (element == null) {
            ModuleRunConfigurationManager.$$$reportNull$$$0(6);
        }
        if ((sharedElement = element.getChild(SHARED)) != null) {
            this.doReadExternal(sharedElement, true);
        }
        if ((localElement = element.getChild(LOCAL)) != null) {
            this.doReadExternal(localElement, false);
        }
    }

    private void doReadExternal(@NotNull Element element, boolean isShared) {
        if (element == null) {
            ModuleRunConfigurationManager.$$$reportNull$$$0(7);
        }
        LOG.debug("readExternal(" + String.valueOf(this.myModule) + ");  shared: " + isShared);
        RunManagerImpl runManager = this.getRunManager();
        for (Element child : element.getChildren("configuration")) {
            runManager.loadConfiguration(child, isShared);
        }
        runManager.requestSort();
    }

    @NotNull
    public static ModuleRunConfigurationManager getInstance(@NotNull Module module) {
        if (module == null) {
            ModuleRunConfigurationManager.$$$reportNull$$$0(8);
        }
        ModuleRunConfigurationManager moduleRunConfigurationManager = (ModuleRunConfigurationManager)module.getService(ModuleRunConfigurationManager.class);
        if (moduleRunConfigurationManager == null) {
            ModuleRunConfigurationManager.$$$reportNull$$$0(9);
        }
        return moduleRunConfigurationManager;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ModuleRunConfigurationManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerAndConfigurationSettings";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ModuleRunConfigurationManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleRunConfigurationSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunManager";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "usesMyModule";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doReadExternal";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 9 -> new IllegalStateException(string);
        };
    }
}

