/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.ruby.compose;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.agent.DockerAgentContainer;
import com.intellij.docker.agent.compose.beans.RestartPolicy;
import com.intellij.docker.compose.service.DockerComposeServiceClient;
import com.intellij.docker.compose.service.commands.ComposeServiceRunCmd;
import com.intellij.docker.remote.DockerComposeContainerUtil;
import com.intellij.docker.remote.DockerComposeCredentialsHolder;
import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.DockerProcessUtil;
import com.intellij.docker.remote.compose.process.DockerComposeProcessUtil;
import com.intellij.docker.remote.ruby.RubyDockerProcessUtil;
import com.intellij.docker.remote.ruby.RubyDockerRemoteTransfer;
import com.intellij.docker.remote.ruby.compose.RubyDockerComposeProcessConnectionData;
import com.intellij.docker.remote.ruby.compose.RubyDockerComposeProcessUtil;
import com.intellij.docker.remote.ruby.settings.RubyDockerSettings;
import com.intellij.docker.remote.run.common.VolumesBuilder;
import com.intellij.docker.remoteRunRuntime.RemoteDockerApplicationRuntime;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.jetbrains.plugins.remotesdk.RemoteTransfer;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkAdditionalData;
import org.jetbrains.plugins.ruby.remote.impl.RubyDockerHelpersTransferConfig;

public class RubyDockerComposeRemoteTransfer
extends RubyDockerRemoteTransfer {
    private static final Logger LOG = Logger.getInstance(RubyDockerComposeRemoteTransfer.class);
    private final RubyDockerComposeProcessConnectionData myDockerConnData;

    protected RubyDockerComposeRemoteTransfer(@Nullable Project project, @NotNull RubyRemoteSdkAdditionalData data) {
        if (data == null) {
            RubyDockerComposeRemoteTransfer.$$$reportNull$$$0(0);
        }
        super(project, null, (RemoteTransfer.HelpersTransferConfig)new RubyDockerHelpersTransferConfig(), data);
        DockerComposeCredentialsHolder credentialsHolder = RubyDockerComposeProcessUtil.getDockerComposeCredentialsHolder(data);
        this.myDockerConnData = new RubyDockerComposeProcessConnectionData((RemoteSdkAdditionalData)data, credentialsHolder);
    }

    @Override
    public void beforeRemoteSdkRemoved(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubyDockerComposeRemoteTransfer.$$$reportNull$$$0(1);
        }
        RubyDockerComposeProcessUtil.removeRubyMineGemsVolume(sdk, this.getProject(), this.myDockerConnData);
    }

    @Override
    @NotNull
    protected RemoteDockerApplicationRuntime getDockerRuntimeForGemSync(@NotNull Sdk sdk) throws RemoteSdkException {
        RemoteDockerApplicationRuntime remoteDockerApplicationRuntime;
        if (sdk == null) {
            RubyDockerComposeRemoteTransfer.$$$reportNull$$$0(2);
        }
        Project project = this.getProject();
        DockerCloudConfiguration account = this.myDockerConnData.getAccount();
        RemoteDockerRuntime dockerRuntime = RubyDockerProcessUtil.createDockerRuntime(account, project);
        if (RubyDockerSettings.getGemsCopyMode() == RubyDockerSettings.RubyDockerGemsCopyMode.RUNNING_CONTAINER_OR_IMAGE) {
            DockerComposeCredentialsHolder credentials = this.myDockerConnData.getCredentials();
            DockerAgentContainer container = DockerComposeContainerUtil.findContainerByServiceName((RemoteDockerRuntime)dockerRuntime, (DockerComposeCredentialsHolder)credentials);
            if (container != null) {
                LOG.debug("Found a running container for gems syncing: ", new Object[]{container.getContainerId()});
                RemoteDockerApplicationRuntime remoteDockerApplicationRuntime2 = RemoteDockerApplicationRuntime.create((RemoteDockerRuntime)dockerRuntime, (DockerAgentContainer)container);
                if (remoteDockerApplicationRuntime2 == null) {
                    RubyDockerComposeRemoteTransfer.$$$reportNull$$$0(3);
                }
                return remoteDockerApplicationRuntime2;
            }
            LOG.debug("Can't find a container to copy gems from, will copy gems from a new one");
        }
        DockerContainerSettings containerSettings = project != null ? DockerContainerSettings.defaultSettings((Project)project) : null;
        VolumesBuilder volumesBinds = DockerProcessUtil.setupVolumesBinds(null, (DockerContainerSettings)containerSettings);
        RubyRemoteSdkAdditionalData additionalData = RubyRemoteSdkAdditionalData.notNullFrom((Sdk)sdk);
        Map<String, String> envs = this.myDockerConnData.getEnvs();
        RubyDockerComposeProcessUtil.addRubyMineGemsVolume(volumesBinds, additionalData, project, envs, this.myDockerConnData, true);
        DockerComposeServiceClient serviceClient = DockerComposeServiceClient.getInstance((RemoteDockerRuntime)dockerRuntime);
        ComposeServiceRunCmd runServiceCmd = (ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)serviceClient.runServiceCmd().withConfigurationPath(this.myDockerConnData.getComposeFilePaths())).withEnvs(envs)).withServiceName(this.myDockerConnData.getComposeServiceName())).withCommand(new String[]{"/bin/true"})).withRestartPolicy((RestartPolicy)RestartPolicy.noRestart())).withVolumes(volumesBinds.build());
        try {
            String serviceContainerNameOrId = runServiceCmd.execDetached();
            remoteDockerApplicationRuntime = DockerComposeProcessUtil.getDockerComposeContainer((RemoteDockerRuntime)dockerRuntime, (String)serviceContainerNameOrId);
        }
        catch (ExecutionException | ServerRuntimeException | IOException e) {
            throw new RemoteSdkException(e.getMessage(), e);
        }
        if (remoteDockerApplicationRuntime == null) {
            RubyDockerComposeRemoteTransfer.$$$reportNull$$$0(4);
        }
        return remoteDockerApplicationRuntime;
    }

    @Override
    @Nullable
    protected String getMachineName() throws RemoteSdkException {
        return this.myDockerConnData.getAccount().getMachine();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/ruby/compose/RubyDockerComposeRemoteTransfer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/ruby/compose/RubyDockerComposeRemoteTransfer";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDockerRuntimeForGemSync";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "beforeRemoteSdkRemoved";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDockerRuntimeForGemSync";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

