/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.ruby.compose;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.agent.DockerAgentContainer;
import com.intellij.docker.agent.cli.compose.AbstractDockerComposeCmdCliBuilder;
import com.intellij.docker.agent.cli.model.DockerExecCommandCliBuilder;
import com.intellij.docker.agent.compose.beans.DefinedDockerComposePort;
import com.intellij.docker.agent.compose.beans.DockerComposeConfiguration;
import com.intellij.docker.agent.compose.beans.DockerComposePort;
import com.intellij.docker.agent.compose.beans.v2.DockerComposeConfigurationV2;
import com.intellij.docker.agent.compose.beans.v2.DockerComposeServiceV2;
import com.intellij.docker.agent.compose.cli.DockerComposeDownCliBuilder;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.compose.cli.DockerComposeCliUtil;
import com.intellij.docker.compose.configuration.beans.parse.DockerComposeFileConfigurationProvider;
import com.intellij.docker.compose.service.DockerComposeServiceClient;
import com.intellij.docker.compose.service.commands.AbstractServiceCmd;
import com.intellij.docker.compose.service.commands.ComposeServiceExecCmd;
import com.intellij.docker.compose.service.commands.ComposeServiceRunCmd;
import com.intellij.docker.compose.service.commands.ComposeServiceUpCmd;
import com.intellij.docker.remote.DockerComposeContainerUtil;
import com.intellij.docker.remote.DockerComposeCredentialsCase;
import com.intellij.docker.remote.DockerComposeCredentialsHolder;
import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.DockerProcessUtil;
import com.intellij.docker.remote.compose.DockerComposeVersionProvider;
import com.intellij.docker.remote.ruby.RubyDockerBundle;
import com.intellij.docker.remote.ruby.RubyDockerProcessUtil;
import com.intellij.docker.remote.ruby.RubyDockerRunner;
import com.intellij.docker.remote.ruby.RubyDockerUtil;
import com.intellij.docker.remote.ruby.RubyDockerVolumeUtil;
import com.intellij.docker.remote.ruby.compose.RubyDockerComposeExecutionData;
import com.intellij.docker.remote.ruby.compose.RubyDockerComposeProcessConnectionData;
import com.intellij.docker.remote.ruby.compose.RubyDockerComposeRunner;
import com.intellij.docker.remote.ruby.compose.RubyDockerComposeUtil;
import com.intellij.docker.remote.ruby.run.RubyDockerComposeCommandType;
import com.intellij.docker.remote.ruby.run.RubyDockerRunConfigurationExtension;
import com.intellij.docker.remote.ruby.run.RubyDockerRunConfigurationSettings;
import com.intellij.docker.remote.ruby.settings.RubyDockerSettings;
import com.intellij.docker.remote.run.common.VolumesBuilder;
import com.intellij.docker.remote.run.runtime.DockerUtil;
import com.intellij.docker.remoteRunRuntime.RemoteDockerApplicationRuntime;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.docker.remoteRunRuntime.WrappedInternalServerErrorException;
import com.intellij.docker.utils.DockerCliUtilsKt;
import com.intellij.docker.utils.DockerUtils;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteConnectionCredentialsWrapper;
import com.intellij.remote.RemoteProcessUtil;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.AbstractPathMapper;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.console.RubyConsoleProcessHandler;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkAdditionalData;
import org.jetbrains.plugins.ruby.remote.impl.RubyRemoteRunner;
import org.jetbrains.plugins.ruby.remote.impl.RubySshRemoteTransfer;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.run.PortForwarding;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLine;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyCommandLineData;
import org.jetbrains.plugins.ruby.ruby.run.configuration.debugger.RubyDebugIdeGemHelper;
import org.jetbrains.plugins.ruby.util.StreamUtil;
import org.jetbrains.plugins.ruby.utils.RubyUIUtil;

public final class RubyDockerComposeProcessUtil {
    private static final Logger LOG = Logger.getInstance(RubyDockerComposeProcessUtil.class);
    private static final String OPT_PATH = "/opt";
    private static final String RUBYMINE_HELPERS_RELATIVE_PATH = ".rubymine_helpers" + File.separator + "rb";
    private static final String RUBYMINE_SDK_CONTAINER = "RUBYMINE_SDK_CONTAINER_";
    private static final String[] PERPETUAL_COMMAND = new String[]{"tail", "-f", "/dev/null"};
    public static final Key<RubyDockerComposeExecutionData> DOCKER_COMPOSE_EXECUTION_DATA_KEY = new Key("DockerComposeExecutionDataKey");

    @NotNull
    public static ProcessHandler startDockerComposeConsole(@NotNull RubyCommandLine commandLine, @NotNull AbstractPathMapper pathMapper) throws RemoteSdkException {
        if (commandLine == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(0);
        }
        if (pathMapper == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(1);
        }
        return RubyDockerComposeProcessUtil.createDockerCommandLine(commandLine, pathMapper, false, true);
    }

    @NotNull
    public static ProcessHandler startDockerComposeProcess(@NotNull RubyCommandLine commandLine, @NotNull AbstractPathMapper pathMapper) throws RemoteSdkException {
        if (commandLine == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(2);
        }
        if (pathMapper == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(3);
        }
        ProcessHandler result = RubyDockerComposeProcessUtil.createDockerCommandLine(commandLine, pathMapper, !commandLine.isAllocatePty(), false);
        result.putUserData(RubyCommandLineData.COMMAND_LINE_KEY, (Object)commandLine);
        ProcessHandler processHandler = result;
        if (processHandler == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(4);
        }
        return processHandler;
    }

    @NotNull
    private static ProcessHandler createDockerCommandLine(@NotNull RubyCommandLine commandLine, @NotNull AbstractPathMapper pathMapper, boolean noPty, boolean isConsole) throws RemoteSdkException {
        ProcessHandler processHandler;
        if (commandLine == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(5);
        }
        if (pathMapper == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(6);
        }
        try {
            PathMappingSettings pathMappingSettings;
            RubyDockerComposeRunner runner = (RubyDockerComposeRunner)commandLine.getRunner();
            RubyDockerComposeExecutionData dockerComposeData = (RubyDockerComposeExecutionData)commandLine.getUserData(DOCKER_COMPOSE_EXECUTION_DATA_KEY);
            if (dockerComposeData == null) {
                dockerComposeData = RubyDockerComposeProcessUtil.buildExecutionData(commandLine, null, runner.getModule(), runner.getSdkAdditionalData());
            }
            if ((pathMappingSettings = RubyDockerRunner.getCommandLinePathMapping(commandLine)) != null) {
                pathMapper = pathMappingSettings;
            }
            RubyCommandLineData rubyCommandLineData = (RubyCommandLineData)commandLine.getUserData(RubyCommandLine.COMMAND_LINE_DATA_KEY);
            List<DockerComposePort> dockerComposePorts = RubyDockerComposeProcessUtil.getPorts(rubyCommandLineData);
            List commandList = commandLine.getCommandLineList(commandLine.getExePath());
            File workDir = commandLine.getWorkDirectory();
            String workDirPath = workDir != null ? RemoteProcessUtil.toRemoteFileSystemStyle((String)workDir.getPath()) : null;
            String remoteWorkDirPath = workDirPath != null ? pathMapper.convertToRemote(workDirPath) : null;
            String beforeTask = (String)commandLine.getUserData(RubyDockerRunConfigurationExtension.BEFORE_TASK_KEY);
            if (beforeTask != null) {
                RubyDockerComposeProcessUtil.patchCommandListWithBeforeTask(commandList, beforeTask);
            }
            String[] remoteCommand = RemoteProcessUtil.buildRemoteCommand((AbstractPathMapper)pathMapper, (Collection)commandList);
            dockerComposeData.withRemoteCommand(remoteCommand).withRemoteWorkingDir(remoteWorkDirPath).withNoPty(noPty).withEnvironment(commandLine.getEnvironment()).withPorts(dockerComposePorts).withBlockingRead(commandLine.isWithBlockingRead()).withOriginalCommandLineString(commandLine.getCommandLineString());
            DockerCloudConfiguration account = dockerComposeData.getConnectionData().getAccount();
            RemoteDockerRuntime dockerRuntime = RubyDockerProcessUtil.createDockerRuntime(account, dockerComposeData.getProject());
            RubyDockerComposeCommandType commandType = dockerComposeData.getCommandType();
            DockerComposeServiceClient client = DockerComposeServiceClient.getInstance((RemoteDockerRuntime)dockerRuntime);
            processHandler = commandType.buildDockerCommandLineAndExecute(dockerComposeData, dockerRuntime, client, isConsole);
        }
        catch (WrappedInternalServerErrorException e) {
            LOG.warn("Docker compose process creation failed: " + e.getMessage());
            throw DockerUtil.propagateInternalServerErrorException((ServerRuntimeException)((Object)e));
        }
        catch (ExecutionException | ServerRuntimeException | IOException e) {
            LOG.warn("Docker compose process creation failed: " + e.getMessage());
            throw DockerUtil.propagateRemoteSdkException((Throwable)e);
        }
        if (processHandler == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(7);
        }
        return processHandler;
    }

    @NotNull
    public static List<DockerComposePort> getPorts(@Nullable RubyCommandLineData rubyCommandLineData) {
        Collection portForwardings = rubyCommandLineData != null ? (Collection)rubyCommandLineData.getUserData(RubyCommandLineData.PORT_FORWARDING_KEY) : null;
        RubyRunner runner = (RubyRunner)ObjectUtils.doIfNotNull((Object)rubyCommandLineData, it -> (RubyRunner)it.getUserData(RubyCommandLineData.RUNNER_KEY));
        List<Object> excludedPortRanges = runner != null ? RubyDockerComposeProcessUtil.getPortsFromConfigFiles(runner) : Collections.emptyList();
        ArrayList<DockerComposePort> dockerComposePorts = new ArrayList<DockerComposePort>();
        if (portForwardings != null) {
            for (PortForwarding portForwarding : portForwardings) {
                if (portForwarding.getDirection() != PortForwarding.Direction.REMOTE_TO_LOCAL || ContainerUtil.exists(excludedPortRanges, portRange -> portRange.contains(portForwarding.getRemotePort()))) continue;
                DockerComposePort dockerComposePort = new DockerComposePort(RubyDockerProcessUtil.PORT_BINDING_HOST_IP, Integer.valueOf(portForwarding.getLocalPort()), Integer.valueOf(portForwarding.getRemotePort()));
                dockerComposePorts.add(dockerComposePort);
            }
        }
        ArrayList<DockerComposePort> arrayList = dockerComposePorts;
        if (arrayList == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    public static RubyConsoleProcessHandler createDockerRubyConsoleProcess(@NotNull RubyDockerComposeExecutionData cmdData, @NotNull GeneralCommandLine cmdLine) throws ExecutionException {
        if (cmdData == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(9);
        }
        if (cmdLine == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(10);
        }
        return new RubyConsoleProcessHandler(cmdLine.createProcess(), cmdData.getOriginalCommandLineString(), cmdData.getWithBlockingRead().booleanValue());
    }

    private static void patchCommandListWithBeforeTask(@NotNull List<String> commandList, @NotNull String beforeTask) {
        if (commandList == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(11);
        }
        if (beforeTask == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(12);
        }
        String[] beforeTaskElements = beforeTask.split(" ");
        for (int i = 0; i < beforeTaskElements.length; ++i) {
            commandList.add(i, beforeTaskElements[i]);
        }
        commandList.add(beforeTaskElements.length, "&&");
    }

    @Contract(value="null, _, _-> null")
    @Nullable
    public static DockerContainerSettings getContainerSettings(@Nullable Project project, @Nullable Module module, @Nullable AbstractPathMapper pathMapper) {
        if (project == null) {
            return null;
        }
        if (pathMapper == null) {
            return DockerContainerSettings.defaultSettings((Project)project);
        }
        Set<String> rootPaths = module != null ? Arrays.stream(ModuleRootManager.getInstance((Module)module).getContentRoots()).map(p -> p.getPath()).collect(Collectors.toSet()) : Collections.singleton(project.getBasePath());
        DockerContainerSettings result = new DockerContainerSettings();
        for (String rootPath : rootPaths) {
            if (rootPath == null || !pathMapper.canReplaceLocal(rootPath)) continue;
            String rootPathInContainer = pathMapper.convertToRemote(rootPath);
            DockerVolumeBindingImpl binding = new DockerVolumeBindingImpl(rootPathInContainer, rootPath, false);
            result.getVolumeBindings().add(binding);
        }
        return result;
    }

    @Nullable
    public static GeneralCommandLine buildCommandLineToRunInSdkContainer(@NotNull RubyDockerComposeExecutionData cmdData, @NotNull RemoteDockerRuntime runtime) throws ExecutionException, IOException, ServerRuntimeException {
        if (cmdData == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(13);
        }
        if (runtime == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(14);
        }
        RubyDockerComposeProcessConnectionData connectionData = cmdData.getConnectionData();
        if (!RubyDockerComposeProcessUtil.prepareRubySdkContainer(cmdData.getProject(), connectionData, cmdData.getVolumeBindings())) {
            return null;
        }
        DockerExecCommandCliBuilder dockerExecCommand = new DockerExecCommandCliBuilder().withName(RubyDockerComposeProcessUtil.getSdkContainerName(connectionData)).withCommand(RubyCommandLine.patchWithSh((String[])cmdData.getRemoteCommand())).withEnvironment(cmdData.getEnvironment());
        return DockerCliUtilsKt.buildCommandLineBlocking((DockerExecCommandCliBuilder)dockerExecCommand, (DockerCloudConfiguration)runtime.getAccount());
    }

    @NotNull
    private static String getSdkContainerName(@NotNull RubyDockerComposeProcessConnectionData data) {
        if (data == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(15);
        }
        String string = RUBYMINE_SDK_CONTAINER + data.getId();
        if (string == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static boolean prepareRubySdkContainer(@Nullable Project project, @NotNull RubyDockerComposeProcessConnectionData data, DockerVolumeBinding @Nullable [] volumesBinding) throws ExecutionException, ServerRuntimeException, IOException {
        DockerCloudConfiguration account;
        RemoteDockerRuntime dockerRuntime;
        RemoteDockerApplicationRuntime runtime;
        if (data == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(17);
        }
        if ((runtime = (dockerRuntime = RubyDockerProcessUtil.createDockerRuntime(account = data.getAccount(), project)).findContainerByNameOrId(RUBYMINE_SDK_CONTAINER)) == null) {
            DockerComposeServiceClient serviceClient = DockerComposeServiceClient.getInstance((RemoteDockerRuntime)dockerRuntime);
            String sdkContainerName = RubyDockerComposeProcessUtil.getSdkContainerName(data);
            GeneralCommandLine commandLine = ((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)((ComposeServiceRunCmd)serviceClient.runServiceCmd().withConfigurationPath(data.getComposeFilePaths())).withServiceName(data.getComposeServiceName())).withCommand(PERPETUAL_COMMAND)).withName(sdkContainerName).withDetached(true)).withVolumes(volumesBinding)).buildCommandLine(dockerRuntime);
            commandLine.setWorkDirectory(FileUtil.getTempDirectory());
            runtime = dockerRuntime.findContainerByNameOrId(sdkContainerName);
        } else if (!runtime.inspect().isRunning()) {
            runtime.start();
        }
        return runtime != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkDockerEnvironmentAndHelpers(@NotNull RubyDockerComposeExecutionData cmdData, @NotNull RemoteDockerRuntime dockerRuntime) throws ExecutionException, IOException {
        RemoteDockerRuntime remoteDockerRuntime;
        RubyDockerComposeProcessConnectionData connectionData;
        DockerAgentContainer serviceInstance;
        if (cmdData == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(18);
        }
        if (dockerRuntime == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(19);
        }
        if ((serviceInstance = RubyDockerComposeProcessUtil.getServiceContainer(connectionData = cmdData.getConnectionData(), dockerRuntime)) != null && cmdData.isDebugMode().booleanValue()) {
            remoteDockerRuntime = dockerRuntime;
            synchronized (remoteDockerRuntime) {
                RubyDockerComposeProcessUtil.downEnvironmentOnMissingRubyMineGemsVolume(cmdData.getProject(), connectionData, dockerRuntime);
                serviceInstance = RubyDockerComposeProcessUtil.getServiceContainer(connectionData, dockerRuntime);
            }
        }
        if (serviceInstance == null) {
            remoteDockerRuntime = dockerRuntime;
            synchronized (remoteDockerRuntime) {
                serviceInstance = RubyDockerComposeProcessUtil.getServiceContainer(connectionData, dockerRuntime);
                if (serviceInstance == null) {
                    RubyDockerComposeProcessUtil.upTheEnvironment(cmdData, dockerRuntime);
                    serviceInstance = RubyDockerComposeProcessUtil.getServiceContainer(connectionData, dockerRuntime);
                    if (serviceInstance == null) {
                        LOG.warn("docker-compose up failed. See `docker logs` for details");
                        throw new ExecutionException(RubyDockerBundle.message("dialog.message.command.docker.compose.up.failed", new Object[0]));
                    }
                }
            }
        }
        if (!RubyDockerComposeProcessUtil.isHelpersDirectoryExists(serviceInstance, dockerRuntime)) {
            remoteDockerRuntime = dockerRuntime;
            synchronized (remoteDockerRuntime) {
                if (!RubyDockerComposeProcessUtil.isHelpersDirectoryExists(serviceInstance, dockerRuntime)) {
                    File tempDir = FileUtil.createTempDirectory((String)"rubymine", null);
                    File rubymineHelpers = new File(tempDir, RUBYMINE_HELPERS_RELATIVE_PATH);
                    if (!rubymineHelpers.mkdirs()) {
                        LOG.warn("Can't create folder: " + rubymineHelpers.getPath());
                    } else {
                        Collection rubyHelperRoots = RubySshRemoteTransfer.getHelpersPaths();
                        for (String rubyHelperRootPath : rubyHelperRoots) {
                            FileUtil.copyDir((File)new File(rubyHelperRootPath), (File)rubymineHelpers);
                        }
                        serviceInstance.copyArchiveToContainer(OPT_PATH, rubymineHelpers.getParent());
                    }
                    tempDir.delete();
                }
            }
        }
    }

    public static boolean isDockerEnvironmentUp(@NotNull RubyDockerComposeProcessConnectionData data, @NotNull RemoteDockerRuntime dockerRuntime) {
        if (data == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(20);
        }
        if (dockerRuntime == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(21);
        }
        return RubyDockerComposeProcessUtil.getServiceContainer(data, dockerRuntime) != null;
    }

    private static DockerAgentContainer getServiceContainer(@NotNull RubyDockerComposeProcessConnectionData data, @NotNull RemoteDockerRuntime dockerRuntime) {
        if (data == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(22);
        }
        if (dockerRuntime == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(23);
        }
        return DockerComposeContainerUtil.findContainerByServiceName((RemoteDockerRuntime)dockerRuntime, (DockerComposeCredentialsHolder)data.getCredentials());
    }

    public static void fillDockerParameters(@NotNull AbstractServiceCmd<?> cmd, @NotNull RubyDockerComposeExecutionData cmdData) {
        if (cmd == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(24);
        }
        if (cmdData == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(25);
        }
        cmd.withConfigurationPath(cmdData.getConnectionData().getComposeFilePaths()).withSharedVolume(cmdData.getSharedVolume()).withPorts(cmdData.getPorts()).withServiceName(cmdData.getConnectionData().getComposeServiceName()).withVolumes(cmdData.getVolumeBindings());
    }

    public static void fillDockerParametersAndSubcommandOptions(@NotNull AbstractServiceCmd<?> cmd, @NotNull RubyDockerComposeExecutionData cmdData) {
        if (cmd == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(26);
        }
        if (cmdData == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(27);
        }
        RubyDockerComposeProcessUtil.fillDockerParameters(cmd, cmdData);
        cmd.withSubcommandOptions(cmdData.getDockerCommandOptions());
    }

    public static void fillCommandLineParameters(@NotNull AbstractServiceCmd<?> cmd, @NotNull RubyDockerComposeExecutionData cmdData, @NotNull RemoteDockerRuntime dockerRuntime) throws RemoteSdkException {
        if (cmd == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(28);
        }
        if (cmdData == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(29);
        }
        if (dockerRuntime == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(30);
        }
        Map<String, String> environment = cmdData.getEnvironment();
        String remoteWorkingDir = cmdData.getRemoteWorkingDir();
        Object[] remoteCommand = cmdData.getRemoteCommand();
        if (cmd instanceof ComposeServiceExecCmd) {
            ComposeServiceExecCmd execCmd = (ComposeServiceExecCmd)cmd;
            if (remoteWorkingDir != null) {
                String composeVersion = DockerComposeVersionProvider.getInstance().getDockerComposeVersion(dockerRuntime);
                if (VersionComparatorUtil.compare((String)composeVersion, (String)"1.21.0") >= 0) {
                    execCmd.withSetupWorkingDirectory(true);
                } else if (!ArrayUtil.isEmpty((Object[])remoteCommand)) {
                    remoteCommand = ArrayUtil.mergeArrays((String[])new String[]{"cd", remoteWorkingDir, "&&"}, (String[])remoteCommand);
                }
            }
        }
        cmd.withEnvironment(environment).withWorkingDir(remoteWorkingDir).withCommand(RubyCommandLine.patchWithSh((String[])remoteCommand));
    }

    private static void upTheEnvironment(@NotNull RubyDockerComposeExecutionData cmdData, @NotNull RemoteDockerRuntime dockerRuntime) throws RemoteSdkException {
        String projectPath;
        if (cmdData == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(31);
        }
        if (dockerRuntime == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(32);
        }
        DockerComposeServiceClient serviceClient = DockerComposeServiceClient.getInstance((RemoteDockerRuntime)dockerRuntime);
        ComposeServiceUpCmd upCmd = serviceClient.upServicesCmd();
        Project project = cmdData.getProject();
        String string = projectPath = project != null ? project.getBasePath() : null;
        if (projectPath != null) {
            RubyDockerUtil.prepareRailsProjectToStart(projectPath);
        }
        try {
            RubyDockerComposeProcessUtil.fillDockerParameters(upCmd, cmdData);
            upCmd.withDetached(true);
            upCmd.withNoDeps(RubyDockerSettings.isNoDeps());
            Ref exception = new Ref(null);
            Ref outputRef = new Ref();
            Runnable upWithProgress = () -> ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                try {
                    LOG.warn("Up the environment: " + upCmd.buildCommandLine(dockerRuntime).getCommandLineString());
                    GeneralCommandLine upCommandLine = upCmd.buildCommandLine(dockerRuntime);
                    ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                    KillableColoredProcessHandler processHandler = new KillableColoredProcessHandler(upCommandLine);
                    CapturingProcessRunner runner = new CapturingProcessRunner((BaseProcessHandler)processHandler);
                    if (indicator != null) {
                        String commandLine = processHandler.getCommandLineForLog();
                        indicator.setText(commandLine);
                        outputRef.set((Object)runner.runProcess(indicator));
                    } else {
                        outputRef.set((Object)runner.runProcess());
                    }
                }
                catch (ExecutionException e) {
                    LOG.warn("Fail to up the environment: " + e.getMessage());
                    exception.set((Object)e);
                }
                catch (IOException e) {
                    exception.set((Object)new ExecutionException((Throwable)e));
                }
            }, RubyDockerBundle.message("ruby.docker.compose.up.project", new Object[0]), true, null, null);
            ApplicationManager.getApplication().invokeAndWait(upWithProgress);
            if (ApplicationManager.getApplication().isUnitTestMode() && !outputRef.isNull() && ((ProcessOutput)outputRef.get()).getExitCode() != 0) {
                LOG.warn("Command 'docker-compose up' failed stdout: " + ((ProcessOutput)outputRef.get()).getStdout());
                LOG.warn("Command 'docker-compose up' failed stderr: " + ((ProcessOutput)outputRef.get()).getStderr());
            }
            if (!exception.isNull()) {
                throw (ExecutionException)((Object)exception.get());
            }
        }
        catch (ExecutionException e) {
            throw new RemoteSdkException(RubyDockerBundle.message("dialog.message.up.docker.compose.failed", new Object[0]), (Throwable)e);
        }
    }

    private static void downTheEnvironment(@Nullable Project project, @NotNull RubyDockerComposeProcessConnectionData data, @NotNull RemoteDockerRuntime runtime) throws RemoteSdkException {
        if (data == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(33);
        }
        if (runtime == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(34);
        }
        Ref exceptionRef = new Ref();
        Ref outputRef = new Ref();
        Runnable commandExecution = () -> {
            try {
                List composeFilePaths = ContainerUtil.map(data.getComposeFilePaths(), x$0 -> Path.of(x$0, new String[0]));
                DockerComposeDownCliBuilder downCommandBuilder = (DockerComposeDownCliBuilder)DockerComposeCliUtil.buildDownCommand((DockerCloudConfiguration)data.getAccount()).withFiles(composeFilePaths);
                GeneralCommandLine commandLine = DockerComposeCliUtil.buildCommandLineBlocking((AbstractDockerComposeCmdCliBuilder)downCommandBuilder, (DockerCloudConfiguration)runtime.getAccount());
                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                KillableColoredProcessHandler processHandler = new KillableColoredProcessHandler(commandLine);
                CapturingProcessRunner runner = new CapturingProcessRunner((BaseProcessHandler)processHandler);
                if (indicator != null) {
                    indicator.setText(processHandler.getCommandLineForLog());
                    outputRef.set((Object)runner.runProcess(indicator));
                } else {
                    outputRef.set((Object)runner.runProcess());
                }
            }
            catch (ExecutionException e) {
                exceptionRef.set((Object)e);
            }
        };
        String title = RubyDockerBundle.message("ruby.docker.compose.down.project", new Object[0]);
        ProgressManager.getInstance().runProcessWithProgressSynchronously(commandExecution, title, false, project);
        if (!outputRef.isNull() && ((ProcessOutput)outputRef.get()).getExitCode() != 0) {
            LOG.warn("Command 'docker-compose down' failed stdout: " + ((ProcessOutput)outputRef.get()).getStdout());
            LOG.warn("Command 'docker-compose down' failed stderr: " + ((ProcessOutput)outputRef.get()).getStderr());
        }
        if (!exceptionRef.isNull()) {
            throw new RemoteSdkException(RubyDockerBundle.message("dialog.message.down.docker.compose.failed", new Object[0]), (Throwable)exceptionRef.get());
        }
    }

    @NotNull
    public static DockerComposeCredentialsHolder getDockerComposeCredentialsHolder(@NotNull RubyRemoteSdkAdditionalData commonCredentials) {
        if (commonCredentials == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(35);
        }
        final Ref result = Ref.create();
        commonCredentials.switchOnConnectionType(new CredentialsCase[]{new DockerComposeCredentialsCase(){

            public void process(DockerComposeCredentialsHolder credentials) {
                result.set((Object)credentials);
            }
        }});
        if (result.isNull()) {
            throw new IllegalArgumentException();
        }
        DockerComposeCredentialsHolder dockerComposeCredentialsHolder = (DockerComposeCredentialsHolder)result.get();
        if (dockerComposeCredentialsHolder == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(36);
        }
        return dockerComposeCredentialsHolder;
    }

    @NotNull
    public static RubyDockerComposeExecutionData buildExecutionData(@NotNull RubyCommandLine commandLine, @Nullable AbstractRubyRunConfiguration<?> config, @Nullable Module module, @NotNull RubyRemoteSdkAdditionalData sdkAdditionalData) throws IOException, ServerRuntimeException, RemoteSdkException {
        if (commandLine == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(37);
        }
        if (sdkAdditionalData == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(38);
        }
        RubyDockerComposeProcessConnectionData connectionData = new RubyDockerComposeProcessConnectionData((RemoteSdkAdditionalData)sdkAdditionalData, RubyDockerComposeProcessUtil.getDockerComposeCredentialsHolder(sdkAdditionalData));
        RubyCommandLineData data = commandLine.getCommandLineData();
        Project project = RModuleUtil.getInstance().getProject(module);
        VolumesBuilder volumesBinds = DockerProcessUtil.setupVolumesBinds(null, (DockerContainerSettings)RubyDockerComposeProcessUtil.getContainerSettings(project, module, (AbstractPathMapper)sdkAdditionalData.getRunnerMappings(module)));
        RubyDockerProcessUtil.addCustomVolumes((GeneralCommandLine)commandLine, volumesBinds);
        RubyDockerComposeProcessUtil.addRubyMineGemsVolume(volumesBinds, sdkAdditionalData, project, commandLine.getEnvironment(), connectionData, false);
        RemoteDockerRuntime dockerRuntime = RubyDockerProcessUtil.createDockerRuntime(connectionData.getAccount(), project);
        RubyDockerComposeExecutionData executionData = new RubyDockerComposeExecutionData(connectionData).withProject(project).withVolumeBindings(volumesBinds.build()).withSharedVolume(RubyDockerProcessUtil.getSharedVolume(dockerRuntime)).withCommandType(config == null ? RubyDockerSettings.getInternalCommandMode() : RubyDockerRunConfigurationSettings.getFrom(config).getDockerComposeCommandType()).withDebugMode(data != null && data.getUserData(RubyCommandLineData.DEBUG_GEM_HELPER_KEY) != null);
        RubyDockerComposeExecutionData rubyDockerComposeExecutionData = commandLine.isAllocatePty() && config != null ? executionData : executionData.withDockerCommandOptions(List.of("-T"));
        if (rubyDockerComposeExecutionData == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(39);
        }
        return rubyDockerComposeExecutionData;
    }

    public static void addRubyMineGemsVolume(@NotNull VolumesBuilder volumesBinds, @NotNull RubyRemoteSdkAdditionalData sdkAdditionalData, @Nullable Project project, @NotNull Map<String, String> environment, @NotNull RubyDockerComposeProcessConnectionData connectionData, boolean isReadOnly) throws RemoteSdkException {
        if (volumesBinds == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(40);
        }
        if (sdkAdditionalData == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(41);
        }
        if (environment == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(42);
        }
        if (connectionData == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(43);
        }
        if (!RubyDockerVolumeUtil.isUsingProprietaryDebaseDebuggerInDocker()) {
            return;
        }
        LOG.debug("Creating RM gems volume for sdk: ", new Object[]{sdkAdditionalData});
        String volumeName = RubyDockerVolumeUtil.computeRubyMineGemsVolumeName(sdkAdditionalData);
        if (StringUtil.isEmpty((String)volumeName)) {
            LOG.debug("Cannot create RM gems volume for sdk: ", new Object[]{sdkAdditionalData});
            return;
        }
        RubyDockerVolumeUtil.setupDockerComposeVolume(volumeName, "/opt/.rubymine_gems", project, environment, connectionData);
        volumesBinds.addBoundVolume("/opt/.rubymine_gems", volumeName, isReadOnly);
    }

    public static void removeRubyMineGemsVolume(@NotNull Sdk sdk, @Nullable Project project, @NotNull RubyDockerComposeProcessConnectionData data) {
        if (sdk == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(44);
        }
        if (data == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(45);
        }
        if (!RubyDockerComposeUtil.isRubyDockerComposeSDK(sdk) || !RubyDockerVolumeUtil.isUsingProprietaryDebaseDebuggerInDocker()) {
            return;
        }
        LOG.debug("Removing RM gems volume for sdk: ", new Object[]{sdk});
        String volumeName = RubyDockerVolumeUtil.computeRubyMineGemsVolumeName(RubyRemoteSdkAdditionalData.from((Sdk)sdk));
        if (StringUtil.isEmpty((String)volumeName)) {
            LOG.debug("Cannot remove RM gems volume for sdk: ", new Object[]{sdk});
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> RubyDockerVolumeUtil.removeDockerComposeVolumes(volumeName, project, data, true));
    }

    @Nullable
    public static RubyDebugIdeGemHelper.BackendDebugGemType getOrInstallDebugIdeGemForDockerCompose(@Nullable Module module, @NotNull Sdk sdk) throws ExecutionException {
        if (sdk == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(46);
        }
        if (!RubyDockerComposeUtil.isRubyDockerComposeSDK(sdk)) {
            LOG.warn("Failed to install debugger gems, because provided SDK is not for Docker Compose: " + String.valueOf(sdk));
            throw new IllegalArgumentException("Docker Compose SDK is expected, but got: " + String.valueOf(sdk));
        }
        if (RubyDockerSettings.isStatefulExecution() && !RubyDebugIdeGemHelper.isAllDebuggerGemsInstalledAndUpToDate((Module)module, (Sdk)sdk)) {
            Project project = RModuleUtil.getInstance().getProject(module);
            RubyRemoteSdkAdditionalData sdkData = RubyRemoteSdkAdditionalData.notNullFrom((Sdk)sdk);
            RubyDockerComposeProcessConnectionData connectionData = new RubyDockerComposeProcessConnectionData((RemoteSdkAdditionalData)sdkData, RubyDockerComposeProcessUtil.getDockerComposeCredentialsHolder(sdkData));
            RemoteDockerRuntime dockerRuntime = RubyDockerProcessUtil.createDockerRuntime(connectionData.getAccount(), project);
            RubyDockerComposeProcessUtil.downEnvironmentOnMissingRubyMineGemsVolume(project, connectionData, dockerRuntime);
        }
        return RubyDebugIdeGemHelper.getOrInstallDebugIdeGem((Module)module, (Sdk)sdk, (String)"/opt/.rubymine_gems", (boolean)true);
    }

    public static List<IntRange> getPortsFromConfigFiles(@NotNull RubyRunner runner) {
        DockerComposeConfiguration configuration;
        if (runner == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(47);
        }
        if (!(runner instanceof RubyDockerRunner)) {
            return Collections.emptyList();
        }
        RubyDockerRunner dockerRunner = (RubyDockerRunner)runner;
        RubyRemoteSdkAdditionalData additionalData = (RubyRemoteSdkAdditionalData)ObjectUtils.doIfNotNull((Object)((Object)dockerRunner), RubyRemoteRunner::getSdkAdditionalData);
        RemoteConnectionCredentialsWrapper credentialsWrapper = (RemoteConnectionCredentialsWrapper)ObjectUtils.doIfNotNull((Object)additionalData, RubyRemoteSdkAdditionalData::connectionCredentials);
        DockerComposeCredentialsHolder docker = (DockerComposeCredentialsHolder)ObjectUtils.tryCast((Object)ObjectUtils.doIfNotNull((Object)credentialsWrapper, RemoteConnectionCredentialsWrapper::getCredentials), DockerComposeCredentialsHolder.class);
        List composeFilesPath = (List)ObjectUtils.coalesce((Object)((List)ObjectUtils.doIfNotNull((Object)docker, DockerComposeCredentialsHolder::getComposeFilePaths)), Collections.emptyList());
        if (docker == null || composeFilesPath.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            DockerCloudConfiguration cloudConfiguration = DockerUtils.getDockerCloudConfiguration((String)docker.getAccountName());
            configuration = DockerComposeFileConfigurationProvider.getInstance().getConfigFor(cloudConfiguration, composeFilesPath);
        }
        catch (IOException e) {
            LOG.info("Unable to determine open ports from the config files: " + String.join((CharSequence)", ", composeFilesPath));
            return Collections.emptyList();
        }
        if (!(configuration instanceof DockerComposeConfigurationV2)) {
            return Collections.emptyList();
        }
        DockerComposeConfigurationV2 configurationV2 = (DockerComposeConfigurationV2)configuration;
        DockerComposeServiceV2 service = (DockerComposeServiceV2)configurationV2.getServices().get(docker.getComposeServiceName());
        if (service == null) {
            return Collections.emptyList();
        }
        return ((List)ObjectUtils.coalesce((Object)service.getPorts(), Collections.emptyList())).stream().mapMulti(StreamUtil.select(DefinedDockerComposePort.class, (Class[])new Class[0])).map(DefinedDockerComposePort::getValue).map(DockerComposePort::getContainerPort).filter(Objects::nonNull).toList();
    }

    private static void downEnvironmentOnMissingRubyMineGemsVolume(@Nullable Project project, @NotNull RubyDockerComposeProcessConnectionData connectionData, @NotNull RemoteDockerRuntime dockerRuntime) throws ExecutionException {
        if (connectionData == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(48);
        }
        if (dockerRuntime == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(49);
        }
        if (!RubyDockerVolumeUtil.isUsingProprietaryDebaseDebuggerInDocker()) {
            return;
        }
        DockerAgentContainer container = RubyDockerComposeProcessUtil.getServiceContainer(connectionData, dockerRuntime);
        if (container == null || RubyDockerComposeProcessUtil.isRubyMineGemsDirectoryExists(container, dockerRuntime)) {
            return;
        }
        int answer = RubyUIUtil.showYesNoDialogFromEDT((Project)project, (String)RubyDockerBundle.message("dialog.message.rm.gems.volume.missing", new Object[0]), (String)RBundle.message((String)"gems.debugger.alert.title"), (Icon)Messages.getQuestionIcon());
        if (answer != 0) {
            throw new ExecutionException(RubyDockerBundle.message("dialog.message.debug.cannot.proceed.without.rm.gems.volume", new Object[0]));
        }
        RubyDockerComposeProcessUtil.downTheEnvironment(project, connectionData, dockerRuntime);
    }

    private static boolean isRubyMineGemsDirectoryExists(@NotNull DockerAgentContainer container, @NotNull RemoteDockerRuntime dockerRuntime) throws RemoteSdkException {
        if (container == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(50);
        }
        if (dockerRuntime == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(51);
        }
        return RubyDockerComposeProcessUtil.isPathExistsInContainer(container, dockerRuntime, "/opt/.rubymine_gems");
    }

    private static boolean isHelpersDirectoryExists(@NotNull DockerAgentContainer container, @NotNull RemoteDockerRuntime dockerRuntime) throws RemoteSdkException {
        if (container == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(52);
        }
        if (dockerRuntime == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(53);
        }
        return RubyDockerComposeProcessUtil.isPathExistsInContainer(container, dockerRuntime, "/opt/.rubymine_helpers/rb");
    }

    private static boolean isPathExistsInContainer(@NotNull DockerAgentContainer container, @NotNull RemoteDockerRuntime dockerRuntime, @NotNull String path) throws RemoteSdkException {
        if (container == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(54);
        }
        if (dockerRuntime == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(55);
        }
        if (path == null) {
            RubyDockerComposeProcessUtil.$$$reportNull$$$0(56);
        }
        try {
            RemoteDockerApplicationRuntime containerRuntime = RemoteDockerApplicationRuntime.create((RemoteDockerRuntime)dockerRuntime, (DockerAgentContainer)container);
            ProcessOutput output = containerRuntime.exec(new String[]{"ls", path});
            return output.getExitCode() == 0;
        }
        catch (ServerRuntimeException | IOException e) {
            throw DockerUtil.propagateRemoteSdkException((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7, 8, 16, 36, 39 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 16: 
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/ruby/compose/RubyDockerComposeProcessUtil";
                break;
            }
            case 9: 
            case 13: 
            case 18: 
            case 25: 
            case 27: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdData";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdLine";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandList";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeTask";
                break;
            }
            case 14: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runtime";
                break;
            }
            case 15: 
            case 17: 
            case 20: 
            case 22: 
            case 33: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 19: 
            case 21: 
            case 23: 
            case 30: 
            case 32: 
            case 49: 
            case 51: 
            case 53: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockerRuntime";
                break;
            }
            case 24: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonCredentials";
                break;
            }
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkAdditionalData";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "volumesBinds";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 43: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionData";
                break;
            }
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 50: 
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/ruby/compose/RubyDockerComposeProcessUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "startDockerComposeProcess";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createDockerCommandLine";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPorts";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkContainerName";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getDockerComposeCredentialsHolder";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "buildExecutionData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "startDockerComposeConsole";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "startDockerComposeProcess";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 16: 
            case 36: 
            case 39: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createDockerCommandLine";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createDockerRubyConsoleProcess";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "patchCommandListWithBeforeTask";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "buildCommandLineToRunInSdkContainer";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSdkContainerName";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "prepareRubySdkContainer";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "checkDockerEnvironmentAndHelpers";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isDockerEnvironmentUp";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getServiceContainer";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "fillDockerParameters";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "fillDockerParametersAndSubcommandOptions";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "fillCommandLineParameters";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "upTheEnvironment";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "downTheEnvironment";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getDockerComposeCredentialsHolder";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "buildExecutionData";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "addRubyMineGemsVolume";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "removeRubyMineGemsVolume";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getOrInstallDebugIdeGemForDockerCompose";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getPortsFromConfigFiles";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "downEnvironmentOnMissingRubyMineGemsVolume";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "isRubyMineGemsDirectoryExists";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "isHelpersDirectoryExists";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "isPathExistsInContainer";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7, 8, 16, 36, 39 -> new IllegalStateException(string);
        };
    }
}

