/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.ruby;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.remote.DockerComposeCredentialsHolder;
import com.intellij.docker.remote.DockerCredentialsHolder;
import com.intellij.docker.remote.DockerProcessUtil;
import com.intellij.docker.remote.ruby.RubyDockerConsoleProcessHandler;
import com.intellij.docker.remote.ruby.RubyDockerProcessConnectionData;
import com.intellij.docker.remote.ruby.RubyDockerProcessUtil;
import com.intellij.docker.remote.ruby.RubyDockerVolumeUtil;
import com.intellij.docker.remote.ruby.compose.RubyDockerComposeRunner;
import com.intellij.docker.utils.DockerNetworkUtil;
import com.intellij.docker.utils.DockerUtils;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.remote.RemoteConnectionCredentialsWrapper;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.util.AbstractPathMapper;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.NetUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkAdditionalData;
import org.jetbrains.plugins.ruby.remote.impl.RubyRemoteRunner;
import org.jetbrains.plugins.ruby.remote.impl.RubyRemoteSdkConfigurator;
import org.jetbrains.plugins.ruby.ruby.run.PortForwarding;
import org.jetbrains.plugins.ruby.ruby.run.RubyCommandLine;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyCommandLineData;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RunConfigurationUtil;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyRunnerExecutionContext;
import org.jetbrains.plugins.ruby.utils.VirtualFileUtil;

public class RubyDockerRunner
extends RubyRemoteRunner {
    private static final Logger LOG = Logger.getInstance(RubyDockerRunner.class);
    private static final Key<PathMappingSettings> PATH_MAPPING_SETTINGS_KEY = new Key("PATH_MAPPING_SETTINGS_KEY");
    private static final Key<Sdk> RUBY_DOCKER_SDK_KEY = new Key("RUBY_DOCKER_SDK_KEY");
    @NotNull
    private static final String DOCKER_CONTAINER_ENVIRONMENT = "DOCKER_CONTAINER_ENVIRONMENT";
    @NotNull
    private static final String DOCKER_EXTRA_DEBUGGER_PORTS = "DOCKER_EXTRA_DEBUGGER_PORTS";
    private static final int MAX_PORT_NUMBER = 65535;
    private static final int MIN_PORT_NUMBER = 1024;
    @NotNull
    private static final String RUBY_DOCKER_DEBUGGER_MAX_CHILD_PRECESSES = "ruby.docker.debugger.max.supported.child.processes";
    protected static final String DOCKER_SERVER_LOCALHOST = System.getProperty("ruby.docker.server.localhost.ip.address", "0.0.0.0");

    protected RubyDockerRunner(@NotNull RubyRemoteSdkAdditionalData data, @Nullable Module module) {
        if (data == null) {
            RubyDockerRunner.$$$reportNull$$$0(0);
        }
        super(data, module);
    }

    @NotNull
    protected ProcessHandler createProcessHandlerInner(@NotNull RubyCommandLine commandLine, @Nullable String runnerId) throws ExecutionException {
        if (commandLine == null) {
            RubyDockerRunner.$$$reportNull$$$0(1);
        }
        DockerCredentialsHolder credentialsHolder = DockerProcessUtil.getDockerCredentialsHolder((RemoteSdkAdditionalData)this.myData);
        RubyDockerProcessConnectionData connectionData = new RubyDockerProcessConnectionData((RemoteSdkAdditionalData)this.myData, credentialsHolder);
        RubyDockerRunner.fixEnvironmentVariables(commandLine);
        ProcessHandler processHandler = RubyDockerProcessUtil.startDockerProcess(this.myModule, connectionData, commandLine, (AbstractPathMapper)this.myData.getPathMappings());
        if (processHandler == null) {
            RubyDockerRunner.$$$reportNull$$$0(2);
        }
        return processHandler;
    }

    @NotNull
    protected ProcessHandler createConsoleProcessHandlerInner(@NotNull RubyCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            RubyDockerRunner.$$$reportNull$$$0(3);
        }
        DockerCredentialsHolder credentialsHolder = DockerProcessUtil.getDockerCredentialsHolder((RemoteSdkAdditionalData)this.myData);
        RubyDockerProcessConnectionData connectionData = new RubyDockerProcessConnectionData((RemoteSdkAdditionalData)this.myData, credentialsHolder);
        RubyDockerRunner.fixEnvironmentVariables(commandLine);
        RubyDockerConsoleProcessHandler rubyDockerConsoleProcessHandler = RubyDockerProcessUtil.startDockerConsole(this.myModule, connectionData, commandLine, (AbstractPathMapper)this.myData.getPathMappings());
        if (rubyDockerConsoleProcessHandler == null) {
            RubyDockerRunner.$$$reportNull$$$0(4);
        }
        return rubyDockerConsoleProcessHandler;
    }

    @NotNull
    public RubyCommandLine createCommandLine(@NotNull RubyRunnerExecutionContext context) {
        if (context == null) {
            RubyDockerRunner.$$$reportNull$$$0(5);
        }
        RubyCommandLine result = super.createCommandLine(context);
        result.putUserData(RUBY_DOCKER_SDK_KEY, (Object)context.getRubySdk());
        result.putUserData(PATH_MAPPING_SETTINGS_KEY, (Object)context.getPathMappings());
        result.putUserData(RubyCommandLineData.RACK_SERVER_HOST_KEY, (Object)DOCKER_SERVER_LOCALHOST);
        RubyCommandLine rubyCommandLine = result;
        if (rubyCommandLine == null) {
            RubyDockerRunner.$$$reportNull$$$0(6);
        }
        return rubyCommandLine;
    }

    @NotNull
    public Pair<PortForwarding, PortForwarding> getDebuggerForwardings() throws ExecutionException {
        Pair pair;
        try {
            int[] localPorts = NetUtils.findAvailableSocketPorts((int)2);
            DockerCloudConfiguration cloudConfiguration = this.getDockerCloudConfiguration();
            String dispatcherHost = cloudConfiguration != null ? DockerNetworkUtil.getDockerNetworkInterface((DockerCloudConfiguration)cloudConfiguration) : DOCKER_SERVER_LOCALHOST;
            pair = Pair.create((Object)PortForwarding.remoteToLocal((String)DOCKER_SERVER_LOCALHOST, (int)localPorts[0], (int)localPorts[0]), (Object)PortForwarding.localToRemote((String)dispatcherHost, (int)localPorts[1], (int)localPorts[1]));
        }
        catch (IOException e) {
            LOG.error("Can not find ports to bind", (Throwable)e);
            throw new ExecutionException(RBundle.message((String)"ruby.debugger.cannot.find.free.port"));
        }
        if (pair == null) {
            RubyDockerRunner.$$$reportNull$$$0(7);
        }
        return pair;
    }

    protected static void fixEnvironmentVariables(@NotNull RubyCommandLine commandLine) {
        if (commandLine == null) {
            RubyDockerRunner.$$$reportNull$$$0(8);
        }
        Map environment = commandLine.getEnvironment();
        environment.remove("PATH");
        DockerProcessUtil.removeIncorrectVariables((Map)environment);
    }

    @Nullable
    public static PathMappingSettings getCommandLinePathMapping(@Nullable RubyCommandLine commandLine) {
        return commandLine != null ? (PathMappingSettings)commandLine.getUserData(PATH_MAPPING_SETTINGS_KEY) : null;
    }

    @Nullable
    public static Sdk getCommandLineSdk(@Nullable RubyCommandLine commandLine) {
        return commandLine != null ? (Sdk)commandLine.getUserData(RUBY_DOCKER_SDK_KEY) : null;
    }

    @Nullable
    public PathMappingSettings customizePathMappings(@Nullable PathMappingSettings mappings) {
        if (mappings == null) {
            return mappings;
        }
        if (!RubyDockerVolumeUtil.isUsingProprietaryDebaseDebuggerInDocker()) {
            return mappings;
        }
        LOG.debug("Before adding custom mappings: ", new Object[]{mappings});
        PathMappingSettings newMappings = new PathMappingSettings();
        newMappings.addAll(mappings);
        String sdkCacheRoot = RubyRemoteSdkAdditionalData.getLocalGemsRootPath((RubyRemoteSdkAdditionalData)this.getSdkAdditionalData());
        for (String subdir : RubyRemoteSdkConfigurator.GEM_MAPPING_SUBDIRS) {
            String remoteBinaryPath = FileUtil.toSystemIndependentName((String)FileUtil.join((String[])new String[]{"/opt/.rubymine_gems", subdir}));
            String localBinaryPath = FileUtil.toSystemDependentName((String)(sdkCacheRoot + remoteBinaryPath));
            newMappings.addMappingCheckUnique(localBinaryPath, remoteBinaryPath);
        }
        LOG.debug("After custom mappings added: ", new Object[]{newMappings});
        return newMappings;
    }

    @Nullable
    public List<String> customizeGemsRootUrls(@Nullable List<String> gemUrls) {
        if (gemUrls == null) {
            return gemUrls;
        }
        if (!RubyDockerVolumeUtil.isUsingProprietaryDebaseDebuggerInDocker()) {
            return gemUrls;
        }
        LOG.debug("Before adding custom gem root urls: ", new Object[]{gemUrls});
        String sdkCacheRoot = RubyRemoteSdkAdditionalData.getLocalGemsRootPath((RubyRemoteSdkAdditionalData)this.getSdkAdditionalData());
        String remoteBinaryPath = FileUtil.toSystemIndependentName((String)FileUtil.join((String[])new String[]{"/opt/.rubymine_gems", "gems"}));
        String localBinaryPath = FileUtil.toSystemDependentName((String)(sdkCacheRoot + remoteBinaryPath));
        List newGemUrls = ContainerUtil.concat(gemUrls, List.of(VirtualFileUtil.constructLocalUrl((String)localBinaryPath)));
        LOG.debug("After custom gem root urls added: ", new Object[]{newGemUrls});
        return newGemUrls;
    }

    public void configureExtraPortsForMultiProcess(@NotNull RubyCommandLineData data, @NotNull Map<String, String> environment) {
        if (data == null) {
            RubyDockerRunner.$$$reportNull$$$0(9);
        }
        if (environment == null) {
            RubyDockerRunner.$$$reportNull$$$0(10);
        }
        environment.put(DOCKER_CONTAINER_ENVIRONMENT, "true");
        List portForwardings = (List)data.getUserData(RubyCommandLineData.PORT_FORWARDING_KEY);
        if (portForwardings == null) {
            portForwardings = List.of();
        }
        List forwardedPorts = portForwardings.stream().flatMap(it -> Stream.of(it.getLocalPort(), it.getRemotePort())).distinct().toList();
        int maxExtraPorts = Registry.intValue((String)RUBY_DOCKER_DEBUGGER_MAX_CHILD_PRECESSES);
        ArrayList<Integer> extraPorts = new ArrayList<Integer>();
        for (int currentPort = 65535; extraPorts.size() < maxExtraPorts && currentPort >= 1024; --currentPort) {
            if (NetUtils.canConnectToSocket((String)NetUtils.getLocalHostString(), (int)currentPort) || forwardedPorts.contains(currentPort)) continue;
            extraPorts.add(currentPort);
        }
        LOG.info("Forwarded " + extraPorts.size() + " extra ports: " + String.valueOf(extraPorts));
        StringJoiner stringJoiner = new StringJoiner(";");
        for (Integer port : extraPorts) {
            RunConfigurationUtil.addPortForwarding((RubyCommandLineData)data, (PortForwarding)PortForwarding.remoteToLocal((String)"localhost", (int)port, (int)port));
            stringJoiner.add(port.toString());
        }
        environment.put(DOCKER_EXTRA_DEBUGGER_PORTS, stringJoiner.toString());
    }

    @Nullable
    protected DockerCloudConfiguration getDockerCloudConfiguration() {
        DockerComposeCredentialsHolder docker;
        RubyRemoteSdkAdditionalData additionalData = this.getSdkAdditionalData();
        RemoteConnectionCredentialsWrapper credentialsWrapper = (RemoteConnectionCredentialsWrapper)ObjectUtils.doIfNotNull((Object)additionalData, RubyRemoteSdkAdditionalData::connectionCredentials);
        if (this instanceof RubyDockerComposeRunner && (docker = (DockerComposeCredentialsHolder)ObjectUtils.tryCast((Object)ObjectUtils.doIfNotNull((Object)credentialsWrapper, RemoteConnectionCredentialsWrapper::getCredentials), DockerComposeCredentialsHolder.class)) != null) {
            return DockerUtils.getDockerCloudConfiguration((String)docker.getAccountName());
        }
        docker = (DockerCredentialsHolder)ObjectUtils.tryCast((Object)ObjectUtils.doIfNotNull((Object)credentialsWrapper, RemoteConnectionCredentialsWrapper::getCredentials), DockerCredentialsHolder.class);
        if (docker != null) {
            return DockerUtils.getDockerCloudConfiguration((String)docker.getAccountName());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/ruby/RubyDockerRunner";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/ruby/RubyDockerRunner";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcessHandlerInner";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleProcessHandlerInner";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebuggerForwardings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createProcessHandlerInner";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleProcessHandlerInner";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLine";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fixEnvironmentVariables";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "configureExtraPortsForMultiProcess";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 6, 7 -> new IllegalStateException(string);
        };
    }
}

