/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.ruby;

import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.DockerProcessUtil;
import com.intellij.docker.remote.ruby.RubyDockerAgentDeploymentConfigImpl;
import com.intellij.docker.remote.ruby.RubyDockerBundle;
import com.intellij.docker.remote.ruby.RubyDockerProcessConnectionData;
import com.intellij.docker.remote.ruby.RubyDockerProcessUtil;
import com.intellij.docker.remote.run.runtime.DockerUtil;
import com.intellij.docker.remoteRunRuntime.RemoteDockerApplicationRuntime;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.docker.remoteRunRuntime.WrappedNotFoundException;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.PathUtil;
import com.jetbrains.plugins.remotesdk.RemoteTransfer;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkAdditionalData;
import org.jetbrains.plugins.ruby.remote.impl.RubyDockerHelpersTransferConfig;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkSystemAccessor;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkTransfer;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;

public class RubyDockerRemoteTransfer
extends RemoteTransfer
implements RubySdkTransfer {
    private static final Logger LOG = Logger.getInstance(RubyDockerRemoteTransfer.class);
    private RubyDockerProcessConnectionData myDockerConData;
    private final RubySdkSystemAccessor myAccessor;

    protected RubyDockerRemoteTransfer(@Nullable Project project, @Nullable Component component, @NotNull RemoteTransfer.HelpersTransferConfig helpersTransferConfig, @NotNull RubyRemoteSdkAdditionalData data) {
        if (helpersTransferConfig == null) {
            RubyDockerRemoteTransfer.$$$reportNull$$$0(0);
        }
        if (data == null) {
            RubyDockerRemoteTransfer.$$$reportNull$$$0(1);
        }
        super(project, component, helpersTransferConfig);
        this.setTransferTaskModal(false);
        this.myAccessor = RubySdkSystemAccessor.from((RubySdkAdditionalData)data);
    }

    protected RubyDockerRemoteTransfer(@Nullable Project project, RubyDockerProcessConnectionData dockerProcessConnectionData, @NotNull RubyRemoteSdkAdditionalData data) {
        if (data == null) {
            RubyDockerRemoteTransfer.$$$reportNull$$$0(2);
        }
        super(project, null, (RemoteTransfer.HelpersTransferConfig)new RubyDockerHelpersTransferConfig());
        this.myDockerConData = dockerProcessConnectionData;
        this.setTransferTaskModal(false);
        this.myAccessor = RubySdkSystemAccessor.from((RubySdkAdditionalData)data);
    }

    @NotNull
    public RubySdkSystemAccessor getSystemAccessor() {
        RubySdkSystemAccessor rubySdkSystemAccessor = this.myAccessor;
        if (rubySdkSystemAccessor == null) {
            RubyDockerRemoteTransfer.$$$reportNull$$$0(3);
        }
        return rubySdkSystemAccessor;
    }

    public void moveFileToLocalPath(@NotNull String sourcePath, String newParentDir, boolean replaceExisting, @NotNull ProgressIndicator progressIndicator) throws IOException {
        if (sourcePath == null) {
            RubyDockerRemoteTransfer.$$$reportNull$$$0(4);
        }
        if (progressIndicator == null) {
            RubyDockerRemoteTransfer.$$$reportNull$$$0(5);
        }
        throw new IOException("Not implemented");
    }

    public void beforeRemoteSdkRemoved(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubyDockerRemoteTransfer.$$$reportNull$$$0(6);
        }
        RubyDockerProcessUtil.removeRubyMineGemsVolume(sdk, this.getProject(), this.myDockerConData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateLocalGemsCopy(@NotNull Sdk sdk, @NotNull List<PathMappingSettings.PathMapping> pathMappings, @NotNull ProgressIndicator indicator) throws RemoteSdkException {
        if (sdk == null) {
            RubyDockerRemoteTransfer.$$$reportNull$$$0(7);
        }
        if (pathMappings == null) {
            RubyDockerRemoteTransfer.$$$reportNull$$$0(8);
        }
        if (indicator == null) {
            RubyDockerRemoteTransfer.$$$reportNull$$$0(9);
        }
        RubyDockerRemoteTransfer.clearLocalGemsRoot(sdk, indicator);
        String localGemRoot = RubyRemoteSdkAdditionalData.getLocalGemsRootPath((Sdk)sdk);
        RemoteDockerApplicationRuntime dockerRuntime = this.getDockerRuntimeForGemSync(sdk);
        String containerId = dockerRuntime.getContainerId();
        try {
            LOG.debug("Syncing gems from container: ", new Object[]{containerId});
            indicator.setIndeterminate(false);
            int done = 0;
            for (PathMappingSettings.PathMapping mapping : pathMappings) {
                LOG.debug("Processing mapping: ", new Object[]{mapping});
                RubySdkUtil.checkIfRubySdkDisposed((Sdk)sdk);
                indicator.checkCanceled();
                String localRoot = mapping.getLocalRoot();
                if (localRoot == null || !FileUtil.isAncestor((String)localGemRoot, (String)localRoot, (boolean)false)) {
                    LOG.debug("Excluding user-defined or project mapping: ", new Object[]{mapping});
                    continue;
                }
                String remoteRoot = mapping.getRemoteRoot();
                indicator.setText2(RubyDockerBundle.message("ruby.docker.sdk.downloading", remoteRoot));
                try {
                    dockerRuntime.downloadDirectory(remoteRoot, new File(localRoot), null, this.getMachineName(), RubyDockerRemoteTransfer.getRemotePathFilter());
                }
                catch (WrappedNotFoundException e) {
                    LOG.debug("Remote file not found: " + remoteRoot);
                }
                catch (ExecutionException | ServerRuntimeException | IOException e) {
                    LOG.warn("Failed to download '" + remoteRoot + "' into '" + localRoot + "'", e);
                }
                finally {
                    indicator.setFraction((double)(++done) / (double)pathMappings.size());
                }
            }
        }
        finally {
            try {
                dockerRuntime.executeAgentTask(dockerRuntime.getAgentContainer().deleteContainer());
            }
            catch (ServerRuntimeException e) {
                LOG.warn("Removal of container " + containerId + " used for gem syncing has failed: " + e.getMessage());
            }
        }
    }

    @NotNull
    protected RemoteDockerApplicationRuntime getDockerRuntimeForGemSync(@NotNull Sdk sdk) throws RemoteSdkException {
        RemoteDockerApplicationRuntime remoteDockerApplicationRuntime;
        Project project;
        if (sdk == null) {
            RubyDockerRemoteTransfer.$$$reportNull$$$0(10);
        }
        DockerContainerSettings containerSettings = (project = this.getProject()) != null ? DockerContainerSettings.defaultSettings((Project)project) : null;
        DockerVolumeBinding[] bindings = DockerProcessUtil.setupVolumesBinds(null, (DockerContainerSettings)containerSettings).build();
        RubyDockerAgentDeploymentConfigImpl config = new RubyDockerAgentDeploymentConfigImpl(this.myDockerConData.getImage(), bindings);
        config.setupRubyMineGemsVolumes(sdk, project, this.myDockerConData, true);
        try {
            RemoteDockerRuntime dockerRuntime = RubyDockerProcessUtil.createDockerRuntime(this.myDockerConData.getAccount(), this.getProject());
            remoteDockerApplicationRuntime = RemoteDockerApplicationRuntime.create((RemoteDockerRuntime)dockerRuntime, (DockerAgentDeploymentConfig)config);
        }
        catch (ServerRuntimeException e) {
            throw DockerUtil.propagateRemoteSdkException((Throwable)e);
        }
        if (remoteDockerApplicationRuntime == null) {
            RubyDockerRemoteTransfer.$$$reportNull$$$0(11);
        }
        return remoteDockerApplicationRuntime;
    }

    private static void clearLocalGemsRoot(@NotNull Sdk sdk, @NotNull ProgressIndicator indicator) {
        Path localGemsRoot;
        if (sdk == null) {
            RubyDockerRemoteTransfer.$$$reportNull$$$0(12);
        }
        if (indicator == null) {
            RubyDockerRemoteTransfer.$$$reportNull$$$0(13);
        }
        if (Files.notExists(localGemsRoot = Path.of(RubyRemoteSdkAdditionalData.getLocalGemsRootPath((Sdk)sdk), new String[0]), new LinkOption[0])) {
            return;
        }
        LOG.debug("Clearing local gem cache: ", new Object[]{localGemsRoot});
        indicator.setIndeterminate(true);
        indicator.setText2(RubyDockerBundle.message("ruby.docker.sdk.cache.clearing", localGemsRoot));
        try {
            NioFiles.deleteRecursively((Path)localGemsRoot, __ -> indicator.checkCanceled());
        }
        catch (IOException origExc) {
            try {
                if (SystemInfo.isWindows || !RubyDockerRemoteTransfer.fixLocalGemsRootPermissions(sdk, indicator)) {
                    throw origExc;
                }
                NioFiles.deleteRecursively((Path)localGemsRoot, __ -> indicator.checkCanceled());
            }
            catch (IOException innerExc) {
                LOG.warn("Failed to clear local gem cache: " + String.valueOf(localGemsRoot), (Throwable)innerExc);
            }
        }
    }

    private static boolean fixLocalGemsRootPermissions(@NotNull Sdk sdk, final @NotNull ProgressIndicator indicator) {
        if (sdk == null) {
            RubyDockerRemoteTransfer.$$$reportNull$$$0(14);
        }
        if (indicator == null) {
            RubyDockerRemoteTransfer.$$$reportNull$$$0(15);
        }
        if (SystemInfo.isWindows) {
            return true;
        }
        Path localGemsRoot = Path.of(RubyRemoteSdkAdditionalData.getLocalGemsRootPath((Sdk)sdk), new String[0]);
        LOG.debug("Fixing permissions inside local gem cache: ", new Object[]{localGemsRoot});
        try {
            final EnumSet<PosixFilePermission> requiredDirPerms = EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE);
            Files.walkFileTree(localGemsRoot, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (exc != null) {
                        throw exc;
                    }
                    indicator.checkCanceled();
                    Files.setPosixFilePermissions(dir, requiredDirPerms);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException | UnsupportedOperationException e) {
            LOG.warn("Failed to fix permissions: " + String.valueOf(localGemsRoot), (Throwable)e);
            return false;
        }
        return true;
    }

    @Nullable
    protected String getMachineName() throws RemoteSdkException {
        return this.myDockerConData.getImage();
    }

    @NotNull
    protected static Predicate<String> getRemotePathFilter() {
        Set<String> excludedFilenames = Set.of(SYNC_EXCLUDE_FILENAMES);
        Set<String> excludedExtensions = Set.of(SYNC_EXCLUDE_EXTENSIONS);
        Predicate<String> predicate = remotePath -> {
            String remoteFilename = PathUtil.getFileName((String)remotePath);
            return !excludedFilenames.contains(remoteFilename) && !excludedExtensions.contains(FileUtilRt.getExtension((String)remoteFilename));
        };
        if (predicate == null) {
            RubyDockerRemoteTransfer.$$$reportNull$$$0(16);
        }
        return predicate;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 11, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpersTransferConfig";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 3: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/ruby/RubyDockerRemoteTransfer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMappings";
                break;
            }
            case 9: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/ruby/RubyDockerRemoteTransfer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemAccessor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDockerRuntimeForGemSync";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemotePathFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 11: 
            case 16: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "moveFileToLocalPath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "beforeRemoteSdkRemoved";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateLocalGemsCopy";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDockerRuntimeForGemSync";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "clearLocalGemsRoot";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "fixLocalGemsRootPermissions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 11, 16 -> new IllegalStateException(string);
        };
    }
}

