/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.resolve;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSGlobalQualifiedElementIndex;
import com.intellij.lang.javascript.psi.stubs.JSNamespaceMembersIndex;
import com.intellij.lang.javascript.psi.stubs.TypeScriptGlobalExportedNamesIndex;
import com.intellij.lang.typescript.resolve.GlobalSearchScopeWithIdFilter;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptClassResolver
extends JSClassResolver {
    private static final CachedValueProvider<Map<String, Collection<JSQualifiedNamedElement>>> MAP_PROVIDER = () -> CachedValueProvider.Result.create((Object)ContainerUtil.createConcurrentSoftValueMap(), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
    private static final CachedValueProvider<Map<String, Collection<JSPsiNamedElementBase>>> NAMED_ELEMENTS_CACHE_PROVIDER = () -> CachedValueProvider.Result.create((Object)ContainerUtil.createConcurrentSoftValueMap(), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
    private static final Key<CachedValue<Map<String, Collection<JSQualifiedNamedElement>>>> CACHE_QUALIFIED_KEY = Key.create((String)"ts.class.resolve");
    private static final Key<CachedValue<Map<String, Collection<JSQualifiedNamedElement>>>> CACHE_GLOBAL_KEY = Key.create((String)"ts.global.resolve");
    private static final Key<CachedValue<Map<String, Collection<JSPsiNamedElementBase>>>> CACHE_GLOBAL_EXPORTED_KEY = Key.create((String)"ts.global.exported.resolve");
    private static TypeScriptClassResolver INSTANCE = null;

    private TypeScriptClassResolver() {
    }

    public static TypeScriptClassResolver getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TypeScriptClassResolver();
        }
        return INSTANCE;
    }

    @Override
    public PsiElement findClassByQName(@NotNull String link, @NotNull PsiElement context2) {
        if (link == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(1);
        }
        return null;
    }

    @NotNull
    public Collection<JSQualifiedNamedElement> findElementsByQNameFilteredByConfig(@NotNull String qName, @NotNull PsiElement place) {
        Project project;
        PsiFile parentFile;
        if (qName == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(2);
        }
        if (place == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(3);
        }
        if ((parentFile = InjectedLanguageManager.getInstance((Project)(project = place.getProject())).getTopLevelFile(place)) != null) {
            Map<String, Collection<JSQualifiedNamedElement>> cachedValues = TypeScriptClassResolver.getMapForKey(CACHE_QUALIFIED_KEY, parentFile);
            Collection<JSQualifiedNamedElement> elements = cachedValues.get(qName);
            if (elements == null) {
                elements = this.findElementsByQName(qName, TypeScriptConfigService.Provider.getConfigResolveScope(place), project);
                cachedValues.putIfAbsent(qName, elements);
            }
            Collection<JSQualifiedNamedElement> collection = elements;
            if (collection == null) {
                TypeScriptClassResolver.$$$reportNull$$$0(4);
            }
            return collection;
        }
        Collection<JSQualifiedNamedElement> collection = this.findElementsByQName(qName, TypeScriptConfigService.Provider.getConfigResolveScope(place), project);
        if (collection == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @NotNull
    private static Map<String, Collection<JSQualifiedNamedElement>> getMapForKey(@NotNull Key<CachedValue<Map<String, Collection<JSQualifiedNamedElement>>>> key, @NotNull PsiFile parentFile) {
        if (key == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(6);
        }
        if (parentFile == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(7);
        }
        Map map2 = (Map)CachedValuesManager.getManager((Project)parentFile.getProject()).getCachedValue((UserDataHolder)parentFile, key, MAP_PROVIDER, false);
        if (map2 == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(8);
        }
        return map2;
    }

    @Override
    @NotNull
    protected GlobalSearchScope adjustScopeForQualifiedNameSearch(@NotNull GlobalSearchScope scope2) {
        if (scope2 == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(9);
        }
        if (!(scope2 instanceof GlobalSearchScopeWithIdFilter) && !(scope2 instanceof Iterable)) {
            scope2 = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)scope2, (FileType[])TypeScriptUtil.TYPESCRIPT_FILE_TYPES_ARRAY);
        }
        GlobalSearchScope globalSearchScope = scope2;
        if (globalSearchScope == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(10);
        }
        return globalSearchScope;
    }

    public Collection<JSPsiElementBase> findChildren(@NotNull String qName, @NotNull PsiElement place) {
        if (qName == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(11);
        }
        if (place == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(12);
        }
        GlobalSearchScope baseScope = JSResolveUtil.getResolveScope(place);
        final Project project = place.getProject();
        DelegatingGlobalSearchScope scope2 = new DelegatingGlobalSearchScope(baseScope){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!super.contains(file)) {
                    return false;
                }
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
                return !(psiFile instanceof JSModuleStatusOwner) || !((JSModuleStatusOwner)psiFile).isCommonJSModule();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/resolve/TypeScriptClassResolver$1", "contains"));
            }
        };
        return this.findNamespaceMembers(qName, (GlobalSearchScope)scope2);
    }

    @Override
    protected PsiElement doFindClassByQName(@NotNull String link, GlobalSearchScope searchScope, boolean allowFileLocalSymbols) {
        if (link == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(13);
        }
        return null;
    }

    @Nullable
    public JSClass findAnyClassByQName(@NotNull String qName, @NotNull GlobalSearchScope scope2) {
        List<JSClass> classes;
        if (qName == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(14);
        }
        if (scope2 == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(15);
        }
        return (classes = this.findClassesByQName(qName, scope2)).isEmpty() ? null : (JSClass)classes.iterator().next();
    }

    @NotNull
    public List<JSClass> findObjectClasses(JSClass scopeElement) {
        List<JSClass> list = this.findClassesByQName("Object", JSResolveUtil.getResolveScope(scopeElement));
        if (list == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(16);
        }
        return list;
    }

    @NotNull
    public Collection<JSQualifiedNamedElement> findGlobalElementsByQName(@NotNull String qName, @NotNull PsiElement context2) {
        PsiFile containingFile;
        if (qName == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(17);
        }
        if (context2 == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(18);
        }
        if ((containingFile = context2.getContainingFile()) == null) {
            Set<JSQualifiedNamedElement> set = Collections.emptySet();
            if (set == null) {
                TypeScriptClassResolver.$$$reportNull$$$0(19);
            }
            return set;
        }
        Map<String, Collection<JSQualifiedNamedElement>> cachedValues = TypeScriptClassResolver.getMapForKey(CACHE_GLOBAL_KEY, containingFile);
        Collection<JSQualifiedNamedElement> elements = cachedValues.get(qName);
        if (elements != null) {
            Collection<JSQualifiedNamedElement> collection = elements;
            if (collection == null) {
                TypeScriptClassResolver.$$$reportNull$$$0(20);
            }
            return collection;
        }
        GlobalSearchScope scope2 = TypeScriptClassResolver.getGlobalTypeScriptScopeForJsOrTs(context2);
        Collection<JSQualifiedNamedElement> result2 = this.findGlobalElementsByQName(context2.getProject(), qName, scope2);
        if (result2.isEmpty() && DialectDetector.isTypeScript(context2)) {
            result2 = this.findGlobalElementsByQName(context2.getProject(), qName, JSResolveUtil.getResolveScope(context2));
        }
        cachedValues.putIfAbsent(qName, result2);
        Collection<JSQualifiedNamedElement> collection = result2;
        if (collection == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(21);
        }
        return collection;
    }

    @NotNull
    public Collection<JSQualifiedNamedElement> findGlobalElementsByQName(@NotNull Project project, @NotNull String qName, @NotNull GlobalSearchScope scope2) {
        if (project == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(22);
        }
        if (qName == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(23);
        }
        if (scope2 == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(24);
        }
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        this.processGlobalElementsByQName(project, qName, scope2, (Processor<? super JSQualifiedNamedElement>)processor);
        Collection collection = processor.getResults();
        if (collection == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(25);
        }
        return collection;
    }

    @NotNull
    public Collection<JSElement> findAllGlobalElements(@NotNull Project project, @NotNull PsiElement place) {
        if (project == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(26);
        }
        if (place == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(27);
        }
        GlobalSearchScope scope2 = TypeScriptClassResolver.getGlobalTypeScriptScopeForJsOrTs(place);
        Collection collection = StubIndex.getElements(JSNamespaceMembersIndex.KEY, (Object)"", (Project)project, (GlobalSearchScope)scope2, JSElement.class);
        if (collection == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(28);
        }
        return collection;
    }

    @NotNull
    public Collection<JSPsiNamedElementBase> findGlobalExportedElementsByQName(@NotNull String qName, @NotNull PsiElement context2) {
        PsiFile containingFile;
        if (qName == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(29);
        }
        if (context2 == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(30);
        }
        if ((containingFile = context2.getContainingFile()) == null) {
            Set<JSPsiNamedElementBase> set = Collections.emptySet();
            if (set == null) {
                TypeScriptClassResolver.$$$reportNull$$$0(31);
            }
            return set;
        }
        Map cachedValues = (Map)CachedValuesManager.getManager((Project)containingFile.getProject()).getCachedValue((UserDataHolder)containingFile, CACHE_GLOBAL_EXPORTED_KEY, NAMED_ELEMENTS_CACHE_PROVIDER, false);
        Collection<JSPsiNamedElementBase> elements = (Collection<JSPsiNamedElementBase>)cachedValues.get(qName);
        if (elements != null) {
            Collection<JSPsiNamedElementBase> collection = elements;
            if (collection == null) {
                TypeScriptClassResolver.$$$reportNull$$$0(32);
            }
            return collection;
        }
        GlobalSearchScope scope2 = TypeScriptClassResolver.getGlobalTypeScriptScopeForJsOrTs(context2);
        elements = TypeScriptClassResolver.findGlobalExportedElementsByQName(context2.getProject(), qName, scope2);
        cachedValues.putIfAbsent(qName, elements);
        Collection<JSPsiNamedElementBase> collection = elements;
        if (collection == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(33);
        }
        return collection;
    }

    public boolean isGloballyExported(@NotNull String qName, @NotNull PsiElement context2) {
        Collection<String> allExportedNames;
        if (qName == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(34);
        }
        if (context2 == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(35);
        }
        return (allExportedNames = TypeScriptGlobalExportedNamesIndex.getAllExportedNames(context2.getProject())).contains(qName) && !this.findGlobalExportedElementsByQName(qName, context2).isEmpty();
    }

    @NotNull
    private static Collection<JSPsiNamedElementBase> findGlobalExportedElementsByQName(@NotNull Project project, @NotNull String qName, @NotNull GlobalSearchScope scope2) {
        if (project == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(36);
        }
        if (qName == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(37);
        }
        if (scope2 == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(38);
        }
        Collection collection = StubIndex.getElements(TypeScriptGlobalExportedNamesIndex.KEY, (Object)qName, (Project)project, (GlobalSearchScope)scope2, JSPsiNamedElementBase.class);
        if (collection == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(39);
        }
        return collection;
    }

    public void processGlobalElementsByQName(@NotNull Project project, @NotNull String qName, @NotNull GlobalSearchScope scope2, @NotNull Processor<? super JSQualifiedNamedElement> processor) {
        if (project == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(40);
        }
        if (qName == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(41);
        }
        if (scope2 == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(42);
        }
        if (processor == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(43);
        }
        StubIndex.getInstance().processElements(JSGlobalQualifiedElementIndex.KEY, (Object)qName, project, scope2, JSQualifiedNamedElement.class, processor);
    }

    @NotNull
    public static GlobalSearchScope getGlobalTypeScriptScopeForJsOrTs(@NotNull PsiElement place) {
        if (place == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(44);
        }
        if (!DialectDetector.isTypeScript(place)) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)JSResolveUtil.getResolveScope(place), (FileType[])TypeScriptUtil.TYPESCRIPT_FILE_TYPES_ARRAY);
            if (globalSearchScope == null) {
                TypeScriptClassResolver.$$$reportNull$$$0(45);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = TypeScriptConfigService.Provider.getConfigResolveScope(place);
        if (globalSearchScope == null) {
            TypeScriptClassResolver.$$$reportNull$$$0(46);
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope excludeGlobalTypeScript(GlobalSearchScope allScope) {
        return new DelegatingGlobalSearchScope(allScope){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    2.$$$reportNull$$$0(0);
                }
                return super.contains(file) && !TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(file.getFileType());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/resolve/TypeScriptClassResolver$2", "contains"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 8, 10, 16, 19, 20, 21, 25, 28, 31, 32, 33, 39, 45, 46 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 1: 
            case 18: 
            case 30: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 11: 
            case 14: 
            case 17: 
            case 23: 
            case 29: 
            case 34: 
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 3: 
            case 12: 
            case 27: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 39: 
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/resolve/TypeScriptClassResolver";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentFile";
                break;
            }
            case 9: 
            case 15: 
            case 24: 
            case 38: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 22: 
            case 26: 
            case 36: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/resolve/TypeScriptClassResolver";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementsByQNameFilteredByConfig";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getMapForKey";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustScopeForQualifiedNameSearch";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findObjectClasses";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "findGlobalElementsByQName";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllGlobalElements";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "findGlobalExportedElementsByQName";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalTypeScriptScopeForJsOrTs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findClassByQName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findElementsByQNameFilteredByConfig";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 25: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 39: 
            case 45: 
            case 46: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getMapForKey";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "adjustScopeForQualifiedNameSearch";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findChildren";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doFindClassByQName";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findAnyClassByQName";
                break;
            }
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findGlobalElementsByQName";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findAllGlobalElements";
                break;
            }
            case 29: 
            case 30: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "findGlobalExportedElementsByQName";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isGloballyExported";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "processGlobalElementsByQName";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getGlobalTypeScriptScopeForJsOrTs";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 8, 10, 16, 19, 20, 21, 25, 28, 31, 32, 33, 39, 45, 46 -> new IllegalStateException(string);
        };
    }
}

