/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.refactoring;

import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGenericOrMappedTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSLiteralTextReference;
import com.intellij.lang.javascript.psi.resolve.JSReferenceUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.JSDefaultRenameProcessor;
import com.intellij.lang.javascript.refactoring.JSGetterSetterRenameUtil;
import com.intellij.lang.javascript.refactoring.rename.JSInplaceRenameHandler;
import com.intellij.lang.typescript.psi.TypeScriptDeclarationMappings;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenameHandler;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenamer;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptMemberInplaceRenameHandler
extends MemberInplaceRenameHandler {
    protected boolean isAvailable(@Nullable PsiElement element2, @NotNull Editor editor, @NotNull PsiFile file) {
        boolean isTypeScriptContext;
        if (editor == null) {
            TypeScriptMemberInplaceRenameHandler.$$$reportNull$$$0(0);
        }
        if (file == null) {
            TypeScriptMemberInplaceRenameHandler.$$$reportNull$$$0(1);
        }
        if (!(file instanceof JSFile) || element2 == null || !DialectDetector.isTypeScript((PsiElement)file)) {
            return false;
        }
        PsiElement context2 = file.findElementAt(editor.getCaretModel().getOffset());
        if (context2 == null && editor.getCaretModel().getOffset() > 0) {
            context2 = file.findElementAt(editor.getCaretModel().getOffset() - 1);
        }
        boolean bl = isTypeScriptContext = context2 != null && DialectDetector.isTypeScript(context2);
        if (!isTypeScriptContext) {
            return false;
        }
        if (JSInplaceRenameHandler.isForbiddenContextForInplace(context2.getParent())) {
            return false;
        }
        if (TypeScriptMemberInplaceRenameHandler.elementIsAcceptable(element2)) {
            return editor.getSettings().isVariableInplaceRenameEnabled();
        }
        return false;
    }

    private static boolean elementIsAcceptable(@Nullable PsiElement element2) {
        if (element2 == null) {
            return false;
        }
        if (JSGetterSetterRenameUtil.isFieldWithAccessors(element2) || JSGetterSetterRenameUtil.isGetterSetterFunction(element2)) {
            return false;
        }
        if (element2 instanceof TypeScriptIndexSignature || element2 instanceof JSFunction && ((JSFunction)element2).isConstructor()) {
            return false;
        }
        return TypeScriptMemberInplaceRenameHandler.isClassOrInterfaceWithName(element2) || element2 instanceof TypeScriptVariable && !(element2.getUseScope() instanceof LocalSearchScope) || element2 instanceof TypeScriptFunction && !(element2.getUseScope() instanceof LocalSearchScope) || JSUtils.isMember(element2) || element2 instanceof ES6ImportExportSpecifierAlias || element2 instanceof ES6ImportedBinding || element2 instanceof JSField || element2 instanceof TypeScriptGenericOrMappedTypeParameter || element2 instanceof TypeScriptImportStatement || element2 instanceof TypeScriptModule && ((TypeScriptModule)element2).isInternal();
    }

    private static boolean isClassOrInterfaceWithName(@NotNull PsiElement element2) {
        if (element2 == null) {
            TypeScriptMemberInplaceRenameHandler.$$$reportNull$$$0(2);
        }
        return element2 instanceof JSClass && ((JSClass)element2).getName() != null;
    }

    @NotNull
    protected MemberInplaceRenamer createMemberRenamer(final @NotNull PsiElement substituted, @NotNull PsiNameIdentifierOwner originalElement, @NotNull Editor editor) {
        if (substituted == null) {
            TypeScriptMemberInplaceRenameHandler.$$$reportNull$$$0(3);
        }
        if (originalElement == null) {
            TypeScriptMemberInplaceRenameHandler.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            TypeScriptMemberInplaceRenameHandler.$$$reportNull$$$0(5);
        }
        return new MemberInplaceRenamer((PsiNamedElement)originalElement, substituted, editor){

            protected boolean acceptReference(PsiReference reference) {
                return JSDefaultRenameProcessor.acceptReference(reference, false, true, substituted, true);
            }

            public boolean performInplaceRename(@Nullable Collection<String> nameSuggestions) {
                return this.checkNeedInplace() && super.performInplaceRename(nameSuggestions);
            }

            protected Collection<PsiReference> collectRefs(SearchScope referencesSearchScope) {
                Collection refs = super.collectRefs(referencesSearchScope);
                if (substituted instanceof JSQualifiedNamedElement) {
                    JSQualifiedNamedElement namedElement = (JSQualifiedNamedElement)substituted;
                    Collection<PsiNamedElement> additionalElements = TypeScriptDeclarationMappings.getInstance(namedElement.getProject()).getSourceElements(namedElement);
                    for (PsiNamedElement element2 : additionalElements) {
                        PsiReference reference = element2.getReference();
                        if (reference == null || refs.contains(reference)) continue;
                        refs.add(reference);
                    }
                }
                return refs;
            }

            private boolean checkNeedInplace() {
                String name;
                if (substituted.getUseScope() instanceof LocalSearchScope) {
                    return true;
                }
                if (JSDefaultRenameProcessor.getSearchDynamicReferences(substituted)) {
                    return false;
                }
                if (!JSDefaultRenameProcessor.getSearchJavaScriptReferences(substituted)) {
                    return true;
                }
                SearchScope scope2 = JSDefaultRenameProcessor.getScope(substituted, JSDefaultRenameProcessor.ReferencesType.JS);
                if (substituted instanceof JSNamedElement && scope2 instanceof GlobalSearchScope && (name = ((JSNamedElement)substituted).getName()) != null) {
                    PsiSearchHelper.SearchCostResult cheapEnough = PsiSearchHelper.getInstance((Project)substituted.getProject()).isCheapEnoughToSearch(name, (GlobalSearchScope)scope2, substituted.getContainingFile());
                    if (cheapEnough == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
                        return false;
                    }
                    if (cheapEnough == PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES) {
                        return true;
                    }
                }
                return ReferencesSearch.search((PsiElement)substituted, (SearchScope)scope2).findFirst() == null;
            }

            @NotNull
            protected TextRange getRangeToRename(@NotNull PsiElement element2) {
                if (element2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element2.getNode().getElementType() != JSTokenTypes.STRING_LITERAL) {
                    TextRange textRange = super.getRangeToRename(element2);
                    if (textRange == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return textRange;
                }
                if (!(element2.getParent() instanceof JSRecordType.PropertySignature)) {
                    TextRange textRange = super.getRangeToRename(element2);
                    if (textRange == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return textRange;
                }
                TextRange textRange = JSReferenceUtil.getRangeWithoutQuotes(element2);
                if (textRange == null) {
                    1.$$$reportNull$$$0(3);
                }
                return textRange;
            }

            @NotNull
            protected TextRange getRangeToRename(@NotNull PsiReference reference) {
                if (reference == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (reference instanceof JSLiteralTextReference && ((JSLiteralTextReference)reference).isLiteralKeyReference()) {
                    TextRange textRange = JSReferenceUtil.getRangeWithoutQuotes(reference.getElement());
                    if (textRange == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    return textRange;
                }
                TextRange textRange = super.getRangeToRename(reference);
                if (textRange == null) {
                    1.$$$reportNull$$$0(6);
                }
                return textRange;
            }

            protected boolean buildTemplateAndStart(@NotNull Collection<PsiReference> refs, @NotNull Collection<Pair<PsiElement, TextRange>> stringUsages, @NotNull PsiElement scope2, @NotNull PsiFile containingFile) {
                if (refs == null) {
                    1.$$$reportNull$$$0(7);
                }
                if (stringUsages == null) {
                    1.$$$reportNull$$$0(8);
                }
                if (scope2 == null) {
                    1.$$$reportNull$$$0(9);
                }
                if (containingFile == null) {
                    1.$$$reportNull$$$0(10);
                }
                if (!this.allRenameLocationsHaveTheSameContents(refs, containingFile)) {
                    return false;
                }
                return super.buildTemplateAndStart(refs, stringUsages, scope2, containingFile);
            }

            private boolean allRenameLocationsHaveTheSameContents(@NotNull Collection<PsiReference> refs, @NotNull PsiFile containingFile) {
                if (refs == null) {
                    1.$$$reportNull$$$0(11);
                }
                if (containingFile == null) {
                    1.$$$reportNull$$$0(12);
                }
                String initialName = null;
                if (this.myElementToRename != null) {
                    initialName = this.myElementToRename.getName();
                }
                if (initialName == null) {
                    initialName = this.getInitialName();
                }
                if (initialName == null) {
                    return true;
                }
                String fileText = containingFile.getText();
                InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)containingFile.getProject());
                for (PsiReference ref2 : refs) {
                    int elementOffset;
                    int n = elementOffset = ref2.getElement().getContainingFile() != containingFile ? injectedLanguageManager.injectedToHost(ref2.getElement(), ref2.getElement().getTextRange()).getStartOffset() : ref2.getElement().getTextRange().getStartOffset();
                    if (initialName.equals(this.getRangeToRename(ref2).shiftRight(elementOffset).substring(fileText))) continue;
                    return false;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2, 3, 5, 6 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/typescript/refactoring/TypeScriptMemberInplaceRenameHandler$1";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "reference";
                        break;
                    }
                    case 7: 
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "refs";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "stringUsages";
                        break;
                    }
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "scope";
                        break;
                    }
                    case 10: 
                    case 12: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "containingFile";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/typescript/refactoring/TypeScriptMemberInplaceRenameHandler$1";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRangeToRename";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getRangeToRename";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: 
                    case 6: {
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        objectArray = objectArray;
                        objectArray[2] = "buildTemplateAndStart";
                        break;
                    }
                    case 11: 
                    case 12: {
                        objectArray = objectArray;
                        objectArray[2] = "allRenameLocationsHaveTheSameContents";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2, 3, 5, 6 -> new IllegalStateException(string);
                };
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substituted";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/typescript/refactoring/TypeScriptMemberInplaceRenameHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isClassOrInterfaceWithName";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createMemberRenamer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

