/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.macro;

import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.liveTemplates.JSLikeTemplateContextType;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.html.HtmlFileImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.xml.XmlFile;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSMacroUtil {
    public static JSNamedElement[] getNamedElementsVisibleAt(ExpressionContext context2) {
        return JSMacroUtil.getNamedElementsVisibleAt(context2, true);
    }

    public static JSNamedElement[] getNamedElementsVisibleAt(final ExpressionContext context2, final boolean skipElementsInsideTemplate) {
        final PsiElement elementFromContext = JSMacroUtil.getElementFromContext(context2);
        final LinkedHashSet vars = new LinkedHashSet();
        if (elementFromContext != null) {
            final int elementFromContextOffset = InjectedLanguageManager.getInstance((Project)context2.getProject()).injectedToHost(elementFromContext, elementFromContext.getTextOffset());
            ResolveProcessor processor = new ResolveProcessor(null){

                public boolean execute(@NotNull PsiElement element2, @NotNull ResolveState state) {
                    if (element2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (state == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (element2 instanceof JSNamedElement) {
                        int varOffset = InjectedLanguageManager.getInstance((Project)context2.getProject()).injectedToHost(element2, element2.getTextOffset());
                        if (skipElementsInsideTemplate) {
                            if (varOffset < context2.getTemplateStartOffset() || varOffset > context2.getTemplateEndOffset()) {
                                vars.add((JSNamedElement)element2);
                            }
                        } else if (varOffset < elementFromContextOffset || varOffset > elementFromContextOffset + elementFromContext.getTextLength()) {
                            vars.add((JSNamedElement)element2);
                        }
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "element";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "state";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/lang/javascript/macro/JSMacroUtil$1";
                    objectArray[2] = "execute";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            processor.setLocalResolve(true);
            JSResolveUtil.treeWalkUp(processor, elementFromContext, elementFromContext.getParent(), elementFromContext);
        }
        return vars.toArray(new JSNamedElement[0]);
    }

    @Nullable
    public static PsiElement getElementFromContext(ExpressionContext context2) {
        Project project = context2.getProject();
        Editor editor = context2.getEditor();
        if (editor == null) {
            return null;
        }
        int offset = context2.getStartOffset();
        int delta = offset - editor.getCaretModel().getOffset();
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        PsiFile file = psiDocumentManager.getPsiFile(editor.getDocument());
        if (file instanceof XmlFile) {
            Editor injEditor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit((Editor)editor, (PsiFile)file, (int)offset);
            if (injEditor instanceof EditorWindow) {
                EditorWindow window = (EditorWindow)injEditor;
                PsiFile injFile = window.getInjectedFile();
                int injOffset = injEditor.getCaretModel().getOffset();
                return injFile.findElementAt(injOffset + delta);
            }
            if (!(file instanceof HtmlFileImpl)) {
                return null;
            }
        }
        return file == null ? null : file.findElementAt(offset);
    }

    public static boolean isJSLikeContext(TemplateContextType type2) {
        return type2 instanceof JSLikeTemplateContextType || type2 != null && JSMacroUtil.isJSLikeContext(type2.getBaseContextType());
    }
}

