/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class JSReferencingMutableVariableFromClosureInspection
extends JSInspection {
    private static final Set<String> ARRAY_METHODS = ContainerUtil.newHashSet((Object[])new String[]{"each", "forEach", "reduce", "reduceRight", "every", "filter", "map", "some"});

    @Override
    @NotNull
    protected JSElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSReferencingMutableVariableFromClosureInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSReferencingMutableVariableFromClosureInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            @Override
            public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.validate(node);
            }

            @Override
            public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.validate(node);
            }

            @Override
            public void visitJSFile(@NotNull JSFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(2);
                }
                this.validate(file);
            }

            @Override
            public void visitJSEmbeddedContent(@NotNull JSEmbeddedContent embeddedContent) {
                if (embeddedContent == null) {
                    1.$$$reportNull$$$0(3);
                }
                this.validate(embeddedContent);
            }

            private void validate(final JSExecutionScope scope2) {
                ResultSink sink = new ResultSink(null){

                    @Override
                    public String getName() {
                        return null;
                    }
                };
                SinkResolveProcessor<ResultSink> processor = new SinkResolveProcessor<ResultSink>(sink){

                    @Override
                    public boolean execute(@NotNull PsiElement element2, @NotNull ResolveState state) {
                        if (element2 == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        if (state == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        if (!(element2 instanceof JSVariable) || element2 instanceof JSParameter || element2 instanceof ImplicitJSVariableImpl) {
                            return true;
                        }
                        return super.execute(element2, state);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "element";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "state";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/lang/javascript/inspections/JSReferencingMutableVariableFromClosureInspection$1$2";
                        objectArray[2] = "execute";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                processor.setLocalResolve(true);
                scope2.processDeclarations(processor, ResolveState.initial(), scope2.getFirstChild(), scope2);
                List<PsiElement> results = sink.getResults();
                if (results == null) {
                    return;
                }
                final HashSet<String> usedNames = new HashSet<String>();
                final HashSet<PsiElement> usedVars = new HashSet<PsiElement>();
                for (PsiElement element2 : results) {
                    String name = ResolveProcessor.getName(element2);
                    if (name == null) continue;
                    usedNames.add(name);
                    usedVars.add(element2);
                }
                scope2.acceptChildren(new JSRecursiveElementVisitor(){
                    private JSLoopStatement myLoopStatement;
                    private Set<PsiElement> changedInCurrentLoop;
                    private boolean hasClosuresInLoop;
                    private boolean shouldRescanFunctions;
                    private JSFunction myFunction;

                    @Override
                    public void visitJSReferenceExpression(@NotNull JSReferenceExpression node) {
                        PsiElement resolve2;
                        String referencedName;
                        if (node == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        if (node.getQualifier() == null && (referencedName = node.getReferencedName()) != null && usedNames.contains(referencedName) && (resolve2 = node.resolve()) != null && usedVars.contains(resolve2) && this.myLoopStatement != null) {
                            ReadWriteAccessDetector.Access access = JSReadWriteAccessDetector.ourInstance.getExpressionAccess((PsiElement)node);
                            if (access != ReadWriteAccessDetector.Access.Read && this.myFunction == null) {
                                this.addChangedNode(resolve2);
                            }
                            if (resolve2 instanceof JSVariable && ((JSVariable)resolve2).hasBlockScope()) {
                                return;
                            }
                            if (this.myFunction != scope2 && this.myFunction != null && this.hasClosuresInLoop && access == ReadWriteAccessDetector.Access.Read && this.changedInCurrentLoop != null && this.changedInCurrentLoop.contains(resolve2)) {
                                this.shouldRescanFunctions = false;
                                boolean closureJustForIteration = false;
                                Object element2 = this.myFunction.getParent();
                                if (element2 instanceof JSArgumentList && (element2 = element2.getParent()) instanceof JSCallExpression && (element2 = ((JSCallExpression)element2).getMethodExpression()) instanceof JSReferenceExpression) {
                                    String calledFunName = ((JSReferenceExpression)element2).getReferenceName();
                                    closureJustForIteration = ARRAY_METHODS.contains(calledFunName);
                                }
                                if (!closureJustForIteration) {
                                    holder.registerProblem((PsiElement)node, JavaScriptBundle.message("javascript.mutable.variable.accessible.from.closure", new Object[0]), new LocalQuickFix[0]);
                                }
                            }
                        }
                        super.visitJSReferenceExpression(node);
                    }

                    private void addChangedNode(PsiElement resolve2) {
                        if (this.changedInCurrentLoop == null) {
                            this.changedInCurrentLoop = new HashSet<PsiElement>(2);
                        }
                        this.changedInCurrentLoop.add(resolve2);
                        this.shouldRescanFunctions = true;
                    }

                    @Override
                    public void visitJSVariable(@NotNull JSVariable node) {
                        String name;
                        if (node == null) {
                            3.$$$reportNull$$$0(1);
                        }
                        if ((name = node.getName()) != null && usedNames.contains(name) && this.myLoopStatement != null && !(node instanceof JSParameter) && !node.hasBlockScope()) {
                            this.addChangedNode((PsiElement)node);
                        }
                        super.visitJSVariable(node);
                    }

                    @Override
                    public void visitJSWhileStatement(@NotNull JSWhileStatement node) {
                        if (node == null) {
                            3.$$$reportNull$$$0(2);
                        }
                        this.proceedWithLoop(node);
                    }

                    @Override
                    public void visitJSForInStatement(@NotNull JSForInStatement node) {
                        if (node == null) {
                            3.$$$reportNull$$$0(3);
                        }
                        this.proceedWithLoop(node);
                    }

                    @Override
                    public void visitJSForStatement(@NotNull JSForStatement node) {
                        if (node == null) {
                            3.$$$reportNull$$$0(4);
                        }
                        this.proceedWithLoop(node);
                    }

                    @Override
                    public void visitJSDoWhileStatement(@NotNull JSDoWhileStatement node) {
                        if (node == null) {
                            3.$$$reportNull$$$0(5);
                        }
                        this.proceedWithLoop(node);
                    }

                    @Override
                    public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
                        if (node == null) {
                            3.$$$reportNull$$$0(6);
                        }
                        if (3.immediatelyCalled(node)) {
                            super.visitJSFunctionExpression(node);
                            return;
                        }
                        this.proceedWithFunction(node);
                    }

                    private static boolean immediatelyCalled(PsiElement node) {
                        PsiElement parent = node.getParent();
                        while (parent instanceof JSParenthesizedExpression) {
                            node = parent;
                            parent = node.getParent();
                        }
                        return parent instanceof JSCallExpression && ((JSCallExpression)parent).getMethodExpression() == node;
                    }

                    @Override
                    public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
                        if (node == null) {
                            3.$$$reportNull$$$0(7);
                        }
                        this.proceedWithFunction(node);
                    }

                    private void proceedWithFunction(JSFunction node) {
                        JSFunction prev = this.myFunction;
                        this.myFunction = node;
                        if (this.myLoopStatement != null) {
                            this.hasClosuresInLoop = true;
                        }
                        this.visitJSElement(node);
                        this.myFunction = prev;
                    }

                    private void proceedWithLoop(JSLoopStatement node) {
                        Set<PsiElement> changed = this.changedInCurrentLoop;
                        this.changedInCurrentLoop = null;
                        if (changed != null) {
                            this.changedInCurrentLoop = new HashSet<PsiElement>(changed);
                        }
                        JSLoopStatement prev = this.myLoopStatement;
                        this.myLoopStatement = node;
                        boolean prevHasClosuresInLoop = this.hasClosuresInLoop;
                        boolean prevShouldRescanFunctions = this.shouldRescanFunctions;
                        this.hasClosuresInLoop = false;
                        this.visitJSStatement(node);
                        if (this.shouldRescanFunctions && this.hasClosuresInLoop) {
                            this.visitJSStatement(node);
                        }
                        this.myLoopStatement = prev;
                        this.changedInCurrentLoop = changed;
                        this.hasClosuresInLoop = prevHasClosuresInLoop;
                        this.shouldRescanFunctions = prevShouldRescanFunctions;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = "node";
                        objectArray2[1] = "com/intellij/lang/javascript/inspections/JSReferencingMutableVariableFromClosureInspection$1$3";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitJSReferenceExpression";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitJSVariable";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitJSWhileStatement";
                                break;
                            }
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitJSForInStatement";
                                break;
                            }
                            case 4: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitJSForStatement";
                                break;
                            }
                            case 5: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitJSDoWhileStatement";
                                break;
                            }
                            case 6: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitJSFunctionExpression";
                                break;
                            }
                            case 7: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitJSFunctionDeclaration";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "embeddedContent";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSReferencingMutableVariableFromClosureInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSFunctionDeclaration";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSFunctionExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSFile";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSEmbeddedContent";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/inspections/JSReferencingMutableVariableFromClosureInspection";
        objectArray[2] = "createVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

