/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.annotations.NotNull;

public final class JSLastCommaInObjectLiteralInspection
extends JSInspection {
    @Override
    @NotNull
    protected JSElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSLastCommaInObjectLiteralInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSLastCommaInObjectLiteralInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            @Override
            public void visitJSObjectLiteralExpression(@NotNull JSObjectLiteralExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (DialectDetector.isTypeScript((PsiElement)node) || DialectDetector.isES6((PsiElement)node)) {
                    return;
                }
                PsiElement child = JSLastCommaInObjectLiteralInspection.findErrorNode(node);
                if (child != null) {
                    holder.registerProblem(child, JavaScriptBundle.message("javascript.validation.message.unneeded.comma", new Object[0]), new LocalQuickFix[]{JSFixFactory.getInstance().removeASTNodeFix("javascript.validation.message.remove.unneeded.comma.fix", child)});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/inspections/JSLastCommaInObjectLiteralInspection$1", "visitJSObjectLiteralExpression"));
            }
        };
    }

    public static PsiElement findErrorNode(JSObjectLiteralExpression node) {
        ASTNode childNode;
        PsiElement child;
        PsiElement lastChild = node.getLastChild();
        PsiElement psiElement = child = lastChild != null ? lastChild.getPrevSibling() : null;
        while (child instanceof PsiWhiteSpace || child instanceof PsiComment) {
            child = child.getPrevSibling();
        }
        if (child != null && (childNode = child.getNode()) != null && childNode.getElementType() == JSTokenTypes.COMMA) {
            return child;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/inspections/JSLastCommaInObjectLiteralInspection";
        objectArray[2] = "createVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

