/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.documentation;

import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.documentation.JSHtmlHighlightingUtil;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.EnumConstantValue;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptEnumLiteralType;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptCompilerType;
import com.intellij.lang.javascript.validation.JSTooltipWithHtmlHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0017H\u0007J \u0010\n\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0017H\u0007J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001c\u001a\u00020\u0017H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/lang/javascript/documentation/JSTypeHighlightingHelper;", "", "<init>", "()V", "BR", "", "MEMBER_INDENT", "RAW_SINGLE_LINE_LIMIT", "", "SINGLE_LINE_ONLY_LIMIT", "getTypeBody", "jsClass", "Lcom/intellij/lang/javascript/psi/ecmal4/JSClass;", "getEnumBody", "tsEnum", "Lcom/intellij/lang/javascript/psi/ecma6/TypeScriptEnum;", "getEnumFieldDeclaration", "field", "Lcom/intellij/lang/javascript/psi/ecma6/TypeScriptEnumField;", "getEnumFieldValueBody", "value", "Lcom/intellij/lang/javascript/psi/ecma6/EnumConstantValue;", "owner", "Lcom/intellij/psi/PsiElement;", "getClassBody", "type", "Lcom/intellij/lang/javascript/psi/JSType;", "context", "typeOwner", "isSoftMultilineTarget", "", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nJSTypeHighlightingHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSTypeHighlightingHelper.kt\ncom/intellij/lang/javascript/documentation/JSTypeHighlightingHelper\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,158:1\n4135#2,11:159\n1563#3:170\n1634#3,3:171\n*S KotlinDebug\n*F\n+ 1 JSTypeHighlightingHelper.kt\ncom/intellij/lang/javascript/documentation/JSTypeHighlightingHelper\n*L\n56#1:159,11\n57#1:170\n57#1:171,3\n*E\n"})
public final class JSTypeHighlightingHelper {
    @NotNull
    public static final JSTypeHighlightingHelper INSTANCE = new JSTypeHighlightingHelper();
    @NotNull
    public static final String BR = "<br>";
    @NotNull
    private static final String MEMBER_INDENT = "    ";
    private static final int RAW_SINGLE_LINE_LIMIT = 33;
    private static final int SINGLE_LINE_ONLY_LIMIT = 10000;

    private JSTypeHighlightingHelper() {
    }

    @JvmStatic
    @Nullable
    public static final String getTypeBody(@NotNull JSClass jsClass) {
        Intrinsics.checkNotNullParameter((Object)jsClass, (String)"jsClass");
        if (jsClass.isInterface()) {
            return INSTANCE.getClassBody(jsClass);
        }
        if (jsClass instanceof TypeScriptEnum) {
            return INSTANCE.getEnumBody((TypeScriptEnum)jsClass);
        }
        if (!(jsClass instanceof TypeScriptTypeAlias)) {
            return null;
        }
        if (((TypeScriptTypeAlias)jsClass).getTypeDeclaration() instanceof TypeScriptObjectType) {
            return " =" + INSTANCE.getClassBody(jsClass);
        }
        JSType declaration = ((TypeScriptTypeAlias)jsClass).getParsedTypeDeclaration();
        if (declaration != null) {
            return " = " + JSTypeHighlightingHelper.getTypeBody(declaration, jsClass);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final String getEnumBody(TypeScriptEnum tsEnum) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        JSField[] jSFieldArray = tsEnum.getFields();
        Intrinsics.checkNotNullExpressionValue((Object)jSFieldArray, (String)"getFields(...)");
        Object[] $this$filterIsInstance$iv = jSFieldArray;
        boolean $i$f$filterIsInstance = false;
        Object[] objectArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (TypeScriptEnumField element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof TypeScriptEnumField)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TypeScriptEnumField element$iv$iv;
            element$iv$iv = (TypeScriptEnumField)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(INSTANCE.getEnumFieldDeclaration((TypeScriptEnumField)it));
        }
        List members = (List)destination$iv$iv;
        if (members.isEmpty()) {
            return " {}";
        }
        return CollectionsKt.joinToString$default((Iterable)members, (CharSequence)BR, (CharSequence)" {<br>", (CharSequence)"<br>}", (int)0, null, null, (int)56, null);
    }

    private final String getEnumFieldDeclaration(TypeScriptEnumField field) {
        String value;
        EnumConstantValue enumConstantValue = field.getConstantValue();
        Intrinsics.checkNotNullExpressionValue((Object)enumConstantValue, (String)"getConstantValue(...)");
        String string = value = this.getEnumFieldValueBody(enumConstantValue, (PsiElement)field);
        Object valueDeclaration = string != null ? " = " + string : "";
        return MEMBER_INDENT + field.getName() + (String)valueDeclaration + ",";
    }

    private final String getEnumFieldValueBody(EnumConstantValue value, PsiElement owner) {
        if (!value.isLiteral()) {
            return null;
        }
        JSType jSType = value.getExpandedJSType(owner);
        if (jSType == null) {
            return null;
        }
        JSType type2 = jSType;
        return ((Object)JSHtmlHighlightingUtil.getTypeWithLinksHtmlHighlighting(type2, owner, false)).toString();
    }

    private final String getClassBody(JSClass jsClass) {
        JSRecordType jSRecordType = TypeScriptTypeParser.buildTypeFromClass(jsClass, false, false);
        Intrinsics.checkNotNullExpressionValue((Object)jSRecordType, (String)"buildTypeFromClass(...)");
        JSRecordType type2 = jSRecordType;
        if (type2.getTypeMembers().isEmpty()) {
            return " {}";
        }
        return " " + JSTypeHighlightingHelper.getTypeBody(type2, jsClass);
    }

    @JvmStatic
    @NotNull
    public static final String getTypeBody(@NotNull JSType type2, @NotNull PsiElement context2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return JSTypeHighlightingHelper.getTypeBody(type2, context2, context2);
    }

    @JvmStatic
    @NotNull
    public static final String getTypeBody(@NotNull JSType type2, @NotNull PsiElement typeOwner, @NotNull PsiElement context2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)typeOwner, (String)"typeOwner");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        JSType jSType = type2 instanceof TypeScriptCompilerType ? type2.substitute() : type2;
        Intrinsics.checkNotNull((Object)jSType);
        JSType type3 = jSType;
        if (type3 instanceof TypeScriptEnumLiteralType) {
            EnumConstantValue enumConstantValue = ((TypeScriptEnumLiteralType)type3).resolveType().getEnumConstValue();
            Intrinsics.checkNotNullExpressionValue((Object)enumConstantValue, (String)"getEnumConstValue(...)");
            String body = INSTANCE.getEnumFieldValueBody(enumConstantValue, typeOwner);
            if (body != null) {
                return body;
            }
        }
        if (type3 instanceof JSPrimitiveLiteralType) {
            return ((Object)JSHtmlHighlightingUtil.getTypeWithLinksHtmlHighlighting(type3, context2, false)).toString();
        }
        JSHtmlHighlightingUtil.TextPlaceholder textPlaceholder = JSHtmlHighlightingUtil.getFullTypeWithLinksPlaceholder(type3);
        Intrinsics.checkNotNullExpressionValue((Object)textPlaceholder, (String)"getFullTypeWithLinksPlaceholder(...)");
        JSHtmlHighlightingUtil.TextPlaceholder placeholder = textPlaceholder;
        String typeText = ((Object)placeholder.getHolderText()).toString();
        boolean singleLineMode = INSTANCE.isSoftMultilineTarget(typeOwner) && typeText.length() < 66 && type3.getTypeText().length() < 33;
        int limit = singleLineMode ? 10000 : 0;
        Project project = context2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        String result2 = JSTooltipWithHtmlHighlighter.Companion.highlightTypeOrStmt(project, typeText, false, limit);
        String string = ((Object)placeholder.restoreText(result2)).toString();
        String string2 = JavaScriptBundle.message("and.more", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)"$$MoreMembers$$", (String)string2, (boolean)false, (int)4, null), (String)",<br>", (String)BR, (boolean)false, (int)4, null), (String)"<br></span>", (String)"</span><br>", (boolean)false, (int)4, null);
    }

    private final boolean isSoftMultilineTarget(PsiElement typeOwner) {
        PsiElement psiElement = typeOwner;
        return psiElement instanceof JSVariable || psiElement instanceof JSProperty || psiElement instanceof TypeScriptPropertySignature;
    }
}

